'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _lang = require('../utils/lang');

var _Keys = require('./Keys');

var _Keys2 = _interopRequireDefault(_Keys);

var _factory = require('../utils/key/factory');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var KeyBuilderForLocalStorage = function (_KeyBuilder) {
  (0, _inherits3.default)(KeyBuilderForLocalStorage, _KeyBuilder);

  function KeyBuilderForLocalStorage() {
    (0, _classCallCheck3.default)(this, KeyBuilderForLocalStorage);
    return (0, _possibleConstructorReturn3.default)(this, (KeyBuilderForLocalStorage.__proto__ || (0, _getPrototypeOf2.default)(KeyBuilderForLocalStorage)).apply(this, arguments));
  }

  (0, _createClass3.default)(KeyBuilderForLocalStorage, [{
    key: 'buildSegmentNameKey',
    value: function buildSegmentNameKey(segmentName) {
      return (0, _factory.matching)(this.settings.core.key) + '.' + this.settings.storage.prefix + '.segment.' + segmentName;
    }
  }, {
    key: 'extractSegmentName',
    value: function extractSegmentName(builtSegmentKeyName) {
      var prefix = (0, _factory.matching)(this.settings.core.key) + '.' + this.settings.storage.prefix + '.segment.';

      if ((0, _lang.startsWith)(builtSegmentKeyName, prefix)) return builtSegmentKeyName.substr(prefix.length);
    }
  }, {
    key: 'buildSplitsWithSegmentCountKey',
    value: function buildSplitsWithSegmentCountKey() {
      return this.settings.storage.prefix + '.splits.usingSegments';
    }
  }]);
  return KeyBuilderForLocalStorage;
}(_Keys2.default);

exports.default = KeyBuilderForLocalStorage;
module.exports = exports.default;