'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _set = require('babel-runtime/core-js/set');

var _set2 = _interopRequireDefault(_set);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _ioredis2 = require('ioredis');

var _ioredis3 = _interopRequireDefault(_ioredis2);

var _lang = require('../utils/lang');

var _thenable = require('../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

var _timeout = require('../utils/promise/timeout');

var _timeout2 = _interopRequireDefault(_timeout);

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-storage:redis-adapter');

// If we ever decide to fully wrap every method, there's a Commander.getBuiltinCommands from ioredis.
var METHODS_TO_PROMISE_WRAP = ['set', 'exec', 'del', 'get', 'keys', 'sadd', 'srem', 'sismember', 'smembers', 'incr', 'rpush', 'pipeline', 'expire'];

// Not part of the settings since it'll vary on each storage. We should be removing storage specific logic from elsewhere.
var DEFAULT_OPTIONS = {
  connectionTimeout: 10000,
  operationTimeout: 5000
};
// Library specifics.
var DEFAULT_LIBRARY_OPTIONS = {
  enableOfflineQueue: false,
  connectTimeout: DEFAULT_OPTIONS.connectionTimeout,
  lazyConnect: false
};

/**
 * Redis adapter on top of the library of choice (written with ioredis) for some extra control.
 */

var RedisAdapter = function (_ioredis) {
  (0, _inherits3.default)(RedisAdapter, _ioredis);

  function RedisAdapter(storageSettings) {
    var _ref;

    (0, _classCallCheck3.default)(this, RedisAdapter);

    var options = RedisAdapter._defineOptions(storageSettings);
    // Call the ioredis constructor

    var _this = (0, _possibleConstructorReturn3.default)(this, (_ref = RedisAdapter.__proto__ || (0, _getPrototypeOf2.default)(RedisAdapter)).call.apply(_ref, [this].concat((0, _toConsumableArray3.default)(RedisAdapter._defineLibrarySettings(options)))));

    _this._options = options;
    _this._notReadyCommandsQueue = [];
    _this._runningCommands = new _set2.default();
    _this._listenToEvents();
    _this._setTimeoutWrappers();
    _this._setDisconnectWrapper();
    return _this;
  }

  (0, _createClass3.default)(RedisAdapter, [{
    key: '_listenToEvents',
    value: function _listenToEvents() {
      var _this2 = this;

      this.once('ready', function () {
        var commandsCount = _this2._notReadyCommandsQueue ? _this2._notReadyCommandsQueue.length : 0;
        log.info('Redis connection established. Queued commands: ' + commandsCount + '.');
        commandsCount && _this2._notReadyCommandsQueue.forEach(function (queued) {
          log.info('Executing queued ' + queued.name + ' command.');
          queued.command().then(queued.resolve).catch(queued.reject);
        });
        // After the SDK is ready for the first time we'll stop queueing commands. This is just so we can keep handling BUR for them.
        _this2._notReadyCommandsQueue = false;
      });
      this.once('close', function () {
        log.info('Redis connection closed.');
      });
    }
  }, {
    key: '_setTimeoutWrappers',
    value: function _setTimeoutWrappers() {
      var instance = this;

      METHODS_TO_PROMISE_WRAP.forEach(function (method) {
        var originalMethod = instance[method];

        instance[method] = function () {
          var params = arguments;

          function commandWrapper() {
            log.debug('Executing ' + method + '.');
            // Return original method
            var result = originalMethod.apply(instance, params);

            if ((0, _thenable2.default)(result)) {
              // For handling pending commands on disconnect, add to the set and remove once finished.
              // On sync commands there's no need, only thenables.
              instance._runningCommands.add(result);
              var cleanUpRunningCommandsCb = function cleanUpRunningCommandsCb(res) {
                instance._runningCommands.delete(result);
                return res;
              };
              // Both success and error remove from queue.
              result.then(cleanUpRunningCommandsCb, cleanUpRunningCommandsCb);

              return (0, _timeout2.default)(instance._options.operationTimeout, result).catch(function (err) {
                log.error(method + ' operation threw an error or exceeded configured timeout of ' + instance._options.operationTimeout + 'ms. Message: ' + err);
                // Handling is not the adapter responsibility.
                throw err;
              });
            }

            return result;
          }

          if (instance._notReadyCommandsQueue) {
            return new _promise2.default(function (res, rej) {
              instance._notReadyCommandsQueue.unshift({
                resolve: res,
                reject: rej,
                command: commandWrapper,
                name: method.toUpperCase()
              });
            });
          } else {
            return commandWrapper();
          }
        };
      });
    }
  }, {
    key: '_setDisconnectWrapper',
    value: function _setDisconnectWrapper() {
      var instance = this;
      var originalMethod = instance.disconnect;

      instance.disconnect = function disconnect() {
        var params = arguments;

        setTimeout(function deferedDisconnect() {
          if (instance._runningCommands.size > 0) {
            log.info('Attempting to disconnect but there are ' + instance._runningCommands.size + ' commands still waiting for resolution. Defering disconnection until those finish.');

            _promise2.default.all(instance._runningCommands.values()).then(function () {
              log.debug('Pending commands finished successfully, disconnecting.');
              originalMethod.apply(instance, params);
            }).catch(function (e) {
              log.warn('Pending commands finished with error: ' + e + '. Proceeding with disconnection.');
              originalMethod.apply(instance, params);
            });
          } else {
            log.debug('No commands pending execution, disconnect.');
            // Nothing pending, just proceed.
            originalMethod.apply(instance, params);
          }
        }, 10);
      };
    }

    /**
     * Receives the options and returns an array of parameters for the ioredis constructor.
     * Keeping both redis setup options for backwards compatibility.
     */

  }], [{
    key: '_defineLibrarySettings',
    value: function _defineLibrarySettings(options) {
      var opts = (0, _lang.merge)({}, DEFAULT_LIBRARY_OPTIONS);
      var result = [opts];

      if (!(0, _lang.isString)(options.url)) {
        (0, _lang.merge)(opts, { // If it's not the string URL, merge the params separately.
          host: options.host,
          port: options.port,
          db: options.db,
          password: options.pass
        });
      } else {
        // If it IS the string URL, that'll be the first param for ioredis.
        result.unshift(options.url);
      }

      return result;
    }

    /**
     * Parses the options into what we care about.
     */

  }, {
    key: '_defineOptions',
    value: function _defineOptions(_ref2) {
      var connectionTimeout = _ref2.connectionTimeout,
          operationTimeout = _ref2.operationTimeout,
          url = _ref2.url,
          host = _ref2.host,
          port = _ref2.port,
          db = _ref2.db,
          pass = _ref2.pass;

      var parsedOptions = {
        connectionTimeout: connectionTimeout, operationTimeout: operationTimeout, url: url, host: host, port: port, db: db, pass: pass
      };

      return (0, _lang.merge)({}, DEFAULT_OPTIONS, parsedOptions);
    }
  }]);
  return RedisAdapter;
}(_ioredis3.default);

exports.default = RedisAdapter;
module.exports = exports.default;