"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _map = require("babel-runtime/core-js/map");

var _map2 = _interopRequireDefault(_map);

var _isInteger = require("babel-runtime/core-js/number/is-integer");

var _isInteger2 = _interopRequireDefault(_isInteger);

var _getIterator2 = require("babel-runtime/core-js/get-iterator");

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _set = require("babel-runtime/core-js/set");

var _set2 = _interopRequireDefault(_set);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SegmentCacheInMemory = function () {
  function SegmentCacheInMemory(keys) {
    (0, _classCallCheck3.default)(this, SegmentCacheInMemory);

    this.keys = keys;
    this.flush();
  }

  (0, _createClass3.default)(SegmentCacheInMemory, [{
    key: "addToSegment",
    value: function addToSegment(segmentName, segmentKeys) {
      var values = this.segmentCache.get(segmentName);
      var keySet = values ? values : new _set2.default();

      segmentKeys.forEach(function (k) {
        return keySet.add(k);
      });

      this.segmentCache.set(segmentName, keySet);

      return true;
    }
  }, {
    key: "removeFromSegment",
    value: function removeFromSegment(segmentName, segmentKeys) {
      var values = this.segmentCache.get(segmentName);
      var keySet = values ? values : new _set2.default();

      segmentKeys.forEach(function (k) {
        return keySet.delete(k);
      });

      this.segmentCache.set(segmentName, keySet);

      return true;
    }
  }, {
    key: "isInSegment",
    value: function isInSegment(segmentName, key) {
      var segmentValues = this.segmentCache.get(segmentName);

      if (segmentValues) {
        return segmentValues.has(key);
      }

      return false;
    }
  }, {
    key: "registerSegment",
    value: function registerSegment(segmentName) {
      if (!this.segmentCache.has(segmentName)) {
        this.segmentCache.set(segmentName, new _set2.default());
      }

      return true;
    }
  }, {
    key: "registerSegments",
    value: function registerSegments(segments) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = (0, _getIterator3.default)(segments), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var segmentName = _step.value;

          this.registerSegment(segmentName);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return true;
    }
  }, {
    key: "getRegisteredSegments",
    value: function getRegisteredSegments() {
      return this.segmentCache.keys();
    }
  }, {
    key: "setChangeNumber",
    value: function setChangeNumber(segmentName, changeNumber) {
      var segmentChangeNumberKey = this.keys.buildSegmentTillKey(segmentName);

      this.segmentChangeNumber.set(segmentChangeNumberKey, changeNumber);

      return true;
    }
  }, {
    key: "getChangeNumber",
    value: function getChangeNumber(segmentName) {
      var segmentChangeNumberKey = this.keys.buildSegmentTillKey(segmentName);
      var value = this.segmentChangeNumber.get(segmentChangeNumberKey);

      return (0, _isInteger2.default)(value) ? value : -1;
    }
  }, {
    key: "flush",
    value: function flush() {
      this.segmentCache = new _map2.default();
      this.segmentChangeNumber = new _map2.default();
    }
  }]);
  return SegmentCacheInMemory;
}();

exports.default = SegmentCacheInMemory;
module.exports = exports.default;