'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isNan = require('babel-runtime/core-js/number/is-nan');

var _isNan2 = _interopRequireDefault(_isNan);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SegmentCacheInRedis = function () {
  function SegmentCacheInRedis(keys, redis) {
    (0, _classCallCheck3.default)(this, SegmentCacheInRedis);

    this.redis = redis;
    this.keys = keys;
  }

  (0, _createClass3.default)(SegmentCacheInRedis, [{
    key: 'addToSegment',
    value: function addToSegment(segmentName, segmentKeys) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      if (segmentKeys.length) {
        return this.redis.sadd(segmentKey, segmentKeys).then(function () {
          return true;
        });
      } else {
        return _promise2.default.resolve(true);
      }
    }
  }, {
    key: 'removeFromSegment',
    value: function removeFromSegment(segmentName, segmentKeys) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      if (segmentKeys.length) {
        return this.redis.srem(segmentKey, segmentKeys).then(function () {
          return true;
        });
      } else {
        return _promise2.default.resolve(true);
      }
    }
  }, {
    key: 'isInSegment',
    value: function isInSegment(segmentName, key) {
      return this.redis.sismember(this.keys.buildSegmentNameKey(segmentName), key).then(function (matches) {
        return matches !== 0;
      });
    }
  }, {
    key: 'setChangeNumber',
    value: function setChangeNumber(segmentName, changeNumber) {
      return this.redis.set(this.keys.buildSegmentTillKey(segmentName), changeNumber + '').then(function (status) {
        return status === 'OK';
      });
    }
  }, {
    key: 'getChangeNumber',
    value: function getChangeNumber(segmentName) {
      return this.redis.get(this.keys.buildSegmentTillKey(segmentName)).then(function (value) {
        var i = parseInt(value, 10);

        return (0, _isNan2.default)(i) ? -1 : i;
      });
    }
  }, {
    key: 'registerSegment',
    value: function registerSegment(segment) {
      return this.registerSegments(segment);
    }
  }, {
    key: 'registerSegments',
    value: function registerSegments(segments) {
      if (segments.length) {
        return this.redis.sadd(this.keys.buildRegisteredSegmentsKey(), segments).then(function () {
          return true;
        });
      } else {
        return _promise2.default.resolve(true);
      }
    }
  }, {
    key: 'getRegisteredSegments',
    value: function getRegisteredSegments() {
      return this.redis.smembers(this.keys.buildRegisteredSegmentsKey());
    }
  }, {
    key: 'flush',
    value: function flush() {
      return this.redis.flushdb().then(function (status) {
        return status === 'OK';
      });
    }
  }]);
  return SegmentCacheInRedis;
}();

exports.default = SegmentCacheInRedis;
module.exports = exports.default;