'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isNan = require('babel-runtime/core-js/number/is-nan');

var _isNan2 = _interopRequireDefault(_isNan);

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _lang = require('../../utils/lang');

var _usesSegments = require('../../utils/splits/usesSegments');

var _usesSegments2 = _interopRequireDefault(_usesSegments);

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-storage:localstorage');

var SplitCacheLocalStorage = function () {
  function SplitCacheLocalStorage(keys) {
    (0, _classCallCheck3.default)(this, SplitCacheLocalStorage);

    this.keys = keys;
  }

  (0, _createClass3.default)(SplitCacheLocalStorage, [{
    key: 'decrementCount',
    value: function decrementCount(key) {
      var count = (0, _lang.toNumber)(localStorage.getItem(key)) - 1;

      if (count > 0) localStorage.setItem(key, count);else localStorage.removeItem(key);
    }
  }, {
    key: 'decrementCounts',
    value: function decrementCounts(split) {
      try {
        if (split) {
          if (split.trafficTypeName) {
            var ttKey = this.keys.buildTrafficTypeKey(split.trafficTypeName);
            this.decrementCount(ttKey);
          }

          if ((0, _usesSegments2.default)(split.conditions)) {
            var segmentsCountKey = this.keys.buildSplitsWithSegmentCountKey();
            this.decrementCount(segmentsCountKey);
          }
        }
      } catch (e) {
        log.error(e);
      }
    }
  }, {
    key: 'incrementCounts',
    value: function incrementCounts(split) {
      try {
        if (split) {
          if (split.trafficTypeName) {
            var ttKey = this.keys.buildTrafficTypeKey(split.trafficTypeName);
            localStorage.setItem(ttKey, (0, _lang.toNumber)(localStorage.getItem(ttKey)) + 1);
          }

          if ((0, _usesSegments2.default)(split.conditions)) {
            var segmentsCountKey = this.keys.buildSplitsWithSegmentCountKey();
            localStorage.setItem(segmentsCountKey, (0, _lang.toNumber)(localStorage.getItem(segmentsCountKey)) + 1);
          }
        }
      } catch (e) {
        log.error(e);
      }
    }
  }, {
    key: 'addSplit',
    value: function addSplit(splitName, split) {
      try {
        var splitKey = this.keys.buildSplitKey(splitName);
        var splitFromLocalStorage = localStorage.getItem(splitKey);
        var previousSplit = splitFromLocalStorage ? JSON.parse(splitFromLocalStorage) : null;
        this.decrementCounts(previousSplit);

        localStorage.setItem(splitKey, split);

        var parsedSplit = split ? JSON.parse(split) : null;

        this.incrementCounts(parsedSplit);

        return true;
      } catch (e) {
        log.error(e);
        return false;
      }
    }
  }, {
    key: 'addSplits',
    value: function addSplits(entries) {
      var results = [];

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = (0, _getIterator3.default)(entries), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var _ref = _step.value;

          var _ref2 = (0, _slicedToArray3.default)(_ref, 2);

          var key = _ref2[0];
          var value = _ref2[1];

          results.push(this.addSplit(key, value));
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return results;
    }
  }, {
    key: 'removeSplit',
    value: function removeSplit(splitName) {
      try {
        var split = this.getSplit(splitName);
        localStorage.removeItem(this.keys.buildSplitKey(splitName));

        var parsedSplit = JSON.parse(split);
        this.decrementCounts(parsedSplit);

        return 1;
      } catch (e) {
        log.error(e);
        return 0;
      }
    }

    /**
     * Bulk delete of splits from LocalStorage. Returns the number of deleted keys.
     */

  }, {
    key: 'removeSplits',
    value: function removeSplits(names) {
      var i = 0;
      var len = names.length;
      var counter = 0;

      for (; i < len; i++) {
        counter += this.removeSplit(names[i]);
      }

      return counter;
    }
  }, {
    key: 'getSplit',
    value: function getSplit(splitName) {
      return localStorage.getItem(this.keys.buildSplitKey(splitName));
    }
  }, {
    key: 'setChangeNumber',
    value: function setChangeNumber(changeNumber) {
      try {
        localStorage.setItem(this.keys.buildSplitsTillKey(), changeNumber + '');
        return true;
      } catch (e) {
        log.error(e);
        return false;
      }
    }
  }, {
    key: 'getChangeNumber',
    value: function getChangeNumber() {
      var n = -1;
      var value = localStorage.getItem(this.keys.buildSplitsTillKey());

      if (value !== null) {
        value = parseInt(value, 10);

        return (0, _isNan2.default)(value) ? n : value;
      }

      return n;
    }
  }, {
    key: 'getAll',
    value: function getAll() {
      var len = localStorage.length;
      var accum = [];

      var cur = 0;

      while (cur < len) {
        var key = localStorage.key(cur);
        var value = key && localStorage.getItem(key);

        if (key != null && this.keys.isSplitKey(key) && value) accum.push(value);

        cur++;
      }

      return accum;
    }
  }, {
    key: 'getKeys',
    value: function getKeys() {
      var len = localStorage.length;
      var accum = [];

      var cur = 0;

      while (cur < len) {
        var key = localStorage.key(cur);

        if (key != null && this.keys.isSplitKey(key)) accum.push(this.keys.extractKey(key));

        cur++;
      }

      return accum;
    }
  }, {
    key: 'trafficTypeExists',
    value: function trafficTypeExists(trafficType) {
      var ttCount = (0, _lang.toNumber)(localStorage.getItem(this.keys.buildTrafficTypeKey(trafficType)));
      return (0, _lang.isFinite)(ttCount) && ttCount > 0;
    }
  }, {
    key: 'usesSegments',
    value: function usesSegments() {
      // If there are no splits in the cache yet, assume we need them.
      if (this.getChangeNumber() === -1) return true;

      var storedCount = localStorage.getItem(this.keys.buildSplitsWithSegmentCountKey());
      var splitsWithSegmentsCount = storedCount === null ? 0 : (0, _lang.toNumber)(storedCount);

      if ((0, _lang.isFinite)(splitsWithSegmentsCount)) {
        return splitsWithSegmentsCount > 0;
      } else {
        return true;
      }
    }
  }, {
    key: 'flush',
    value: function flush() {
      log.info('Flushing localStorage');
      localStorage.clear();
    }
  }]);
  return SplitCacheLocalStorage;
}();

exports.default = SplitCacheLocalStorage;
module.exports = exports.default;