'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _map = require('babel-runtime/core-js/map');

var _map2 = _interopRequireDefault(_map);

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _lang = require('../../utils/lang');

var _usesSegments = require('../../utils/splits/usesSegments');

var _usesSegments2 = _interopRequireDefault(_usesSegments);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SplitCacheInMemory = function () {
  function SplitCacheInMemory() {
    (0, _classCallCheck3.default)(this, SplitCacheInMemory);

    this.flush();
  }

  (0, _createClass3.default)(SplitCacheInMemory, [{
    key: 'addSplit',
    value: function addSplit(splitName, split) {
      var splitFromMemory = this.getSplit(splitName);
      if (splitFromMemory) {
        // We had this Split already
        var previousSplit = JSON.parse(splitFromMemory);

        if (previousSplit.trafficTypeName) {
          var previousTtName = previousSplit.trafficTypeName;
          this.ttCache[previousTtName]--;
          if (!this.ttCache[previousTtName]) delete this.ttCache[previousTtName];
        }

        if ((0, _usesSegments2.default)(previousSplit.conditions)) {
          // Substract from segments count for the previous version of this Split.
          this.splitsWithSegmentsCount--;
        }
      }

      var parsedSplit = JSON.parse(split);

      if (parsedSplit) {
        // Store the Split.
        this.splitCache.set(splitName, split);
        // Update TT cache
        var ttName = parsedSplit.trafficTypeName;
        if (ttName) {
          // safeguard
          if (!this.ttCache[ttName]) this.ttCache[ttName] = 0;
          this.ttCache[ttName]++;
        }

        // Add to segments count for the new version of the Split
        if ((0, _usesSegments2.default)(parsedSplit.conditions)) this.splitsWithSegmentsCount++;

        return true;
      } else {
        return false;
      }
    }
  }, {
    key: 'addSplits',
    value: function addSplits(entries) {
      var results = [];

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = (0, _getIterator3.default)(entries), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var _ref = _step.value;

          var _ref2 = (0, _slicedToArray3.default)(_ref, 2);

          var key = _ref2[0];
          var value = _ref2[1];

          results.push(this.addSplit(key, value));
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return results;
    }
  }, {
    key: 'removeSplit',
    value: function removeSplit(splitName) {
      var split = this.getSplit(splitName);
      if (split) {
        // Delete the Split
        this.splitCache.delete(splitName);

        var parsedSplit = JSON.parse(split);
        var ttName = parsedSplit.trafficTypeName;

        if (ttName) {
          // safeguard
          this.ttCache[ttName]--; // Update tt cache
          if (!this.ttCache[ttName]) delete this.ttCache[ttName];
        }

        // Update the segments count.
        if ((0, _usesSegments2.default)(parsedSplit.conditions)) this.splitsWithSegmentsCount--;

        return 1;
      } else {
        return 0;
      }
    }
  }, {
    key: 'removeSplits',
    value: function removeSplits(splitNames) {
      var _this = this;

      splitNames.forEach(function (n) {
        return _this.removeSplit(n);
      });

      return splitNames.length;
    }
  }, {
    key: 'getSplit',
    value: function getSplit(splitName) {
      return this.splitCache.get(splitName);
    }
  }, {
    key: 'setChangeNumber',
    value: function setChangeNumber(changeNumber) {
      this.changeNumber = changeNumber;

      return true;
    }
  }, {
    key: 'getChangeNumber',
    value: function getChangeNumber() {
      return this.changeNumber;
    }
  }, {
    key: 'getAll',
    value: function getAll() {
      return [].concat((0, _toConsumableArray3.default)(this.splitCache.values()));
    }
  }, {
    key: 'getKeys',
    value: function getKeys() {
      return [].concat((0, _toConsumableArray3.default)(this.splitCache.keys()));
    }
  }, {
    key: 'trafficTypeExists',
    value: function trafficTypeExists(trafficType) {
      return (0, _lang.isFinite)(this.ttCache[trafficType]) && this.ttCache[trafficType] > 0;
    }
  }, {
    key: 'usesSegments',
    value: function usesSegments() {
      return this.getChangeNumber() === -1 || this.splitsWithSegmentsCount > 0;
    }
  }, {
    key: 'flush',
    value: function flush() {
      this.splitCache = new _map2.default();
      this.ttCache = {};
      this.changeNumber = -1;
      this.splitsWithSegmentsCount = 0;
    }
  }]);
  return SplitCacheInMemory;
}();

exports.default = SplitCacheInMemory;
module.exports = exports.default;