'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _InMemory = require('./SplitCache/InMemory');

var _InMemory2 = _interopRequireDefault(_InMemory);

var _InLocalStorage = require('./SplitCache/InLocalStorage');

var _InLocalStorage2 = _interopRequireDefault(_InLocalStorage);

var _InMemory3 = require('./SegmentCache/InMemory');

var _InMemory4 = _interopRequireDefault(_InMemory3);

var _InLocalStorage3 = require('./SegmentCache/InLocalStorage');

var _InLocalStorage4 = _interopRequireDefault(_InLocalStorage3);

var _InMemory5 = require('./ImpressionsCache/InMemory');

var _InMemory6 = _interopRequireDefault(_InMemory5);

var _InMemory7 = require('./LatencyCache/InMemory');

var _InMemory8 = _interopRequireDefault(_InMemory7);

var _InMemory9 = require('./CountCache/InMemory');

var _InMemory10 = _interopRequireDefault(_InMemory9);

var _InMemory11 = require('./EventsCache/InMemory');

var _InMemory12 = _interopRequireDefault(_InMemory11);

var _Keys = require('./Keys');

var _Keys2 = _interopRequireDefault(_Keys);

var _KeysLocalStorage = require('./KeysLocalStorage');

var _KeysLocalStorage2 = _interopRequireDefault(_KeysLocalStorage);

var _constants = require('../utils/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var BrowserStorageFactory = function BrowserStorageFactory(context) {
  var settings = context.get(context.constants.SETTINGS);
  var storage = settings.storage;


  switch (storage.type) {
    case _constants.STORAGE_MEMORY:
      {
        var keys = new _Keys2.default(settings);

        return {
          splits: new _InMemory2.default(),
          segments: new _InMemory4.default(keys),
          impressions: new _InMemory6.default(),
          metrics: new _InMemory8.default(),
          count: new _InMemory10.default(),
          events: new _InMemory12.default(context),

          // When using shared instanciation with MEMORY we reuse everything but segments (they are customer per key).
          shared: function shared(settings) {
            var childKeyBuilder = new _Keys2.default(settings);

            return {
              splits: this.splits,
              segments: new _InMemory4.default(childKeyBuilder),
              impressions: this.impressions,
              metrics: this.metrics,
              count: this.count,
              events: this.events,

              destroy: function destroy() {
                this.splits = new _InMemory2.default();
                this.segments.flush();
              }
            };
          },
          destroy: function destroy() {
            this.splits.flush();
            this.segments.flush();
            this.impressions.clear();
            this.metrics.clear();
            this.count.clear();
            this.events.clear();
          }
        };
      }

    case _constants.STORAGE_LOCALSTORAGE:
      {
        var _keys = new _KeysLocalStorage2.default(settings);

        return {
          splits: new _InLocalStorage2.default(_keys),
          segments: new _InLocalStorage4.default(_keys),
          impressions: new _InMemory6.default(),
          metrics: new _InMemory8.default(),
          count: new _InMemory10.default(),
          events: new _InMemory12.default(context),

          // When using shared instanciation with MEMORY we reuse everything but segments (they are customer per key).
          shared: function shared(settings) {
            var childKeysBuilder = new _KeysLocalStorage2.default(settings);

            return {
              splits: this.splits,
              segments: new _InLocalStorage4.default(childKeysBuilder),
              impressions: this.impressions,
              metrics: this.metrics,
              count: this.count,
              events: this.events,

              destroy: function destroy() {
                this.splits = new _InMemory2.default();
                this.segments = new _InMemory4.default(childKeysBuilder);
              }
            };
          },
          destroy: function destroy() {
            this.splits = new _InMemory2.default();
            this.segments = new _InMemory4.default(new _Keys2.default(settings));
            this.impressions.clear();
            this.metrics.clear();
            this.count.clear();
            this.events.clear();
          }
        };
      }

    default:
      throw new Error('Unsupported storage type');
  }
};

exports.default = BrowserStorageFactory;
module.exports = exports.default;