'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _RedisAdapter = require('./RedisAdapter');

var _RedisAdapter2 = _interopRequireDefault(_RedisAdapter);

var _InMemory = require('./SplitCache/InMemory');

var _InMemory2 = _interopRequireDefault(_InMemory);

var _InRedis = require('./SplitCache/InRedis');

var _InRedis2 = _interopRequireDefault(_InRedis);

var _InMemory3 = require('./SegmentCache/InMemory');

var _InMemory4 = _interopRequireDefault(_InMemory3);

var _InRedis3 = require('./SegmentCache/InRedis');

var _InRedis4 = _interopRequireDefault(_InRedis3);

var _InMemory5 = require('./ImpressionsCache/InMemory');

var _InMemory6 = _interopRequireDefault(_InMemory5);

var _InRedis5 = require('./ImpressionsCache/InRedis');

var _InRedis6 = _interopRequireDefault(_InRedis5);

var _InMemory7 = require('./LatencyCache/InMemory');

var _InMemory8 = _interopRequireDefault(_InMemory7);

var _InRedis7 = require('./LatencyCache/InRedis');

var _InRedis8 = _interopRequireDefault(_InRedis7);

var _InMemory9 = require('./CountCache/InMemory');

var _InMemory10 = _interopRequireDefault(_InMemory9);

var _InRedis9 = require('./CountCache/InRedis');

var _InRedis10 = _interopRequireDefault(_InRedis9);

var _InMemory11 = require('./EventsCache/InMemory');

var _InMemory12 = _interopRequireDefault(_InMemory11);

var _InRedis11 = require('./EventsCache/InRedis');

var _InRedis12 = _interopRequireDefault(_InRedis11);

var _Keys = require('./Keys');

var _Keys2 = _interopRequireDefault(_Keys);

var _Meta = require('./Meta');

var _Meta2 = _interopRequireDefault(_Meta);

var _constants = require('../utils/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NodeStorageFactory = function NodeStorageFactory(context) {
  var settings = context.get(context.constants.SETTINGS);
  var storage = settings.storage;

  var keys = new _Keys2.default(settings);

  switch (storage.type) {
    case _constants.STORAGE_REDIS:
      {
        var redis = new _RedisAdapter2.default(storage.options);
        var meta = (0, _Meta2.default)(settings);

        return {
          splits: new _InRedis2.default(keys, redis),
          segments: new _InRedis4.default(keys, redis),
          impressions: new _InRedis6.default(keys, redis, meta),
          metrics: new _InRedis8.default(keys, redis),
          count: new _InRedis10.default(keys, redis),
          events: new _InRedis12.default(keys, redis, meta),

          // When using REDIS we should:
          // 1- Disconnect from the storage
          // 2- Stop sending data to Redis and instance using empty in memory implementation
          destroy: function destroy() {
            redis.disconnect();

            this.splits = new _InMemory2.default();
            this.segments = new _InMemory4.default(keys);
            this.impressions = new _InMemory6.default();
            this.metrics = new _InMemory8.default();
            this.count = new _InMemory10.default();
            this.events = new _InMemory12.default(context);
          }
        };
      }

    case _constants.STORAGE_MEMORY:
    default:
      return {
        splits: new _InMemory2.default(),
        segments: new _InMemory4.default(keys),
        impressions: new _InMemory6.default(),
        metrics: new _InMemory8.default(),
        count: new _InMemory10.default(),
        events: new _InMemory12.default(context),

        // When using MEMORY we should flush all the storages and leave them empty
        destroy: function destroy() {
          this.splits.flush();
          this.segments.flush();
          this.impressions.clear();
          this.metrics.clear();
          this.count.clear();
          this.events.clear();
        }
      };
  }
};

exports.default = NodeStorageFactory;
module.exports = exports.default;