'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

exports.validateApiKey = validateApiKey;
exports.releaseApiKey = releaseApiKey;

var _lang = require('../lang');

var _logger = require('../logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', {
  displayAllErrors: true
});

var usedKeysMap = {};

function validateApiKey(maybeApiKey) {
  var apiKey = false;
  if (maybeApiKey == undefined) {
    // eslint-disable-line eqeqeq
    log.error('Factory instantiation: you passed a null or undefined api_key, api_key must be a non-empty string.');
  } else if ((0, _lang.isString)(maybeApiKey)) {
    if (maybeApiKey.length > 0) apiKey = maybeApiKey;else log.error('Factory instantiation: you passed an empty api_key, api_key must be a non-empty string.');
  } else {
    log.error('Factory instantiation: you passed an invalid api_key, api_key must be a non-empty string.');
  }

  // If the apiKey is correct, we'll save it as the instance creation should work.
  if (apiKey) {
    if (!usedKeysMap[apiKey]) {
      // If this key is not present, only warning scenarios is that we have factories for other keys.
      usedKeysMap[apiKey] = 1;
      if ((0, _keys2.default)(usedKeysMap).length > 1) {
        log.warn('Factory instantiation: You already have an instance of the Split factory. Make sure you definitely want this additional instance. We recommend keeping only one instance of the factory at all times (Singleton pattern) and reusing it throughout your application.');
      }
    } else {
      log.warn('Factory instantiation: You already have ' + usedKeysMap[apiKey] + ' ' + (usedKeysMap[apiKey] === 1 ? 'factory' : 'factories') + ' with this API Key. We recommend keeping only one instance of the factory at all times (Singleton pattern) and reusing it throughout your application.');
      usedKeysMap[apiKey]++;
    }
  }

  return apiKey;
}

function releaseApiKey(apiKey) {
  if (usedKeysMap[apiKey]) usedKeysMap[apiKey]--;
  if (usedKeysMap[apiKey] === 0) delete usedKeysMap[apiKey];
}