'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAttributes = validateAttributes;

var _lang = require('../lang');

var _logger = require('../logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', {
  displayAllErrors: true
});

function validateAttributes(maybeAttrs, method) {
  // Attributes are optional
  if ((0, _lang.isObject)(maybeAttrs) || maybeAttrs == undefined) // eslint-disable-line eqeqeq
    return maybeAttrs;

  log.error(method + ': attributes must be a plain object.');
  return false;
}