'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEventValue = validateEventValue;

var _lang = require('../lang');

var _logger = require('../logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', {
  displayAllErrors: true
});

function validateEventValue(maybeValue, method) {
  if ((0, _lang.isFinite)(maybeValue) || maybeValue == undefined) // eslint-disable-line eqeqeq
    return maybeValue;

  log.error(method + ': value must be a finite number.');
  return false;
}