'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateIfDestroyed = validateIfDestroyed;
exports.validateIfReady = validateIfReady;

var _logger = require('../logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', { displayAllErrors: true });

function validateIfDestroyed(context) {
  if (!context.get(context.constants.DESTROYED, true)) return true;

  log.error('Client has already been destroyed - no calls possible.');
  return false;
}

function validateIfReady(context, method) {
  if (context.get(context.constants.READY, true)) return true;

  log.warn(method + ': the SDK is not ready, results may be incorrect. Make sure to wait for SDK readiness before using this method.');
  return false;
}