'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateKey = validateKey;

var _lang = require('../lang');

var _logger = require('../logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', {
  displayAllErrors: true
});

var KEY_MAX_LENGTH = 250;

function validateKeyValue(maybeKey, method, type) {
  if (maybeKey == undefined) {
    // eslint-disable-line eqeqeq
    log.error(method + ': you passed a null or undefined ' + type + ', ' + type + ' must be a non-empty string.');
  } else if ((0, _lang.isFinite)(maybeKey) || (0, _lang.isString)(maybeKey)) {
    if ((0, _lang.isFinite)(maybeKey)) {
      log.warn(method + ': ' + type + ' "' + maybeKey + '" is not of type string, converting.');
      return (0, _lang.toString)(maybeKey);
    }
    // It's a string, start by trimming the value.
    maybeKey = maybeKey.trim();

    // It's aaaaaall good.
    if (maybeKey.length > 0 && maybeKey.length <= KEY_MAX_LENGTH) return maybeKey;

    if (maybeKey.length === 0) {
      log.error(method + ': you passed an empty string, ' + type + ' must be a non-empty string.');
    } else if (maybeKey.length > KEY_MAX_LENGTH) {
      log.error(method + ': ' + type + ' too long, ' + type + ' must be 250 characters or less.');
    }
  } else {
    log.error(method + ': you passed an invalid ' + type + ' type, ' + type + ' must be a non-empty string.');
  }

  return false;
}

function validateKey(maybeKey, method) {
  if ((0, _lang.isObject)(maybeKey)) {
    // Validate key object
    var matchingKey = validateKeyValue(maybeKey.matchingKey, method, 'matchingKey');
    var bucketingKey = validateKeyValue(maybeKey.bucketingKey, method, 'bucketingKey');

    if (matchingKey && bucketingKey) return {
      matchingKey: matchingKey, bucketingKey: bucketingKey
    };

    log.error(method + ': Key must be an object with bucketingKey and matchingKey with valid string properties.');
    return false;
  } else {
    return validateKeyValue(maybeKey, method, 'key');
  }
}