'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSplits = validateSplits;

var _lang = require('../lang');

var _logger = require('../logger');

var _logger2 = _interopRequireDefault(_logger);

var _split = require('./split');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', {
  displayAllErrors: true
});

function validateSplits(maybeSplits, method) {
  if (Array.isArray(maybeSplits) && maybeSplits.length > 0) {
    var validatedArray = [];
    // Remove invalid values
    maybeSplits.forEach(function (maybeSplit) {
      var splitName = (0, _split.validateSplit)(maybeSplit);
      if (splitName) validatedArray.push(splitName);
    });

    // Strip off duplicated values if we have valid split names then return
    if (validatedArray.length) return (0, _lang.uniq)(validatedArray);
  }

  log.error(method + ': split_names must be a non-empty array.');
  return false;
}