'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lang = require('../lang');

/**
 * Verify type of key and return a valid object key used for get treatment for a
 * specific split.
 */
exports.default = function (key) {
  if ((0, _lang.isObject)(key)) {
    return {
      matchingKey: key.matchingKey,
      bucketingKey: key.bucketingKey
    };
  } else {
    return {
      matchingKey: key,
      bucketingKey: key
    };
  }
}; /**
   Copyright 2016 Split Software
   
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
   
       http://www.apache.org/licenses/LICENSE-2.0
   
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   **/


module.exports = exports.default;