'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _filter = require('babel-runtime/core-js/array/filter');

var _filter2 = _interopRequireDefault(_filter);

var _typeof2 = require('babel-runtime/helpers/typeof');

var _typeof3 = _interopRequireDefault(_typeof2);

var _isFinite = require('babel-runtime/core-js/number/is-finite');

var _isFinite2 = _interopRequireDefault(_isFinite);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

exports.startsWith = startsWith;
exports.endsWith = endsWith;
exports.get = get;
exports.findIndex = findIndex;
exports.find = find;
exports.isString = isString;
exports.isFinite = isFinite;
exports.uniqueId = uniqueId;
exports.isObject = isObject;
exports.merge = merge;
exports.uniq = uniq;
exports.toString = toString;
exports.toNumber = toNumber;
exports.forOwn = forOwn;
exports.groupBy = groupBy;
exports.getFnName = getFnName;
exports.shallowClone = shallowClone;
exports.isBoolean = isBoolean;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Checks if the target string starts with the sub string.
 */
function startsWith(target, sub) {
  if (!(isString(target) && isString(sub))) {
    return false;
  }
  return target.slice(0, sub.length) === sub;
}

/**
 * Checks if the target string ends with the sub string.
 */
function endsWith(target, sub) {
  var caseInsensitive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  if (!(isString(target) && isString(sub))) {
    return false;
  }
  if (caseInsensitive) {
    target = target.toLowerCase();
    sub = sub.toLowerCase();
  }
  return target.slice(target.length - sub.length) === sub;
}

/**
 * Safely retrieve the specified prop from obj. If we can't retrieve
 * that property value, we return the default value.
 */
function get(obj, prop, val) {
  var res = val;

  try {
    // No risks nor lots of checks.
    var pathPieces = prop.split('.');
    var partial = obj;
    pathPieces.forEach(function (pathPiece) {
      return partial = partial[pathPiece];
    });

    if (typeof partial !== 'undefined') res = partial;
  } catch (e) {
    // noop
  }
  return res;
}

/**
 * Evaluates iteratee for each element of the source array. Returns the index of the first element
 * for which iteratee returns truthy. If no element is found or there's an issue with the params it returns -1.
 */
function findIndex(source, iteratee) {
  if (Array.isArray(source) && typeof iteratee === 'function') {
    for (var i = 0; i < source.length; i++) {
      if (iteratee(source[i], i, source) === true) {
        return i;
      }
    }
  }

  return -1;
}

/**
 * Loops through a source collection (an object or an array) running iteratee
 * against each element. It returns the first element for which iteratee returned
 * a truthy value and stops the loop.
 * Iteratee receives three arguments (element, key/index, collection)
 */
function find(source, iteratee) {
  var res = void 0;

  if (isObject(source)) {
    var keys = (0, _keys2.default)(source);
    for (var i = 0; i < keys.length && !res; i++) {
      var key = keys[i];
      var iterateeResult = iteratee(source[key], key, source);

      if (iterateeResult) res = source[key];
    }
  } else if (Array.isArray(source)) {
    for (var _i = 0; _i < source.length && !res; _i++) {
      var _iterateeResult = iteratee(source[_i], _i, source);

      if (_iterateeResult) res = source[_i];
    }
  }

  return res;
}

/**
 * Checks if a given value is a string.
 */
function isString(val) {
  return typeof val === 'string' || val instanceof String;
}

/**
 * Checks if a given value is a finite number.
 */
function isFinite(val) {
  if (typeof val === 'number') return (0, _isFinite2.default)(val);
  if (val instanceof Number) return (0, _isFinite2.default)(val.valueOf());

  return false;
}

var uniqueIdCounter = -1;

/**
 * Returns a number to be used as ID, which will be unique.
 */
function uniqueId() {
  return uniqueIdCounter++;
}

/**
 * Validates if a value is an object.
 */
function isObject(obj) {
  return obj && (typeof obj === 'undefined' ? 'undefined' : (0, _typeof3.default)(obj)) === 'object' && obj.constructor === Object;
}

/**
 * There are some assumptions here. It's for internal use and we don't need verbose errors
 * or to ensure the data types or whatever. Parameters should always be correct (at least have a target and a source, of type object).
 */
function merge(target, source) {
  var res = target;

  isObject(source) && (0, _keys2.default)(source).forEach(function (key) {
    var val = source[key];

    if (isObject(val)) {
      if (res[key] && isObject(res[key])) {
        // If both are objects, merge into a new one.
        val = merge({}, res[key], val);
      } else {
        // else make a copy.
        val = merge({}, val);
      }
    }
    // We skip undefined values.
    if (val !== undefined) res[key] = val;
  });

  for (var _len = arguments.length, rest = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    rest[_key - 2] = arguments[_key];
  }

  if (rest && rest.length) {
    var nextSource = rest.splice(0, 1)[0];
    res = merge.apply(undefined, [res, nextSource].concat(rest));
  }

  return res;
}

/**
 * Removes duplicate items on an array of strings.
 */
function uniq(arr) {
  var seen = {};
  return (0, _filter2.default)(arr, function (item) {
    return seen.hasOwnProperty(item) ? false : seen[item] = true;
  });
}

/**
 * Transforms a value into it's string representation.
 */
function toString(val) {
  if (val == null) return '';
  if (typeof val === 'string') return val;
  if (Array.isArray(val)) return val.map(function (val) {
    return isString(val) ? val : '';
  }) + '';

  var result = val + '';
  return result === '0' && 1 / val === Number.NEGATIVE_INFINITY ? '-0' : result;
}

/**
 * Transforms a value into a number.
 * Note: We're not expecting anything fancy here. If we are at some point, add more type checks.
 */
function toNumber(val) {
  if (typeof val === 'number') return val;

  if (isObject(val) && typeof val.valueOf === 'function') {
    var valOf = val.valueOf();
    val = isObject(valOf) ? valOf + '' : valOf;
  }

  if (typeof val !== 'string') {
    return val === 0 ? val : +val;
  }

  // Remove trailing whitespaces.
  val = val.replace(/^\s+|\s+$/g, '');

  return +val;
}

/**
 * Executes iteratee for given obj own props.
 */
function forOwn(obj, iteratee) {
  var keys = (0, _keys2.default)(obj);

  keys.forEach(function (key) {
    return iteratee(obj[key], key, obj);
  });

  return obj;
}

/**
 * Parses an array into a map of different arrays, grouping by the specified prop value.
 */
function groupBy(source, prop) {
  var map = {};

  if (Array.isArray(source) && isString(prop)) {
    for (var i = 0; i < source.length; i++) {
      var key = source[i][prop];

      // Skip the element if the key is not a string.
      if (isString(key)) {
        if (!map[key]) map[key] = [];

        map[key].push(source[i]);
      }
    }
  }

  return map;
}

/**
 * Returns the name of a given function.
 */
function getFnName(fn) {
  if (fn.name) return fn.name;

  return (fn.toString().match(/function (.+?)\(/) || ['', ''])[1];
}

/**
 * Shallow clone an object
 */
function shallowClone(obj) {
  var keys = (0, _keys2.default)(obj);
  var output = {};

  for (var i = 0; i < keys.length; i++) {
    output[keys[i]] = obj[keys[i]];
  }

  return output;
}

function isBoolean(val) {
  return val === true || val === false;
}