/* eslint-disable no-console */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logger = exports.setLogLevel = exports.LogLevels = undefined;

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var isNode = typeof process !== 'undefined' && process.version ? true : false;

var LogLevels = exports.LogLevels = {
  'DEBUG': 'DEBUG',
  'INFO': 'INFO',
  'WARN': 'WARN',
  'ERROR': 'ERROR',
  'NONE': 'NONE'
};

// DEBUG is the default. The log level is not specific to an SDK instance.
var GlobalLogLevel = LogLevels.DEBUG;

var setLogLevel = exports.setLogLevel = function setLogLevel(level) {
  GlobalLogLevel = level;
};

var defaultOptions = {
  showLevel: true,
  displayAllErrors: false
};

var Logger = exports.Logger = function () {
  function Logger(category, options) {
    (0, _classCallCheck3.default)(this, Logger);

    this.category = category;
    this.options = (0, _assign2.default)({}, defaultOptions, options);
  }

  (0, _createClass3.default)(Logger, [{
    key: 'debug',
    value: function debug(msg) {
      if (this._shouldLog(LogLevels.DEBUG)) this._log(LogLevels.DEBUG, msg);
    }
  }, {
    key: 'info',
    value: function info(msg) {
      if (this._shouldLog(LogLevels.INFO)) this._log(LogLevels.INFO, msg);
    }
  }, {
    key: 'warn',
    value: function warn(msg) {
      if (this._shouldLog(LogLevels.WARN)) this._log(LogLevels.WARN, msg);
    }
  }, {
    key: 'error',
    value: function error(msg) {
      if (this.options.displayAllErrors || this._shouldLog(LogLevels.ERROR)) this._log(LogLevels.ERROR, msg);
    }
  }, {
    key: '_log',
    value: function _log(level, text) {
      var formattedText = this._generateLogMessage(level, text);
      var method = level === LogLevels.ERROR && !isNode ? 'error' : 'log';

      console[method](formattedText);
    }
  }, {
    key: '_generateLogMessage',
    value: function _generateLogMessage(level, text) {
      var textPre = ' => ';
      var result = '';

      if (this.options.showLevel) {
        result += '[' + level + ']' + (level === LogLevels.INFO || level === LogLevels.WARN ? ' ' : '') + ' ';
      }

      if (this.category) {
        result += this.category + textPre;
      }

      return result += text;
    }
  }, {
    key: '_shouldLog',
    value: function _shouldLog(level) {
      var logLevel = GlobalLogLevel;
      var levels = (0, _keys2.default)(LogLevels).map(function (f) {
        return LogLevels[f];
      });
      var index = levels.indexOf(level); // What's the index of what it's trying to check if it should log
      var levelIdx = levels.indexOf(logLevel); // What's the current log level index.

      return index >= levelIdx;
    }
  }]);
  return Logger;
}();