'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.API = undefined;

var _LoggerFactory = require('./LoggerFactory');

var _isAvailable = require('../localstorage/isAvailable');

var _isAvailable2 = _interopRequireDefault(_isAvailable);

var _lang = require('../lang');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var isLogLevelString = function isLogLevelString(str) {
  return !!(0, _lang.find)(_LoggerFactory.LogLevels, function (lvl) {
    return str === lvl;
  });
}; /**
   Copyright 2016 Split Software
   
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
   
       http://www.apache.org/licenses/LICENSE-2.0
   
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   **/

var defaultOptions = {
  showLevel: true,
  forceDisplayErrors: false
};

var LS_KEY = 'splitio_debug';
var ENV_VAR_KEY = 'SPLITIO_DEBUG';
var isNode = false;

// We check for version truthiness since most shims will have that as empty string.
if (typeof process !== 'undefined' && typeof process.version !== 'undefined' && !!process.version) {
  isNode = true;
}

var initialState = String(isNode ? process.env[ENV_VAR_KEY] : (0, _isAvailable2.default)() ? localStorage.getItem(LS_KEY) : '');

var createLog = function createLog(namespace) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return new _LoggerFactory.Logger(namespace, (0, _lang.merge)(options, defaultOptions));
};

var ownLog = createLog('splitio-utils:logger');

/**
 * The public Logger utility API.
 */
var API = exports.API = {
  /**
   * Enables all the logs.
   */
  enable: function enable() {
    (0, _LoggerFactory.setLogLevel)(_LoggerFactory.LogLevels.DEBUG);
  },

  /**
   * Sets a custom log Level for the SDK.
   * @param {string} logLevel - Custom LogLevel value.
   */
  setLogLevel: function setLogLevel(logLevel) {
    if (isLogLevelString(logLevel)) {
      (0, _LoggerFactory.setLogLevel)(logLevel);
    } else {
      ownLog.error('Invalid Log Level - No changes to the logs will be applied.');
    }
  },

  /**
   * Disables all the log levels.
   */
  disable: function disable() {
    // Disabling is equal logLevel none
    (0, _LoggerFactory.setLogLevel)(_LoggerFactory.LogLevels.NONE);
  },

  /**
   * Exposed for usage with setLogLevel
   */
  LogLevel: _LoggerFactory.LogLevels
};

// "enable", "enabled" and "on", are synonims with 'DEBUG' loglevel
if (/^(enabled?|on)/i.test(initialState)) {
  API.enable(_LoggerFactory.LogLevels.DEBUG);
} else if (isLogLevelString(initialState)) {
  API.setLogLevel(initialState);
} else {
  // By default it starts disabled.
  API.disable();
}

// By default we expose logger instance creator wrapper.
exports.default = createLog;