'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _isAvailable = require('../../../utils/localstorage/isAvailable');

var _isAvailable2 = _interopRequireDefault(_isAvailable);

var _constants = require('../../../utils/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-settings'); /**
                                                     Copyright 2016 Split Software
                                                     
                                                     Licensed under the Apache License, Version 2.0 (the "License");
                                                     you may not use this file except in compliance with the License.
                                                     You may obtain a copy of the License at
                                                     
                                                         http://www.apache.org/licenses/LICENSE-2.0
                                                     
                                                     Unless required by applicable law or agreed to in writing, software
                                                     distributed under the License is distributed on an "AS IS" BASIS,
                                                     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                     See the License for the specific language governing permissions and
                                                     limitations under the License.
                                                     **/

var ParseStorageSettings = function ParseStorageSettings(settings) {
  var mode = settings.mode,
      _settings$storage = settings.storage,
      _settings$storage$typ = _settings$storage.type,
      type = _settings$storage$typ === undefined ? _constants.STORAGE_MEMORY : _settings$storage$typ,
      _settings$storage$opt = _settings$storage.options,
      options = _settings$storage$opt === undefined ? {} : _settings$storage$opt,
      prefix = _settings$storage.prefix;


  if (prefix) {
    prefix += '.SPLITIO';
  } else {
    prefix = 'SPLITIO';
  }

  if (mode === _constants.LOCALHOST_MODE) return {
    type: _constants.STORAGE_MEMORY,
    prefix: prefix
  };

  // If an invalid storage type is provided OR we want to use LOCALSTORAGE and
  // it's not available, fallback into MEMORY
  if (type !== _constants.STORAGE_MEMORY && type !== _constants.STORAGE_LOCALSTORAGE || type === _constants.STORAGE_LOCALSTORAGE && !(0, _isAvailable2.default)()) {
    type = _constants.STORAGE_MEMORY;
    log.warn('Invalid or unavailable storage. Fallbacking into MEMORY storage');
  }

  return {
    type: type,
    options: options,
    prefix: prefix
  };
};

exports.default = ParseStorageSettings;
module.exports = exports.default;