'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _constants = require('../../constants');

var ParseStorageSettings = function ParseStorageSettings(settings) {
  var mode = settings.mode,
      _settings$storage = settings.storage,
      type = _settings$storage.type,
      _settings$storage$opt = _settings$storage.options,
      options = _settings$storage$opt === undefined ? {} : _settings$storage$opt,
      prefix = _settings$storage.prefix;


  if (prefix) {
    prefix += '.SPLITIO';
  } else {
    prefix = 'SPLITIO';
  }

  // In localhost mode we should force the user to use the MEMORY storage
  if (mode === _constants.LOCALHOST_MODE) return {
    type: _constants.STORAGE_MEMORY,
    prefix: prefix
  };

  // In other cases we can have MEMORY or REDIS
  switch (type) {
    case _constants.STORAGE_REDIS:
      {
        var host = options.host,
            port = options.port,
            db = options.db,
            pass = options.pass,
            url = options.url,
            connectionTimeout = options.connectionTimeout,
            operationTimeout = options.operationTimeout;


        if (process.env.REDIS_HOST) host = process.env.REDIS_HOST;
        if (process.env.REDIS_PORT) port = process.env.REDIS_PORT;
        if (process.env.REDIS_DB) db = process.env.REDIS_DB;
        if (process.env.REDIS_PASS) pass = process.env.REDIS_PASS;
        if (process.env.REDIS_URL) url = process.env.REDIS_URL;

        var newOpts = {
          connectionTimeout: connectionTimeout, operationTimeout: operationTimeout
        };

        if (url) {
          newOpts.url = url;
        } else {
          newOpts.host = host;
          newOpts.port = port;
          newOpts.db = db;
          newOpts.pass = pass;
        }

        return {
          type: type,
          prefix: prefix,
          options: newOpts
        };
      }

    // For now, we don't have modifiers or settings for MEMORY in NodeJS
    case _constants.STORAGE_MEMORY:
    default:
      {
        return {
          type: _constants.STORAGE_MEMORY,
          prefix: prefix
        };
      }
  }
}; /**
   Copyright 2016 Split Software
   
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
   
       http://www.apache.org/licenses/LICENSE-2.0
   
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   **/
exports.default = ParseStorageSettings;
module.exports = exports.default;