/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
//
// JAVA reference implementation for the hashing function.
//
// int h = 0;
// for (int i = 0; i < key.length(); i++) {
//     h = 31 * h + key.charAt(i);
// }
// return h ^ seed; // XOR the hash and seed
//

function ToInteger(x) {
  x = Number(x);
  return x < 0 ? Math.ceil(x) : Math.floor(x);
}

function modulo(a, b) {
  return a - Math.floor(a / b) * b;
}

function ToUint32(x) {
  return modulo(ToInteger(x), Math.pow(2, 32));
}

function ToInt32(x) {
  let uint32 = ToUint32(x);

  if (uint32 >= Math.pow(2, 31)) {
    return uint32 - Math.pow(2, 32);
  } else {
    return uint32;
  }
}

function hash(str /*: string */, seed /*: number */) /*: number */ {
  let h = 0;

  for (let c of str) {
    h = ToInt32(ToInt32(31 * h) + c.charCodeAt(0));
  }

  return ToInt32(h ^ seed);
}

function bucket(str /*: string */, seed /*: number */) /*: number */ {
  return Math.abs(hash(str, seed) % 100) + 1;
}

export default {
  hash,
  bucket
};