import { Directive, Input, Output, EventEmitter, Inject, ElementRef } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { fromEvent } from 'rxjs';
import { sampleTime } from 'rxjs/operators';
import { CompositeDisposable, Disposable } from 'ts-disposables';
import * as _$ from 'jquery';
const $ = _$;
export class ResizerDirective {
    constructor(element, document) {
        this.element = element;
        this.document = document;
        this.dragInProgress = false;
        this.vertical = true;
        this._subscriptions = new CompositeDisposable();
        this.sizeChange = new EventEmitter();
        this.mouseMoveHandler = (e) => {
            if (this.dragInProgress) {
                this.mousemove(e);
            }
        };
    }
    set splitSize(splitSize) {
        if (this.maxSplitSize && splitSize > this.maxSplitSize) {
            splitSize = this.maxSplitSize;
        }
        if (this.vertical) {
            // Handle vertical resizer
            $(this.element.nativeElement).css({
                left: splitSize + 'px'
            });
            $(this.element.nativeElement).parent().find(this.first).css({
                width: splitSize + 'px'
            });
            $(this.element.nativeElement).parent().find(this.second).css({
                left: (splitSize + this._size) + 'px'
            });
        }
        else {
            // Handle horizontal resizer
            $(this.element.nativeElement).css({
                bottom: splitSize + 'px'
            });
            $(this.element.nativeElement).parent().find(this.first).css({
                bottom: (splitSize + this._size) + 'px'
            });
            $(this.element.nativeElement).parent().find(this.second).css({
                height: splitSize + 'px'
            });
        }
        this._splitSize = splitSize;
        // Update the local field
        this.sizeChange.emit(splitSize);
    }
    set resizerWidth(width) {
        this._size = width;
        this.vertical = true;
    }
    set resizerHeight(height) {
        this._size = height;
        this.vertical = false;
    }
    set resizerLeft(first) {
        this.first = first;
    }
    set resizerTop(first) {
        this.first = first;
    }
    set resizerRight(second) {
        this.second = second;
    }
    set resizerBottom(second) {
        this.second = second;
    }
    startDrag() {
        this.dragInProgress = true;
    }
    mousemove(event) {
        let size;
        if (this.vertical) { // Handle vertical resizer. Calculate new size relative to palette container DOM node
            size = event.pageX - $(this.first).offset().left;
        }
        else {
            // Handle horizontal resizer Calculate new size relative to palette container DOM node
            size = window.innerHeight - event.pageY - $(this.second).offset().top;
        }
        this.splitSize = size;
    }
    ngOnInit() {
        // Need to set left and right elements width and fire events on init when DOM is built
        this.splitSize = this._splitSize;
        let subscription1 = fromEvent($(this.document).get(0), 'mousemove')
            .pipe(sampleTime(300))
            .subscribe(this.mouseMoveHandler);
        this._subscriptions.add(Disposable.create(() => subscription1.unsubscribe()));
        let subscription2 = fromEvent($(this.document).get(0), 'mouseup')
            .subscribe(e => {
            if (this.dragInProgress) {
                this.mousemove(e);
                this.dragInProgress = false;
            }
        });
        this._subscriptions.add(Disposable.create(() => subscription2.unsubscribe()));
    }
    ngOnDestroy() {
        this._subscriptions.dispose();
    }
}
ResizerDirective.decorators = [
    { type: Directive, args: [{
                selector: '[resizer]',
                host: { '(mousedown)': 'startDrag()' }
            },] }
];
ResizerDirective.ctorParameters = () => [
    { type: ElementRef },
    { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] }
];
ResizerDirective.propDecorators = {
    maxSplitSize: [{ type: Input }],
    sizeChange: [{ type: Output }],
    splitSize: [{ type: Input }],
    resizerWidth: [{ type: Input }],
    resizerHeight: [{ type: Input }],
    resizerLeft: [{ type: Input }],
    resizerTop: [{ type: Input }],
    resizerRight: [{ type: Input }],
    resizerBottom: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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