import { Component, Input, Output, ElementRef, EventEmitter, ViewEncapsulation } from '@angular/core';
import * as _ from 'lodash';
import * as CodeMirror from 'codemirror-minified';
import * as _$ from 'jquery';
const $ = _$;
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
export class DslEditorComponent {
    constructor(element) {
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.debounce = 0;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = () => {
            this._dsl = this.doc.getValue();
            this.dslChange.emit(this._dsl);
        };
    }
    set dsl(dsl) {
        this._dsl = dsl;
        if (this.doc && this._dsl !== this.doc.getValue()) {
            let cursorPosition = this.doc.getCursor();
            this.doc.setValue(this._dsl || '');
            this.doc.setCursor(cursorPosition);
        }
    }
    set lintOptions(lintOptions) {
        this._lint = lintOptions;
        if (this.doc) {
            this.doc.setOption('lint', this._lint);
        }
    }
    set hintOptions(hintOptions) {
        this._hint = hintOptions;
        if (this.doc) {
            this.doc.setOption('hintOptions', this._hint);
        }
    }
    triggerLinting() {
        this.doc.setOption('lint', {});
        this.doc.setOption('lint', this._lint);
    }
    ngOnInit() {
        let options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            electricChars: false,
            smartIndent: false,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        if (this._hint) {
            options.hintOptions = this._hint;
        }
        this.doc = CodeMirror.fromTextArea($('#dsl-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this.debounce ? _.debounce(this._dslChangedHandler, this.debounce) : this._dslChangedHandler);
        this.doc.on('focus', () => this.focus.emit());
        this.doc.on('blur', () => this.blur.emit());
        this.editor.emit(this.doc);
    }
}
DslEditorComponent.decorators = [
    { type: Component, args: [{
                selector: 'dsl-editor',
                template: "<textarea id=\"dsl-editor-host\"></textarea>\n",
                encapsulation: ViewEncapsulation.None,
                styles: [".CodeMirror{-moz-user-select:none;-ms-user-select:none;-o-user-select:none;-webkit-user-select:none;height:100%;user-select:none}.CodeMirror-hint{max-width:38em}.CodeMirror-vertical-ruler-error{background-color:rgba(188,0,0,.5)}.CodeMirror-vertical-ruler-warning{background-color:rgba(255,188,0,.5)}"]
            },] }
];
DslEditorComponent.ctorParameters = () => [
    { type: ElementRef }
];
DslEditorComponent.propDecorators = {
    lineNumbers: [{ type: Input, args: ['line-numbers',] }],
    lineWrapping: [{ type: Input, args: ['line-wrapping',] }],
    scrollbarStyle: [{ type: Input, args: ['scrollbar-style',] }],
    placeholder: [{ type: Input }],
    debounce: [{ type: Input }],
    dslChange: [{ type: Output }],
    focus: [{ type: Output }],
    blur: [{ type: Output }],
    editor: [{ type: Output }],
    dsl: [{ type: Input }],
    lintOptions: [{ type: Input }],
    hintOptions: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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