import { Flo } from '../shared/flo-common';
import * as _ from 'lodash';
const joint = Flo.joint;
import * as _$ from 'jquery';
const $ = _$;
export class Utils {
    static fanRoute(graph, cell) {
        if (cell instanceof joint.dia.Element) {
            const links = graph.getConnectedLinks(cell);
            const groupsOfOverlappingLinks = _.groupBy(links, (link) => {
                // the key of the group is the model id of the link's source or target, but not our cell id.
                const sourceId = link.get('source').id;
                const targetId = link.get('target').id;
                return cell.id !== sourceId ? sourceId : targetId;
            });
            _.each(groupsOfOverlappingLinks, (group, key) => {
                // If the member of the group has both source and target model adjust vertices.
                let toRoute = {};
                if (key !== undefined) {
                    group.forEach((link) => {
                        if (link.get('source').id === cell.get('id') && link.get('target').id) {
                            toRoute[link.get('target').id] = link;
                        }
                        else if (link.get('target').id === cell.get('id') && link.get('source').id) {
                            toRoute[link.get('source').id] = link;
                        }
                    });
                    Object.keys(toRoute).forEach(k => {
                        Utils.fanRoute(graph, toRoute[k]);
                    });
                }
            });
        }
        else if (cell instanceof joint.dia.Link) {
            const link = cell;
            // The cell is a link. Let's find its source and target models.
            let src = link.source() || link.previous('source');
            let trg = link.target() || cell.previous('target');
            // If one of the ends is not a model, the link has no siblings.
            if (!src.id || !trg.id) {
                return;
            }
            const siblings = graph.getLinks().filter((sibling) => {
                const _src = sibling.source();
                const _trg = sibling.target();
                const vertices = sibling.get('vertices');
                const fanRouted = !vertices || vertices.length === 0 || sibling.get('fanRouted');
                return ((_.isEqual(_src, src) && _.isEqual(_trg, trg)) || (_.isEqual(_src, trg) && _.isEqual(_trg, src))) && fanRouted;
            });
            switch (siblings.length) {
                case 0:
                    // The link was removed and had no siblings.
                    break;
                case 1:
                    // There is only one link between the source and target. No vertices needed.
                    let vertices = cell.get('vertices');
                    if (vertices && vertices.length && cell.get('fanRouted')) {
                        cell.unset('vertices');
                    }
                    break;
                default:
                    // There is more than one siblings. We need to create vertices.
                    // First of all we'll find the middle point of the link.
                    let source = link.getSourceElement();
                    let target = link.getTargetElement();
                    if (!source || !target) {
                        // When clearing the graph it may happen that some nodes are gone and some are left
                        return;
                    }
                    let srcCenter = source.getBBox().center();
                    let trgCenter = target.getBBox().center();
                    let midPoint = joint.g.line(srcCenter, trgCenter).midpoint();
                    // Then find the angle it forms.
                    let theta = srcCenter.theta(trgCenter);
                    // This is the maximum distance between links
                    let gap = 20;
                    siblings.forEach((sibling, index) => {
                        // We want the offset values to be calculated as follows 0, 20, 20, 40, 40, 60, 60 ..
                        let offset = gap * Math.ceil(index / 2);
                        // Now we need the vertices to be placed at points which are 'offset' pixels distant
                        // from the first link and forms a perpendicular angle to it. And as index goes up
                        // alternate left and right.
                        //
                        //  ^  odd indexes
                        //  |
                        //  |---->  index 0 line (straight line between a source center and a target center.
                        //  |
                        //  v  even indexes
                        let sign = index % 2 ? 1 : -1;
                        let angle = joint.g.toRad(theta + sign * 90);
                        // We found the vertex.
                        let vertex = joint.g.point.fromPolar(offset, angle, midPoint);
                        sibling.set('fanRouted', true);
                        sibling.set('vertices', [{ x: vertex.x, y: vertex.y }], { 'fanRouted': true });
                    });
            }
        }
    }
    static isCustomPaperEvent(args) {
        return args.length === 5 &&
            _.isString(args[0]) &&
            (args[0].indexOf('link:') === 0 || args[0].indexOf('element:') === 0) &&
            args[1] instanceof $.Event &&
            args[2] instanceof joint.dia.CellView &&
            _.isNumber(args[3]) &&
            _.isNumber(args[4]);
    }
}
//# sourceMappingURL=data:application/json;base64,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