import { Component, EventEmitter, HostListener, Output, ViewChild, ViewEncapsulation } from '@angular/core';
export class PaperComponent {
    constructor() {
        this.onDelete = new EventEmitter();
        this.onProperties = new EventEmitter();
        this.onBlur = new EventEmitter();
    }
    click() {
        this.paperElement.nativeElement.focus();
    }
    mousedown() {
        this.paperElement.nativeElement.focus();
    }
    backspaceHandle() {
        this.onDelete.emit();
    }
    deleteHandle() {
        this.onDelete.emit();
    }
    oHandle() {
        this.onProperties.emit();
    }
    ngOnInit() {
        const onBlur = this.onBlur;
        this.paperElement.nativeElement.addEventListener('blur', () => {
            onBlur.emit();
        });
    }
}
PaperComponent.decorators = [
    { type: Component, args: [{
                selector: 'flo-editor-paper',
                template: `
    <div #paper tabindex="0" id="paper-container">
      <ng-content></ng-content>
    </div>`,
                encapsulation: ViewEncapsulation.None,
                styles: ["flo-view{-moz-user-select:none;-ms-user-select:none;-o-user-select:none;-webkit-user-select:none;background-color:#eee;font-family:Varela Round,sans-serif;height:100%;margin:0;user-select:none;width:100%}.canvas{border:1px solid #6db33f;border-radius:2px;margin-top:3px}.paper{background-color:#fff;padding:0}#sidebar-resizer{background-color:#34302d;bottom:0;cursor:e-resize;position:absolute;top:0;width:6px}#palette-container{background-color:#eee;left:0}#palette-container,#paper-container{bottom:0;overflow:auto;position:absolute;top:0}#paper-container{background-color:#fff;color:#fff;outline:none;right:0}.node-tooltip .tooltip-description{margin-bottom:5px;margin-left:0;margin-top:5px}.node-tooltip{background-color:#34302d;border:1px solid #333;border-radius:5px;color:#fff;display:none;font-family:Varela Round,sans-serif;font-size:19px;padding:5px;position:absolute;z-index:100}.tooltip-title-type{font-size:24px;font-weight:700}.tooltip-title-group{font-size:20px;font-style:italic;padding-left:5px}.node-tooltip-option-name{font-family:monospace;font-size:17px;font-weight:700;padding-right:20px}.node-tooltip-option-description{font-family:Varela Round,sans-serif;font-size:18px}.error-tooltip p{color:#fff;margin-bottom:5px;margin-left:0;margin-top:5px}.error-tooltip{background-color:red;border:1px solid #333;border-radius:5px;color:#fff;display:none;font-family:Varela Round,sans-serif;font-size:20px;padding:5px;position:absolute;z-index:100}.canvas-controls-container{position:absolute;right:15px;top:5px}.canvas-control{background:transparent;font-family:Varela Round,sans-serif;font-size:11px;margin:0;vertical-align:middle}.zoom-canvas-control{border:0;margin:0;outline:none;padding:0}.zoom-canvas-input{background-color:transparent;color:#000;font-weight:700;text-align:right}.zoom-canvas-label{color:#000;padding-right:4px}.highlighted{outline:none}.joint-type-handle{cursor:pointer}.available-magnet{stroke-width:3}.link{fill:none;stroke:#ccc;stroke-width:1.5px}.link-tools .tool-options{display:none}.link-tools .tool-options circle{fill:transparent;stroke:transparent}.link-tools .tool-options path{fill:#000;stroke:#000}.link-tools .tool-remove circle{fill:red;stroke:red}.link-tools .tool-remove path{fill:#fff;stroke:#fff}.link-tools-container{fill:transparent;stroke-width:0}"]
            },] }
];
PaperComponent.propDecorators = {
    paperElement: [{ type: ViewChild, args: ['paper', { static: true },] }],
    onDelete: [{ type: Output }],
    onProperties: [{ type: Output }],
    onBlur: [{ type: Output }],
    click: [{ type: HostListener, args: ['click',] }],
    mousedown: [{ type: HostListener, args: ['mousedown',] }],
    backspaceHandle: [{ type: HostListener, args: ['keydown.backspace',] }],
    deleteHandle: [{ type: HostListener, args: ['keydown.delete',] }],
    oHandle: [{ type: HostListener, args: ['keydown.o',] }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFwZXIuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2xpYi9lZGl0b3IvcGFwZXIuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFDTCxTQUFTLEVBQ0csWUFBWSxFQUN4QixZQUFZLEVBQ1osTUFBTSxFQUNOLFNBQVMsRUFDVCxpQkFBaUIsRUFDbEIsTUFBTSxlQUFlLENBQUM7QUFXdkIsTUFBTSxPQUFPLGNBQWM7SUFUM0I7UUFjRSxhQUFRLEdBQUcsSUFBSSxZQUFZLEVBQVUsQ0FBQztRQUd0QyxpQkFBWSxHQUFHLElBQUksWUFBWSxFQUFVLENBQUM7UUFHMUMsV0FBTSxHQUFHLElBQUksWUFBWSxFQUFXLENBQUM7SUFrQ3ZDLENBQUM7SUEvQkMsS0FBSztRQUNILElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLEtBQUssRUFBRSxDQUFDO0lBQzFDLENBQUM7SUFHRCxTQUFTO1FBQ1AsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDMUMsQ0FBQztJQUdELGVBQWU7UUFDYixJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ3ZCLENBQUM7SUFHRCxZQUFZO1FBQ1YsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUN2QixDQUFDO0lBR0QsT0FBTztRQUNMLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDM0IsQ0FBQztJQUVELFFBQVE7UUFDTixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1FBQzNCLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxHQUFHLEVBQUU7WUFDNUQsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ2hCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7O1lBcERGLFNBQVMsU0FBQztnQkFDVCxRQUFRLEVBQUUsa0JBQWtCO2dCQUM1QixRQUFRLEVBQUU7OztXQUdEO2dCQUVULGFBQWEsRUFBRSxpQkFBaUIsQ0FBQyxJQUFJOzthQUN0Qzs7OzJCQUdFLFNBQVMsU0FBQyxPQUFPLEVBQUUsRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFO3VCQUVuQyxNQUFNOzJCQUdOLE1BQU07cUJBR04sTUFBTTtvQkFHTixZQUFZLFNBQUMsT0FBTzt3QkFLcEIsWUFBWSxTQUFDLFdBQVc7OEJBS3hCLFlBQVksU0FBQyxtQkFBbUI7MkJBS2hDLFlBQVksU0FBQyxnQkFBZ0I7c0JBSzdCLFlBQVksU0FBQyxXQUFXIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgQ29tcG9uZW50LFxuICBFbGVtZW50UmVmLCBFdmVudEVtaXR0ZXIsXG4gIEhvc3RMaXN0ZW5lciwgT25Jbml0LFxuICBPdXRwdXQsXG4gIFZpZXdDaGlsZCxcbiAgVmlld0VuY2Fwc3VsYXRpb25cbn0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ2Zsby1lZGl0b3ItcGFwZXInLFxuICB0ZW1wbGF0ZTogYFxuICAgIDxkaXYgI3BhcGVyIHRhYmluZGV4PVwiMFwiIGlkPVwicGFwZXItY29udGFpbmVyXCI+XG4gICAgICA8bmctY29udGVudD48L25nLWNvbnRlbnQ+XG4gICAgPC9kaXY+YCxcbiAgc3R5bGVVcmxzOiBbJy4vZWRpdG9yLmNvbXBvbmVudC5zY3NzJ10sXG4gIGVuY2Fwc3VsYXRpb246IFZpZXdFbmNhcHN1bGF0aW9uLk5vbmVcbn0pXG5leHBvcnQgY2xhc3MgUGFwZXJDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuXG4gIEBWaWV3Q2hpbGQoJ3BhcGVyJywgeyBzdGF0aWM6IHRydWUgfSkgcGFwZXJFbGVtZW50OiBFbGVtZW50UmVmO1xuXG4gIEBPdXRwdXQoKVxuICBvbkRlbGV0ZSA9IG5ldyBFdmVudEVtaXR0ZXI8bnVtYmVyPigpO1xuXG4gIEBPdXRwdXQoKVxuICBvblByb3BlcnRpZXMgPSBuZXcgRXZlbnRFbWl0dGVyPG51bWJlcj4oKTtcblxuICBAT3V0cHV0KClcbiAgb25CbHVyID0gbmV3IEV2ZW50RW1pdHRlcjxib29sZWFuPigpO1xuXG4gIEBIb3N0TGlzdGVuZXIoJ2NsaWNrJylcbiAgY2xpY2soKSB7XG4gICAgdGhpcy5wYXBlckVsZW1lbnQubmF0aXZlRWxlbWVudC5mb2N1cygpO1xuICB9XG5cbiAgQEhvc3RMaXN0ZW5lcignbW91c2Vkb3duJylcbiAgbW91c2Vkb3duKCkge1xuICAgIHRoaXMucGFwZXJFbGVtZW50Lm5hdGl2ZUVsZW1lbnQuZm9jdXMoKTtcbiAgfVxuXG4gIEBIb3N0TGlzdGVuZXIoJ2tleWRvd24uYmFja3NwYWNlJylcbiAgYmFja3NwYWNlSGFuZGxlKCkge1xuICAgIHRoaXMub25EZWxldGUuZW1pdCgpO1xuICB9XG5cbiAgQEhvc3RMaXN0ZW5lcigna2V5ZG93bi5kZWxldGUnKVxuICBkZWxldGVIYW5kbGUoKSB7XG4gICAgdGhpcy5vbkRlbGV0ZS5lbWl0KCk7XG4gIH1cblxuICBASG9zdExpc3RlbmVyKCdrZXlkb3duLm8nKVxuICBvSGFuZGxlKCkge1xuICAgIHRoaXMub25Qcm9wZXJ0aWVzLmVtaXQoKTtcbiAgfVxuXG4gIG5nT25Jbml0KCk6IHZvaWQge1xuICAgIGNvbnN0IG9uQmx1ciA9IHRoaXMub25CbHVyO1xuICAgIHRoaXMucGFwZXJFbGVtZW50Lm5hdGl2ZUVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignYmx1cicsICgpID0+IHtcbiAgICAgIG9uQmx1ci5lbWl0KCk7XG4gICAgfSk7XG4gIH1cblxufVxuIl19