import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { Palette } from './palette/palette.component';
import { EditorComponent } from './editor/editor.component';
import { ResizerDirective } from './directives/resizer';
import { DslEditorComponent } from './dsl-editor/dsl-editor.component';
import { CodeEditorComponent } from './code-editor/code-editor.component';
import { PropertiesGroupComponent } from './properties/properties.group.component';
import { DynamicFormPropertyComponent } from './properties/df.property.component';
import { PaperComponent } from './editor/paper.component';
export class FloModule {
}
FloModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    FormsModule,
                    CommonModule,
                    ReactiveFormsModule
                ],
                declarations: [
                    Palette,
                    EditorComponent,
                    ResizerDirective,
                    DslEditorComponent,
                    CodeEditorComponent,
                    PropertiesGroupComponent,
                    DynamicFormPropertyComponent,
                    PaperComponent
                ],
                exports: [
                    EditorComponent,
                    DslEditorComponent,
                    DynamicFormPropertyComponent,
                    PropertiesGroupComponent
                ]
            },] }
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kdWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2xpYi9tb2R1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUN6QyxPQUFPLEVBQUUsV0FBVyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDbEUsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBRS9DLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSw2QkFBNkIsQ0FBQztBQUN0RCxPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sMkJBQTJCLENBQUM7QUFDNUQsT0FBTyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sc0JBQXNCLENBQUM7QUFDeEQsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sbUNBQW1DLENBQUM7QUFDdkUsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0scUNBQXFDLENBQUM7QUFDMUUsT0FBTyxFQUFFLHdCQUF3QixFQUFFLE1BQU0seUNBQXlDLENBQUM7QUFDbkYsT0FBTyxFQUFFLDRCQUE0QixFQUFFLE1BQU0sb0NBQW9DLENBQUM7QUFDbEYsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLDBCQUEwQixDQUFDO0FBeUIxRCxNQUFNLE9BQU8sU0FBUzs7O1lBdkJyQixRQUFRLFNBQUM7Z0JBQ1IsT0FBTyxFQUFFO29CQUNQLFdBQVc7b0JBQ1gsWUFBWTtvQkFDWixtQkFBbUI7aUJBQ3BCO2dCQUNELFlBQVksRUFBRTtvQkFDWixPQUFPO29CQUNQLGVBQWU7b0JBQ2YsZ0JBQWdCO29CQUNoQixrQkFBa0I7b0JBQ2xCLG1CQUFtQjtvQkFDbkIsd0JBQXdCO29CQUN4Qiw0QkFBNEI7b0JBQzVCLGNBQWM7aUJBQ2Y7Z0JBQ0QsT0FBTyxFQUFFO29CQUNQLGVBQWU7b0JBQ2Ysa0JBQWtCO29CQUNsQiw0QkFBNEI7b0JBQzVCLHdCQUF3QjtpQkFDekI7YUFDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE5nTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBGb3Jtc01vZHVsZSwgUmVhY3RpdmVGb3Jtc01vZHVsZSB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcbmltcG9ydCB7IENvbW1vbk1vZHVsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvbW1vbic7XG5cbmltcG9ydCB7IFBhbGV0dGUgfSBmcm9tICcuL3BhbGV0dGUvcGFsZXR0ZS5jb21wb25lbnQnO1xuaW1wb3J0IHsgRWRpdG9yQ29tcG9uZW50IH0gZnJvbSAnLi9lZGl0b3IvZWRpdG9yLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBSZXNpemVyRGlyZWN0aXZlIH0gZnJvbSAnLi9kaXJlY3RpdmVzL3Jlc2l6ZXInO1xuaW1wb3J0IHsgRHNsRWRpdG9yQ29tcG9uZW50IH0gZnJvbSAnLi9kc2wtZWRpdG9yL2RzbC1lZGl0b3IuY29tcG9uZW50JztcbmltcG9ydCB7IENvZGVFZGl0b3JDb21wb25lbnQgfSBmcm9tICcuL2NvZGUtZWRpdG9yL2NvZGUtZWRpdG9yLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBQcm9wZXJ0aWVzR3JvdXBDb21wb25lbnQgfSBmcm9tICcuL3Byb3BlcnRpZXMvcHJvcGVydGllcy5ncm91cC5jb21wb25lbnQnO1xuaW1wb3J0IHsgRHluYW1pY0Zvcm1Qcm9wZXJ0eUNvbXBvbmVudCB9IGZyb20gJy4vcHJvcGVydGllcy9kZi5wcm9wZXJ0eS5jb21wb25lbnQnO1xuaW1wb3J0IHsgUGFwZXJDb21wb25lbnQgfSBmcm9tICcuL2VkaXRvci9wYXBlci5jb21wb25lbnQnO1xuXG5ATmdNb2R1bGUoe1xuICBpbXBvcnRzOiBbXG4gICAgRm9ybXNNb2R1bGUsXG4gICAgQ29tbW9uTW9kdWxlLFxuICAgIFJlYWN0aXZlRm9ybXNNb2R1bGVcbiAgXSxcbiAgZGVjbGFyYXRpb25zOiBbXG4gICAgUGFsZXR0ZSxcbiAgICBFZGl0b3JDb21wb25lbnQsXG4gICAgUmVzaXplckRpcmVjdGl2ZSxcbiAgICBEc2xFZGl0b3JDb21wb25lbnQsXG4gICAgQ29kZUVkaXRvckNvbXBvbmVudCxcbiAgICBQcm9wZXJ0aWVzR3JvdXBDb21wb25lbnQsXG4gICAgRHluYW1pY0Zvcm1Qcm9wZXJ0eUNvbXBvbmVudCxcbiAgICBQYXBlckNvbXBvbmVudFxuICBdLFxuICBleHBvcnRzOiBbXG4gICAgRWRpdG9yQ29tcG9uZW50LFxuICAgIERzbEVkaXRvckNvbXBvbmVudCxcbiAgICBEeW5hbWljRm9ybVByb3BlcnR5Q29tcG9uZW50LFxuICAgIFByb3BlcnRpZXNHcm91cENvbXBvbmVudFxuICBdXG59KVxuZXhwb3J0IGNsYXNzIEZsb01vZHVsZSB7IH1cbiJdfQ==