import { Component, Input, ViewEncapsulation } from '@angular/core';
import { Properties } from '../shared/flo-properties';
export class DynamicFormPropertyComponent {
    constructor() { }
    get types() {
        return Properties.InputType;
    }
    get control() {
        return this.form.controls[this.model.id];
    }
    get errorData() {
        return (this.model.validation && this.model.validation.errorData ? this.model.validation.errorData : [])
            .filter(e => this.control.errors && this.control.errors[e.id]);
    }
}
DynamicFormPropertyComponent.decorators = [
    { type: Component, args: [{
                selector: 'df-property',
                template: "<tr [formGroup]=\"form\" class=\"df-property-row\" [ngClass]=\"{'invalid-property-value': control.invalid}\">\n\n  <td class=\"df-property-label-cell\">\n    <label [attr.for]=\"model.id\" class=\"df-form-label\">{{model.name}}</label>\n  </td>\n\n  <td class=\"df-property-control-cell\">\n    <div [ngSwitch]=\"model.type\" class=\"df-property-container\">\n\n      <label *ngSwitchCase=\"types.CHECKBOX\" class=\"df-property-control\">\n        <input type=\"checkbox\" [id]=\"model.id\" [(ngModel)]=\"model.value\" [formControlName]=\"model.id\">\n        {{model.value ? 'True' : 'False' }}\n      </label>\n\n      <input *ngSwitchCase=\"types.NUMBER\" class=\"df-property-control\" type=\"number\" [id]=\"model.id\"\n             [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n      <input *ngSwitchCase=\"types.PASSWORD\" class=\"df-property-control\" type=\"password\" [id]=\"model.id\"\n             [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n      <input *ngSwitchCase=\"types.EMAIL\" class=\"df-property-control\" type=\"password\" [id]=\"model.id\"\n             [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n      <input *ngSwitchCase=\"types.URL\" class=\"df-property-control\" type=\"url\" [id]=\"model.id\"\n             [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n      <select *ngSwitchCase=\"types.SELECT\" class=\"df-property-control\" [id]=\"model.id\"\n             [formControlName]=\"model.id\" [(ngModel)]=\"model.value\">\n        <option *ngFor=\"let o of model['options']\" [ngValue]=\"o.value\">{{o.name}}</option>\n      </select>\n\n      <code-editor *ngSwitchCase=\"types.CODE\" class=\"df-property-control\" [id]=\"model.id\"\n              [formControlName]=\"model.id\" [language]=\"model['language']\" [(ngModel)]=\"model.value\" line-numbers=\"true\"\n              scrollbar-style=\"simple\" [placeholder]=\"model.defaultValue || 'Enter code snippet...'\" overview-ruler=\"true\">\n      </code-editor>\n\n      <input *ngSwitchDefault class=\"df-property-control\" type=\"text\" [id]=\"model.id\" [formControlName]=\"model.id\"\n             [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n    </div>\n    <div class=\"help-block\">\n      <div>{{model.description}}</div>\n      <div *ngFor=\"let e of errorData\" class=\"validation-error-block\">{{e.message}}</div>\n    </div>\n  </td>\n\n</tr>\n\n",
                encapsulation: ViewEncapsulation.None
            },] }
];
DynamicFormPropertyComponent.ctorParameters = () => [];
DynamicFormPropertyComponent.propDecorators = {
    model: [{ type: Input }],
    form: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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