import { Component, Input, ViewEncapsulation } from '@angular/core';
import { FormControl } from '@angular/forms';
export class PropertiesGroupComponent {
    ngOnInit() {
        if (this.propertiesGroupModel.isLoading) {
            let subscription = this.propertiesGroupModel.loadedSubject.subscribe(loaded => {
                if (loaded) {
                    subscription.unsubscribe();
                    this.createGroupControls();
                }
            });
        }
        else {
            this.createGroupControls();
        }
    }
    createGroupControls() {
        this.propertiesGroupModel.getControlsModels().forEach(c => {
            if (c.validation) {
                this.form.addControl(c.id, new FormControl(c.value || '', c.validation.validator, c.validation.asyncValidator));
            }
            else {
                this.form.addControl(c.id, new FormControl(c.value || ''));
            }
        });
    }
    get controlModelsToDisplay() {
        return this.propertiesGroupModel.getControlsModels().filter(c => !this.filter || this.filter.accept(c.property));
    }
}
PropertiesGroupComponent.decorators = [
    { type: Component, args: [{
                selector: 'properties-group',
                template: "<div *ngIf=\"propertiesGroupModel && !propertiesGroupModel.isLoading\" class=\"properties-group-container\"\n     [formGroup]=\"form\">\n  <div\n    *ngIf=\"propertiesGroupModel.getControlsModels().length > 0 && controlModelsToDisplay.length === 0; else propertiesList\"\n    class=\"no-matches-label\">No results found.\n  </div>\n</div>\n\n<ng-template #propertiesList>\n  <df-property *ngFor=\"let model of controlModelsToDisplay\" [model]=\"model\" [form]=\"form\"\n               class=\"property-row\"></df-property>\n</ng-template>\n",
                encapsulation: ViewEncapsulation.None
            },] }
];
PropertiesGroupComponent.propDecorators = {
    propertiesGroupModel: [{ type: Input }],
    form: [{ type: Input }],
    filter: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvcGVydGllcy5ncm91cC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL3Byb3BlcnRpZXMvcHJvcGVydGllcy5ncm91cC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQVUsaUJBQWlCLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDNUUsT0FBTyxFQUFhLFdBQVcsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBVXhELE1BQU0sT0FBTyx3QkFBd0I7SUFXbkMsUUFBUTtRQUNOLElBQUksSUFBSSxDQUFDLG9CQUFvQixDQUFDLFNBQVMsRUFBRTtZQUN2QyxJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsRUFBRTtnQkFDNUUsSUFBSSxNQUFNLEVBQUU7b0JBQ1YsWUFBWSxDQUFDLFdBQVcsRUFBRSxDQUFDO29CQUMzQixJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztpQkFDNUI7WUFDSCxDQUFDLENBQUMsQ0FBQTtTQUNIO2FBQU07WUFDTCxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztTQUM1QjtJQUNILENBQUM7SUFFRCxtQkFBbUI7UUFDakIsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGlCQUFpQixFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQ3hELElBQUksQ0FBQyxDQUFDLFVBQVUsRUFBRTtnQkFDaEIsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxJQUFJLFdBQVcsQ0FBQyxDQUFDLENBQUMsS0FBSyxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7YUFDakg7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxJQUFJLFdBQVcsQ0FBQyxDQUFDLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7YUFDNUQ7UUFDSCxDQUFDLENBQUMsQ0FBQTtJQUNKLENBQUM7SUFFRCxJQUFJLHNCQUFzQjtRQUN4QixPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUNuSCxDQUFDOzs7WUF6Q0YsU0FBUyxTQUFDO2dCQUNULFFBQVEsRUFBRSxrQkFBa0I7Z0JBQzVCLHdpQkFBZ0Q7Z0JBQ2hELGFBQWEsRUFBRSxpQkFBaUIsQ0FBQyxJQUFJO2FBQ3RDOzs7bUNBR0UsS0FBSzttQkFHTCxLQUFLO3FCQUdMLEtBQUsiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBPbkluaXQsIFZpZXdFbmNhcHN1bGF0aW9uIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBGb3JtR3JvdXAsIEZvcm1Db250cm9sIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xuaW1wb3J0IHsgUHJvcGVydGllcyB9IGZyb20gJy4uL3NoYXJlZC9mbG8tcHJvcGVydGllcyc7XG5pbXBvcnQgUHJvcGVydHkgPSBQcm9wZXJ0aWVzLlByb3BlcnR5O1xuaW1wb3J0IFByb3BlcnR5RmlsdGVyID0gUHJvcGVydGllcy5Qcm9wZXJ0eUZpbHRlcjtcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAncHJvcGVydGllcy1ncm91cCcsXG4gIHRlbXBsYXRlVXJsOiAnLi9wcm9wZXJ0aWVzLmdyb3VwLmNvbXBvbmVudC5odG1sJyxcbiAgZW5jYXBzdWxhdGlvbjogVmlld0VuY2Fwc3VsYXRpb24uTm9uZVxufSlcbmV4cG9ydCBjbGFzcyBQcm9wZXJ0aWVzR3JvdXBDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuXG4gIEBJbnB1dCgpXG4gIHByb3BlcnRpZXNHcm91cE1vZGVsOiBQcm9wZXJ0aWVzLlByb3BlcnRpZXNHcm91cE1vZGVsO1xuXG4gIEBJbnB1dCgpXG4gIGZvcm06IEZvcm1Hcm91cDtcblxuICBASW5wdXQoKVxuICBmaWx0ZXI6IFByb3BlcnR5RmlsdGVyO1xuXG4gIG5nT25Jbml0KCkge1xuICAgIGlmICh0aGlzLnByb3BlcnRpZXNHcm91cE1vZGVsLmlzTG9hZGluZykge1xuICAgICAgbGV0IHN1YnNjcmlwdGlvbiA9IHRoaXMucHJvcGVydGllc0dyb3VwTW9kZWwubG9hZGVkU3ViamVjdC5zdWJzY3JpYmUobG9hZGVkID0+IHtcbiAgICAgICAgaWYgKGxvYWRlZCkge1xuICAgICAgICAgIHN1YnNjcmlwdGlvbi51bnN1YnNjcmliZSgpO1xuICAgICAgICAgIHRoaXMuY3JlYXRlR3JvdXBDb250cm9scygpO1xuICAgICAgICB9XG4gICAgICB9KVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmNyZWF0ZUdyb3VwQ29udHJvbHMoKTtcbiAgICB9XG4gIH1cblxuICBjcmVhdGVHcm91cENvbnRyb2xzKCkge1xuICAgIHRoaXMucHJvcGVydGllc0dyb3VwTW9kZWwuZ2V0Q29udHJvbHNNb2RlbHMoKS5mb3JFYWNoKGMgPT4ge1xuICAgICAgaWYgKGMudmFsaWRhdGlvbikge1xuICAgICAgICB0aGlzLmZvcm0uYWRkQ29udHJvbChjLmlkLCBuZXcgRm9ybUNvbnRyb2woYy52YWx1ZSB8fCAnJywgYy52YWxpZGF0aW9uLnZhbGlkYXRvciwgYy52YWxpZGF0aW9uLmFzeW5jVmFsaWRhdG9yKSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLmZvcm0uYWRkQ29udHJvbChjLmlkLCBuZXcgRm9ybUNvbnRyb2woYy52YWx1ZSB8fCAnJykpO1xuICAgICAgfVxuICAgIH0pXG4gIH1cblxuICBnZXQgY29udHJvbE1vZGVsc1RvRGlzcGxheSgpIHtcbiAgICByZXR1cm4gdGhpcy5wcm9wZXJ0aWVzR3JvdXBNb2RlbC5nZXRDb250cm9sc01vZGVscygpLmZpbHRlcihjID0+ICF0aGlzLmZpbHRlciB8fCB0aGlzLmZpbHRlci5hY2NlcHQoYy5wcm9wZXJ0eSkpO1xuICB9XG5cbn1cbiJdfQ==