import * as _joint from 'jointjs';
import * as _$ from 'jquery';
const $ = _$;
export var Flo;
(function (Flo) {
    Flo.joint = _joint;
    let DnDEventType;
    (function (DnDEventType) {
        DnDEventType[DnDEventType["DRAG"] = 0] = "DRAG";
        DnDEventType[DnDEventType["DROP"] = 1] = "DROP";
    })(DnDEventType = Flo.DnDEventType || (Flo.DnDEventType = {}));
    let Severity;
    (function (Severity) {
        Severity[Severity["Error"] = 0] = "Error";
        Severity[Severity["Warning"] = 1] = "Warning";
    })(Severity = Flo.Severity || (Flo.Severity = {}));
    function findMagnetByClass(view, className) {
        if (className && className.startsWith('.')) {
            className = className.substr(1);
        }
        const element = view.$('[magnet]').toArray().find((magnet) => magnet.getAttribute('class').split(/\s+/).indexOf(className) >= 0);
        if (element) {
            return view.findMagnet($(element));
        }
    }
    Flo.findMagnetByClass = findMagnetByClass;
    function findMagnetByPort(view, port) {
        const element = view.$('[magnet]').toArray().find((magnet) => magnet.getAttribute('port') === port);
        if (element) {
            return view.findMagnet($(element));
        }
    }
    Flo.findMagnetByPort = findMagnetByPort;
    /**
     * Return the metadata for a particular palette entry in a particular group.
     * @param name - name of the palette entry
     * @param group - group in which the palette entry should exist (e.g. sinks)
     * @return
     */
    function getMetadata(metamodel, name, group) {
        const groupObj = metamodel && group ? metamodel.get(group) : undefined;
        if (name && groupObj && groupObj.get(name)) {
            return metamodel.get(group).get(name);
        }
        else {
            return {
                name: name,
                group: group,
                unresolved: true,
                get: (property) => new Promise(resolve => resolve()),
                properties: () => Promise.resolve(new Map())
            };
        }
    }
    Flo.getMetadata = getMetadata;
    function getScrollbarWidth() {
        // Creating invisible container
        const outer = document.createElement('div');
        outer.style.visibility = 'hidden';
        outer.style.overflow = 'scroll'; // forcing scrollbar to appear
        // outer.style.msOverflowStyle = 'scrollbar'; // needed for WinJS apps
        document.body.appendChild(outer);
        // Creating inner element and placing it in the container
        const inner = document.createElement('div');
        outer.appendChild(inner);
        // Calculating difference between container's full width and the child width
        const scrollbarWidth = (outer.offsetWidth - inner.offsetWidth);
        // Removing temporary elements from the DOM
        outer.parentNode.removeChild(outer);
        return scrollbarWidth;
    }
    Flo.getScrollbarWidth = getScrollbarWidth;
    Flo.SCROLLBAR_WIDTH = getScrollbarWidth();
})(Flo || (Flo = {}));
//# sourceMappingURL=data:application/json;base64,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