import * as tslib_1 from "tslib";
var CodeEditorComponent_1;
import { Component, Input, Output, ElementRef, EventEmitter, ViewEncapsulation, forwardRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import * as CodeMirror from 'codemirror-minified';
import * as _$ from 'jquery';
const $ = _$;
// CodeMirror extensions
import 'codemirror-minified/mode/meta';
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
// import 'codemirror-minified/addon/mode/loadmode';
import 'codemirror-minified/addon/edit/matchbrackets';
import 'codemirror-minified/addon/edit/closebrackets';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
// Lint support
// Unclear how to import this dynamically...
// import 'codemirror-minified/addon/lint/javascript-lint';
// import 'codemirror-minified/addon/lint/json-lint';
// import 'codemirror-minified/addon/lint/yaml-lint';
// TODO: use dynamic import with JS7 in the future. CM autoLoad cannot load it properly - thinks its AMD
// Supported languages until dynamic loading
// import 'codemirror-minified/mode/groovy/groovy';
// import 'codemirror-minified/mode/javascript/javascript';
// import 'codemirror-minified/mode/python/python';
// import 'codemirror-minified/mode/ruby/ruby';
// import 'codemirror-minified/mode/clike/clike';
// import 'codemirror-minified/mode/yaml/yaml';
let CodeEditorComponent = CodeEditorComponent_1 = class CodeEditorComponent {
    constructor(element) {
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = () => {
            this._dsl = this.doc.getValue();
            this.dslChange.emit(this._dsl);
            if (this._onChangeHandler) {
                this._onChangeHandler(this._dsl);
            }
        };
    }
    set dsl(dsl) {
        this._dsl = dsl;
        if (this.doc && this._dsl !== this.doc.getValue()) {
            let cursorPosition = this.doc.getCursor();
            this.doc.setValue(this._dsl || '');
            this.doc.setCursor(cursorPosition);
        }
    }
    set language(_language) {
        if (this._language !== _language) {
            this._language = _language;
            this.loadEditorMode();
        }
    }
    ngOnInit() {
        let options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            matchBrackets: true,
            autoCloseBrackets: true,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        this.doc = CodeMirror.fromTextArea($('#code-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this._dslChangedHandler);
        this.doc.on('focus', () => {
            this.focus.emit();
            if (this._onTouchHandler) {
                this._onTouchHandler();
            }
        });
        this.doc.on('blur', () => this.blur.emit());
        this.warningRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-warning');
        this.errorRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-error');
        this.loadEditorMode();
        this.editor.emit(this.doc);
    }
    loadEditorMode() {
        // CodeMirror doc object must be initialized
        if (!this.doc) {
            return;
        }
        const info = this._language ? CodeMirror.findModeByName(this._language) : undefined;
        // Set proper editor mode
        if (info) {
            this.doc.setOption('mode', info.mime);
            // (<any>CodeMirror).autoLoadMode(this.doc, info.mode);
        }
        else {
            this.doc.setOption('mode', 'text/plain');
        }
        // Set proper Lint mode
        this.doc.setOption('lint', this.getLintOptions());
    }
    ngOnDestroy() {
    }
    writeValue(obj) {
        this.dsl = obj;
    }
    registerOnChange(fn) {
        this._onChangeHandler = fn;
    }
    registerOnTouched(fn) {
        this._onTouchHandler = fn;
    }
    getLintOptions() {
        switch (this._language) {
            case 'javascript':
            case 'json':
            case 'coffeescript':
            case 'yaml':
                return {
                    onUpdateLinting: (annotations) => {
                        const warnings = [];
                        const errors = [];
                        if (this.overviewRuler) {
                            if (Array.isArray(annotations)) {
                                annotations.forEach((a) => {
                                    if (a.to && a.from && a.from.line >= 0 && a.from.ch >= 0 && a.to.line >= a.from.line && a.from.ch >= 0) {
                                        if (a.severity === 'error') {
                                            errors.push(a);
                                        }
                                        else if (a.severity === 'warning') {
                                            warnings.push(a);
                                        }
                                    }
                                });
                            }
                        }
                        this.warningRuler.update(warnings);
                        this.errorRuler.update(errors);
                    }
                };
        }
        return false;
    }
};
tslib_1.__decorate([
    Input('line-numbers'),
    tslib_1.__metadata("design:type", Object)
], CodeEditorComponent.prototype, "lineNumbers", void 0);
tslib_1.__decorate([
    Input('line-wrapping'),
    tslib_1.__metadata("design:type", Object)
], CodeEditorComponent.prototype, "lineWrapping", void 0);
tslib_1.__decorate([
    Input('scrollbar-style'),
    tslib_1.__metadata("design:type", String)
], CodeEditorComponent.prototype, "scrollbarStyle", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", String)
], CodeEditorComponent.prototype, "placeholder", void 0);
tslib_1.__decorate([
    Input('overview-ruler'),
    tslib_1.__metadata("design:type", Boolean)
], CodeEditorComponent.prototype, "overviewRuler", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], CodeEditorComponent.prototype, "dslChange", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], CodeEditorComponent.prototype, "focus", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], CodeEditorComponent.prototype, "blur", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], CodeEditorComponent.prototype, "editor", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [String])
], CodeEditorComponent.prototype, "dsl", null);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [String])
], CodeEditorComponent.prototype, "language", null);
CodeEditorComponent = CodeEditorComponent_1 = tslib_1.__decorate([
    Component({
        selector: 'code-editor',
        template: `
    <div class="code-editor-host">
      <textarea id="code-editor-host"></textarea>
    </div>
  `,
        styles: [`
    .CodeMirror {
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
      height: 100%;
    }
    .CodeMirror-hint {
      max-width: 38em;
    }
    .CodeMirror-vertical-ruler-error {
      background-color: rgba(188, 0, 0, 0.5);
    }
    .CodeMirror-vertical-ruler-warning {
      background-color: rgba(255, 188, 0, 0.5);
    }
    .CodeMirror-lint-tooltip {
      z-index: 2000;
    }
  `],
        encapsulation: ViewEncapsulation.None,
        providers: [
            {
                provide: NG_VALUE_ACCESSOR,
                useExisting: forwardRef(() => CodeEditorComponent_1),
                multi: true
            }
        ]
    }),
    tslib_1.__metadata("design:paramtypes", [ElementRef])
], CodeEditorComponent);
export { CodeEditorComponent };
//# sourceMappingURL=code-editor.component.js.map