import * as tslib_1 from "tslib";
import { Component, Input, Output, ElementRef, EventEmitter, ViewEncapsulation } from '@angular/core';
import * as _ from 'lodash';
import * as CodeMirror from 'codemirror-minified';
import * as _$ from 'jquery';
const $ = _$;
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
let DslEditorComponent = class DslEditorComponent {
    constructor(element) {
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.debounce = 0;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = () => {
            this._dsl = this.doc.getValue();
            this.dslChange.emit(this._dsl);
        };
    }
    set dsl(dsl) {
        this._dsl = dsl;
        if (this.doc && this._dsl !== this.doc.getValue()) {
            let cursorPosition = this.doc.getCursor();
            this.doc.setValue(this._dsl || '');
            this.doc.setCursor(cursorPosition);
        }
    }
    set lintOptions(lintOptions) {
        this._lint = lintOptions;
        if (this.doc) {
            this.doc.setOption('lint', this._lint);
        }
    }
    set hintOptions(hintOptions) {
        this._hint = hintOptions;
        if (this.doc) {
            this.doc.setOption('hintOptions', this._hint);
        }
    }
    ngOnInit() {
        let options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            electricChars: false,
            smartIndent: false,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        if (this._hint) {
            options.hintOptions = this._hint;
        }
        this.doc = CodeMirror.fromTextArea($('#dsl-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this.debounce ? _.debounce(this._dslChangedHandler, this.debounce) : this._dslChangedHandler);
        this.doc.on('focus', () => this.focus.emit());
        this.doc.on('blur', () => this.blur.emit());
        this.editor.emit(this.doc);
    }
    ngOnDestroy() {
    }
};
tslib_1.__decorate([
    Input('line-numbers'),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "lineNumbers", void 0);
tslib_1.__decorate([
    Input('line-wrapping'),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "lineWrapping", void 0);
tslib_1.__decorate([
    Input('scrollbar-style'),
    tslib_1.__metadata("design:type", String)
], DslEditorComponent.prototype, "scrollbarStyle", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", String)
], DslEditorComponent.prototype, "placeholder", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "debounce", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "dslChange", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "focus", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "blur", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], DslEditorComponent.prototype, "editor", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [String])
], DslEditorComponent.prototype, "dsl", null);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", Object),
    tslib_1.__metadata("design:paramtypes", [Object])
], DslEditorComponent.prototype, "lintOptions", null);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", Object),
    tslib_1.__metadata("design:paramtypes", [Object])
], DslEditorComponent.prototype, "hintOptions", null);
DslEditorComponent = tslib_1.__decorate([
    Component({
        selector: 'dsl-editor',
        template: `
    <textarea id="dsl-editor-host"></textarea>
  `,
        styles: [`
    /* Code Mirror related styles START */

    .CodeMirror {
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
      height: 100%;
    }
    .CodeMirror-hint {
      max-width: 38em;
    }
    .CodeMirror-vertical-ruler-error {
      background-color: rgba(188, 0, 0, 0.5);
    }
    .CodeMirror-vertical-ruler-warning {
      background-color: rgba(255, 188, 0, 0.5);
    }


    /* Code Mirror related styles END */
  `],
        encapsulation: ViewEncapsulation.None
    }),
    tslib_1.__metadata("design:paramtypes", [ElementRef])
], DslEditorComponent);
export { DslEditorComponent };
//# sourceMappingURL=dsl-editor.component.js.map