import * as tslib_1 from "tslib";
import { Component, ElementRef, EventEmitter, HostListener, Output, ViewChild, ViewEncapsulation } from '@angular/core';
let PaperComponent = class PaperComponent {
    constructor() {
        this.onDelete = new EventEmitter();
        this.onProperties = new EventEmitter();
        this.onBlur = new EventEmitter();
    }
    click() {
        this.paperElement.nativeElement.focus();
    }
    mousedown() {
        this.paperElement.nativeElement.focus();
    }
    backspaceHandle() {
        this.onDelete.emit();
    }
    deleteHandle() {
        this.onDelete.emit();
    }
    oHandle() {
        this.onProperties.emit();
    }
    ngOnInit() {
        const onBlur = this.onBlur;
        this.paperElement.nativeElement.addEventListener('blur', () => {
            onBlur.emit();
        });
    }
};
tslib_1.__decorate([
    ViewChild('paper', { static: true }),
    tslib_1.__metadata("design:type", ElementRef)
], PaperComponent.prototype, "paperElement", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], PaperComponent.prototype, "onDelete", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], PaperComponent.prototype, "onProperties", void 0);
tslib_1.__decorate([
    Output(),
    tslib_1.__metadata("design:type", Object)
], PaperComponent.prototype, "onBlur", void 0);
tslib_1.__decorate([
    HostListener('click'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PaperComponent.prototype, "click", null);
tslib_1.__decorate([
    HostListener('mousedown'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PaperComponent.prototype, "mousedown", null);
tslib_1.__decorate([
    HostListener('keydown.backspace'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PaperComponent.prototype, "backspaceHandle", null);
tslib_1.__decorate([
    HostListener('keydown.delete'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PaperComponent.prototype, "deleteHandle", null);
tslib_1.__decorate([
    HostListener('keydown.o'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PaperComponent.prototype, "oHandle", null);
PaperComponent = tslib_1.__decorate([
    Component({
        selector: 'flo-editor-paper',
        template: `
    <div #paper tabindex="0" id="paper-container">
      <ng-content></ng-content>
    </div>`,
        styles: [`
    flo-view {
      width:100%;
      height:100%;
      margin: 0;
      background-color: #eeeeee;
      font-family: "Varela Round",sans-serif;
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
    }

    .canvas {
      border: 1px solid;
      border-color: #6db33f;
      border-radius: 2px;
      margin-top: 3px;
    }

    /* Canvas contains the palette on the left and the paper on the right */

    .paper {
      padding: 0px;
      background-color: #ffffff;
      /* 	height: 100%;
          width: 100%;
          position: relative;
          overflow: hidden;
       *//* 	margin-left: 400px; */
    }

    #sidebar-resizer {
      background-color: #34302d;
      position: absolute;
      top: 0;
      bottom: 0;
      width: 6px;
      cursor: e-resize;
    }

    #palette-container {
      background-color: #EEE;
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      overflow: auto;
    }

    #paper-container {
      position: absolute;
      top: 0;
      bottom: 0;
      right: 0;
      overflow: auto;
      color: #FFF;
      background-color: #FFF;
      outline: none;
    }

    /* Tooltip START */

    .node-tooltip .tooltip-description {
      margin-top: 5px;
      margin-left: 0px;
      margin-bottom: 5px;
    }

    .node-tooltip {
      display:none;
      position:absolute;
      border:1px solid #333;
      background-color:#34302d;/*#161616;*/
      border-radius:5px;
      padding:5px;
      color:#fff;
      /*	font-size:12px Arial;*/
      font-family: "Varela Round",sans-serif;
      font-size: 19px;
      z-index: 100;
    }

    .tooltip-title-type {
      font-size: 24px;
      font-weight: bold;
    }

    .tooltip-title-group {
      padding-left: 5px;
      font-size: 20px;
      font-style: italic;
    }

    .node-tooltip-option-name {
      font-family: monospace;/*"Varela Round",sans-serif;*/
      font-size: 17px;
      font-weight: bold;
      padding-right: 20px;

    }

    .node-tooltip-option-description {
      font-family: "Varela Round",sans-serif;
      font-size: 18px;
    }

    /* Tooltip END */


    /* Validation Error Marker on Canvas START */

    .error-tooltip p {
      margin-top: 5px;
      margin-left: 0px;
      margin-bottom: 5px;
      color:#fff;
    }
    .error-tooltip {
      display:none;
      position:absolute;
      border:1px solid #333;
      background-color:red;/*#161616;*/
      border-radius:5px;
      padding:5px;
      color:#fff;
      /*	font-size:12px Arial;*/
      font-family: "Varela Round",sans-serif;
      font-size: 20px;
      z-index: 100;
    }

    /* Validation Error Marker on Canvas END */

    /* Controls on Canvas START */

    .canvas-controls-container {
      position: absolute;
      right: 15px;
      top: 5px;
    }

    .canvas-control {
      background: transparent;
      font-family: "Varela Round",sans-serif;
      font-size: 11px;
      vertical-align: middle;
      margin: 0px;
    }

    .zoom-canvas-control {
      border: 0px;
      padding: 0px;
      margin: 0px;
      outline: none;
    }

    .zoom-canvas-input {
      text-align: right;
      font-weight:bold;
      color: black;
      background-color: transparent;
    }

    .zoom-canvas-label {
      padding-right: 4px;
      color: black;
    }

    /* Controls on Canvas END */




    /* START - FLO CANVAS STYLES - override joint js styles */

    .highlighted {
      outline: none;
    }

    .joint-type-handle {
      cursor: pointer;
    }

    .available-magnet {
      stroke-width: 3;
    }

    .link {
      fill: none;
      stroke: #ccc;
      stroke-width: 1.5px;
    }

    .link-tools .tool-options {
      display: none;       /* by default, we don't display link options tool */
    }

    /* Make transparent the circle around the link-tools (cog) icon. It'll allow shape to have a circle clicking area */
    .link-tools .tool-options circle {
      fill: transparent;
      stroke: transparent;
    }

    .link-tools .tool-options path {
      fill: black;
      stroke: black;
    }

    .link-tools .tool-remove circle {
      fill: red;
      stroke: red;
    }

    .link-tools .tool-remove path {
      fill: white;
      stroke: white;
    }

    .link-tools-container {
      stroke-width: 0;
      fill: transparent;
    }

    /* END - FLO CANVAS STYLES */
  `],
        encapsulation: ViewEncapsulation.None
    })
], PaperComponent);
export { PaperComponent };
//# sourceMappingURL=paper.component.js.map