import * as tslib_1 from "tslib";
import { Component, Input, ViewEncapsulation } from '@angular/core';
import { FormGroup, FormControl } from '@angular/forms';
import { Properties } from '../shared/flo-properties';
let PropertiesGroupComponent = class PropertiesGroupComponent {
    ngOnInit() {
        if (this.propertiesGroupModel.isLoading) {
            let subscription = this.propertiesGroupModel.loadedSubject.subscribe(loaded => {
                if (loaded) {
                    subscription.unsubscribe();
                    this.createGroupControls();
                }
            });
        }
        else {
            this.createGroupControls();
        }
    }
    createGroupControls() {
        this.propertiesGroupModel.getControlsModels().forEach(c => {
            if (c.validation) {
                this.form.addControl(c.id, new FormControl(c.value || '', c.validation.validator, c.validation.asyncValidator));
            }
            else {
                this.form.addControl(c.id, new FormControl(c.value || ''));
            }
        });
    }
    get controlModelsToDisplay() {
        return this.propertiesGroupModel.getControlsModels().filter(c => !this.filter || this.filter.accept(c.property));
    }
};
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", Properties.PropertiesGroupModel)
], PropertiesGroupComponent.prototype, "propertiesGroupModel", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", FormGroup)
], PropertiesGroupComponent.prototype, "form", void 0);
tslib_1.__decorate([
    Input(),
    tslib_1.__metadata("design:type", Object)
], PropertiesGroupComponent.prototype, "filter", void 0);
PropertiesGroupComponent = tslib_1.__decorate([
    Component({
        selector: 'properties-group',
        template: `
    <div *ngIf="propertiesGroupModel && !propertiesGroupModel.isLoading" class="properties-group-container"
         [formGroup]="form">
      <div
        *ngIf="propertiesGroupModel.getControlsModels().length > 0 && controlModelsToDisplay.length === 0; else propertiesList"
        class="no-matches-label">No results found.
      </div>
    </div>

    <ng-template #propertiesList>
      <df-property *ngFor="let model of controlModelsToDisplay" [model]="model" [form]="form"
                   class="property-row"></df-property>
    </ng-template>
  `,
        encapsulation: ViewEncapsulation.None
    })
], PropertiesGroupComponent);
export { PropertiesGroupComponent };
//# sourceMappingURL=properties.group.component.js.map