import * as tslib_1 from "tslib";
import { Component, Input, Output, ElementRef, EventEmitter, ViewEncapsulation, forwardRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import * as CodeMirror from 'codemirror-minified';
import * as _$ from 'jquery';
var $ = _$;
// CodeMirror extensions
import 'codemirror-minified/mode/meta';
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
// import 'codemirror-minified/addon/mode/loadmode';
import 'codemirror-minified/addon/edit/matchbrackets';
import 'codemirror-minified/addon/edit/closebrackets';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
// Lint support
// Unclear how to import this dynamically...
// import 'codemirror-minified/addon/lint/javascript-lint';
// import 'codemirror-minified/addon/lint/json-lint';
// import 'codemirror-minified/addon/lint/yaml-lint';
// TODO: use dynamic import with JS7 in the future. CM autoLoad cannot load it properly - thinks its AMD
// Supported languages until dynamic loading
// import 'codemirror-minified/mode/groovy/groovy';
// import 'codemirror-minified/mode/javascript/javascript';
// import 'codemirror-minified/mode/python/python';
// import 'codemirror-minified/mode/ruby/ruby';
// import 'codemirror-minified/mode/clike/clike';
// import 'codemirror-minified/mode/yaml/yaml';
var CodeEditorComponent = /** @class */ (function () {
    function CodeEditorComponent(element) {
        var _this = this;
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = function () {
            _this._dsl = _this.doc.getValue();
            _this.dslChange.emit(_this._dsl);
            if (_this._onChangeHandler) {
                _this._onChangeHandler(_this._dsl);
            }
        };
    }
    CodeEditorComponent_1 = CodeEditorComponent;
    Object.defineProperty(CodeEditorComponent.prototype, "dsl", {
        set: function (dsl) {
            this._dsl = dsl;
            if (this.doc && this._dsl !== this.doc.getValue()) {
                var cursorPosition = this.doc.getCursor();
                this.doc.setValue(this._dsl || '');
                this.doc.setCursor(cursorPosition);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CodeEditorComponent.prototype, "language", {
        set: function (_language) {
            if (this._language !== _language) {
                this._language = _language;
                this.loadEditorMode();
            }
        },
        enumerable: true,
        configurable: true
    });
    CodeEditorComponent.prototype.ngOnInit = function () {
        var _this = this;
        var options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            matchBrackets: true,
            autoCloseBrackets: true,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        this.doc = CodeMirror.fromTextArea($('#code-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this._dslChangedHandler);
        this.doc.on('focus', function () {
            _this.focus.emit();
            if (_this._onTouchHandler) {
                _this._onTouchHandler();
            }
        });
        this.doc.on('blur', function () { return _this.blur.emit(); });
        this.warningRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-warning');
        this.errorRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-error');
        this.loadEditorMode();
        this.editor.emit(this.doc);
    };
    CodeEditorComponent.prototype.loadEditorMode = function () {
        // CodeMirror doc object must be initialized
        if (!this.doc) {
            return;
        }
        var info = this._language ? CodeMirror.findModeByName(this._language) : undefined;
        // Set proper editor mode
        if (info) {
            this.doc.setOption('mode', info.mime);
            // (<any>CodeMirror).autoLoadMode(this.doc, info.mode);
        }
        else {
            this.doc.setOption('mode', 'text/plain');
        }
        // Set proper Lint mode
        this.doc.setOption('lint', this.getLintOptions());
    };
    CodeEditorComponent.prototype.ngOnDestroy = function () {
    };
    CodeEditorComponent.prototype.writeValue = function (obj) {
        this.dsl = obj;
    };
    CodeEditorComponent.prototype.registerOnChange = function (fn) {
        this._onChangeHandler = fn;
    };
    CodeEditorComponent.prototype.registerOnTouched = function (fn) {
        this._onTouchHandler = fn;
    };
    CodeEditorComponent.prototype.getLintOptions = function () {
        var _this = this;
        switch (this._language) {
            case 'javascript':
            case 'json':
            case 'coffeescript':
            case 'yaml':
                return {
                    onUpdateLinting: function (annotations) {
                        var warnings = [];
                        var errors = [];
                        if (_this.overviewRuler) {
                            if (Array.isArray(annotations)) {
                                annotations.forEach(function (a) {
                                    if (a.to && a.from && a.from.line >= 0 && a.from.ch >= 0 && a.to.line >= a.from.line && a.from.ch >= 0) {
                                        if (a.severity === 'error') {
                                            errors.push(a);
                                        }
                                        else if (a.severity === 'warning') {
                                            warnings.push(a);
                                        }
                                    }
                                });
                            }
                        }
                        _this.warningRuler.update(warnings);
                        _this.errorRuler.update(errors);
                    }
                };
        }
        return false;
    };
    var CodeEditorComponent_1;
    tslib_1.__decorate([
        Input('line-numbers'),
        tslib_1.__metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "lineNumbers", void 0);
    tslib_1.__decorate([
        Input('line-wrapping'),
        tslib_1.__metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "lineWrapping", void 0);
    tslib_1.__decorate([
        Input('scrollbar-style'),
        tslib_1.__metadata("design:type", String)
    ], CodeEditorComponent.prototype, "scrollbarStyle", void 0);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", String)
    ], CodeEditorComponent.prototype, "placeholder", void 0);
    tslib_1.__decorate([
        Input('overview-ruler'),
        tslib_1.__metadata("design:type", Boolean)
    ], CodeEditorComponent.prototype, "overviewRuler", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "dslChange", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "focus", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "blur", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "editor", void 0);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", String),
        tslib_1.__metadata("design:paramtypes", [String])
    ], CodeEditorComponent.prototype, "dsl", null);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", String),
        tslib_1.__metadata("design:paramtypes", [String])
    ], CodeEditorComponent.prototype, "language", null);
    CodeEditorComponent = CodeEditorComponent_1 = tslib_1.__decorate([
        Component({
            selector: 'code-editor',
            template: "\n    <div class=\"code-editor-host\">\n      <textarea id=\"code-editor-host\"></textarea>\n    </div>\n  ",
            styles: ["\n    .CodeMirror {\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n      height: 100%;\n    }\n    .CodeMirror-hint {\n      max-width: 38em;\n    }\n    .CodeMirror-vertical-ruler-error {\n      background-color: rgba(188, 0, 0, 0.5);\n    }\n    .CodeMirror-vertical-ruler-warning {\n      background-color: rgba(255, 188, 0, 0.5);\n    }\n    .CodeMirror-lint-tooltip {\n      z-index: 2000;\n    }\n  "],
            encapsulation: ViewEncapsulation.None,
            providers: [
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(function () { return CodeEditorComponent_1; }),
                    multi: true
                }
            ]
        }),
        tslib_1.__metadata("design:paramtypes", [ElementRef])
    ], CodeEditorComponent);
    return CodeEditorComponent;
}());
export { CodeEditorComponent };
//# sourceMappingURL=code-editor.component.js.map