import * as tslib_1 from "tslib";
import { Component, Input, Output, ElementRef, EventEmitter, ViewEncapsulation } from '@angular/core';
import * as _ from 'lodash';
import * as CodeMirror from 'codemirror-minified';
import * as _$ from 'jquery';
var $ = _$;
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
var DslEditorComponent = /** @class */ (function () {
    function DslEditorComponent(element) {
        var _this = this;
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.debounce = 0;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = function () {
            _this._dsl = _this.doc.getValue();
            _this.dslChange.emit(_this._dsl);
        };
    }
    Object.defineProperty(DslEditorComponent.prototype, "dsl", {
        set: function (dsl) {
            this._dsl = dsl;
            if (this.doc && this._dsl !== this.doc.getValue()) {
                var cursorPosition = this.doc.getCursor();
                this.doc.setValue(this._dsl || '');
                this.doc.setCursor(cursorPosition);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DslEditorComponent.prototype, "lintOptions", {
        set: function (lintOptions) {
            this._lint = lintOptions;
            if (this.doc) {
                this.doc.setOption('lint', this._lint);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DslEditorComponent.prototype, "hintOptions", {
        set: function (hintOptions) {
            this._hint = hintOptions;
            if (this.doc) {
                this.doc.setOption('hintOptions', this._hint);
            }
        },
        enumerable: true,
        configurable: true
    });
    DslEditorComponent.prototype.ngOnInit = function () {
        var _this = this;
        var options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            electricChars: false,
            smartIndent: false,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        if (this._hint) {
            options.hintOptions = this._hint;
        }
        this.doc = CodeMirror.fromTextArea($('#dsl-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this.debounce ? _.debounce(this._dslChangedHandler, this.debounce) : this._dslChangedHandler);
        this.doc.on('focus', function () { return _this.focus.emit(); });
        this.doc.on('blur', function () { return _this.blur.emit(); });
        this.editor.emit(this.doc);
    };
    DslEditorComponent.prototype.ngOnDestroy = function () {
    };
    tslib_1.__decorate([
        Input('line-numbers'),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "lineNumbers", void 0);
    tslib_1.__decorate([
        Input('line-wrapping'),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "lineWrapping", void 0);
    tslib_1.__decorate([
        Input('scrollbar-style'),
        tslib_1.__metadata("design:type", String)
    ], DslEditorComponent.prototype, "scrollbarStyle", void 0);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", String)
    ], DslEditorComponent.prototype, "placeholder", void 0);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "debounce", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "dslChange", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "focus", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "blur", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], DslEditorComponent.prototype, "editor", void 0);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", String),
        tslib_1.__metadata("design:paramtypes", [String])
    ], DslEditorComponent.prototype, "dsl", null);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", Object),
        tslib_1.__metadata("design:paramtypes", [Object])
    ], DslEditorComponent.prototype, "lintOptions", null);
    tslib_1.__decorate([
        Input(),
        tslib_1.__metadata("design:type", Object),
        tslib_1.__metadata("design:paramtypes", [Object])
    ], DslEditorComponent.prototype, "hintOptions", null);
    DslEditorComponent = tslib_1.__decorate([
        Component({
            selector: 'dsl-editor',
            template: "\n    <textarea id=\"dsl-editor-host\"></textarea>\n  ",
            styles: ["\n    /* Code Mirror related styles START */\n\n    .CodeMirror {\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n      height: 100%;\n    }\n    .CodeMirror-hint {\n      max-width: 38em;\n    }\n    .CodeMirror-vertical-ruler-error {\n      background-color: rgba(188, 0, 0, 0.5);\n    }\n    .CodeMirror-vertical-ruler-warning {\n      background-color: rgba(255, 188, 0, 0.5);\n    }\n\n\n    /* Code Mirror related styles END */\n  "],
            encapsulation: ViewEncapsulation.None
        }),
        tslib_1.__metadata("design:paramtypes", [ElementRef])
    ], DslEditorComponent);
    return DslEditorComponent;
}());
export { DslEditorComponent };
//# sourceMappingURL=dsl-editor.component.js.map