import * as tslib_1 from "tslib";
import { Component, ElementRef, EventEmitter, HostListener, Output, ViewChild, ViewEncapsulation } from '@angular/core';
var PaperComponent = /** @class */ (function () {
    function PaperComponent() {
        this.onDelete = new EventEmitter();
        this.onProperties = new EventEmitter();
        this.onBlur = new EventEmitter();
    }
    PaperComponent.prototype.click = function () {
        this.paperElement.nativeElement.focus();
    };
    PaperComponent.prototype.mousedown = function () {
        this.paperElement.nativeElement.focus();
    };
    PaperComponent.prototype.backspaceHandle = function () {
        this.onDelete.emit();
    };
    PaperComponent.prototype.deleteHandle = function () {
        this.onDelete.emit();
    };
    PaperComponent.prototype.oHandle = function () {
        this.onProperties.emit();
    };
    PaperComponent.prototype.ngOnInit = function () {
        var onBlur = this.onBlur;
        this.paperElement.nativeElement.addEventListener('blur', function () {
            onBlur.emit();
        });
    };
    tslib_1.__decorate([
        ViewChild('paper', { static: true }),
        tslib_1.__metadata("design:type", ElementRef)
    ], PaperComponent.prototype, "paperElement", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], PaperComponent.prototype, "onDelete", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], PaperComponent.prototype, "onProperties", void 0);
    tslib_1.__decorate([
        Output(),
        tslib_1.__metadata("design:type", Object)
    ], PaperComponent.prototype, "onBlur", void 0);
    tslib_1.__decorate([
        HostListener('click'),
        tslib_1.__metadata("design:type", Function),
        tslib_1.__metadata("design:paramtypes", []),
        tslib_1.__metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "click", null);
    tslib_1.__decorate([
        HostListener('mousedown'),
        tslib_1.__metadata("design:type", Function),
        tslib_1.__metadata("design:paramtypes", []),
        tslib_1.__metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "mousedown", null);
    tslib_1.__decorate([
        HostListener('keydown.backspace'),
        tslib_1.__metadata("design:type", Function),
        tslib_1.__metadata("design:paramtypes", []),
        tslib_1.__metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "backspaceHandle", null);
    tslib_1.__decorate([
        HostListener('keydown.delete'),
        tslib_1.__metadata("design:type", Function),
        tslib_1.__metadata("design:paramtypes", []),
        tslib_1.__metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "deleteHandle", null);
    tslib_1.__decorate([
        HostListener('keydown.o'),
        tslib_1.__metadata("design:type", Function),
        tslib_1.__metadata("design:paramtypes", []),
        tslib_1.__metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "oHandle", null);
    PaperComponent = tslib_1.__decorate([
        Component({
            selector: 'flo-editor-paper',
            template: "\n    <div #paper tabindex=\"0\" id=\"paper-container\">\n      <ng-content></ng-content>\n    </div>",
            styles: ["\n    flo-view {\n      width:100%;\n      height:100%;\n      margin: 0;\n      background-color: #eeeeee;\n      font-family: \"Varela Round\",sans-serif;\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n    }\n\n    .canvas {\n      border: 1px solid;\n      border-color: #6db33f;\n      border-radius: 2px;\n      margin-top: 3px;\n    }\n\n    /* Canvas contains the palette on the left and the paper on the right */\n\n    .paper {\n      padding: 0px;\n      background-color: #ffffff;\n      /* \theight: 100%;\n          width: 100%;\n          position: relative;\n          overflow: hidden;\n       *//* \tmargin-left: 400px; */\n    }\n\n    #sidebar-resizer {\n      background-color: #34302d;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      width: 6px;\n      cursor: e-resize;\n    }\n\n    #palette-container {\n      background-color: #EEE;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      left: 0;\n      overflow: auto;\n    }\n\n    #paper-container {\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      right: 0;\n      overflow: auto;\n      color: #FFF;\n      background-color: #FFF;\n      outline: none;\n    }\n\n    /* Tooltip START */\n\n    .node-tooltip .tooltip-description {\n      margin-top: 5px;\n      margin-left: 0px;\n      margin-bottom: 5px;\n    }\n\n    .node-tooltip {\n      display:none;\n      position:absolute;\n      border:1px solid #333;\n      background-color:#34302d;/*#161616;*/\n      border-radius:5px;\n      padding:5px;\n      color:#fff;\n      /*\tfont-size:12px Arial;*/\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 19px;\n      z-index: 100;\n    }\n\n    .tooltip-title-type {\n      font-size: 24px;\n      font-weight: bold;\n    }\n\n    .tooltip-title-group {\n      padding-left: 5px;\n      font-size: 20px;\n      font-style: italic;\n    }\n\n    .node-tooltip-option-name {\n      font-family: monospace;/*\"Varela Round\",sans-serif;*/\n      font-size: 17px;\n      font-weight: bold;\n      padding-right: 20px;\n\n    }\n\n    .node-tooltip-option-description {\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 18px;\n    }\n\n    /* Tooltip END */\n\n\n    /* Validation Error Marker on Canvas START */\n\n    .error-tooltip p {\n      margin-top: 5px;\n      margin-left: 0px;\n      margin-bottom: 5px;\n      color:#fff;\n    }\n    .error-tooltip {\n      display:none;\n      position:absolute;\n      border:1px solid #333;\n      background-color:red;/*#161616;*/\n      border-radius:5px;\n      padding:5px;\n      color:#fff;\n      /*\tfont-size:12px Arial;*/\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 20px;\n      z-index: 100;\n    }\n\n    /* Validation Error Marker on Canvas END */\n\n    /* Controls on Canvas START */\n\n    .canvas-controls-container {\n      position: absolute;\n      right: 15px;\n      top: 5px;\n    }\n\n    .canvas-control {\n      background: transparent;\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 11px;\n      vertical-align: middle;\n      margin: 0px;\n    }\n\n    .zoom-canvas-control {\n      border: 0px;\n      padding: 0px;\n      margin: 0px;\n      outline: none;\n    }\n\n    .zoom-canvas-input {\n      text-align: right;\n      font-weight:bold;\n      color: black;\n      background-color: transparent;\n    }\n\n    .zoom-canvas-label {\n      padding-right: 4px;\n      color: black;\n    }\n\n    /* Controls on Canvas END */\n\n\n\n\n    /* START - FLO CANVAS STYLES - override joint js styles */\n\n    .highlighted {\n      outline: none;\n    }\n\n    .joint-type-handle {\n      cursor: pointer;\n    }\n\n    .available-magnet {\n      stroke-width: 3;\n    }\n\n    .link {\n      fill: none;\n      stroke: #ccc;\n      stroke-width: 1.5px;\n    }\n\n    .link-tools .tool-options {\n      display: none;       /* by default, we don't display link options tool */\n    }\n\n    /* Make transparent the circle around the link-tools (cog) icon. It'll allow shape to have a circle clicking area */\n    .link-tools .tool-options circle {\n      fill: transparent;\n      stroke: transparent;\n    }\n\n    .link-tools .tool-options path {\n      fill: black;\n      stroke: black;\n    }\n\n    .link-tools .tool-remove circle {\n      fill: red;\n      stroke: red;\n    }\n\n    .link-tools .tool-remove path {\n      fill: white;\n      stroke: white;\n    }\n\n    .link-tools-container {\n      stroke-width: 0;\n      fill: transparent;\n    }\n\n    /* END - FLO CANVAS STYLES */\n  "],
            encapsulation: ViewEncapsulation.None
        })
    ], PaperComponent);
    return PaperComponent;
}());
export { PaperComponent };
//# sourceMappingURL=paper.component.js.map