import { __decorate, __metadata, __param } from 'tslib';
import { EventEmitter, Input, Output, Component, ViewEncapsulation, Inject, ElementRef, Directive, forwardRef, ViewChild, HostListener, NgModule } from '@angular/core';
import { NG_VALUE_ACCESSOR, FormControl, FormGroup, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { DOCUMENT, CommonModule } from '@angular/common';
import { Subject, BehaviorSubject, fromEvent, Observable } from 'rxjs';
import { debounceTime, sampleTime, switchMap } from 'rxjs/operators';
import * as _joint from 'jointjs';
import * as _$ from 'jquery';
import { cloneDeepWith, isObject, isPlainObject, template, isFunction, groupBy, each, isEqual, isString, isNumber, partial, debounce } from 'lodash';
import { CompositeDisposable, Disposable } from 'ts-disposables';
import { fromTextArea, findModeByName } from 'codemirror-minified';
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
import 'codemirror-minified/mode/meta';
import 'codemirror-minified/addon/edit/matchbrackets';
import 'codemirror-minified/addon/edit/closebrackets';

const $ = _$;
var Flo;
(function (Flo) {
    Flo.joint = _joint;
    let DnDEventType;
    (function (DnDEventType) {
        DnDEventType[DnDEventType["DRAG"] = 0] = "DRAG";
        DnDEventType[DnDEventType["DROP"] = 1] = "DROP";
    })(DnDEventType = Flo.DnDEventType || (Flo.DnDEventType = {}));
    let Severity;
    (function (Severity) {
        Severity[Severity["Error"] = 0] = "Error";
        Severity[Severity["Warning"] = 1] = "Warning";
    })(Severity = Flo.Severity || (Flo.Severity = {}));
    function findMagnetByClass(view, className) {
        if (className && className.startsWith('.')) {
            className = className.substr(1);
        }
        const element = view.$('[magnet]').toArray().find((magnet) => magnet.getAttribute('class').split(/\s+/).indexOf(className) >= 0);
        if (element) {
            return view.findMagnet($(element));
        }
    }
    Flo.findMagnetByClass = findMagnetByClass;
    function findMagnetByPort(view, port) {
        const element = view.$('[magnet]').toArray().find((magnet) => magnet.getAttribute('port') === port);
        if (element) {
            return view.findMagnet($(element));
        }
    }
    Flo.findMagnetByPort = findMagnetByPort;
    /**
     * Return the metadata for a particular palette entry in a particular group.
     * @param name - name of the palette entry
     * @param group - group in which the palette entry should exist (e.g. sinks)
     * @return
     */
    function getMetadata(metamodel, name, group) {
        const groupObj = metamodel && group ? metamodel.get(group) : undefined;
        if (name && groupObj && groupObj.get(name)) {
            return metamodel.get(group).get(name);
        }
        else {
            return {
                name: name,
                group: group,
                unresolved: true,
                get: (property) => new Promise(resolve => resolve()),
                properties: () => Promise.resolve(new Map())
            };
        }
    }
    Flo.getMetadata = getMetadata;
    function getScrollbarWidth() {
        // Creating invisible container
        const outer = document.createElement('div');
        outer.style.visibility = 'hidden';
        outer.style.overflow = 'scroll'; // forcing scrollbar to appear
        outer.style.msOverflowStyle = 'scrollbar'; // needed for WinJS apps
        document.body.appendChild(outer);
        // Creating inner element and placing it in the container
        const inner = document.createElement('div');
        outer.appendChild(inner);
        // Calculating difference between container's full width and the child width
        const scrollbarWidth = (outer.offsetWidth - inner.offsetWidth);
        // Removing temporary elements from the DOM
        outer.parentNode.removeChild(outer);
        return scrollbarWidth;
    }
    Flo.getScrollbarWidth = getScrollbarWidth;
    Flo.SCROLLBAR_WIDTH = getScrollbarWidth();
})(Flo || (Flo = {}));

const joint = Flo.joint;
const $$1 = _$;
const isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
const isFF = navigator.userAgent.indexOf('Firefox') > 0;
const IMAGE_W = 120;
const IMAGE_H = 35;
const ERROR_MARKER_SIZE = { width: 16, height: 16 };
const HANDLE_SIZE = { width: 10, height: 10 };
joint.shapes.flo = {};
joint.shapes.flo.NODE_TYPE = 'sinspctr.IntNode';
joint.shapes.flo.LINK_TYPE = 'sinspctr.Link';
joint.shapes.flo.DECORATION_TYPE = 'decoration';
joint.shapes.flo.HANDLE_TYPE = 'handle';
const HANDLE_ICON_MAP = new Map();
const REMOVE = 'remove';
HANDLE_ICON_MAP.set(REMOVE, 'icons/delete.svg');
const DECORATION_ICON_MAP = new Map();
const ERROR = 'error';
DECORATION_ICON_MAP.set(ERROR, 'icons/error.svg');
joint.util.cloneDeep = (obj) => {
    return cloneDeepWith(obj, (o) => {
        if (isObject(o) && !isPlainObject(o)) {
            return o;
        }
    });
};
joint.util.filter.redscale = (args) => {
    let amount = Number.isFinite(args.amount) ? args.amount : 1;
    return template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 ${d} ${e} ${f} ${g} 0 0 ${h} ${i} ${k} 0 0 0 0 0 1 0"/></filter>', {
        a: 1 - 0.96 * amount,
        b: 0.95 * amount,
        c: 0.01 * amount,
        d: 0.3 * amount,
        e: 0.2 * amount,
        f: 1 - 0.9 * amount,
        g: 0.7 * amount,
        h: 0.05 * amount,
        i: 0.05 * amount,
        k: 1 - 0.1 * amount
    });
};
joint.util.filter.orangescale = (args) => {
    let amount = Number.isFinite(args.amount) ? args.amount : 1;
    return template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 ${d} ${e} ${f} ${g} 0 ${h} ${i} ${k} ${l} 0 0 0 0 0 1 0"/></filter>', {
        a: 1.0 + 0.5 * amount,
        b: 1.4 * amount,
        c: 0.2 * amount,
        d: 0.3 * amount,
        e: 0.3 * amount,
        f: 1 + 0.05 * amount,
        g: 0.2 * amount,
        h: 0.15 * amount,
        i: 0.3 * amount,
        k: 0.3 * amount,
        l: 1 - 0.6 * amount
    });
};
joint.shapes.flo.Node = joint.shapes.basic.Generic.extend({
    markup: '<g class="shape"><image class="image" /></g>' +
        '<rect class="border-white"/>' +
        '<rect class="border"/>' +
        '<rect class="box"/>' +
        '<text class="label"/>' +
        '<text class="label2"></text>' +
        '<rect class="input-port" />' +
        '<rect class="output-port"/>' +
        '<rect class="output-port-cover"/>',
    defaults: joint.util.deepSupplement({
        type: joint.shapes.flo.NODE_TYPE,
        position: { x: 0, y: 0 },
        size: { width: IMAGE_W, height: IMAGE_H },
        attrs: {
            '.': { magnet: false },
            // rounded edges around image
            '.border': {
                width: IMAGE_W,
                height: IMAGE_H,
                rx: 3,
                ry: 3,
                'fill-opacity': 0,
                stroke: '#eeeeee',
                'stroke-width': 0
            },
            '.box': {
                width: IMAGE_W,
                height: IMAGE_H,
                rx: 3,
                ry: 3,
                //'fill-opacity': 0, // see through
                stroke: '#6db33f',
                fill: '#eeeeee',
                'stroke-width': 1
            },
            '.input-port': {
                idp: 'input',
                port: 'input',
                height: 8, width: 8,
                magnet: true,
                fill: '#eeeeee',
                transform: 'translate(' + -4 + ',' + ((IMAGE_H / 2) - 4) + ')',
                stroke: '#34302d',
                'stroke-width': 1
            },
            '.output-port': {
                id: 'output',
                port: 'output',
                height: 8, width: 8,
                magnet: true,
                fill: '#eeeeee',
                transform: 'translate(' + (IMAGE_W - 4) + ',' + ((IMAGE_H / 2) - 4) + ')',
                stroke: '#34302d',
                'stroke-width': 1
            },
            '.label': {
                'text-anchor': 'middle',
                'ref-x': 0.5,
                // 'ref-y': -12, // jointjs specific: relative position to ref'd element
                'ref-y': 0.3,
                ref: '.border',
                fill: 'black',
                'font-size': 14
            },
            '.label2': {
                'text': '\u21d2',
                'text-anchor': 'middle',
                'ref-x': 0.15,
                'ref-y': 0.2,
                ref: '.border',
                // transform: 'translate(' + (IMAGE_W/2) + ',' + (IMAGE_H/2) + ')',
                fill: 'black',
                'font-size': 24
            },
            '.shape': {},
            '.image': {
                width: IMAGE_W,
                height: IMAGE_H
            }
        }
    }, joint.shapes.basic.Generic.prototype.defaults)
});
joint.shapes.flo.Link = joint.dia.Link.extend({
    defaults: joint.util.deepSupplement({
        type: joint.shapes.flo.LINK_TYPE,
        attrs: {
            '.connection': { stroke: '#34302d', 'stroke-width': 2 },
            // Lots of alternatives that have been played with:
            //	            '.smoooth': true
            //	            '.marker-source': { stroke: '#9B59B6', fill: '#9B59B6', d: 'M24.316,5.318,9.833,13.682,9.833,5.5,5.5,5.5,5.5,25.5,9.833,25.5,9.833,17.318,24.316,25.682z' },
            //	            '.marker-target': { stroke: '#F39C12', fill: '#F39C12', d: 'M14.615,4.928c0.487-0.986,1.284-0.986,1.771,0l2.249,4.554c0.486,0.986,1.775,1.923,2.864,2.081l5.024,0.73c1.089,0.158,1.335,0.916,0.547,1.684l-3.636,3.544c-0.788,0.769-1.28,2.283-1.095,3.368l0.859,5.004c0.186,1.085-0.459,1.553-1.433,1.041l-4.495-2.363c-0.974-0.512-2.567-0.512-3.541,0l-4.495,2.363c-0.974,0.512-1.618,0.044-1.432-1.041l0.858-5.004c0.186-1.085-0.307-2.6-1.094-3.368L3.93,13.977c-0.788-0.768-0.542-1.525,0.547-1.684l5.026-0.73c1.088-0.158,2.377-1.095,2.864-2.081L14.615,4.928z' },
            //	        	'.connection': { 'stroke':'black'},
            //	        	'.': { filter: { name: 'dropShadow', args: { dx: 1, dy: 1, blur: 2 } } },
            //	        	'.connection': { 'stroke-width': 10, 'stroke-linecap': 'round' },
            // This means: moveto 10 0, lineto 0 5, lineto, 10 10 closepath(z)
            //	        	'.marker-target': { d: 'M 5 0 L 0 7 L 5 14 z', stroke: '#34302d','stroke-width': 1},
            //	        	'.marker-target': { d: 'M 14 2 L 9,2 L9,0 L 0,7 L 9,14 L 9,12 L 14,12 z', 'stroke-width': 1, fill: '#34302d', stroke: '#34302d'},
            //	        	'.marker-source': {d: 'M 5 0 L 5,10 L 0,10 L 0,0 z', 'stroke-width': 0, fill: '#34302d', stroke: '#34302d'},
            //	            '.marker-target': { stroke: '#E74C3C', fill: '#E74C3C', d: 'M 10 0 L 0 5 L 10 10 z' },
            '.marker-arrowheads': { display: 'none' },
            '.tool-options': { display: 'none' }
        },
    }, joint.dia.Link.prototype.defaults)
});
joint.shapes.flo.LinkView = joint.dia.LinkView.extend({
    options: joint.util.deepSupplement({
        linkToolsOffset: 0.5,
        shortLinkLength: 40
    }, joint.dia.LinkView.prototype.options),
    updateToolsPosition: function () {
        // Overriden to support relative offset for tools placement.
        // If offset is between 0 and 1 then percentage of the connection length will be used to offset the tools group
        if (this.options.linkToolsOffset < 1 && this.options.linkToolsOffset > 0) {
            let connectionLength = this.getConnectionLength();
            const relativeOffset = this.options.linkToolsOffset;
            this.options.linkToolsOffset = connectionLength * relativeOffset;
            const returnValue = joint.dia.LinkView.prototype.updateToolsPosition.apply(this, arguments);
            this.options.linkToolsOffset = relativeOffset;
            return returnValue;
        }
        else {
            return joint.dia.LinkView.prototype.updateToolsPosition.apply(this, arguments);
        }
    },
    _beforeArrowheadMove: function () {
        if (this.model.get('source').id) {
            this._oldSource = this.model.get('source');
        }
        if (this.model.get('target').id) {
            this._oldTarget = this.model.get('target');
        }
        joint.dia.LinkView.prototype._beforeArrowheadMove.apply(this, arguments);
    },
    _afterArrowheadMove: function () {
        joint.dia.LinkView.prototype._afterArrowheadMove.apply(this, arguments);
        if (!this.model.get('source').id) {
            if (this._oldSource) {
                this.model.set('source', this._oldSource);
            }
            else {
                this.model.remove();
            }
        }
        if (!this.model.get('target').id) {
            if (this._oldTarget) {
                this.model.set('target', this._oldTarget);
            }
            else {
                this.model.remove();
            }
        }
        delete this._oldSource;
        delete this._oldTarget;
    }
});
// TODO: must do cleanup for the `mainElementView'
joint.shapes.flo.ElementView = joint.dia.ElementView.extend({
    // canShowTooltip: true,
    beingDragged: false,
    // _tempZorder: 0,
    _tempOpacity: 1.0,
    _hovering: false,
    dragLinkStart: function (evt, magnet, x, y) {
        this.model.startBatch('add-link');
        const linkView = this.addLinkFromMagnet(magnet, x, y);
        // backwards compatiblity events
        joint.dia.CellView.prototype.pointerdown.apply(linkView, [evt, x, y]);
        linkView.notify('link:pointerdown', evt, x, y);
        /*** START MAIN DIFF ***/
        const sourceOrTarget = $$1(magnet).attr('port') === 'input' ? 'source' : 'target';
        linkView.eventData(evt, linkView.startArrowheadMove(sourceOrTarget, { whenNotAllowed: 'remove' }));
        /*** END MAIN DIFF ***/
        this.eventData(evt, { linkView: linkView });
    },
    addLinkFromMagnet: function (magnet, x, y) {
        const paper = this.paper;
        const graph = paper.model;
        const link = paper.getDefaultLink(this, magnet);
        let sourceEnd, targetEnd;
        /*** START MAIN DIFF ***/
        if ($$1(magnet).attr('port') === 'input') {
            sourceEnd = { x: x, y: y };
            targetEnd = this.getLinkEnd(magnet, x, y, link, 'target');
        }
        else {
            sourceEnd = this.getLinkEnd(magnet, x, y, link, 'source');
            targetEnd = { x: x, y: y };
        }
        /*** END MAIN DIFF ***/
        link.set({
            source: sourceEnd,
            target: targetEnd
        }).addTo(graph, {
            async: false,
            ui: true
        });
        return link.findView(paper);
    },
    // pointerdown: function(evt: any, x: number, y: number) {
    //   // this.canShowTooltip = false;
    //   // this.hideTooltip();
    //   this.beingDragged = false;
    //   this._tempOpacity = this.model.attr('./opacity');
    //
    //   this.model.trigger('batch:start');
    //
    //   if ( // target is a valid magnet start linking
    //     evt.target.getAttribute('magnet') &&
    //     this.paper.options.validateMagnet.call(this.paper, this, evt.target)
    //   ) {
    //     let link = this.paper.getDefaultLink(this, evt.target);
    //     if ($(evt.target).attr('port') === 'input') {
    //       link.set({
    //         source: { x: x, y: y },
    //         target: {
    //           id: this.model.id,
    //           selector: this.getSelector(evt.target),
    //           port: evt.target.getAttribute('port')
    //         }
    //       });
    //     } else {
    //       link.set({
    //         source: {
    //           id: this.model.id,
    //           selector: this.getSelector(evt.target),
    //           port: evt.target.getAttribute('port')
    //         },
    //         target: { x: x, y: y }
    //       });
    //     }
    //     this.paper.model.addCell(link);
    //     this._linkView = this.paper.findViewByModel(link);
    //     if ($(evt.target).attr('port') === 'input') {
    //       this._linkView.startArrowheadMove('source');
    //     } else {
    //       this._linkView.startArrowheadMove('target');
    //     }
    //     this.paper.__creatingLinkFromPort = true;
    //   } else {
    //     this._dx = x;
    //     this._dy = y;
    //     joint.dia.CellView.prototype.pointerdown.apply(this, arguments);
    //   }
    // },
    drag: function (evt, x, y) {
        let interactive = isFunction(this.options.interactive) ? this.options.interactive(this, 'pointermove') :
            this.options.interactive;
        if (interactive !== false) {
            this.paper.trigger('dragging-node-over-canvas', { type: Flo.DnDEventType.DRAG, view: this, event: evt });
        }
        joint.dia.ElementView.prototype.drag.apply(this, arguments);
    },
    dragEnd: function (evt, x, y) {
        this.paper.trigger('dragging-node-over-canvas', { type: Flo.DnDEventType.DROP, view: this, event: evt });
        joint.dia.ElementView.prototype.dragEnd.apply(this, arguments);
    },
});
joint.shapes.flo.ErrorDecoration = joint.shapes.basic.Generic.extend({
    markup: '<g class="rotatable"><g class="scalable"><image/></g></g>',
    defaults: joint.util.deepSupplement({
        type: joint.shapes.flo.DECORATION_TYPE,
        size: ERROR_MARKER_SIZE,
        attrs: {
            'image': ERROR_MARKER_SIZE
        }
    }, joint.shapes.basic.Generic.prototype.defaults)
});
var Constants;
(function (Constants) {
    Constants.REMOVE_HANDLE_TYPE = REMOVE;
    Constants.PROPERTIES_HANDLE_TYPE = 'properties';
    Constants.ERROR_DECORATION_KIND = ERROR;
    Constants.PALETTE_CONTEXT = 'palette';
    Constants.CANVAS_CONTEXT = 'canvas';
    Constants.FEEDBACK_CONTEXT = 'feedback';
})(Constants || (Constants = {}));
var Shapes;
(function (Shapes) {
    class Factory {
        /**
         * Create a JointJS node that embeds extra metadata (properties).
         */
        static createNode(params) {
            let renderer = params.renderer;
            let paper = params.paper;
            let metadata = params.metadata;
            let position = params.position;
            let props = params.props;
            let graph = params.graph || (params.paper ? params.paper.model : undefined);
            let node;
            if (!position) {
                position = { x: 0, y: 0 };
            }
            if (renderer && isFunction(renderer.createNode)) {
                node = renderer.createNode({ graph, paper }, metadata, props);
            }
            else {
                node = new joint.shapes.flo.Node();
                if (metadata) {
                    node.attr('.label/text', metadata.name);
                }
            }
            node.set('type', joint.shapes.flo.NODE_TYPE);
            if (position) {
                node.set('position', position);
            }
            if (props) {
                Array.from(props.keys()).forEach(key => node.attr(`props/${key}`, props.get(key)));
            }
            node.attr('metadata', metadata);
            if (graph) {
                graph.addCell(node);
            }
            if (renderer && isFunction(renderer.initializeNewNode)) {
                let descriptor = {
                    paper: paper,
                    graph: graph
                };
                renderer.initializeNewNode(node, descriptor);
            }
            return node;
        }
        static createLink(params) {
            let renderer = params.renderer;
            let paper = params.paper;
            let metadata = params.metadata;
            let source = params.source;
            let target = params.target;
            let props = params.props;
            let graph = params.graph || (params.paper ? params.paper.model : undefined);
            let link;
            if (renderer && isFunction(renderer.createLink)) {
                link = renderer.createLink(source, target, metadata, props);
            }
            else {
                link = new joint.shapes.flo.Link();
            }
            if (source) {
                link.set('source', source);
            }
            if (target) {
                link.set('target', target);
            }
            link.set('type', joint.shapes.flo.LINK_TYPE);
            if (metadata) {
                link.attr('metadata', metadata);
            }
            if (props) {
                Array.from(props.keys()).forEach(key => link.attr(`props/${key}`, props.get(key)));
            }
            if (graph) {
                graph.addCell(link);
            }
            if (renderer && isFunction(renderer.initializeNewLink)) {
                let descriptor = {
                    paper: paper,
                    graph: graph
                };
                renderer.initializeNewLink(link, descriptor);
            }
            // prevent creation of link breaks
            link.attr('.marker-vertices/display', 'none');
            return link;
        }
        static createDecoration(params) {
            let renderer = params.renderer;
            let paper = params.paper;
            let parent = params.parent;
            let kind = params.kind;
            let messages = params.messages;
            let location = params.position;
            let graph = params.graph || (params.paper ? params.paper.model : undefined);
            let decoration;
            if (renderer && isFunction(renderer.createDecoration)) {
                decoration = renderer.createDecoration(kind, parent);
            }
            if (decoration) {
                decoration.set('type', joint.shapes.flo.DECORATION_TYPE);
                if ((isChrome || isFF) && parent && typeof parent.get('z') === 'number') {
                    decoration.set('z', parent.get('z') + 1);
                }
                decoration.attr('./kind', kind);
                decoration.attr('messages', messages);
                if (graph) {
                    graph.addCell(decoration);
                }
                parent.embed(decoration);
                if (renderer && isFunction(renderer.initializeNewDecoration)) {
                    let descriptor = {
                        paper: paper,
                        graph: graph
                    };
                    renderer.initializeNewDecoration(decoration, descriptor);
                }
                return decoration;
            }
        }
        static createHandle(params) {
            let renderer = params.renderer;
            let paper = params.paper;
            let parent = params.parent;
            let kind = params.kind;
            let location = params.position;
            let graph = params.graph || (params.paper ? params.paper.model : undefined);
            let handle;
            if (!location) {
                location = { x: 0, y: 0 };
            }
            if (renderer && isFunction(renderer.createHandle)) {
                handle = renderer.createHandle(kind, parent);
            }
            else {
                handle = new joint.shapes.flo.ErrorDecoration({
                    size: HANDLE_SIZE,
                    attrs: {
                        'image': {
                            'xlink:href': HANDLE_ICON_MAP.get(kind)
                        }
                    }
                });
            }
            handle.set('type', joint.shapes.flo.HANDLE_TYPE);
            handle.set('position', location);
            if ((isChrome || isFF) && parent && typeof parent.get('z') === 'number') {
                handle.set('z', parent.get('z') + 1);
            }
            handle.attr('./kind', kind);
            if (graph) {
                graph.addCell(handle);
            }
            parent.embed(handle);
            if (renderer && isFunction(renderer.initializeNewHandle)) {
                let descriptor = {
                    paper: paper,
                    graph: graph
                };
                renderer.initializeNewHandle(handle, descriptor);
            }
            return handle;
        }
    }
    Shapes.Factory = Factory;
})(Shapes || (Shapes = {}));

const joint$1 = Flo.joint;
const $$2 = _$;
const DEBOUNCE_TIME = 300;
joint$1.shapes.flo.PaletteGroupHeader = joint$1.shapes.basic.Generic.extend({
    // The path is the open/close arrow, defaults to vertical (open)
    markup: '<g class="scalable"><rect/></g><text/><g class="rotatable"><path d="m 10 10 l 5 8.7 l 5 -8.7 z"/></g>',
    defaults: joint$1.util.deepSupplement({
        type: 'palette.groupheader',
        size: { width: 170, height: 30 },
        position: { x: 0, y: 0 },
        attrs: {
            'rect': { fill: '#34302d', 'stroke-width': 1, stroke: '#6db33f', 'follow-scale': true, width: 80, height: 40 },
            'text': {
                text: '',
                fill: '#eeeeee',
                'ref-x': 0.5,
                'ref-y': 7,
                'x-alignment': 'middle',
                'font-size': 18 /*, 'font-weight': 'bold', 'font-variant': 'small-caps', 'text-transform': 'capitalize'*/
            },
            'path': { fill: 'white', 'stroke-width': 2, stroke: 'white' /*,transform:'rotate(90,15,15)'*/ }
        },
        // custom properties
        isOpen: true
    }, joint$1.shapes.basic.Generic.prototype.defaults)
});
joint$1.shapes.flo.NoMatchesFound = joint$1.shapes.basic.Generic.extend({
    // The path is the open/close arrow, defaults to vertical (open)
    markup: '<g class="scalable"><rect class="no-matches-label-border"/></g><rect class="no-mathes-label-bg"/><text class="no-matches-label"/>',
    defaults: joint$1.util.deepSupplement({
        size: { width: 170, height: 30 },
        position: { x: 0, y: 0 },
        attrs: {
            '.no-matches-label-border': {
                refWidth: 1,
                refHeight: 1,
                refX: 0,
                refY: 0,
            },
            '.no-macthes-label-bg': {
                ref: '.no-matches-label',
                refWidth: 10,
                refHeight: 2,
                'follow-scale': true
            },
            '.no-matches-label': {
                text: 'No results found.',
                ref: '.no-matches-label-border',
                refY: 0.5,
                refY2: 5,
                yAlignment: 'middle',
            },
        },
    }, joint$1.shapes.basic.Generic.prototype.defaults)
});
let Palette = class Palette {
    constructor(element, document) {
        this.element = element;
        this.document = document;
        this._metamodelListener = {
            metadataError: (data) => { },
            metadataAboutToChange: () => { },
            metadataChanged: () => {
                if (this.initialized && this.metamodel) {
                    this.metamodel.load().then(metamodel => this.buildPalette(metamodel));
                }
            }
        };
        this.initialized = false;
        this._filterText = '';
        this.filterTextModel = new Subject();
        this.paletteEntryPadding = { width: 12, height: 12 };
        this.searchFilterPlaceHolder = 'Search...';
        this.onPaletteEntryDrop = new EventEmitter();
        this.paletteReady = new EventEmitter();
        this.paletteFocus = new EventEmitter();
        this.mouseMoveHanlder = (e) => this.handleDrag(e);
        this.mouseUpHanlder = (e) => this.handleMouseUp(e);
        this.paletteGraph = new joint$1.dia.Graph();
        this.paletteGraph.set('type', Constants.PALETTE_CONTEXT);
        this._filterText = '';
        this.closedGroups = new Set();
    }
    set paletteSize(size) {
        console.debug('Palette Size: ' + size);
        if (this._paletteSize !== size) {
            this._paletteSize = size;
            if (this.palette) {
                this.layout();
            }
        }
    }
    onFocus() {
        this.paletteFocus.emit();
    }
    ngOnInit() {
        let element = $$2('#palette-paper', this.element.nativeElement);
        // Create the paper for the palette using the specified element view
        this.palette = new joint$1.dia.Paper({
            el: element,
            gridSize: 1,
            model: this.paletteGraph,
            height: $$2(this.element.nativeElement.parentNode).height(),
            width: $$2(this.element.nativeElement.parentNode).width(),
            elementView: this.getPaletteView(this.renderer && this.renderer.getNodeView ? this.renderer.getNodeView() : joint$1.dia.ElementView),
            interactive: false
        });
        this.palette.on('cell:pointerup', (cellview, evt) => {
            if (this.viewBeingDragged) {
                this.trigger({
                    type: Flo.DnDEventType.DROP,
                    view: this.viewBeingDragged,
                    event: evt
                });
                this.viewBeingDragged = undefined;
            }
            this.clickedElement = undefined;
            $$2('#palette-floater').remove();
            if (this.floaterpaper) {
                this.floaterpaper.remove();
            }
        });
        // Toggle the header open/closed on a click
        this.palette.on('cell:pointerclick', (cellview, event) => {
            // TODO [design][palette] should the user need to click on the arrow rather than anywhere on the header?
            // Click position within the element would be: evt.offsetX, evt.offsetY
            const cell = cellview.model;
            if (cell.attributes.header) ;
            // TODO [palette] ensure other mouse handling events do nothing for headers
            // TODO [palette] move 'metadata' field to the right place (not inside attrs I think)
        });
        $$2(this.document).on('mouseup', this.mouseUpHanlder);
        if (this.metamodel) {
            this.metamodel.load().then(data => {
                this.buildPalette(data);
                // Add listener to metamodel
                if (this.metamodel && this.metamodel.subscribe) {
                    this.metamodel.subscribe(this._metamodelListener);
                }
                // Add debounced listener to filter text changes
                this.filterTextModel
                    .pipe(debounceTime(DEBOUNCE_TIME))
                    .subscribe((value) => this.layout());
                this.initialized = true;
            });
        }
        else {
            console.error('No Metamodel service specified for palette!');
        }
        this._paletteSize = this._paletteSize || $$2(this.element.nativeElement.parentNode).width();
    }
    ngOnDestroy() {
        if (this.metamodel && this.metamodel.unsubscribe) {
            this.metamodel.unsubscribe(this._metamodelListener);
        }
        $$2(this.document).off('mouseup', this.mouseUpHanlder);
        this.palette.remove();
    }
    ngOnChanges(changes) {
        // if (changes.hasOwnProperty('paletteSize') || changes.hasOwnProperty('filterText')) {
        //   this.metamodel.load().then(metamodel => this.buildPalette(metamodel));
        // }
    }
    createPaletteGroup(title, isOpen) {
        const paletteRenderer = this.renderer && this.renderer.getPaletteRenderer ? this.renderer.getPaletteRenderer() : {
            createGroupHeader: (titleStr, isOpenParam) => {
                const header = new joint$1.shapes.flo.PaletteGroupHeader({ attrs: { text: { text: titleStr } } });
                if (!isOpenParam) {
                    header.attr({ 'path': { 'transform': 'rotate(-90,15,13)' } });
                }
                return header;
            },
            onClose: (groupView) => this.rotateClosed(groupView.model),
            onOpen: (groupView) => this.rotateOpen(groupView.model)
        };
        let newGroupHeader = paletteRenderer.createGroupHeader(title, isOpen);
        if (!isOpen) {
            newGroupHeader.set('isOpen', false);
        }
        newGroupHeader.set('header', title);
        this.paletteGraph.addCell(newGroupHeader);
        const view = this.palette.findViewByModel(newGroupHeader);
        view.on('cell:pointerclick', () => {
            if (newGroupHeader.get('isOpen')) {
                if (typeof paletteRenderer.onClose === 'function') {
                    paletteRenderer.onClose(view).then(() => {
                        newGroupHeader.set('isOpen', false);
                        this.closedGroups.add(newGroupHeader.get('header'));
                        this.layout();
                    });
                }
                else {
                    newGroupHeader.set('isOpen', false);
                    this.closedGroups.add(newGroupHeader.get('header'));
                    this.layout();
                }
            }
            else {
                if (typeof paletteRenderer.onOpen === 'function') {
                    paletteRenderer.onOpen(view).then(() => {
                        newGroupHeader.set('isOpen', true);
                        this.closedGroups.delete(newGroupHeader.get('header'));
                        this.layout();
                    });
                }
                else {
                    newGroupHeader.set('isOpen', true);
                    this.closedGroups.delete(newGroupHeader.get('header'));
                    this.layout();
                }
            }
        });
        return newGroupHeader;
    }
    createPaletteEntry(title, metadata) {
        return Shapes.Factory.createNode({
            renderer: this.renderer,
            paper: this.palette,
            metadata: metadata
        });
    }
    buildPalette(metamodel) {
        let startTime = new Date().getTime();
        this.paletteReady.emit(false);
        this.paletteGraph.clear();
        let groupAdded = new Set();
        let parentWidth = this._paletteSize - Flo.SCROLLBAR_WIDTH;
        console.debug(`Parent Width: ${parentWidth}`);
        // The field closedGroups tells us which should not be shown
        // Work out the list of active groups/nodes based on the filter text
        this.metamodel.groups().forEach(group => {
            if (metamodel && metamodel.has(group)) {
                Array.from(metamodel.get(group).keys()).sort().forEach(name => {
                    let node = metamodel.get(group).get(name);
                    if (node) {
                        if (!groupAdded.has(group)) {
                            this.createPaletteGroup(group, !this.closedGroups.has(group));
                            groupAdded.add(group);
                        }
                        if (!(node.metadata && node.metadata.noPaletteEntry)) {
                            this.createPaletteEntry(name, node);
                        }
                    }
                });
            }
        });
        this.noMacthesFoundNode = new joint$1.shapes.flo.NoMatchesFound();
        this.palette.model.addCell(this.noMacthesFoundNode);
        this.layout();
        this.paletteReady.emit(true);
        console.debug('buildPalette took ' + (new Date().getTime() - startTime) + 'ms');
    }
    layout() {
        let startTime = new Date().getTime();
        let filterText = this.filterText;
        if (filterText) {
            filterText = filterText.toLowerCase();
        }
        let paletteNodes = [];
        let parentWidth = this._paletteSize - Flo.SCROLLBAR_WIDTH;
        console.debug(`Parent Width: ${parentWidth}`);
        const presentGroups = new Set();
        this.palette.model.getCells().forEach((cell) => {
            const metadata = cell.attr('metadata');
            if (cell.get('header')) {
                paletteNodes.push(cell);
            }
            else if (metadata && metadata.group && metadata.name
                && (!filterText || metadata.group.indexOf(filterText) >= 0 || metadata.name.indexOf(filterText) >= 0)) {
                if (!this.closedGroups.has(metadata.group)) {
                    cell.attr('./display', 'block');
                    cell.removeAttr('./display');
                    paletteNodes.push(cell);
                }
                else {
                    cell.attr('./display', 'none');
                }
                presentGroups.add(metadata.group);
            }
            else {
                if (cell === this.noMacthesFoundNode) ;
                else {
                    cell.attr('./display', 'none');
                }
            }
        });
        // Clean group headers
        const filteredGroupHeaders = [];
        paletteNodes.forEach(cell => {
            if (cell.get('header')) {
                if (presentGroups.has(cell.get('header'))) {
                    cell.attr('./display', 'block');
                    cell.removeAttr('./display');
                    filteredGroupHeaders.push(cell);
                }
                else {
                    cell.attr('./display', 'none');
                }
            }
            else {
                filteredGroupHeaders.push(cell);
            }
        });
        paletteNodes = filteredGroupHeaders;
        // Check if last group is empty
        const previous = paletteNodes.length > 0 ? paletteNodes[paletteNodes.length - 1] : undefined;
        // If previous is a paletter header node as well then the previous header had no nodes under it and we can hide it and remove from paletteNodes aeeay
        if (previous && previous.get('header') && !this.closedGroups.has(previous.get('header'))) {
            paletteNodes.pop().attr('./display', 'none');
        }
        let cellWidth = 0, cellHeight = 0;
        // Determine the size of the palette entry cell (width and height)
        paletteNodes.forEach(pnode => {
            if (pnode.attr('metadata/name')) {
                const elementSize = this.palette.findViewByModel(pnode).getBBox();
                let dimension = {
                    width: elementSize.width,
                    height: elementSize.height
                };
                if (cellWidth < dimension.width) {
                    cellWidth = dimension.width;
                }
                if (cellHeight < dimension.height) {
                    cellHeight = dimension.height;
                }
            }
        });
        // Adjust the palette entry cell size with paddings.
        cellWidth += 2 * this.paletteEntryPadding.width;
        cellHeight += 2 * this.paletteEntryPadding.height;
        // Align palette entries row to be at the center
        let startX = parentWidth >= cellWidth ? (parentWidth - Math.floor(parentWidth / cellWidth) * cellWidth) / 2 : 0;
        let xpos = startX;
        let ypos = 0;
        let prevNode;
        // Layout palette entry nodes
        paletteNodes.forEach(pnode => {
            const elementSize = this.palette.findViewByModel(pnode).getBBox();
            let dimension = {
                width: elementSize.width,
                height: elementSize.height
            };
            if (pnode.get('header')) { //attributes.attrs.header) {
                // Palette entry header
                xpos = startX;
                if (ypos) {
                    ypos += this.paletteEntryPadding.height;
                }
                pnode.set('size', { width: parentWidth, height: pnode.get('size').height || 30 });
                pnode.set('position', { x: 0, y: ypos });
                ypos += dimension.height + this.paletteEntryPadding.height;
            }
            else {
                // Palette entry element
                if (xpos + cellWidth > parentWidth) {
                    // Not enough real estate to place entry in a row - reset x position and leave the y pos which is next line
                    xpos = startX;
                    pnode.set('position', { x: xpos + (cellWidth - dimension.width) / 2, y: ypos + (cellHeight - dimension.height) / 2 });
                }
                else {
                    // Enough real estate to place entry in a row - adjust y position
                    if (prevNode && prevNode.attr('metadata/name')) {
                        ypos -= cellHeight;
                    }
                    pnode.set('position', { x: xpos + (cellWidth - dimension.width) / 2, y: ypos + (cellHeight - dimension.height) / 2 });
                }
                // increment x position and y position (can be reorganized)
                xpos += cellWidth;
                ypos += cellHeight;
            }
            prevNode = pnode;
        });
        this.noMacthesFoundNode.set('size', { width: parentWidth, height: this.noMacthesFoundNode.get('size').height || 30 });
        this.noMacthesFoundNode.set('position', { x: 0, y: 0 });
        if (paletteNodes.length === 0 && filterText) {
            // There is a filter present but everything is filtered out
            // Show no matches found node
            this.noMacthesFoundNode.attr('./display', 'block');
            this.noMacthesFoundNode.removeAttr('./display');
            ypos = this.noMacthesFoundNode.get('size').height;
        }
        else {
            // Hide no matches node in all other cases
            this.noMacthesFoundNode.attr('./display', 'none');
        }
        this.palette.setDimensions(parentWidth, ypos);
        console.debug('buildPalette layout ' + (new Date().getTime() - startTime) + 'ms');
    }
    set filterText(text) {
        if (this._filterText !== text) {
            this._filterText = text;
            this.filterTextModel.next(text);
        }
    }
    get filterText() {
        return this._filterText;
    }
    getPaletteView(view) {
        let self = this;
        return view.extend({
            pointerdown: function ( /*evt, x, y*/) {
                // Remove the tooltip
                // $('.node-tooltip').remove();
                // TODO move metadata to the right place (not inside attrs I think)
                self.clickedElement = this.model;
                if (self.clickedElement && self.clickedElement.attr('metadata')) {
                    $$2(self.document).on('mousemove', self.mouseMoveHanlder);
                }
            },
            pointermove: function ( /*evt, x, y*/) {
                // Nothing to prevent move within the palette canvas
            },
        });
    }
    handleMouseUp(event) {
        $$2(this.document).off('mousemove', this.mouseMoveHanlder);
    }
    trigger(event) {
        this.onPaletteEntryDrop.emit(event);
    }
    handleDrag(event) {
        // TODO offsetX/Y not on firefox
        // console.debug("tracking move: x="+event.pageX+",y="+event.pageY);
        // console.debug('Element = ' + (this.clickedElement ? this.clickedElement.attr('metadata/name'): 'null'));
        if (this.clickedElement && this.clickedElement.attr('metadata')) {
            if (!this.viewBeingDragged) {
                let dataOfClickedElement = this.clickedElement.attr('metadata');
                // custom div if not already built.
                $$2('<div>', {
                    id: 'palette-floater'
                }).appendTo($$2('body'));
                let floatergraph = new joint$1.dia.Graph();
                floatergraph.set('type', Constants.FEEDBACK_CONTEXT);
                const parent = $$2('#palette-floater');
                this.floaterpaper = new joint$1.dia.Paper({
                    el: $$2('#palette-floater'),
                    elementView: this.renderer && this.renderer.getNodeView ? this.renderer.getNodeView() : joint$1.dia.ElementView,
                    gridSize: 10,
                    model: floatergraph,
                    height: parent.height(),
                    width: parent.width(),
                    validateMagnet: () => false,
                    validateConnection: () => false
                });
                // TODO float thing needs to be bigger otherwise icon label is missing
                // Initiative drag and drop - create draggable element
                let floaternode = Shapes.Factory.createNode({
                    'renderer': this.renderer,
                    'paper': this.floaterpaper,
                    'graph': floatergraph,
                    'metadata': dataOfClickedElement
                });
                // Only node view expected
                this.viewBeingDragged = this.floaterpaper.findViewByModel(floaternode);
                let box = this.viewBeingDragged.getBBox();
                let size = floaternode.get('size');
                parent.css('width', box.width + box.width - size.width);
                parent.css('height', box.height + box.height - size.height);
                // Account for node real size including ports
                floaternode.translate(box.width - size.width, box.height - size.height);
                parent.offset({ left: event.pageX + 5, top: event.pageY + 5 });
            }
            else {
                $$2('#palette-floater').offset({ left: event.pageX + 5, top: event.pageY + 5 });
                this.trigger({
                    type: Flo.DnDEventType.DRAG,
                    view: this.viewBeingDragged,
                    event: event
                });
            }
        }
    }
    /*
     * Modify the rotation of the arrow in the header from horizontal(closed) to vertical(open)
     */
    rotateOpen(element) {
        return new Promise(resolve => {
            setTimeout(() => this.doRotateOpen(element, 90).then(() => {
                resolve();
            }));
        });
    }
    doRotateOpen(element, angle) {
        return new Promise(resolve => {
            angle -= 10;
            element.attr({ 'path': { 'transform': 'rotate(-' + angle + ',15,13)' } });
            if (angle <= 0) {
                resolve();
            }
            else {
                setTimeout(() => this.doRotateOpen(element, angle).then(() => resolve()), 10);
            }
        });
    }
    doRotateClose(element, angle) {
        return new Promise(resolve => {
            angle += 10;
            element.attr({ 'path': { 'transform': 'rotate(-' + angle + ',15,13)' } });
            if (angle >= 90) {
                resolve();
            }
            else {
                setTimeout(() => this.doRotateClose(element, angle).then(() => resolve()), 10);
            }
        });
    }
    // TODO better name for this function as this does the animation *and* updates the palette
    /*
     * Modify the rotation of the arrow in the header from vertical(open) to horizontal(closed)
     */
    rotateClosed(element) {
        return new Promise(resolve => {
            setTimeout(() => {
                this.doRotateClose(element, 0).then(() => {
                    resolve();
                });
            });
        });
    }
};
__decorate([
    Input(),
    __metadata("design:type", Object)
], Palette.prototype, "metamodel", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], Palette.prototype, "renderer", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], Palette.prototype, "paletteEntryPadding", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], Palette.prototype, "searchFilterPlaceHolder", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], Palette.prototype, "onPaletteEntryDrop", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], Palette.prototype, "paletteReady", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], Palette.prototype, "paletteFocus", void 0);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], Palette.prototype, "paletteSize", null);
Palette = __decorate([
    Component({
        selector: 'flo-palette',
        template: `
    <div id="palette-filter" class="palette-filter">
      <label class="palette-filter-label" for="palette-filter-textfield">
        <input type="search" id="palette-filter-textfield" class="palette-filter-textfield" [(ngModel)]="filterText" (focus)="onFocus()" [placeholder]="searchFilterPlaceHolder"/>
      </label>
    </div>
    <div id="palette-paper-container">
      <div id="palette-paper" class="palette-paper" style="overflow:hidden;"></div>
    </div>
  `,
        styles: [`
    /* Joint JS paper for drawing palette -> canvas DnD visual feedback START */

    #palette-floater {
      /* TODO size relative to paper that goes on it? */
      opacity: 0.75;
      background-color: transparent;
      /*
        background-color: #6db33f;
        */
      float:left;
      position: absolute;
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
    }

    #palette-floater.joint-paper > svg {
      background-color: transparent;
    }

    #palette-paper-container {
      overflow-y: auto;
      overflow-x: hidden;
      background-color: white;
      color: white;
      height:calc(100% - 46px);
      width:100%;
    }

    /* Joint JS paper for drawing palette -> canvas DnD visual feedback END */

    /* Palette START */

    .palette-filter {
      border: 3px solid #6db33f;
      font-size:24px;
      background-color: white;
    }

    .palette-filter-textfield {
      width: 100%;
      border: none;
      /* border: 3px solid #6db33f;
     */	font-family: "Varela Round",sans-serif;
      /* 	padding: 2px; */
    }

    .palette-paper {
      background-color: #eeeeee;
      /*
        border-right: 7px solid;
        */
      border-color: #6db33f;
      /* 	width: 170px;
            height:100%;
                float: left;
         */
    }

    .no-matches-label {
      fill: #777;
      font-size: 14px;
    }

    /* Palette END */
  `],
        encapsulation: ViewEncapsulation.None
    }),
    __param(1, Inject(DOCUMENT)),
    __metadata("design:paramtypes", [ElementRef, Object])
], Palette);

const joint$2 = Flo.joint;
const $$3 = _$;
class Utils {
    static fanRoute(graph, cell) {
        if (cell instanceof joint$2.dia.Element) {
            const links = graph.getConnectedLinks(cell);
            const groupsOfOverlappingLinks = groupBy(links, (link) => {
                // the key of the group is the model id of the link's source or target, but not our cell id.
                const sourceId = link.get('source').id;
                const targetId = link.get('target').id;
                return cell.id !== sourceId ? sourceId : targetId;
            });
            each(groupsOfOverlappingLinks, (group, key) => {
                // If the member of the group has both source and target model adjust vertices.
                let toRoute = {};
                if (key !== undefined) {
                    group.forEach((link) => {
                        if (link.get('source').id === cell.get('id') && link.get('target').id) {
                            toRoute[link.get('target').id] = link;
                        }
                        else if (link.get('target').id === cell.get('id') && link.get('source').id) {
                            toRoute[link.get('source').id] = link;
                        }
                    });
                    Object.keys(toRoute).forEach(k => {
                        Utils.fanRoute(graph, toRoute[k]);
                    });
                }
            });
        }
        else if (cell instanceof joint$2.dia.Link) {
            const link = cell;
            // The cell is a link. Let's find its source and target models.
            let src = link.source() || link.previous('source');
            let trg = link.target() || cell.previous('target');
            // If one of the ends is not a model, the link has no siblings.
            if (!src.id || !trg.id) {
                return;
            }
            const siblings = graph.getLinks().filter((sibling) => {
                const _src = sibling.source();
                const _trg = sibling.target();
                const vertices = sibling.get('vertices');
                const fanRouted = !vertices || vertices.length === 0 || sibling.get('fanRouted');
                return ((isEqual(_src, src) && isEqual(_trg, trg)) || (isEqual(_src, trg) && isEqual(_trg, src))) && fanRouted;
            });
            switch (siblings.length) {
                case 0:
                    // The link was removed and had no siblings.
                    break;
                case 1:
                    // There is only one link between the source and target. No vertices needed.
                    let vertices = cell.get('vertices');
                    if (vertices && vertices.length && cell.get('fanRouted')) {
                        cell.unset('vertices');
                    }
                    break;
                default:
                    // There is more than one siblings. We need to create vertices.
                    // First of all we'll find the middle point of the link.
                    let source = link.getSourceElement();
                    let target = link.getTargetElement();
                    if (!source || !target) {
                        // When clearing the graph it may happen that some nodes are gone and some are left
                        return;
                    }
                    let srcCenter = source.getBBox().center();
                    let trgCenter = target.getBBox().center();
                    let midPoint = joint$2.g.line(srcCenter, trgCenter).midpoint();
                    // Then find the angle it forms.
                    let theta = srcCenter.theta(trgCenter);
                    // This is the maximum distance between links
                    let gap = 20;
                    siblings.forEach((sibling, index) => {
                        // We want the offset values to be calculated as follows 0, 20, 20, 40, 40, 60, 60 ..
                        let offset = gap * Math.ceil(index / 2);
                        // Now we need the vertices to be placed at points which are 'offset' pixels distant
                        // from the first link and forms a perpendicular angle to it. And as index goes up
                        // alternate left and right.
                        //
                        //  ^  odd indexes
                        //  |
                        //  |---->  index 0 line (straight line between a source center and a target center.
                        //  |
                        //  v  even indexes
                        let sign = index % 2 ? 1 : -1;
                        let angle = joint$2.g.toRad(theta + sign * 90);
                        // We found the vertex.
                        let vertex = joint$2.g.point.fromPolar(offset, angle, midPoint);
                        sibling.set('fanRouted', true);
                        sibling.set('vertices', [{ x: vertex.x, y: vertex.y }], { 'fanRouted': true });
                    });
            }
        }
    }
    static isCustomPaperEvent(args) {
        return args.length === 5 &&
            isString(args[0]) &&
            (args[0].indexOf('link:') === 0 || args[0].indexOf('element:') === 0) &&
            args[1] instanceof $$3.Event &&
            args[2] instanceof joint$2.dia.CellView &&
            isNumber(args[3]) &&
            isNumber(args[4]);
    }
}

const joint$3 = Flo.joint;
const $$4 = _$;
let EditorComponent = class EditorComponent {
    constructor(element) {
        this.element = element;
        /**
         * Flag specifying whether the Flo-Editor is in read-only mode.
         */
        this._readOnlyCanvas = false;
        /**
         * Grid size
         */
        this._gridSize = 1;
        this._hiddenPalette = false;
        this.paletteSizeValue = 170;
        this.textToGraphEventEmitter = new EventEmitter();
        this.graphToTextEventEmitter = new EventEmitter();
        this._graphToTextSyncEnabled = true;
        this.validationEventEmitter = new EventEmitter();
        this._disposables = new CompositeDisposable();
        this._dslText = '';
        this.textToGraphConversionCompleted = new Subject();
        this.graphToTextConversionCompleted = new Subject();
        this.paletteReady = new BehaviorSubject(false);
        this.paletteSizeChange = new EventEmitter();
        this.searchFilterPlaceHolder = 'Search...';
        /**
         * Min zoom percent value
         */
        this.minZoom = 5;
        /**
         * Max zoom percent value
         */
        this.maxZoom = 400;
        /**
         * Zoom percent increment/decrement step
         */
        this.zoomStep = 5;
        this.paperPadding = 0;
        this.floApi = new EventEmitter();
        this.validationMarkers = new EventEmitter();
        this.contentValidated = new EventEmitter();
        this.dslChange = new EventEmitter();
        this.onProperties = new EventEmitter();
        this._resizeHandler = () => this.autosizePaper();
        let self = this;
        this.editorContext = new (class DefaultRunnableContext {
            set zoomPercent(percent) {
                self.zoomPercent = percent;
            }
            get zoomPercent() {
                return self.zoomPercent;
            }
            set noPalette(noPalette) {
                self.noPalette = noPalette;
            }
            get noPalette() {
                return self.noPalette;
            }
            set gridSize(gridSize) {
                self.gridSize = gridSize;
            }
            get gridSize() {
                return self.gridSize;
            }
            set readOnlyCanvas(readOnly) {
                self.readOnlyCanvas = readOnly;
            }
            get readOnlyCanvas() {
                return self.readOnlyCanvas;
            }
            setDsl(dsl) {
                self.dsl = dsl;
            }
            updateGraph() {
                return self.updateGraphRepresentation();
            }
            updateText() {
                return self.updateTextRepresentation();
            }
            performLayout() {
                return self.doLayout();
            }
            clearGraph() {
                self.selection = undefined;
                self.graph.clear();
                if (self.metamodel && self.metamodel.load && self.editor && self.editor.setDefaultContent) {
                    return self.metamodel.load().then(data => {
                        self.editor.setDefaultContent(this, data);
                        if (!self.graphToTextSync) {
                            return self.updateTextRepresentation();
                        }
                    });
                }
                else {
                    if (!self.graphToTextSync) {
                        return self.updateTextRepresentation();
                    }
                }
            }
            getGraph() {
                return self.graph;
            }
            getPaper() {
                return self.paper;
            }
            get graphToTextSync() {
                return self.graphToTextSync;
            }
            set graphToTextSync(sync) {
                self.graphToTextSync = sync;
            }
            getMinZoom() {
                return self.minZoom;
            }
            getMaxZoom() {
                return self.maxZoom;
            }
            getZoomStep() {
                return self.zoomStep;
            }
            fitToPage() {
                self.fitToPage();
            }
            createNode(metadata, props, position) {
                return self.createNode(metadata, props, position);
            }
            createLink(source, target, metadata, props) {
                return self.createLink(source, target, metadata, props);
            }
            get selection() {
                return self.selection;
            }
            set selection(newSelection) {
                self.selection = newSelection;
            }
            deleteSelectedNode() {
                self.deleteSelected();
            }
            delete(cell) {
                self.delete(cell);
            }
            get textToGraphConversionObservable() {
                return self.textToGraphConversionCompleted;
            }
            get graphToTextConversionObservable() {
                return self.graphToTextConversionCompleted;
            }
            get paletteReady() {
                return self.paletteReady;
            }
        })();
    }
    /**
     * Size (Width) of the palette
     */
    get paletteSize() {
        return this.paletteSizeValue;
    }
    set paletteSize(newSize) {
        this.paletteSizeValue = newSize;
        this.paletteSizeChange.emit(newSize);
    }
    onPropertiesHandle() {
        if (this.editorContext.selection) {
            this.onProperties.emit(this.editorContext.selection.model);
        }
    }
    ngOnInit() {
        this.initGraph();
        this.initPaper();
        this.initGraphListeners();
        this.initPaperListeners();
        this.initMetamodel();
        $$4(window).on('resize', this._resizeHandler);
        this._disposables.add(Disposable.create(() => $$4(window).off('resize', this._resizeHandler)));
        /*
         * Execute resize to get the right size for the SVG element on the editor canvas.
         * Executed via timeout to let angular render the DOM first and elements to have the right width and height
         */
        window.setTimeout(this._resizeHandler);
        this.floApi.emit(this.editorContext);
    }
    ngOnDestroy() {
        this._disposables.dispose();
    }
    deleteSelected() {
        if (this.selection) {
            this.delete(this.selection.model);
        }
    }
    delete(cell) {
        this.graph.trigger('startDeletion', cell);
    }
    get noPalette() {
        return this._hiddenPalette;
    }
    set noPalette(hidden) {
        this._hiddenPalette = hidden;
        // If palette is not shown ensure that canvas starts from the left==0!
        if (hidden) {
            $$4('#paper-container', this.element.nativeElement).css('left', 0);
        }
    }
    get graphToTextSync() {
        return this._graphToTextSyncEnabled;
    }
    set graphToTextSync(sync) {
        this._graphToTextSyncEnabled = sync;
        // Try commenting the sync out. Just set the flag but don't kick off graph->text conversion
        // this.performGraphToTextSyncing();
    }
    performGraphToTextSyncing() {
        if (this._graphToTextSyncEnabled) {
            this.graphToTextEventEmitter.emit();
        }
    }
    createHandle(element, kind, action, location) {
        if (!location) {
            let bbox = element.model.getBBox();
            location = bbox.origin().offset(bbox.width / 2, bbox.height / 2);
        }
        let handle = Shapes.Factory.createHandle({
            renderer: this.renderer,
            paper: this.paper,
            parent: element.model,
            kind: kind,
            position: location
        });
        const view = this.paper.findViewByModel(handle);
        view.on('cell:pointerdown', () => {
            if (action) {
                action();
            }
        });
        view.on('cell:mouseover', () => {
            handle.attr('image/filter', {
                name: 'dropShadow',
                args: { dx: 1, dy: 1, blur: 1, color: 'black' }
            });
        });
        view.on('cell:mouseout', () => {
            handle.removeAttr('image/filter');
        });
        view.setInteractivity(false);
        return handle;
    }
    removeEmbeddedChildrenOfType(element, types) {
        let embeds = element.getEmbeddedCells();
        for (let i = 0; i < embeds.length; i++) {
            if (types.indexOf(embeds[i].get('type')) >= 0) {
                embeds[i].remove();
            }
        }
    }
    get selection() {
        return this._selection;
    }
    set selection(newSelection) {
        if (newSelection && (newSelection.model.get('type') === joint$3.shapes.flo.DECORATION_TYPE || newSelection.model.get('type') === joint$3.shapes.flo.HANDLE_TYPE)) {
            newSelection = this.paper.findViewByModel(this.graph.getCell(newSelection.model.get('parent')));
        }
        if (newSelection && (!newSelection.model.attr('metadata') || newSelection.model.attr('metadata/metadata/unselectable'))) {
            newSelection = undefined;
        }
        if (newSelection !== this._selection) {
            if (this._selection) {
                const elementview = this.paper.findViewByModel(this._selection.model);
                if (elementview) { // May have been removed from the graph
                    this.removeEmbeddedChildrenOfType(elementview.model, joint$3.shapes.flo.HANDLE_TYPE);
                    elementview.unhighlight();
                }
            }
            if (newSelection) {
                newSelection.highlight();
                if (this.editor && this.editor.createHandles) {
                    this.editor.createHandles(this.editorContext, (owner, kind, action, location) => this.createHandle(owner, kind, action, location), newSelection);
                }
            }
            this._selection = newSelection;
        }
    }
    get readOnlyCanvas() {
        return this._readOnlyCanvas;
    }
    set readOnlyCanvas(value) {
        if (this._readOnlyCanvas === value) {
            // Nothing to do
            return;
        }
        if (value) {
            this.selection = undefined;
        }
        if (this.graph) {
            this.graph.getLinks().forEach((link) => {
                if (value) {
                    link.attr('.link-tools/display', 'none');
                    link.attr('.marker-vertices/display', 'none');
                    link.attr('.connection-wrap/display', 'none');
                }
                else {
                    link.removeAttr('.link-tools/display');
                    if (this.editor && this.editor.allowLinkVertexEdit) {
                        link.removeAttr('.marker-vertices/display');
                    }
                    link.removeAttr('.connection-wrap/display');
                }
            });
        }
        this._readOnlyCanvas = value;
    }
    /**
     * Displays graphical feedback for the drag and drop in progress based on current drag and drop descriptor object
     *
     * @param dragDescriptor DnD info object. Has on info on graph node being dragged (drag source) and what it is
     * being dragged over at the moment (drop target)
     */
    showDragFeedback(dragDescriptor) {
        if (this.editor && this.editor.showDragFeedback) {
            this.editor.showDragFeedback(this.editorContext, dragDescriptor);
        }
        else {
            let magnet;
            if (dragDescriptor.source && dragDescriptor.source.view) {
                joint$3.V(dragDescriptor.source.view.el).addClass('dnd-source-feedback');
                if (dragDescriptor.source.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.source.view, dragDescriptor.source.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).addClass('dnd-source-feedback');
                    }
                }
            }
            if (dragDescriptor.target && dragDescriptor.target.view) {
                joint$3.V(dragDescriptor.target.view.el).addClass('dnd-target-feedback');
                if (dragDescriptor.target.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.target.view, dragDescriptor.target.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).addClass('dnd-target-feedback');
                    }
                }
            }
        }
    }
    /**
     * Hides graphical feedback for the drag and drop in progress based on current drag and drop descriptor object
     *
     * @param dragDescriptor DnD info object. Has on info on graph node being dragged (drag source) and what it is
     * being dragged over at the moment (drop target)
     */
    hideDragFeedback(dragDescriptor) {
        if (this.editor && this.editor.hideDragFeedback) {
            this.editor.hideDragFeedback(this.editorContext, dragDescriptor);
        }
        else {
            let magnet;
            if (dragDescriptor.source && dragDescriptor.source.view) {
                joint$3.V(dragDescriptor.source.view.el).removeClass('dnd-source-feedback');
                if (dragDescriptor.source.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.source.view, dragDescriptor.source.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).removeClass('dnd-source-feedback');
                    }
                }
            }
            if (dragDescriptor.target && dragDescriptor.target.view) {
                joint$3.V(dragDescriptor.target.view.el).removeClass('dnd-target-feedback');
                if (dragDescriptor.target.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.target.view, dragDescriptor.target.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).removeClass('dnd-target-feedback');
                    }
                }
            }
        }
    }
    /**
     * Sets the new DnD info object - the descriptor for DnD
     *
     * @param dragDescriptor DnD info object. Has on info on graph node being dragged (drag source) and what it is
     * being dragged over at the moment (drop target)
     */
    setDragDescriptor(dragDescriptor) {
        if (this.highlighted === dragDescriptor) {
            return;
        }
        if (this.highlighted && dragDescriptor && isEqual(this.highlighted.sourceComponent, dragDescriptor.sourceComponent)) {
            if (this.highlighted.source === dragDescriptor.source && this.highlighted.target === dragDescriptor.target) {
                return;
            }
            if (this.highlighted.source &&
                dragDescriptor.source &&
                this.highlighted.target &&
                dragDescriptor.target &&
                this.highlighted.source.view.model === dragDescriptor.source.view.model &&
                this.highlighted.source.cssClassSelector === dragDescriptor.source.cssClassSelector &&
                this.highlighted.target.view.model === dragDescriptor.target.view.model &&
                this.highlighted.target.cssClassSelector === dragDescriptor.target.cssClassSelector) {
                return;
            }
        }
        if (this.highlighted) {
            this.hideDragFeedback(this.highlighted);
        }
        this.highlighted = dragDescriptor;
        if (this.highlighted) {
            this.showDragFeedback(this.highlighted);
        }
    }
    /**
     * Handles DnD events when a node is being dragged over canvas
     *
     * @param draggedView The Joint JS view object being dragged
     * @param targetUnderMouse The Joint JS view under mouse cursor
     * @param x X coordinate of the mouse on the canvas
     * @param y Y coordinate of the mosue on the canvas
     * @param context DnD context (palette or canvas)
     */
    handleNodeDragging(draggedView, targetUnderMouse, x, y, sourceComponent) {
        if (this.editor && this.editor.calculateDragDescriptor) {
            this.setDragDescriptor(this.editor.calculateDragDescriptor(this.editorContext, draggedView, targetUnderMouse, joint$3.g.point(x, y), sourceComponent));
        }
    }
    /**
     * Handles DnD drop event when a node is being dragged and dropped on the main canvas
     */
    handleNodeDropping() {
        if (this.highlighted && this.editor && this.editor.handleNodeDropping) {
            this.editor.handleNodeDropping(this.editorContext, this.highlighted);
        }
        this.setDragDescriptor(undefined);
    }
    /**
     * Hides DOM Node (used to determine drop target DOM element)
     * @param domNode DOM node to hide
     * @returns
     */
    _hideNode(domNode) {
        let oldVisibility = {
            visibility: domNode.style ? domNode.style.display : undefined,
            children: []
        };
        for (let i = 0; i < domNode.children.length; i++) {
            let node = domNode.children.item(i);
            if (node instanceof HTMLElement) {
                oldVisibility.children.push(this._hideNode(node));
            }
        }
        domNode.style.display = 'none';
        return oldVisibility;
    }
    /**
     * Restored DOM node original visibility (used to determine drop target DOM element)
     * @param domNode DOM node to restore visibility of
     * @param oldVisibility original visibility parameter
     */
    _restoreNodeVisibility(domNode, oldVisibility) {
        if (domNode.style) {
            domNode.style.display = oldVisibility.visibility;
        }
        let j = 0;
        for (let i = 0; i < domNode.childNodes.length; i++) {
            if (j < oldVisibility.children.length) {
                let node = domNode.children.item(i);
                if (node instanceof HTMLElement) {
                    this._restoreNodeVisibility(node, oldVisibility.children[j++]);
                }
            }
        }
    }
    /**
     * Unfortunately we can't just use event.target because often draggable shape on the canvas overlaps the target.
     * We can easily find the element(s) at location, but only nodes :-( Unclear how to find links at location
     * (bounding box of a link for testing is bad).
     * The result of that is that links can only be the drop target when dragging from the palette currently.
     * When DnDing shapes on the canvas drop target cannot be a link.
     *
     * Excluded views enables you to choose to filter some possible answers (useful in the case where elements are stacked
     * - e.g. Drag-n-Drop)
     */
    getTargetViewFromEvent(event, x, y, excludeViews = []) {
        if (!x && !y) {
            let l = this.paper.snapToGrid({ x: event.clientX, y: event.clientY });
            x = l.x;
            y = l.y;
        }
        // TODO: See if next code paragraph is needed. Most likely it's just code executed for nothing
        // let elements = this.graph.findModelsFromPoint(joint.g.point(x, y));
        // let underMouse = elements.find(e => !_.isUndefined(excludeViews.find(x => x === this.paper.findViewByModel(e))));
        // if (underMouse) {
        //   return underMouse;
        // }
        let oldVisibility = excludeViews.map(_x => this._hideNode(_x.el));
        let targetElement = document.elementFromPoint(event.clientX, event.clientY);
        excludeViews.forEach((excluded, i) => {
            this._restoreNodeVisibility(excluded.el, oldVisibility[i]);
        });
        return this.paper.findView($$4(targetElement));
    }
    handleDnDFromPalette(dndEvent) {
        switch (dndEvent.type) {
            case Flo.DnDEventType.DRAG:
                this.handleDragFromPalette(dndEvent);
                break;
            case Flo.DnDEventType.DROP:
                this.handleDropFromPalette(dndEvent);
                break;
            default:
                break;
        }
    }
    handleDragFromPalette(dnDEvent) {
        console.debug('Dragging from palette');
        if (dnDEvent.view && !this.readOnlyCanvas) {
            let location = this.paper.snapToGrid({ x: dnDEvent.event.clientX, y: dnDEvent.event.clientY });
            this.handleNodeDragging(dnDEvent.view, this.getTargetViewFromEvent(dnDEvent.event, location.x, location.y, [dnDEvent.view]), location.x, location.y, Constants.PALETTE_CONTEXT);
        }
    }
    createNode(metadata, props, position) {
        return Shapes.Factory.createNode({
            renderer: this.renderer,
            paper: this.paper,
            metadata: metadata,
            props: props,
            position: position
        });
    }
    createLink(source, target, metadata, props) {
        return Shapes.Factory.createLink({
            renderer: this.renderer,
            paper: this.paper,
            source: source,
            target: target,
            metadata: metadata,
            props: props
        });
    }
    handleDropFromPalette(event) {
        let cellview = event.view;
        let evt = event.event;
        if (this.paper.el === evt.target || $$4.contains(this.paper.el, evt.target)) {
            if (this.readOnlyCanvas) {
                this.setDragDescriptor(undefined);
            }
            else {
                let metadata = cellview.model.attr('metadata');
                let props = cellview.model.attr('props');
                let position = this.paper.snapToGrid({ x: evt.clientX, y: evt.clientY });
                /* Calculate target element before creating the new
                 * element under mouse location. Otherwise target
                 * element would be the newly created element because
                 * it's under the mouse pointer
                 */
                let targetElement = this.getTargetViewFromEvent(evt, position.x, position.y, [event.view]);
                let newNode = this.createNode(metadata, props, position);
                let newView = this.paper.findViewByModel(newNode);
                this.handleNodeDragging(newView, targetElement, position.x, position.y, Constants.PALETTE_CONTEXT);
                this.handleNodeDropping();
            }
        }
    }
    fitToContent(gridWidth, gridHeight, padding, opt) {
        const paper = this.paper;
        if (joint$3.util.isObject(gridWidth)) {
            // first parameter is an option object
            opt = gridWidth;
            gridWidth = opt.gridWidth || 1;
            gridHeight = opt.gridHeight || 1;
            padding = opt.padding || 0;
        }
        else {
            opt = opt || {};
            gridWidth = gridWidth || 1;
            gridHeight = gridHeight || 1;
            padding = padding || 0;
        }
        const paddingJson = joint$3.util.normalizeSides(padding);
        // Calculate the paper size to accomodate all the graph's elements.
        const bbox = joint$3.V(paper.viewport).getBBox();
        const currentScale = paper.scale();
        const currentTranslate = paper.translate();
        bbox.x *= currentScale.sx;
        bbox.y *= currentScale.sy;
        bbox.width *= currentScale.sx;
        bbox.height *= currentScale.sy;
        let calcWidth = Math.max((bbox.width + bbox.x) / gridWidth, 1) * gridWidth;
        let calcHeight = Math.max((bbox.height + bbox.y) / gridHeight, 1) * gridHeight;
        let tx = 0;
        let ty = 0;
        if ((opt.allowNewOrigin === 'negative' && bbox.x < 0) || (opt.allowNewOrigin === 'positive' && bbox.x >= 0) || opt.allowNewOrigin === 'any') {
            tx = (-bbox.x / gridWidth) * gridWidth;
            tx += paddingJson.left;
        }
        else if (opt.allowNewOrigin === 'same') {
            tx = currentTranslate.tx;
        }
        calcWidth += tx;
        if ((opt.allowNewOrigin === 'negative' && bbox.y < 0) || (opt.allowNewOrigin === 'positive' && bbox.y >= 0) || opt.allowNewOrigin === 'any') {
            ty = (-bbox.y / gridHeight) * gridHeight;
            ty += paddingJson.top;
        }
        else if (opt.allowNewOrigin === 'same') {
            ty = currentTranslate.ty;
        }
        calcHeight += ty;
        calcWidth += paddingJson.right;
        calcHeight += paddingJson.bottom;
        // Make sure the resulting width and height are greater than minimum.
        calcWidth = Math.max(calcWidth, opt.minWidth || 0);
        calcHeight = Math.max(calcHeight, opt.minHeight || 0);
        // Make sure the resulting width and height are lesser than maximum.
        calcWidth = Math.min(calcWidth, opt.maxWidth || Number.MAX_VALUE);
        calcHeight = Math.min(calcHeight, opt.maxHeight || Number.MAX_VALUE);
        const dimensionChange = calcWidth !== paper.options.width || calcHeight !== paper.options.height;
        const originChange = tx !== currentTranslate.tx || ty !== currentTranslate.ty;
        // Change the dimensions only if there is a size discrepency or an origin change
        if (originChange) {
            paper.translate(tx, ty);
        }
        if (dimensionChange) {
            paper.setDimensions(calcWidth, calcHeight);
        }
    }
    autosizePaper() {
        let parent = $$4('#paper-container', this.element.nativeElement);
        const parentWidth = parent.innerWidth();
        const parentHeight = parent.innerHeight();
        this.fitToContent(this.gridSize, this.gridSize, this.paperPadding, {
            minWidth: parentWidth - Flo.SCROLLBAR_WIDTH,
            minHeight: parentHeight - Flo.SCROLLBAR_WIDTH,
            allowNewOrigin: 'same'
        });
    }
    fitToPage() {
        let parent = $$4('#paper-container', this.element.nativeElement);
        let minScale = this.minZoom / 100;
        let maxScale = 2;
        const parentWidth = parent.innerWidth();
        const parentHeight = parent.innerHeight();
        this.paper.scaleContentToFit({
            padding: this.paperPadding,
            minScaleX: minScale,
            minScaleY: minScale,
            maxScaleX: maxScale,
            maxScaleY: maxScale,
            fittingBBox: { x: 0, y: 0, width: parentWidth - Flo.SCROLLBAR_WIDTH, height: parentHeight - Flo.SCROLLBAR_WIDTH }
        });
        /**
         * Size the canvas appropriately and allow origin movement
         */
        this.fitToContent(this.gridSize, this.gridSize, this.paperPadding, {
            minWidth: parentWidth,
            minHeight: parentHeight,
            maxWidth: parentWidth,
            maxHeight: parentHeight,
            allowNewOrigin: 'any'
        });
    }
    get zoomPercent() {
        return Math.round(this.paper.scale().sx * 100);
    }
    set zoomPercent(percent) {
        if (!isNaN(percent)) {
            if (percent < this.minZoom) {
                percent = this.minZoom;
            }
            else if (percent >= this.maxZoom) {
                percent = this.maxZoom;
            }
            else {
                if (percent <= 0) {
                    percent = 0.00001;
                }
            }
            this.paper.scale(percent / 100, percent / 100);
        }
    }
    get gridSize() {
        return this._gridSize;
    }
    set gridSize(size) {
        if (!isNaN(size) && size >= 1) {
            this._gridSize = size;
            if (this.paper) {
                this.paper.setGridSize(size);
            }
        }
    }
    validateContent() {
        return new Promise(resolve => {
            if (this.editor && this.editor.validate) {
                return this.editor
                    .validate(this.graph, this.dsl, this.editorContext)
                    .then(allMarkers => {
                    this.graph.getCells()
                        .forEach((cell) => this.markElement(cell, allMarkers.has(cell.id) ? allMarkers.get(cell.id) : []));
                    this.validationMarkers.emit(allMarkers);
                    this.contentValidated.emit(true);
                    resolve();
                });
            }
            else {
                resolve();
            }
        });
    }
    markElement(cell, markers) {
        cell.set('markers', markers);
        // Old legacy code below consider removing
        let errorMessages = markers.map(m => m.message);
        let errorCell = cell.getEmbeddedCells().find((e) => e.attr('./kind') === Constants.ERROR_DECORATION_KIND);
        if (errorCell) {
            if (errorMessages.length === 0) {
                errorCell.remove();
            }
            else {
                // Without rewrite we merge this list with existing errors
                errorCell.attr('messages', errorMessages, { rewrite: true });
            }
        }
        else if (errorMessages.length > 0) {
            let error = Shapes.Factory.createDecoration({
                renderer: this.renderer,
                paper: this.paper,
                parent: cell,
                kind: Constants.ERROR_DECORATION_KIND,
                messages: errorMessages
            });
            if (error) {
                const view = this.paper.findViewByModel(error);
                view.setInteractivity(false);
            }
        }
    }
    doLayout() {
        if (this.renderer && this.renderer.layout) {
            return this.renderer.layout(this.paper);
        }
    }
    set dsl(dslText) {
        if (this._dslText !== dslText) {
            this._dslText = dslText;
            this.textToGraphEventEmitter.emit();
        }
    }
    get dsl() {
        return this._dslText;
    }
    /**
     * Ask the server to parse the supplied text into a JSON graph of nodes and links,
     * then update the view based on that new information.
     */
    updateGraphRepresentation() {
        console.debug(`Updating graph to represent '${this._dslText}'`);
        if (this.metamodel && this.metamodel.textToGraph) {
            return this.metamodel.textToGraph(this.editorContext, this._dslText).then(() => {
                this.textToGraphConversionCompleted.next();
                return this.validateContent();
            });
        }
        else {
            this.textToGraphConversionCompleted.next();
            return this.validateContent();
        }
    }
    updateTextRepresentation() {
        if (this.metamodel && this.metamodel.graphToText) {
            return this.metamodel.graphToText(this.editorContext).then(text => {
                if (this._dslText !== text) {
                    this._dslText = text;
                    this.dslChange.emit(text);
                }
                this.graphToTextConversionCompleted.next();
                return this.validateContent();
            })
                .catch(error => {
                // Validation may reveal why the graph couldn't be
                // converted so let it run
                this.graphToTextConversionCompleted.next();
                return this.validateContent();
            });
        }
        else {
            this.graphToTextConversionCompleted.next();
            return this.validateContent();
        }
    }
    initMetamodel() {
        this.metamodel.load().then(data => {
            this.updateGraphRepresentation();
            let textSyncSubscription = this.graphToTextEventEmitter.pipe(debounceTime(100)).subscribe(() => {
                if (this._graphToTextSyncEnabled) {
                    this.updateTextRepresentation();
                }
            });
            this._disposables.add(Disposable.create(() => textSyncSubscription.unsubscribe()));
            // Setup content validated event emitter. Emit not validated when graph to text conversion required
            let graphValidatedSubscription1 = this.graphToTextEventEmitter.subscribe(() => this.contentValidated.emit(false));
            this._disposables.add(Disposable.create(() => graphValidatedSubscription1.unsubscribe));
            // let validationSubscription = this.validationEventEmitter.pipe(debounceTime(100)).subscribe(() => this.validateGraph());
            // this._disposables.add(Disposable.create(() => validationSubscription.unsubscribe()));
            let graphSyncSubscription = this.textToGraphEventEmitter.pipe(debounceTime(300)).subscribe(() => this.updateGraphRepresentation());
            this._disposables.add(Disposable.create(() => graphSyncSubscription.unsubscribe()));
            // Setup content validated event emitter. Emit not validated when text to graph conversion required
            let graphValidatedSubscription2 = this.textToGraphEventEmitter.subscribe(() => this.contentValidated.emit(false));
            this._disposables.add(Disposable.create(() => graphValidatedSubscription2.unsubscribe));
            if (this.editor && this.editor.setDefaultContent) {
                this.editor.setDefaultContent(this.editorContext, data);
            }
        });
    }
    initGraph() {
        this.graph = new joint$3.dia.Graph();
        this.graph.set('type', Constants.CANVAS_CONTEXT);
        this.graph.set('paperPadding', this.paperPadding);
    }
    handleNodeCreation(node) {
        node.on('change:size', this._resizeHandler);
        node.on('change:position', this._resizeHandler);
        if (node.attr('metadata')) {
            node.on('change:attrs', (cell, attrs, changeData) => {
                let propertyPath = changeData ? changeData.propertyPath : undefined;
                if (propertyPath) {
                    let propAttr = propertyPath.substr(propertyPath.indexOf('/') + 1);
                    if (propAttr.indexOf('metadata') === 0 ||
                        propAttr.indexOf('props') === 0 ||
                        (this.renderer && this.renderer.isSemanticProperty && this.renderer.isSemanticProperty(propAttr, node))) {
                        this.performGraphToTextSyncing();
                    }
                    if (this.renderer && this.renderer.refreshVisuals) {
                        this.renderer.refreshVisuals(node, propAttr, this.paper);
                    }
                }
            });
        }
        node.on('change:markers', () => {
            if (this.renderer && this.renderer.markersChanged) {
                this.renderer.markersChanged(node, this.paper);
            }
        });
    }
    /**
     * Forwards a link event occurrence to any handlers in the editor service, if they are defined. Event examples
     * are 'change:source', 'change:target'.
     */
    handleLinkEvent(event, link) {
        if (this.renderer && this.renderer.handleLinkEvent) {
            this.renderer.handleLinkEvent(this.editorContext, event, link);
        }
    }
    handleLinkCreation(link) {
        link.on('change:source', (l) => {
            this.autosizePaper();
            let newSourceId = l.get('source').id;
            let oldSourceId = l.previous('source').id;
            if (newSourceId !== oldSourceId) {
                this.performGraphToTextSyncing();
            }
            this.handleLinkEvent('change:source', l);
        });
        link.on('change:target', (l) => {
            this.autosizePaper();
            let newTargetId = l.get('target').id;
            let oldTargetId = l.previous('target').id;
            if (newTargetId !== oldTargetId) {
                this.performGraphToTextSyncing();
            }
            this.handleLinkEvent('change:target', l);
        });
        link.on('change:vertices', this._resizeHandler);
        link.on('change:attrs', (cell, attrs, changeData) => {
            let propertyPath = changeData ? changeData.propertyPath : undefined;
            if (propertyPath) {
                let propAttr = propertyPath.substr(propertyPath.indexOf('/') + 1);
                if (propAttr.indexOf('metadata') === 0 ||
                    propAttr.indexOf('props') === 0 ||
                    (this.renderer && this.renderer.isSemanticProperty && this.renderer.isSemanticProperty(propAttr, link))) {
                    let sourceId = link.get('source').id;
                    let targetId = link.get('target').id;
                    this.performGraphToTextSyncing();
                }
                if (this.renderer && this.renderer.refreshVisuals) {
                    this.renderer.refreshVisuals(link, propAttr, this.paper);
                }
            }
        });
        this.paper.findViewByModel(link).on('link:options', () => this.handleLinkEvent('options', link));
        if (this.readOnlyCanvas) {
            link.attr('.link-tools/display', 'none');
        }
        this.handleLinkEvent('add', link);
    }
    initGraphListeners() {
        this.graph.on('add', (element) => {
            if (element instanceof joint$3.dia.Link) {
                this.handleLinkCreation(element);
            }
            else if (element instanceof joint$3.dia.Element) {
                this.handleNodeCreation(element);
            }
            if (element.get('type') === joint$3.shapes.flo.NODE_TYPE || element.get('type') === joint$3.shapes.flo.LINK_TYPE) {
                this.performGraphToTextSyncing();
            }
            this.autosizePaper();
        });
        this.graph.on('remove', (element) => {
            if (element instanceof joint$3.dia.Link) {
                this.handleLinkEvent('remove', element);
            }
            if (this.selection && this.selection.model === element) {
                this.selection = undefined;
            }
            if (element.isLink()) {
                window.setTimeout(() => this.performGraphToTextSyncing(), 100);
            }
            else if (element.get('type') === joint$3.shapes.flo.NODE_TYPE) {
                this.performGraphToTextSyncing();
            }
            this.autosizePaper();
        });
        // Set if link is fan-routed. Should be called before routing call
        this.graph.on('change:vertices', (link, changed, opt) => {
            if (opt.fanRouted) {
                link.set('fanRouted', true);
            }
            else {
                link.unset('fanRouted');
            }
        });
        // adjust vertices when a cell is removed or its source/target was changed
        this.graph.on('add remove change:source change:target change:vertices change:position', partial(Utils.fanRoute, this.graph));
        this.graph.on('startDeletion', (cell) => {
            if (this.editor && this.editor.preDelete) {
                if (this.editor.preDelete(this.editorContext, this.selection.model)) {
                    cell.remove();
                }
            }
            else {
                cell.remove();
            }
        });
    }
    initPaperListeners() {
        // https://stackoverflow.com/questions/20463533/how-to-add-an-onclick-event-to-a-joint-js-element
        this.paper.on('cell:pointerup', (cellView) => {
            if (!this.readOnlyCanvas) {
                this.selection = cellView;
            }
        });
        this.paper.on('blank:pointerdown', () => {
            this.selection = undefined;
        });
        this.paper.on('scale', this._resizeHandler);
        this.paper.on('all', function () {
            if (Utils.isCustomPaperEvent(arguments)) {
                arguments[2].trigger.apply(arguments[2], [arguments[0], arguments[1], arguments[3], arguments[4]]);
            }
        });
        this.paper.on('dragging-node-over-canvas', (dndEvent) => {
            console.debug(`Canvas DnD type = ${dndEvent.type}`);
            let location = this.paper.snapToGrid({ x: dndEvent.event.clientX, y: dndEvent.event.clientY });
            switch (dndEvent.type) {
                case Flo.DnDEventType.DRAG:
                    this.handleNodeDragging(dndEvent.view, this.getTargetViewFromEvent(dndEvent.event, location.x, location.y, [dndEvent.view]), location.x, location.y, Constants.CANVAS_CONTEXT);
                    break;
                case Flo.DnDEventType.DROP:
                    this.handleNodeDropping();
                    break;
                default:
                    break;
            }
        });
        // JointJS now no longer grabs focus if working in a paper element - crude...
        // $('#flow-view', this.element.nativeElement).on('mousedown', () => {
        // $('#palette-filter-textfield', this.element.nativeElement).focus();
        // });
    }
    initPaper() {
        let options = {
            el: $$4('#paper', this.element.nativeElement),
            gridSize: this._gridSize,
            drawGrid: true,
            model: this.graph,
            elementView: this.renderer && this.renderer.getNodeView ? this.renderer.getNodeView() : joint$3.shapes.flo.ElementView /*joint.dia.ElementView*/,
            linkView: this.renderer && this.renderer.getLinkView ? this.renderer.getLinkView() : joint$3.shapes.flo.LinkView,
            // Enable link snapping within 25px lookup radius
            snapLinks: { radius: 25 },
            defaultLink: /*this.renderer && this.renderer.createDefaultLink ? this.renderer.createDefaultLink: new joint.shapes.flo.Link*/ (cellView, magnet) => {
                if (this.renderer && this.renderer.createLink) {
                    let linkEnd = {
                        id: cellView.model.id
                    };
                    if (magnet) {
                        linkEnd.selector = cellView.getSelector(magnet, undefined);
                    }
                    if (magnet.getAttribute('port')) {
                        linkEnd.port = magnet.getAttribute('port');
                    }
                    if (magnet.getAttribute('port') === 'input') {
                        return this.renderer.createLink(undefined, linkEnd);
                    }
                    else {
                        return this.renderer.createLink(linkEnd, undefined);
                    }
                }
                else {
                    return new joint$3.shapes.flo.Link();
                }
            },
            // decide whether to create a link if the user clicks a magnet
            validateMagnet: (cellView, magnet) => {
                if (this.readOnlyCanvas) {
                    return false;
                }
                else {
                    if (this.editor && this.editor.validatePort) {
                        return this.editor.validatePort(this.editorContext, cellView, magnet);
                    }
                    else {
                        return true;
                    }
                }
            },
            interactive: (cellView, event) => {
                if (this.readOnlyCanvas) {
                    return false;
                }
                else {
                    if (this.editor && this.editor.interactive) {
                        if (typeof this.editor.interactive === 'function') {
                            // Type for interactive is wrong in JointJS have to cast to <any>
                            return this.editor.interactive(cellView, event);
                        }
                        else {
                            return this.editor.interactive;
                        }
                    }
                    return true;
                }
            },
            highlighting: this.editor && this.editor.highlighting ? this.editor.highlighting : {
                'default': {
                    name: 'addClass',
                    options: {
                        className: 'highlighted'
                    }
                }
            },
            markAvailable: true
        };
        if (this.renderer && this.renderer.getLinkAnchorPoint) {
            options.linkConnectionPoint = this.renderer.getLinkAnchorPoint;
        }
        if (this.editor && this.editor.validateLink) {
            const self = this;
            options.validateConnection = (cellViewS, magnetS, cellViewT, magnetT, end, linkView) => self.editor.validateLink(this.editorContext, cellViewS, magnetS, cellViewT, magnetT, end === 'source', linkView);
        }
        // The paper is what will represent the graph on the screen
        this.paper = new joint$3.dia.Paper(options);
        this._disposables.add(Disposable.create(() => this.paper.remove()));
        this.paper.options.highlighterNamespace['addParentClass'] = {
            /**
             * @param {joint.dia.CellView} cellView
             * @param {Element} magnetEl
             * @param {object=} opt
             */
            highlight(cellView, magnetEl, opt) {
                opt = opt || {};
                const className = opt.className || this.className;
                joint$3.V(magnetEl.parentElement).addClass(className);
            },
            /**
             * @param {joint.dia.CellView} cellView
             * @param {Element} magnetEl
             * @param {object=} opt
             */
            unhighlight(cellView, magnetEl, opt) {
                opt = opt || {};
                const className = opt.className || this.className;
                joint$3.V(magnetEl.parentElement).removeClass(className);
            }
        };
    }
    updatePaletteReadyState(ready) {
        this.paletteReady.next(ready);
    }
};
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "metamodel", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "renderer", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "editor", void 0);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], EditorComponent.prototype, "paletteSize", null);
__decorate([
    Output(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "paletteSizeChange", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "searchFilterPlaceHolder", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "paletteEntryPadding", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "minZoom", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "maxZoom", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "zoomStep", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "paperPadding", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "floApi", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "validationMarkers", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "contentValidated", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "dslChange", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], EditorComponent.prototype, "onProperties", void 0);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], EditorComponent.prototype, "dsl", null);
EditorComponent = __decorate([
    Component({
        selector: 'flo-editor',
        template: `
    <ng-content select="[header]"></ng-content>
    <div id="flow-view" class="flow-view" style="position:relative">
      <div id="canvas" class="canvas" style="position:relative; display: block; width: 100%; height: 100%;">
        <div *ngIf="!noPalette" id="palette-container" class="palette-container" style="overflow:hidden;">
          <flo-palette [metamodel]="metamodel" [renderer]="renderer" [paletteSize]="paletteSize"
                       [paletteEntryPadding]="paletteEntryPadding || {width: 12, height: 12}"
                       (onPaletteEntryDrop)="handleDnDFromPalette($event)"
                        (paletteReady)="updatePaletteReadyState($event)"
                        (paletteFocus)="graphToTextSync=true"
                        [searchFilterPlaceHolder]="searchFilterPlaceHolder">
          </flo-palette>
        </div>

        <div id="sidebar-resizer" *ngIf="!noPalette"
          resizer
          [splitSize]="paletteSize"
          (sizeChange)="paletteSize = $event"
          [resizerWidth]="6"
          [resizerLeft]="'#palette-container'"
          [resizerRight]="'#paper-container'">
        </div>

          <flo-editor-paper tabindex="0" (onDelete)="deleteSelected()" (onBlur)="selection = null"
                            (onProperties)="onPropertiesHandle()">
            <div id="paper" class="paper" tabindex="0" style="overflow: hidden; position: absolute; display: block; height:100%; width:100%; overflow:auto;"></div>
            <ng-content select="[canvas]"></ng-content>
          </flo-editor-paper>

          <span class="canvas-controls-container" ng-if="canvasControls">
            <table ng-if="canvasControls.zoom" class="canvas-control zoom-canvas-control">
              <tbody>
                <tr>
                  <td>
                    <input class="zoom-canvas-input canvas-control zoom-canvas-control" type="text"
                           data-inline="true" [(ngModel)]="zoomPercent"
                           size="3">
                  </td>
                  <td>
                    <label class="canvas-control zoom-canvas-label">%</label>
                  </td>
                  <td>
                    <input type="range" data-inline="true" [(ngModel)]="zoomPercent"
                           [step]="zoomStep"
                           [max]="maxZoom" [min]="minZoom" data-type="range"
                           name="range" class="canvas-control zoom-canvas-control">
                  </td>
                </tr>
              </tbody>
            </table>
          </span>

      </div>
    </div>
    <ng-content select="[footer]"></ng-content>
  `,
        styles: [`
    flo-view {
      width:100%;
      height:100%;
      margin: 0;
      background-color: #eeeeee;
      font-family: "Varela Round",sans-serif;
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
    }

    .canvas {
      border: 1px solid;
      border-color: #6db33f;
      border-radius: 2px;
      margin-top: 3px;
    }

    /* Canvas contains the palette on the left and the paper on the right */

    .paper {
      padding: 0px;
      background-color: #ffffff;
      /* 	height: 100%;
          width: 100%;
          position: relative;
          overflow: hidden;
       *//* 	margin-left: 400px; */
    }

    #sidebar-resizer {
      background-color: #34302d;
      position: absolute;
      top: 0;
      bottom: 0;
      width: 6px;
      cursor: e-resize;
    }

    #palette-container {
      background-color: #EEE;
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      overflow: auto;
    }

    #paper-container {
      position: absolute;
      top: 0;
      bottom: 0;
      right: 0;
      overflow: auto;
      color: #FFF;
      background-color: #FFF;
      outline: none;
    }

    /* Tooltip START */

    .node-tooltip .tooltip-description {
      margin-top: 5px;
      margin-left: 0px;
      margin-bottom: 5px;
    }

    .node-tooltip {
      display:none;
      position:absolute;
      border:1px solid #333;
      background-color:#34302d;/*#161616;*/
      border-radius:5px;
      padding:5px;
      color:#fff;
      /*	font-size:12px Arial;*/
      font-family: "Varela Round",sans-serif;
      font-size: 19px;
      z-index: 100;
    }

    .tooltip-title-type {
      font-size: 24px;
      font-weight: bold;
    }

    .tooltip-title-group {
      padding-left: 5px;
      font-size: 20px;
      font-style: italic;
    }

    .node-tooltip-option-name {
      font-family: monospace;/*"Varela Round",sans-serif;*/
      font-size: 17px;
      font-weight: bold;
      padding-right: 20px;

    }

    .node-tooltip-option-description {
      font-family: "Varela Round",sans-serif;
      font-size: 18px;
    }

    /* Tooltip END */


    /* Validation Error Marker on Canvas START */

    .error-tooltip p {
      margin-top: 5px;
      margin-left: 0px;
      margin-bottom: 5px;
      color:#fff;
    }
    .error-tooltip {
      display:none;
      position:absolute;
      border:1px solid #333;
      background-color:red;/*#161616;*/
      border-radius:5px;
      padding:5px;
      color:#fff;
      /*	font-size:12px Arial;*/
      font-family: "Varela Round",sans-serif;
      font-size: 20px;
      z-index: 100;
    }

    /* Validation Error Marker on Canvas END */

    /* Controls on Canvas START */

    .canvas-controls-container {
      position: absolute;
      right: 15px;
      top: 5px;
    }

    .canvas-control {
      background: transparent;
      font-family: "Varela Round",sans-serif;
      font-size: 11px;
      vertical-align: middle;
      margin: 0px;
    }

    .zoom-canvas-control {
      border: 0px;
      padding: 0px;
      margin: 0px;
      outline: none;
    }

    .zoom-canvas-input {
      text-align: right;
      font-weight:bold;
      color: black;
      background-color: transparent;
    }

    .zoom-canvas-label {
      padding-right: 4px;
      color: black;
    }

    /* Controls on Canvas END */




    /* START - FLO CANVAS STYLES - override joint js styles */

    .highlighted {
      outline: none;
    }

    .joint-type-handle {
      cursor: pointer;
    }

    .available-magnet {
      stroke-width: 3;
    }

    .link {
      fill: none;
      stroke: #ccc;
      stroke-width: 1.5px;
    }

    .link-tools .tool-options {
      display: none;       /* by default, we don't display link options tool */
    }

    /* Make transparent the circle around the link-tools (cog) icon. It'll allow shape to have a circle clicking area */
    .link-tools .tool-options circle {
      fill: transparent;
      stroke: transparent;
    }

    .link-tools .tool-options path {
      fill: black;
      stroke: black;
    }

    .link-tools .tool-remove circle {
      fill: red;
      stroke: red;
    }

    .link-tools .tool-remove path {
      fill: white;
      stroke: white;
    }

    .link-tools-container {
      stroke-width: 0;
      fill: transparent;
    }

    /* END - FLO CANVAS STYLES */
  `],
        encapsulation: ViewEncapsulation.None
    }),
    __metadata("design:paramtypes", [ElementRef])
], EditorComponent);

const $$5 = _$;
let ResizerDirective = class ResizerDirective {
    constructor(element, document) {
        this.element = element;
        this.document = document;
        this.dragInProgress = false;
        this.vertical = true;
        this._subscriptions = new CompositeDisposable();
        this.sizeChange = new EventEmitter();
        this.mouseMoveHandler = (e) => {
            if (this.dragInProgress) {
                this.mousemove(e);
            }
        };
    }
    set splitSize(splitSize) {
        if (this.maxSplitSize && splitSize > this.maxSplitSize) {
            splitSize = this.maxSplitSize;
        }
        if (this.vertical) {
            // Handle vertical resizer
            $$5(this.element.nativeElement).css({
                left: splitSize + 'px'
            });
            $$5(this.first).css({
                width: splitSize + 'px'
            });
            $$5(this.second).css({
                left: (splitSize + this._size) + 'px'
            });
        }
        else {
            // Handle horizontal resizer
            $$5(this.element.nativeElement).css({
                bottom: splitSize + 'px'
            });
            $$5(this.first).css({
                bottom: (splitSize + this._size) + 'px'
            });
            $$5(this.second).css({
                height: splitSize + 'px'
            });
        }
        this._splitSize = splitSize;
        // Update the local field
        this.sizeChange.emit(splitSize);
    }
    set resizerWidth(width) {
        this._size = width;
        this.vertical = true;
    }
    set resizerHeight(height) {
        this._size = height;
        this.vertical = false;
    }
    set resizerLeft(first) {
        this.first = first;
    }
    set resizerTop(first) {
        this.first = first;
    }
    set resizerRight(second) {
        this.second = second;
    }
    set resizerBottom(second) {
        this.second = second;
    }
    startDrag() {
        this.dragInProgress = true;
    }
    mousemove(event) {
        let size;
        if (this.vertical) { // Handle vertical resizer. Calculate new size relative to palette container DOM node
            size = event.pageX - $$5(this.first).offset().left;
        }
        else {
            // Handle horizontal resizer Calculate new size relative to palette container DOM node
            size = window.innerHeight - event.pageY - $$5(this.second).offset().top;
        }
        this.splitSize = size;
    }
    ngOnInit() {
        // Need to set left and right elements width and fire events on init when DOM is built
        this.splitSize = this._splitSize;
        let subscription1 = fromEvent($$5(this.document).get(0), 'mousemove')
            .pipe(sampleTime(300))
            .subscribe(this.mouseMoveHandler);
        this._subscriptions.add(Disposable.create(() => subscription1.unsubscribe()));
        let subscription2 = fromEvent($$5(this.document).get(0), 'mouseup')
            .subscribe(e => {
            if (this.dragInProgress) {
                this.mousemove(e);
                this.dragInProgress = false;
            }
        });
        this._subscriptions.add(Disposable.create(() => subscription2.unsubscribe()));
    }
    ngOnDestroy() {
        this._subscriptions.dispose();
    }
};
__decorate([
    Input(),
    __metadata("design:type", Number)
], ResizerDirective.prototype, "maxSplitSize", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], ResizerDirective.prototype, "sizeChange", void 0);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], ResizerDirective.prototype, "splitSize", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], ResizerDirective.prototype, "resizerWidth", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], ResizerDirective.prototype, "resizerHeight", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], ResizerDirective.prototype, "resizerLeft", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], ResizerDirective.prototype, "resizerTop", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], ResizerDirective.prototype, "resizerRight", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], ResizerDirective.prototype, "resizerBottom", null);
ResizerDirective = __decorate([
    Directive({
        selector: '[resizer]',
        host: { '(mousedown)': 'startDrag()' }
    }),
    __param(1, Inject(DOCUMENT)),
    __metadata("design:paramtypes", [ElementRef, Object])
], ResizerDirective);

const $$6 = _$;
let DslEditorComponent = class DslEditorComponent {
    constructor(element) {
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.debounce = 0;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = () => {
            this._dsl = this.doc.getValue();
            this.dslChange.emit(this._dsl);
        };
    }
    set dsl(dsl) {
        this._dsl = dsl;
        if (this.doc && this._dsl !== this.doc.getValue()) {
            let cursorPosition = this.doc.getCursor();
            this.doc.setValue(this._dsl || '');
            this.doc.setCursor(cursorPosition);
        }
    }
    set lintOptions(lintOptions) {
        this._lint = lintOptions;
        if (this.doc) {
            this.doc.setOption('lint', this._lint);
        }
    }
    set hintOptions(hintOptions) {
        this._hint = hintOptions;
        if (this.doc) {
            this.doc.setOption('hintOptions', this._hint);
        }
    }
    ngOnInit() {
        let options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            electricChars: false,
            smartIndent: false,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        if (this._hint) {
            options.hintOptions = this._hint;
        }
        this.doc = fromTextArea($$6('#dsl-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this.debounce ? debounce(this._dslChangedHandler, this.debounce) : this._dslChangedHandler);
        this.doc.on('focus', () => this.focus.emit());
        this.doc.on('blur', () => this.blur.emit());
        this.editor.emit(this.doc);
    }
    ngOnDestroy() {
    }
};
__decorate([
    Input('line-numbers'),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "lineNumbers", void 0);
__decorate([
    Input('line-wrapping'),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "lineWrapping", void 0);
__decorate([
    Input('scrollbar-style'),
    __metadata("design:type", String)
], DslEditorComponent.prototype, "scrollbarStyle", void 0);
__decorate([
    Input(),
    __metadata("design:type", String)
], DslEditorComponent.prototype, "placeholder", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "debounce", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "dslChange", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "focus", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "blur", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], DslEditorComponent.prototype, "editor", void 0);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], DslEditorComponent.prototype, "dsl", null);
__decorate([
    Input(),
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [Object])
], DslEditorComponent.prototype, "lintOptions", null);
__decorate([
    Input(),
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [Object])
], DslEditorComponent.prototype, "hintOptions", null);
DslEditorComponent = __decorate([
    Component({
        selector: 'dsl-editor',
        template: `
    <textarea id="dsl-editor-host"></textarea>
  `,
        styles: [`
    /* Code Mirror related styles START */

    .CodeMirror {
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
      height: 100%;
    }
    .CodeMirror-hint {
      max-width: 38em;
    }
    .CodeMirror-vertical-ruler-error {
      background-color: rgba(188, 0, 0, 0.5);
    }
    .CodeMirror-vertical-ruler-warning {
      background-color: rgba(255, 188, 0, 0.5);
    }


    /* Code Mirror related styles END */
  `],
        encapsulation: ViewEncapsulation.None
    }),
    __metadata("design:paramtypes", [ElementRef])
], DslEditorComponent);

var CodeEditorComponent_1;
const $$7 = _$;
// Lint support
// Unclear how to import this dynamically...
// import 'codemirror-minified/addon/lint/javascript-lint';
// import 'codemirror-minified/addon/lint/json-lint';
// import 'codemirror-minified/addon/lint/yaml-lint';
// TODO: use dynamic import with JS7 in the future. CM autoLoad cannot load it properly - thinks its AMD
// Supported languages until dynamic loading
// import 'codemirror-minified/mode/groovy/groovy';
// import 'codemirror-minified/mode/javascript/javascript';
// import 'codemirror-minified/mode/python/python';
// import 'codemirror-minified/mode/ruby/ruby';
// import 'codemirror-minified/mode/clike/clike';
// import 'codemirror-minified/mode/yaml/yaml';
let CodeEditorComponent = CodeEditorComponent_1 = class CodeEditorComponent {
    constructor(element) {
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = () => {
            this._dsl = this.doc.getValue();
            this.dslChange.emit(this._dsl);
            if (this._onChangeHandler) {
                this._onChangeHandler(this._dsl);
            }
        };
    }
    set dsl(dsl) {
        this._dsl = dsl;
        if (this.doc && this._dsl !== this.doc.getValue()) {
            let cursorPosition = this.doc.getCursor();
            this.doc.setValue(this._dsl || '');
            this.doc.setCursor(cursorPosition);
        }
    }
    set language(_language) {
        if (this._language !== _language) {
            this._language = _language;
            this.loadEditorMode();
        }
    }
    ngOnInit() {
        let options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            matchBrackets: true,
            autoCloseBrackets: true,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        this.doc = fromTextArea($$7('#code-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this._dslChangedHandler);
        this.doc.on('focus', () => {
            this.focus.emit();
            if (this._onTouchHandler) {
                this._onTouchHandler();
            }
        });
        this.doc.on('blur', () => this.blur.emit());
        this.warningRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-warning');
        this.errorRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-error');
        this.loadEditorMode();
        this.editor.emit(this.doc);
    }
    loadEditorMode() {
        // CodeMirror doc object must be initialized
        if (!this.doc) {
            return;
        }
        const info = this._language ? findModeByName(this._language) : undefined;
        // Set proper editor mode
        if (info) {
            this.doc.setOption('mode', info.mime);
            // (<any>CodeMirror).autoLoadMode(this.doc, info.mode);
        }
        else {
            this.doc.setOption('mode', 'text/plain');
        }
        // Set proper Lint mode
        this.doc.setOption('lint', this.getLintOptions());
    }
    ngOnDestroy() {
    }
    writeValue(obj) {
        this.dsl = obj;
    }
    registerOnChange(fn) {
        this._onChangeHandler = fn;
    }
    registerOnTouched(fn) {
        this._onTouchHandler = fn;
    }
    getLintOptions() {
        switch (this._language) {
            case 'javascript':
            case 'json':
            case 'coffeescript':
            case 'yaml':
                return {
                    onUpdateLinting: (annotations) => {
                        const warnings = [];
                        const errors = [];
                        if (this.overviewRuler) {
                            if (Array.isArray(annotations)) {
                                annotations.forEach((a) => {
                                    if (a.to && a.from && a.from.line >= 0 && a.from.ch >= 0 && a.to.line >= a.from.line && a.from.ch >= 0) {
                                        if (a.severity === 'error') {
                                            errors.push(a);
                                        }
                                        else if (a.severity === 'warning') {
                                            warnings.push(a);
                                        }
                                    }
                                });
                            }
                        }
                        this.warningRuler.update(warnings);
                        this.errorRuler.update(errors);
                    }
                };
        }
        return false;
    }
};
__decorate([
    Input('line-numbers'),
    __metadata("design:type", Object)
], CodeEditorComponent.prototype, "lineNumbers", void 0);
__decorate([
    Input('line-wrapping'),
    __metadata("design:type", Object)
], CodeEditorComponent.prototype, "lineWrapping", void 0);
__decorate([
    Input('scrollbar-style'),
    __metadata("design:type", String)
], CodeEditorComponent.prototype, "scrollbarStyle", void 0);
__decorate([
    Input(),
    __metadata("design:type", String)
], CodeEditorComponent.prototype, "placeholder", void 0);
__decorate([
    Input('overview-ruler'),
    __metadata("design:type", Boolean)
], CodeEditorComponent.prototype, "overviewRuler", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], CodeEditorComponent.prototype, "dslChange", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], CodeEditorComponent.prototype, "focus", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], CodeEditorComponent.prototype, "blur", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], CodeEditorComponent.prototype, "editor", void 0);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CodeEditorComponent.prototype, "dsl", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CodeEditorComponent.prototype, "language", null);
CodeEditorComponent = CodeEditorComponent_1 = __decorate([
    Component({
        selector: 'code-editor',
        template: `
    <div class="code-editor-host">
      <textarea id="code-editor-host"></textarea>
    </div>
  `,
        styles: [`
    .CodeMirror {
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
      height: 100%;
    }
    .CodeMirror-hint {
      max-width: 38em;
    }
    .CodeMirror-vertical-ruler-error {
      background-color: rgba(188, 0, 0, 0.5);
    }
    .CodeMirror-vertical-ruler-warning {
      background-color: rgba(255, 188, 0, 0.5);
    }
    .CodeMirror-lint-tooltip {
      z-index: 2000;
    }
  `],
        encapsulation: ViewEncapsulation.None,
        providers: [
            {
                provide: NG_VALUE_ACCESSOR,
                useExisting: forwardRef(() => CodeEditorComponent_1),
                multi: true
            }
        ]
    }),
    __metadata("design:paramtypes", [ElementRef])
], CodeEditorComponent);

var Properties;
(function (Properties) {
    let InputType;
    (function (InputType) {
        InputType[InputType["TEXT"] = 0] = "TEXT";
        InputType[InputType["NUMBER"] = 1] = "NUMBER";
        InputType[InputType["SELECT"] = 2] = "SELECT";
        InputType[InputType["CHECKBOX"] = 3] = "CHECKBOX";
        InputType[InputType["PASSWORD"] = 4] = "PASSWORD";
        InputType[InputType["EMAIL"] = 5] = "EMAIL";
        InputType[InputType["URL"] = 6] = "URL";
        InputType[InputType["CODE"] = 7] = "CODE";
    })(InputType = Properties.InputType || (Properties.InputType = {}));
    class GenericControlModel {
        constructor(_property, type, validation) {
            this._property = _property;
            this.type = type;
            this.validation = validation;
        }
        get id() {
            return this.property.id;
        }
        get name() {
            return this.property.name;
        }
        get description() {
            return this.property.description;
        }
        get defaultValue() {
            return this.property.defaultValue;
        }
        get value() {
            return this.getValue();
        }
        set value(value) {
            this.setValue(value);
        }
        get property() {
            return this._property;
        }
        setValue(value) {
            this.property.value = value;
        }
        getValue() {
            return this.property.value;
        }
    }
    Properties.GenericControlModel = GenericControlModel;
    class CheckBoxControlModel extends GenericControlModel {
        constructor(_property, validation) {
            super(_property, InputType.CHECKBOX, validation);
        }
        getValue() {
            const res = super.getValue();
            const type = typeof res;
            switch (type) {
                case 'boolean':
                    return res;
                case 'string':
                    switch (res.trim().toLowerCase()) {
                        case 'true':
                        case '1':
                            return true;
                        case 'false':
                        case '0':
                            return false;
                        default:
                            return this.property.defaultValue;
                    }
                case 'number':
                    const num = res;
                    if (num === 0) {
                        return false;
                    }
                    else if (num === 1) {
                        return true;
                    }
                    else {
                        return this.property.defaultValue;
                    }
            }
            return this.property.defaultValue;
        }
    }
    Properties.CheckBoxControlModel = CheckBoxControlModel;
    class AbstractCodeControlModel extends GenericControlModel {
        constructor(_property, encode, decode, validation) {
            super(_property, InputType.CODE, validation);
            this.encode = encode;
            this.decode = decode;
        }
        set value(value) {
            if (value && this.encode) {
                super.setValue(this.encode(value));
            }
            else {
                super.setValue(value);
            }
        }
        get value() {
            let dsl = super.getValue();
            if (dsl && this.decode) {
                return this.decode(dsl);
            }
            else {
                return dsl;
            }
        }
    }
    Properties.AbstractCodeControlModel = AbstractCodeControlModel;
    class GenericCodeControlModel extends AbstractCodeControlModel {
        constructor(_property, language, encode, decode, validation) {
            super(_property, encode, decode, validation);
            this.language = language;
        }
    }
    Properties.GenericCodeControlModel = GenericCodeControlModel;
    class CodeControlModelWithDynamicLanguageProperty extends AbstractCodeControlModel {
        constructor(_property, _languagePropertyName, _groupModel, encode, decode, validation) {
            super(_property, encode, decode, validation);
            this._languagePropertyName = _languagePropertyName;
            this._groupModel = _groupModel;
        }
        get language() {
            const value = this.languageControlModel.value;
            return value ? value : this.languageControlModel.defaultValue;
        }
        get languageControlModel() {
            if (!this._langControlModel) {
                // Cast to Properties.ControlModel<any> from Properties.ControlModel<any> | undefined
                // Should not be undefined!
                this._langControlModel = this._groupModel.getControlsModels().find(c => c.id === this._languagePropertyName);
            }
            return this._langControlModel;
        }
    }
    Properties.CodeControlModelWithDynamicLanguageProperty = CodeControlModelWithDynamicLanguageProperty;
    class GenericListControlModel extends GenericControlModel {
        constructor(property, validation) {
            super(property, InputType.TEXT, validation);
        }
        get value() {
            return this.property.value ? this.property.value.toString().trim().split(/\s*,\s*/).join(', ') : '';
        }
        set value(value) {
            this.property.value = value && value.trim() ? value.split(/\s*,\s*/).join(',') : undefined;
        }
    }
    Properties.GenericListControlModel = GenericListControlModel;
    class SelectControlModel extends GenericControlModel {
        constructor(_property, type, options) {
            super(_property, type);
            this.options = options;
            if (_property.defaultValue === undefined) {
                options.unshift({
                    name: 'SELECT',
                    value: _property.defaultValue
                });
            }
        }
    }
    Properties.SelectControlModel = SelectControlModel;
    class DefaultCellPropertiesSource {
        constructor(cell) {
            this.cell = cell;
        }
        getProperties() {
            let metadata = this.cell.attr('metadata');
            return Promise.resolve(metadata.properties().then(propsMetadata => Array.from(propsMetadata.values()).map(m => this.createProperty(m))));
        }
        createProperty(metadata) {
            return {
                id: metadata.id,
                name: metadata.name,
                type: metadata.type,
                defaultValue: metadata.defaultValue,
                attr: `props/${metadata.name}`,
                value: this.cell.attr(`props/${metadata.name}`),
                description: metadata.description,
                valueOptions: metadata.options
            };
        }
        applyChanges(properties) {
            this.cell.trigger('batch:start', { batchName: 'update properties' });
            properties.forEach(property => {
                if ((typeof property.value === 'boolean' && !property.defaultValue && !property.value) ||
                    (property.value === property.defaultValue || property.value === '' || property.value === undefined || property.value === null)) {
                    let currentValue = this.cell.attr(property.attr);
                    if (currentValue !== undefined && currentValue !== null) {
                        // Remove attr doesn't fire appropriate event. Set default value first as a workaround to schedule DSL resync
                        this.cell.attr(property.attr, property.defaultValue === undefined ? null : property.defaultValue);
                        this.cell.removeAttr(property.attr);
                    }
                }
                else {
                    this.cell.attr(property.attr, property.value);
                }
            });
            this.cell.trigger('batch:stop', { batchName: 'update properties' });
        }
    }
    Properties.DefaultCellPropertiesSource = DefaultCellPropertiesSource;
    class PropertiesGroupModel {
        constructor(propertiesSource) {
            this.loading = true;
            this.propertiesSource = propertiesSource;
        }
        load() {
            this.loading = true;
            this._loadedSubject = new Subject();
            this.propertiesSource.getProperties().then(properties => {
                this.controlModels = properties.map(p => this.createControlModel(p));
                this.loading = false;
                this._loadedSubject.next(true);
                this._loadedSubject.complete();
            });
        }
        get isLoading() {
            return this.loading;
        }
        get loadedSubject() {
            return this._loadedSubject;
        }
        getControlsModels() {
            return this.controlModels;
        }
        createControlModel(property) {
            return new GenericControlModel(property, InputType.TEXT);
        }
        applyChanges() {
            if (this.loading) {
                return;
            }
            let properties = this.controlModels.map(cm => cm.property);
            this.propertiesSource.applyChanges(properties);
        }
    }
    Properties.PropertiesGroupModel = PropertiesGroupModel;
    const UNIQUE_RESOURCE_ERROR = { uniqueResource: true };
    let Validators;
    (function (Validators) {
        function uniqueResource(service, debounceDuration) {
            return (control) => {
                return new Observable(obs => {
                    if (control.valueChanges) {
                        return control.valueChanges.pipe(debounceTime(debounceDuration), switchMap(() => service(control.value))).subscribe((res) => {
                            if (res) {
                                obs.next(undefined);
                            }
                            else {
                                obs.next(UNIQUE_RESOURCE_ERROR);
                            }
                            obs.complete();
                        }, () => {
                            obs.next(UNIQUE_RESOURCE_ERROR);
                            obs.complete();
                        });
                    }
                    else {
                        service(control.value).subscribe((res) => {
                            if (res) {
                                obs.next(undefined);
                            }
                            else {
                                obs.next(UNIQUE_RESOURCE_ERROR);
                            }
                            obs.complete();
                        }, () => {
                            obs.next(UNIQUE_RESOURCE_ERROR);
                            obs.complete();
                        });
                    }
                });
            };
        }
        Validators.uniqueResource = uniqueResource;
        function noneOf(excluded) {
            return (control) => {
                return excluded.find(e => e === control.value) ? { 'noneOf': { value: control.value } } : {};
            };
        }
        Validators.noneOf = noneOf;
    })(Validators = Properties.Validators || (Properties.Validators = {}));
})(Properties || (Properties = {}));

let PropertiesGroupComponent = class PropertiesGroupComponent {
    ngOnInit() {
        if (this.propertiesGroupModel.isLoading) {
            let subscription = this.propertiesGroupModel.loadedSubject.subscribe(loaded => {
                if (loaded) {
                    subscription.unsubscribe();
                    this.createGroupControls();
                }
            });
        }
        else {
            this.createGroupControls();
        }
    }
    createGroupControls() {
        this.propertiesGroupModel.getControlsModels().forEach(c => {
            if (c.validation) {
                this.form.addControl(c.id, new FormControl(c.value || '', c.validation.validator, c.validation.asyncValidator));
            }
            else {
                this.form.addControl(c.id, new FormControl(c.value || ''));
            }
        });
    }
    get controlModelsToDisplay() {
        return this.propertiesGroupModel.getControlsModels().filter(c => !this.filter || this.filter.accept(c.property));
    }
};
__decorate([
    Input(),
    __metadata("design:type", Properties.PropertiesGroupModel)
], PropertiesGroupComponent.prototype, "propertiesGroupModel", void 0);
__decorate([
    Input(),
    __metadata("design:type", FormGroup)
], PropertiesGroupComponent.prototype, "form", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object)
], PropertiesGroupComponent.prototype, "filter", void 0);
PropertiesGroupComponent = __decorate([
    Component({
        selector: 'properties-group',
        template: `
    <div *ngIf="propertiesGroupModel && !propertiesGroupModel.isLoading" class="properties-group-container"
         [formGroup]="form">
      <div
        *ngIf="propertiesGroupModel.getControlsModels().length > 0 && controlModelsToDisplay.length === 0; else propertiesList"
        class="no-matches-label">No results found.
      </div>
    </div>

    <ng-template #propertiesList>
      <df-property *ngFor="let model of controlModelsToDisplay" [model]="model" [form]="form"
                   class="property-row"></df-property>
    </ng-template>
  `,
        encapsulation: ViewEncapsulation.None
    })
], PropertiesGroupComponent);

let DynamicFormPropertyComponent = class DynamicFormPropertyComponent {
    constructor() { }
    get types() {
        return Properties.InputType;
    }
    get control() {
        return this.form.controls[this.model.id];
    }
    get errorData() {
        return (this.model.validation && this.model.validation.errorData ? this.model.validation.errorData : [])
            .filter(e => this.control.errors && this.control.errors[e.id]);
    }
};
__decorate([
    Input(),
    __metadata("design:type", Object)
], DynamicFormPropertyComponent.prototype, "model", void 0);
__decorate([
    Input(),
    __metadata("design:type", FormGroup)
], DynamicFormPropertyComponent.prototype, "form", void 0);
DynamicFormPropertyComponent = __decorate([
    Component({
        selector: 'df-property',
        template: `
    <tr [formGroup]="form" class="df-property-row" [ngClass]="{'invalid-property-value': control.invalid}">

      <td class="df-property-label-cell">
        <label [attr.for]="model.id" class="df-form-label">{{model.name}}</label>
      </td>

      <td class="df-property-control-cell">
        <div [ngSwitch]="model.type" class="df-property-container">

          <label *ngSwitchCase="types.CHECKBOX" class="df-property-control">
            <input type="checkbox" [id]="model.id" [(ngModel)]="model.value" [formControlName]="model.id">
            {{model.value ? 'True' : 'False' }}
          </label>

          <input *ngSwitchCase="types.NUMBER" class="df-property-control" type="number" [id]="model.id"
                 [formControlName]="model.id" [placeholder]="model.defaultValue || ''" [(ngModel)]="model.value">

          <input *ngSwitchCase="types.PASSWORD" class="df-property-control" type="password" [id]="model.id"
                 [formControlName]="model.id" [placeholder]="model.defaultValue || ''" [(ngModel)]="model.value">

          <input *ngSwitchCase="types.EMAIL" class="df-property-control" type="password" [id]="model.id"
                 [formControlName]="model.id" [placeholder]="model.defaultValue || ''" [(ngModel)]="model.value">

          <input *ngSwitchCase="types.URL" class="df-property-control" type="url" [id]="model.id"
                 [formControlName]="model.id" [placeholder]="model.defaultValue || ''" [(ngModel)]="model.value">

          <select *ngSwitchCase="types.SELECT" class="df-property-control" [id]="model.id"
                 [formControlName]="model.id" [(ngModel)]="model.value">
            <option *ngFor="let o of model['options']" [ngValue]="o.value">{{o.name}}</option>
          </select>

          <code-editor *ngSwitchCase="types.CODE" class="df-property-control" [id]="model.id"
                  [formControlName]="model.id" [language]="model['language']" [(ngModel)]="model.value" line-numbers="true"
                  scrollbar-style="simple" [placeholder]="model.defaultValue || 'Enter code snippet...'" overview-ruler="true">
          </code-editor>

          <input *ngSwitchDefault class="df-property-control" type="text" [id]="model.id" [formControlName]="model.id"
                 [placeholder]="model.defaultValue || ''" [(ngModel)]="model.value">
        </div>
        <div class="help-block">
          <div>{{model.description}}</div>
          <div *ngFor="let e of errorData" class="validation-error-block">{{e.message}}</div>
        </div>
      </td>

    </tr>
  `,
        encapsulation: ViewEncapsulation.None
    }),
    __metadata("design:paramtypes", [])
], DynamicFormPropertyComponent);

let PaperComponent = class PaperComponent {
    constructor() {
        this.onDelete = new EventEmitter();
        this.onProperties = new EventEmitter();
        this.onBlur = new EventEmitter();
    }
    click() {
        this.paperElement.nativeElement.focus();
    }
    mousedown() {
        this.paperElement.nativeElement.focus();
    }
    backspaceHandle() {
        this.onDelete.emit();
    }
    deleteHandle() {
        this.onDelete.emit();
    }
    oHandle() {
        this.onProperties.emit();
    }
    ngOnInit() {
        const onBlur = this.onBlur;
        this.paperElement.nativeElement.addEventListener('blur', () => {
            onBlur.emit();
        });
    }
};
__decorate([
    ViewChild('paper', { static: true }),
    __metadata("design:type", ElementRef)
], PaperComponent.prototype, "paperElement", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], PaperComponent.prototype, "onDelete", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], PaperComponent.prototype, "onProperties", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], PaperComponent.prototype, "onBlur", void 0);
__decorate([
    HostListener('click'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PaperComponent.prototype, "click", null);
__decorate([
    HostListener('mousedown'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PaperComponent.prototype, "mousedown", null);
__decorate([
    HostListener('keydown.backspace'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PaperComponent.prototype, "backspaceHandle", null);
__decorate([
    HostListener('keydown.delete'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PaperComponent.prototype, "deleteHandle", null);
__decorate([
    HostListener('keydown.o'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PaperComponent.prototype, "oHandle", null);
PaperComponent = __decorate([
    Component({
        selector: 'flo-editor-paper',
        template: `
    <div #paper tabindex="0" id="paper-container">
      <ng-content></ng-content>
    </div>`,
        styles: [`
    flo-view {
      width:100%;
      height:100%;
      margin: 0;
      background-color: #eeeeee;
      font-family: "Varela Round",sans-serif;
      -webkit-user-select: none;
      -khtml-user-select: none;
      -moz-user-select: none;
      -o-user-select: none;
      user-select: none;
    }

    .canvas {
      border: 1px solid;
      border-color: #6db33f;
      border-radius: 2px;
      margin-top: 3px;
    }

    /* Canvas contains the palette on the left and the paper on the right */

    .paper {
      padding: 0px;
      background-color: #ffffff;
      /* 	height: 100%;
          width: 100%;
          position: relative;
          overflow: hidden;
       *//* 	margin-left: 400px; */
    }

    #sidebar-resizer {
      background-color: #34302d;
      position: absolute;
      top: 0;
      bottom: 0;
      width: 6px;
      cursor: e-resize;
    }

    #palette-container {
      background-color: #EEE;
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      overflow: auto;
    }

    #paper-container {
      position: absolute;
      top: 0;
      bottom: 0;
      right: 0;
      overflow: auto;
      color: #FFF;
      background-color: #FFF;
      outline: none;
    }

    /* Tooltip START */

    .node-tooltip .tooltip-description {
      margin-top: 5px;
      margin-left: 0px;
      margin-bottom: 5px;
    }

    .node-tooltip {
      display:none;
      position:absolute;
      border:1px solid #333;
      background-color:#34302d;/*#161616;*/
      border-radius:5px;
      padding:5px;
      color:#fff;
      /*	font-size:12px Arial;*/
      font-family: "Varela Round",sans-serif;
      font-size: 19px;
      z-index: 100;
    }

    .tooltip-title-type {
      font-size: 24px;
      font-weight: bold;
    }

    .tooltip-title-group {
      padding-left: 5px;
      font-size: 20px;
      font-style: italic;
    }

    .node-tooltip-option-name {
      font-family: monospace;/*"Varela Round",sans-serif;*/
      font-size: 17px;
      font-weight: bold;
      padding-right: 20px;

    }

    .node-tooltip-option-description {
      font-family: "Varela Round",sans-serif;
      font-size: 18px;
    }

    /* Tooltip END */


    /* Validation Error Marker on Canvas START */

    .error-tooltip p {
      margin-top: 5px;
      margin-left: 0px;
      margin-bottom: 5px;
      color:#fff;
    }
    .error-tooltip {
      display:none;
      position:absolute;
      border:1px solid #333;
      background-color:red;/*#161616;*/
      border-radius:5px;
      padding:5px;
      color:#fff;
      /*	font-size:12px Arial;*/
      font-family: "Varela Round",sans-serif;
      font-size: 20px;
      z-index: 100;
    }

    /* Validation Error Marker on Canvas END */

    /* Controls on Canvas START */

    .canvas-controls-container {
      position: absolute;
      right: 15px;
      top: 5px;
    }

    .canvas-control {
      background: transparent;
      font-family: "Varela Round",sans-serif;
      font-size: 11px;
      vertical-align: middle;
      margin: 0px;
    }

    .zoom-canvas-control {
      border: 0px;
      padding: 0px;
      margin: 0px;
      outline: none;
    }

    .zoom-canvas-input {
      text-align: right;
      font-weight:bold;
      color: black;
      background-color: transparent;
    }

    .zoom-canvas-label {
      padding-right: 4px;
      color: black;
    }

    /* Controls on Canvas END */




    /* START - FLO CANVAS STYLES - override joint js styles */

    .highlighted {
      outline: none;
    }

    .joint-type-handle {
      cursor: pointer;
    }

    .available-magnet {
      stroke-width: 3;
    }

    .link {
      fill: none;
      stroke: #ccc;
      stroke-width: 1.5px;
    }

    .link-tools .tool-options {
      display: none;       /* by default, we don't display link options tool */
    }

    /* Make transparent the circle around the link-tools (cog) icon. It'll allow shape to have a circle clicking area */
    .link-tools .tool-options circle {
      fill: transparent;
      stroke: transparent;
    }

    .link-tools .tool-options path {
      fill: black;
      stroke: black;
    }

    .link-tools .tool-remove circle {
      fill: red;
      stroke: red;
    }

    .link-tools .tool-remove path {
      fill: white;
      stroke: white;
    }

    .link-tools-container {
      stroke-width: 0;
      fill: transparent;
    }

    /* END - FLO CANVAS STYLES */
  `],
        encapsulation: ViewEncapsulation.None
    })
], PaperComponent);

let FloModule = class FloModule {
};
FloModule = __decorate([
    NgModule({
        imports: [
            FormsModule,
            CommonModule,
            ReactiveFormsModule
        ],
        declarations: [
            Palette,
            EditorComponent,
            ResizerDirective,
            DslEditorComponent,
            CodeEditorComponent,
            PropertiesGroupComponent,
            DynamicFormPropertyComponent,
            PaperComponent
        ],
        exports: [
            EditorComponent,
            DslEditorComponent,
            DynamicFormPropertyComponent,
            PropertiesGroupComponent
        ]
    })
], FloModule);

/**
 * Generated bundle index. Do not edit.
 */

export { CodeEditorComponent, Constants, DslEditorComponent, DynamicFormPropertyComponent, EditorComponent, Flo, FloModule, Palette, Properties, PropertiesGroupComponent, ResizerDirective, Shapes, PaperComponent as ɵa };
//# sourceMappingURL=spring-flo.js.map
