import { __decorate, __metadata, __param, __extends } from 'tslib';
import { Input, Output, Component, ViewEncapsulation, Inject, ElementRef, EventEmitter, Directive, forwardRef, ViewChild, HostListener, NgModule } from '@angular/core';
import { NG_VALUE_ACCESSOR, FormControl, FormGroup, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { DOCUMENT, CommonModule } from '@angular/common';
import { Subject, BehaviorSubject, fromEvent, Observable } from 'rxjs';
import { debounceTime, sampleTime, switchMap } from 'rxjs/operators';
import * as _joint from 'jointjs';
import * as _$ from 'jquery';
import { cloneDeepWith, isObject, isPlainObject, template, isFunction, groupBy, each, isEqual, isString, isNumber, partial, debounce } from 'lodash';
import { Disposable, CompositeDisposable } from 'ts-disposables';
import { fromTextArea, findModeByName } from 'codemirror-minified';
import 'codemirror-minified/addon/lint/lint';
import 'codemirror-minified/addon/hint/show-hint';
import 'codemirror-minified/addon/display/placeholder';
import 'codemirror-minified/addon/scroll/annotatescrollbar';
import 'codemirror-minified/addon/scroll/simplescrollbars';
import 'codemirror-minified/mode/meta';
import 'codemirror-minified/addon/edit/matchbrackets';
import 'codemirror-minified/addon/edit/closebrackets';

var $ = _$;
var Flo;
(function (Flo) {
    Flo.joint = _joint;
    var DnDEventType;
    (function (DnDEventType) {
        DnDEventType[DnDEventType["DRAG"] = 0] = "DRAG";
        DnDEventType[DnDEventType["DROP"] = 1] = "DROP";
    })(DnDEventType = Flo.DnDEventType || (Flo.DnDEventType = {}));
    var Severity;
    (function (Severity) {
        Severity[Severity["Error"] = 0] = "Error";
        Severity[Severity["Warning"] = 1] = "Warning";
    })(Severity = Flo.Severity || (Flo.Severity = {}));
    function findMagnetByClass(view, className) {
        if (className && className.startsWith('.')) {
            className = className.substr(1);
        }
        var element = view.$('[magnet]').toArray().find(function (magnet) { return magnet.getAttribute('class').split(/\s+/).indexOf(className) >= 0; });
        if (element) {
            return view.findMagnet($(element));
        }
    }
    Flo.findMagnetByClass = findMagnetByClass;
    function findMagnetByPort(view, port) {
        var element = view.$('[magnet]').toArray().find(function (magnet) { return magnet.getAttribute('port') === port; });
        if (element) {
            return view.findMagnet($(element));
        }
    }
    Flo.findMagnetByPort = findMagnetByPort;
    /**
     * Return the metadata for a particular palette entry in a particular group.
     * @param name - name of the palette entry
     * @param group - group in which the palette entry should exist (e.g. sinks)
     * @return
     */
    function getMetadata(metamodel, name, group) {
        var groupObj = metamodel && group ? metamodel.get(group) : undefined;
        if (name && groupObj && groupObj.get(name)) {
            return metamodel.get(group).get(name);
        }
        else {
            return {
                name: name,
                group: group,
                unresolved: true,
                get: function (property) { return new Promise(function (resolve) { return resolve(); }); },
                properties: function () { return Promise.resolve(new Map()); }
            };
        }
    }
    Flo.getMetadata = getMetadata;
    function getScrollbarWidth() {
        // Creating invisible container
        var outer = document.createElement('div');
        outer.style.visibility = 'hidden';
        outer.style.overflow = 'scroll'; // forcing scrollbar to appear
        outer.style.msOverflowStyle = 'scrollbar'; // needed for WinJS apps
        document.body.appendChild(outer);
        // Creating inner element and placing it in the container
        var inner = document.createElement('div');
        outer.appendChild(inner);
        // Calculating difference between container's full width and the child width
        var scrollbarWidth = (outer.offsetWidth - inner.offsetWidth);
        // Removing temporary elements from the DOM
        outer.parentNode.removeChild(outer);
        return scrollbarWidth;
    }
    Flo.getScrollbarWidth = getScrollbarWidth;
    Flo.SCROLLBAR_WIDTH = getScrollbarWidth();
})(Flo || (Flo = {}));

var joint = Flo.joint;
var $$1 = _$;
var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
var isFF = navigator.userAgent.indexOf('Firefox') > 0;
var IMAGE_W = 120;
var IMAGE_H = 35;
var ERROR_MARKER_SIZE = { width: 16, height: 16 };
var HANDLE_SIZE = { width: 10, height: 10 };
joint.shapes.flo = {};
joint.shapes.flo.NODE_TYPE = 'sinspctr.IntNode';
joint.shapes.flo.LINK_TYPE = 'sinspctr.Link';
joint.shapes.flo.DECORATION_TYPE = 'decoration';
joint.shapes.flo.HANDLE_TYPE = 'handle';
var HANDLE_ICON_MAP = new Map();
var REMOVE = 'remove';
HANDLE_ICON_MAP.set(REMOVE, 'icons/delete.svg');
var DECORATION_ICON_MAP = new Map();
var ERROR = 'error';
DECORATION_ICON_MAP.set(ERROR, 'icons/error.svg');
joint.util.cloneDeep = function (obj) {
    return cloneDeepWith(obj, function (o) {
        if (isObject(o) && !isPlainObject(o)) {
            return o;
        }
    });
};
joint.util.filter.redscale = function (args) {
    var amount = Number.isFinite(args.amount) ? args.amount : 1;
    return template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 ${d} ${e} ${f} ${g} 0 0 ${h} ${i} ${k} 0 0 0 0 0 1 0"/></filter>', {
        a: 1 - 0.96 * amount,
        b: 0.95 * amount,
        c: 0.01 * amount,
        d: 0.3 * amount,
        e: 0.2 * amount,
        f: 1 - 0.9 * amount,
        g: 0.7 * amount,
        h: 0.05 * amount,
        i: 0.05 * amount,
        k: 1 - 0.1 * amount
    });
};
joint.util.filter.orangescale = function (args) {
    var amount = Number.isFinite(args.amount) ? args.amount : 1;
    return template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 ${d} ${e} ${f} ${g} 0 ${h} ${i} ${k} ${l} 0 0 0 0 0 1 0"/></filter>', {
        a: 1.0 + 0.5 * amount,
        b: 1.4 * amount,
        c: 0.2 * amount,
        d: 0.3 * amount,
        e: 0.3 * amount,
        f: 1 + 0.05 * amount,
        g: 0.2 * amount,
        h: 0.15 * amount,
        i: 0.3 * amount,
        k: 0.3 * amount,
        l: 1 - 0.6 * amount
    });
};
joint.shapes.flo.Node = joint.shapes.basic.Generic.extend({
    markup: '<g class="shape"><image class="image" /></g>' +
        '<rect class="border-white"/>' +
        '<rect class="border"/>' +
        '<rect class="box"/>' +
        '<text class="label"/>' +
        '<text class="label2"></text>' +
        '<rect class="input-port" />' +
        '<rect class="output-port"/>' +
        '<rect class="output-port-cover"/>',
    defaults: joint.util.deepSupplement({
        type: joint.shapes.flo.NODE_TYPE,
        position: { x: 0, y: 0 },
        size: { width: IMAGE_W, height: IMAGE_H },
        attrs: {
            '.': { magnet: false },
            // rounded edges around image
            '.border': {
                width: IMAGE_W,
                height: IMAGE_H,
                rx: 3,
                ry: 3,
                'fill-opacity': 0,
                stroke: '#eeeeee',
                'stroke-width': 0
            },
            '.box': {
                width: IMAGE_W,
                height: IMAGE_H,
                rx: 3,
                ry: 3,
                //'fill-opacity': 0, // see through
                stroke: '#6db33f',
                fill: '#eeeeee',
                'stroke-width': 1
            },
            '.input-port': {
                idp: 'input',
                port: 'input',
                height: 8, width: 8,
                magnet: true,
                fill: '#eeeeee',
                transform: 'translate(' + -4 + ',' + ((IMAGE_H / 2) - 4) + ')',
                stroke: '#34302d',
                'stroke-width': 1
            },
            '.output-port': {
                id: 'output',
                port: 'output',
                height: 8, width: 8,
                magnet: true,
                fill: '#eeeeee',
                transform: 'translate(' + (IMAGE_W - 4) + ',' + ((IMAGE_H / 2) - 4) + ')',
                stroke: '#34302d',
                'stroke-width': 1
            },
            '.label': {
                'text-anchor': 'middle',
                'ref-x': 0.5,
                // 'ref-y': -12, // jointjs specific: relative position to ref'd element
                'ref-y': 0.3,
                ref: '.border',
                fill: 'black',
                'font-size': 14
            },
            '.label2': {
                'text': '\u21d2',
                'text-anchor': 'middle',
                'ref-x': 0.15,
                'ref-y': 0.2,
                ref: '.border',
                // transform: 'translate(' + (IMAGE_W/2) + ',' + (IMAGE_H/2) + ')',
                fill: 'black',
                'font-size': 24
            },
            '.shape': {},
            '.image': {
                width: IMAGE_W,
                height: IMAGE_H
            }
        }
    }, joint.shapes.basic.Generic.prototype.defaults)
});
joint.shapes.flo.Link = joint.dia.Link.extend({
    defaults: joint.util.deepSupplement({
        type: joint.shapes.flo.LINK_TYPE,
        attrs: {
            '.connection': { stroke: '#34302d', 'stroke-width': 2 },
            // Lots of alternatives that have been played with:
            //	            '.smoooth': true
            //	            '.marker-source': { stroke: '#9B59B6', fill: '#9B59B6', d: 'M24.316,5.318,9.833,13.682,9.833,5.5,5.5,5.5,5.5,25.5,9.833,25.5,9.833,17.318,24.316,25.682z' },
            //	            '.marker-target': { stroke: '#F39C12', fill: '#F39C12', d: 'M14.615,4.928c0.487-0.986,1.284-0.986,1.771,0l2.249,4.554c0.486,0.986,1.775,1.923,2.864,2.081l5.024,0.73c1.089,0.158,1.335,0.916,0.547,1.684l-3.636,3.544c-0.788,0.769-1.28,2.283-1.095,3.368l0.859,5.004c0.186,1.085-0.459,1.553-1.433,1.041l-4.495-2.363c-0.974-0.512-2.567-0.512-3.541,0l-4.495,2.363c-0.974,0.512-1.618,0.044-1.432-1.041l0.858-5.004c0.186-1.085-0.307-2.6-1.094-3.368L3.93,13.977c-0.788-0.768-0.542-1.525,0.547-1.684l5.026-0.73c1.088-0.158,2.377-1.095,2.864-2.081L14.615,4.928z' },
            //	        	'.connection': { 'stroke':'black'},
            //	        	'.': { filter: { name: 'dropShadow', args: { dx: 1, dy: 1, blur: 2 } } },
            //	        	'.connection': { 'stroke-width': 10, 'stroke-linecap': 'round' },
            // This means: moveto 10 0, lineto 0 5, lineto, 10 10 closepath(z)
            //	        	'.marker-target': { d: 'M 5 0 L 0 7 L 5 14 z', stroke: '#34302d','stroke-width': 1},
            //	        	'.marker-target': { d: 'M 14 2 L 9,2 L9,0 L 0,7 L 9,14 L 9,12 L 14,12 z', 'stroke-width': 1, fill: '#34302d', stroke: '#34302d'},
            //	        	'.marker-source': {d: 'M 5 0 L 5,10 L 0,10 L 0,0 z', 'stroke-width': 0, fill: '#34302d', stroke: '#34302d'},
            //	            '.marker-target': { stroke: '#E74C3C', fill: '#E74C3C', d: 'M 10 0 L 0 5 L 10 10 z' },
            '.marker-arrowheads': { display: 'none' },
            '.tool-options': { display: 'none' }
        },
    }, joint.dia.Link.prototype.defaults)
});
joint.shapes.flo.LinkView = joint.dia.LinkView.extend({
    options: joint.util.deepSupplement({
        linkToolsOffset: 0.5,
        shortLinkLength: 40
    }, joint.dia.LinkView.prototype.options),
    updateToolsPosition: function () {
        // Overriden to support relative offset for tools placement.
        // If offset is between 0 and 1 then percentage of the connection length will be used to offset the tools group
        if (this.options.linkToolsOffset < 1 && this.options.linkToolsOffset > 0) {
            var connectionLength = this.getConnectionLength();
            var relativeOffset = this.options.linkToolsOffset;
            this.options.linkToolsOffset = connectionLength * relativeOffset;
            var returnValue = joint.dia.LinkView.prototype.updateToolsPosition.apply(this, arguments);
            this.options.linkToolsOffset = relativeOffset;
            return returnValue;
        }
        else {
            return joint.dia.LinkView.prototype.updateToolsPosition.apply(this, arguments);
        }
    },
    _beforeArrowheadMove: function () {
        if (this.model.get('source').id) {
            this._oldSource = this.model.get('source');
        }
        if (this.model.get('target').id) {
            this._oldTarget = this.model.get('target');
        }
        joint.dia.LinkView.prototype._beforeArrowheadMove.apply(this, arguments);
    },
    _afterArrowheadMove: function () {
        joint.dia.LinkView.prototype._afterArrowheadMove.apply(this, arguments);
        if (!this.model.get('source').id) {
            if (this._oldSource) {
                this.model.set('source', this._oldSource);
            }
            else {
                this.model.remove();
            }
        }
        if (!this.model.get('target').id) {
            if (this._oldTarget) {
                this.model.set('target', this._oldTarget);
            }
            else {
                this.model.remove();
            }
        }
        delete this._oldSource;
        delete this._oldTarget;
    }
});
// TODO: must do cleanup for the `mainElementView'
joint.shapes.flo.ElementView = joint.dia.ElementView.extend({
    // canShowTooltip: true,
    beingDragged: false,
    // _tempZorder: 0,
    _tempOpacity: 1.0,
    _hovering: false,
    dragLinkStart: function (evt, magnet, x, y) {
        this.model.startBatch('add-link');
        var linkView = this.addLinkFromMagnet(magnet, x, y);
        // backwards compatiblity events
        joint.dia.CellView.prototype.pointerdown.apply(linkView, [evt, x, y]);
        linkView.notify('link:pointerdown', evt, x, y);
        /*** START MAIN DIFF ***/
        var sourceOrTarget = $$1(magnet).attr('port') === 'input' ? 'source' : 'target';
        linkView.eventData(evt, linkView.startArrowheadMove(sourceOrTarget, { whenNotAllowed: 'remove' }));
        /*** END MAIN DIFF ***/
        this.eventData(evt, { linkView: linkView });
    },
    addLinkFromMagnet: function (magnet, x, y) {
        var paper = this.paper;
        var graph = paper.model;
        var link = paper.getDefaultLink(this, magnet);
        var sourceEnd, targetEnd;
        /*** START MAIN DIFF ***/
        if ($$1(magnet).attr('port') === 'input') {
            sourceEnd = { x: x, y: y };
            targetEnd = this.getLinkEnd(magnet, x, y, link, 'target');
        }
        else {
            sourceEnd = this.getLinkEnd(magnet, x, y, link, 'source');
            targetEnd = { x: x, y: y };
        }
        /*** END MAIN DIFF ***/
        link.set({
            source: sourceEnd,
            target: targetEnd
        }).addTo(graph, {
            async: false,
            ui: true
        });
        return link.findView(paper);
    },
    // pointerdown: function(evt: any, x: number, y: number) {
    //   // this.canShowTooltip = false;
    //   // this.hideTooltip();
    //   this.beingDragged = false;
    //   this._tempOpacity = this.model.attr('./opacity');
    //
    //   this.model.trigger('batch:start');
    //
    //   if ( // target is a valid magnet start linking
    //     evt.target.getAttribute('magnet') &&
    //     this.paper.options.validateMagnet.call(this.paper, this, evt.target)
    //   ) {
    //     let link = this.paper.getDefaultLink(this, evt.target);
    //     if ($(evt.target).attr('port') === 'input') {
    //       link.set({
    //         source: { x: x, y: y },
    //         target: {
    //           id: this.model.id,
    //           selector: this.getSelector(evt.target),
    //           port: evt.target.getAttribute('port')
    //         }
    //       });
    //     } else {
    //       link.set({
    //         source: {
    //           id: this.model.id,
    //           selector: this.getSelector(evt.target),
    //           port: evt.target.getAttribute('port')
    //         },
    //         target: { x: x, y: y }
    //       });
    //     }
    //     this.paper.model.addCell(link);
    //     this._linkView = this.paper.findViewByModel(link);
    //     if ($(evt.target).attr('port') === 'input') {
    //       this._linkView.startArrowheadMove('source');
    //     } else {
    //       this._linkView.startArrowheadMove('target');
    //     }
    //     this.paper.__creatingLinkFromPort = true;
    //   } else {
    //     this._dx = x;
    //     this._dy = y;
    //     joint.dia.CellView.prototype.pointerdown.apply(this, arguments);
    //   }
    // },
    drag: function (evt, x, y) {
        var interactive = isFunction(this.options.interactive) ? this.options.interactive(this, 'pointermove') :
            this.options.interactive;
        if (interactive !== false) {
            this.paper.trigger('dragging-node-over-canvas', { type: Flo.DnDEventType.DRAG, view: this, event: evt });
        }
        joint.dia.ElementView.prototype.drag.apply(this, arguments);
    },
    dragEnd: function (evt, x, y) {
        this.paper.trigger('dragging-node-over-canvas', { type: Flo.DnDEventType.DROP, view: this, event: evt });
        joint.dia.ElementView.prototype.dragEnd.apply(this, arguments);
    },
});
joint.shapes.flo.ErrorDecoration = joint.shapes.basic.Generic.extend({
    markup: '<g class="rotatable"><g class="scalable"><image/></g></g>',
    defaults: joint.util.deepSupplement({
        type: joint.shapes.flo.DECORATION_TYPE,
        size: ERROR_MARKER_SIZE,
        attrs: {
            'image': ERROR_MARKER_SIZE
        }
    }, joint.shapes.basic.Generic.prototype.defaults)
});
var Constants;
(function (Constants) {
    Constants.REMOVE_HANDLE_TYPE = REMOVE;
    Constants.PROPERTIES_HANDLE_TYPE = 'properties';
    Constants.ERROR_DECORATION_KIND = ERROR;
    Constants.PALETTE_CONTEXT = 'palette';
    Constants.CANVAS_CONTEXT = 'canvas';
    Constants.FEEDBACK_CONTEXT = 'feedback';
})(Constants || (Constants = {}));
var Shapes;
(function (Shapes) {
    var Factory = /** @class */ (function () {
        function Factory() {
        }
        /**
         * Create a JointJS node that embeds extra metadata (properties).
         */
        Factory.createNode = function (params) {
            var renderer = params.renderer;
            var paper = params.paper;
            var metadata = params.metadata;
            var position = params.position;
            var props = params.props;
            var graph = params.graph || (params.paper ? params.paper.model : undefined);
            var node;
            if (!position) {
                position = { x: 0, y: 0 };
            }
            if (renderer && isFunction(renderer.createNode)) {
                node = renderer.createNode({ graph: graph, paper: paper }, metadata, props);
            }
            else {
                node = new joint.shapes.flo.Node();
                if (metadata) {
                    node.attr('.label/text', metadata.name);
                }
            }
            node.set('type', joint.shapes.flo.NODE_TYPE);
            if (position) {
                node.set('position', position);
            }
            if (props) {
                Array.from(props.keys()).forEach(function (key) { return node.attr("props/" + key, props.get(key)); });
            }
            node.attr('metadata', metadata);
            if (graph) {
                graph.addCell(node);
            }
            if (renderer && isFunction(renderer.initializeNewNode)) {
                var descriptor = {
                    paper: paper,
                    graph: graph
                };
                renderer.initializeNewNode(node, descriptor);
            }
            return node;
        };
        Factory.createLink = function (params) {
            var renderer = params.renderer;
            var paper = params.paper;
            var metadata = params.metadata;
            var source = params.source;
            var target = params.target;
            var props = params.props;
            var graph = params.graph || (params.paper ? params.paper.model : undefined);
            var link;
            if (renderer && isFunction(renderer.createLink)) {
                link = renderer.createLink(source, target, metadata, props);
            }
            else {
                link = new joint.shapes.flo.Link();
            }
            if (source) {
                link.set('source', source);
            }
            if (target) {
                link.set('target', target);
            }
            link.set('type', joint.shapes.flo.LINK_TYPE);
            if (metadata) {
                link.attr('metadata', metadata);
            }
            if (props) {
                Array.from(props.keys()).forEach(function (key) { return link.attr("props/" + key, props.get(key)); });
            }
            if (graph) {
                graph.addCell(link);
            }
            if (renderer && isFunction(renderer.initializeNewLink)) {
                var descriptor = {
                    paper: paper,
                    graph: graph
                };
                renderer.initializeNewLink(link, descriptor);
            }
            // prevent creation of link breaks
            link.attr('.marker-vertices/display', 'none');
            return link;
        };
        Factory.createDecoration = function (params) {
            var renderer = params.renderer;
            var paper = params.paper;
            var parent = params.parent;
            var kind = params.kind;
            var messages = params.messages;
            var location = params.position;
            var graph = params.graph || (params.paper ? params.paper.model : undefined);
            var decoration;
            if (renderer && isFunction(renderer.createDecoration)) {
                decoration = renderer.createDecoration(kind, parent);
            }
            if (decoration) {
                decoration.set('type', joint.shapes.flo.DECORATION_TYPE);
                if ((isChrome || isFF) && parent && typeof parent.get('z') === 'number') {
                    decoration.set('z', parent.get('z') + 1);
                }
                decoration.attr('./kind', kind);
                decoration.attr('messages', messages);
                if (graph) {
                    graph.addCell(decoration);
                }
                parent.embed(decoration);
                if (renderer && isFunction(renderer.initializeNewDecoration)) {
                    var descriptor = {
                        paper: paper,
                        graph: graph
                    };
                    renderer.initializeNewDecoration(decoration, descriptor);
                }
                return decoration;
            }
        };
        Factory.createHandle = function (params) {
            var renderer = params.renderer;
            var paper = params.paper;
            var parent = params.parent;
            var kind = params.kind;
            var location = params.position;
            var graph = params.graph || (params.paper ? params.paper.model : undefined);
            var handle;
            if (!location) {
                location = { x: 0, y: 0 };
            }
            if (renderer && isFunction(renderer.createHandle)) {
                handle = renderer.createHandle(kind, parent);
            }
            else {
                handle = new joint.shapes.flo.ErrorDecoration({
                    size: HANDLE_SIZE,
                    attrs: {
                        'image': {
                            'xlink:href': HANDLE_ICON_MAP.get(kind)
                        }
                    }
                });
            }
            handle.set('type', joint.shapes.flo.HANDLE_TYPE);
            handle.set('position', location);
            if ((isChrome || isFF) && parent && typeof parent.get('z') === 'number') {
                handle.set('z', parent.get('z') + 1);
            }
            handle.attr('./kind', kind);
            if (graph) {
                graph.addCell(handle);
            }
            parent.embed(handle);
            if (renderer && isFunction(renderer.initializeNewHandle)) {
                var descriptor = {
                    paper: paper,
                    graph: graph
                };
                renderer.initializeNewHandle(handle, descriptor);
            }
            return handle;
        };
        return Factory;
    }());
    Shapes.Factory = Factory;
})(Shapes || (Shapes = {}));

var joint$1 = Flo.joint;
var $$2 = _$;
var DEBOUNCE_TIME = 300;
joint$1.shapes.flo.PaletteGroupHeader = joint$1.shapes.basic.Generic.extend({
    // The path is the open/close arrow, defaults to vertical (open)
    markup: '<g class="scalable"><rect/></g><text/><g class="rotatable"><path d="m 10 10 l 5 8.7 l 5 -8.7 z"/></g>',
    defaults: joint$1.util.deepSupplement({
        type: 'palette.groupheader',
        size: { width: 170, height: 30 },
        position: { x: 0, y: 0 },
        attrs: {
            'rect': { fill: '#34302d', 'stroke-width': 1, stroke: '#6db33f', 'follow-scale': true, width: 80, height: 40 },
            'text': {
                text: '',
                fill: '#eeeeee',
                'ref-x': 0.5,
                'ref-y': 7,
                'x-alignment': 'middle',
                'font-size': 18 /*, 'font-weight': 'bold', 'font-variant': 'small-caps', 'text-transform': 'capitalize'*/
            },
            'path': { fill: 'white', 'stroke-width': 2, stroke: 'white' /*,transform:'rotate(90,15,15)'*/ }
        },
        // custom properties
        isOpen: true
    }, joint$1.shapes.basic.Generic.prototype.defaults)
});
joint$1.shapes.flo.NoMatchesFound = joint$1.shapes.basic.Generic.extend({
    // The path is the open/close arrow, defaults to vertical (open)
    markup: '<g class="scalable"><rect class="no-matches-label-border"/></g><rect class="no-mathes-label-bg"/><text class="no-matches-label"/>',
    defaults: joint$1.util.deepSupplement({
        size: { width: 170, height: 30 },
        position: { x: 0, y: 0 },
        attrs: {
            '.no-matches-label-border': {
                refWidth: 1,
                refHeight: 1,
                refX: 0,
                refY: 0,
            },
            '.no-macthes-label-bg': {
                ref: '.no-matches-label',
                refWidth: 10,
                refHeight: 2,
                'follow-scale': true
            },
            '.no-matches-label': {
                text: 'No results found.',
                ref: '.no-matches-label-border',
                refY: 0.5,
                refY2: 5,
                yAlignment: 'middle',
            },
        },
    }, joint$1.shapes.basic.Generic.prototype.defaults)
});
var Palette = /** @class */ (function () {
    function Palette(element, document) {
        var _this = this;
        this.element = element;
        this.document = document;
        this._metamodelListener = {
            metadataError: function (data) { },
            metadataAboutToChange: function () { },
            metadataChanged: function () {
                if (_this.initialized && _this.metamodel) {
                    _this.metamodel.load().then(function (metamodel) { return _this.buildPalette(metamodel); });
                }
            }
        };
        this.initialized = false;
        this._filterText = '';
        this.filterTextModel = new Subject();
        this.paletteEntryPadding = { width: 12, height: 12 };
        this.searchFilterPlaceHolder = 'Search...';
        this.onPaletteEntryDrop = new EventEmitter();
        this.paletteReady = new EventEmitter();
        this.paletteFocus = new EventEmitter();
        this.mouseMoveHanlder = function (e) { return _this.handleDrag(e); };
        this.mouseUpHanlder = function (e) { return _this.handleMouseUp(e); };
        this.paletteGraph = new joint$1.dia.Graph();
        this.paletteGraph.set('type', Constants.PALETTE_CONTEXT);
        this._filterText = '';
        this.closedGroups = new Set();
    }
    Object.defineProperty(Palette.prototype, "paletteSize", {
        set: function (size) {
            console.debug('Palette Size: ' + size);
            if (this._paletteSize !== size) {
                this._paletteSize = size;
                if (this.palette) {
                    this.layout();
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Palette.prototype.onFocus = function () {
        this.paletteFocus.emit();
    };
    Palette.prototype.ngOnInit = function () {
        var _this = this;
        var element = $$2('#palette-paper', this.element.nativeElement);
        // Create the paper for the palette using the specified element view
        this.palette = new joint$1.dia.Paper({
            el: element,
            gridSize: 1,
            model: this.paletteGraph,
            height: $$2(this.element.nativeElement.parentNode).height(),
            width: $$2(this.element.nativeElement.parentNode).width(),
            elementView: this.getPaletteView(this.renderer && this.renderer.getNodeView ? this.renderer.getNodeView() : joint$1.dia.ElementView),
            interactive: false
        });
        this.palette.on('cell:pointerup', function (cellview, evt) {
            if (_this.viewBeingDragged) {
                _this.trigger({
                    type: Flo.DnDEventType.DROP,
                    view: _this.viewBeingDragged,
                    event: evt
                });
                _this.viewBeingDragged = undefined;
            }
            _this.clickedElement = undefined;
            $$2('#palette-floater').remove();
            if (_this.floaterpaper) {
                _this.floaterpaper.remove();
            }
        });
        // Toggle the header open/closed on a click
        this.palette.on('cell:pointerclick', function (cellview, event) {
            // TODO [design][palette] should the user need to click on the arrow rather than anywhere on the header?
            // Click position within the element would be: evt.offsetX, evt.offsetY
            var cell = cellview.model;
            if (cell.attributes.header) ;
            // TODO [palette] ensure other mouse handling events do nothing for headers
            // TODO [palette] move 'metadata' field to the right place (not inside attrs I think)
        });
        $$2(this.document).on('mouseup', this.mouseUpHanlder);
        if (this.metamodel) {
            this.metamodel.load().then(function (data) {
                _this.buildPalette(data);
                // Add listener to metamodel
                if (_this.metamodel && _this.metamodel.subscribe) {
                    _this.metamodel.subscribe(_this._metamodelListener);
                }
                // Add debounced listener to filter text changes
                _this.filterTextModel
                    .pipe(debounceTime(DEBOUNCE_TIME))
                    .subscribe(function (value) { return _this.layout(); });
                _this.initialized = true;
            });
        }
        else {
            console.error('No Metamodel service specified for palette!');
        }
        this._paletteSize = this._paletteSize || $$2(this.element.nativeElement.parentNode).width();
    };
    Palette.prototype.ngOnDestroy = function () {
        if (this.metamodel && this.metamodel.unsubscribe) {
            this.metamodel.unsubscribe(this._metamodelListener);
        }
        $$2(this.document).off('mouseup', this.mouseUpHanlder);
        this.palette.remove();
    };
    Palette.prototype.ngOnChanges = function (changes) {
        // if (changes.hasOwnProperty('paletteSize') || changes.hasOwnProperty('filterText')) {
        //   this.metamodel.load().then(metamodel => this.buildPalette(metamodel));
        // }
    };
    Palette.prototype.createPaletteGroup = function (title, isOpen) {
        var _this = this;
        var paletteRenderer = this.renderer && this.renderer.getPaletteRenderer ? this.renderer.getPaletteRenderer() : {
            createGroupHeader: function (titleStr, isOpenParam) {
                var header = new joint$1.shapes.flo.PaletteGroupHeader({ attrs: { text: { text: titleStr } } });
                if (!isOpenParam) {
                    header.attr({ 'path': { 'transform': 'rotate(-90,15,13)' } });
                }
                return header;
            },
            onClose: function (groupView) { return _this.rotateClosed(groupView.model); },
            onOpen: function (groupView) { return _this.rotateOpen(groupView.model); }
        };
        var newGroupHeader = paletteRenderer.createGroupHeader(title, isOpen);
        if (!isOpen) {
            newGroupHeader.set('isOpen', false);
        }
        newGroupHeader.set('header', title);
        this.paletteGraph.addCell(newGroupHeader);
        var view = this.palette.findViewByModel(newGroupHeader);
        view.on('cell:pointerclick', function () {
            if (newGroupHeader.get('isOpen')) {
                if (typeof paletteRenderer.onClose === 'function') {
                    paletteRenderer.onClose(view).then(function () {
                        newGroupHeader.set('isOpen', false);
                        _this.closedGroups.add(newGroupHeader.get('header'));
                        _this.layout();
                    });
                }
                else {
                    newGroupHeader.set('isOpen', false);
                    _this.closedGroups.add(newGroupHeader.get('header'));
                    _this.layout();
                }
            }
            else {
                if (typeof paletteRenderer.onOpen === 'function') {
                    paletteRenderer.onOpen(view).then(function () {
                        newGroupHeader.set('isOpen', true);
                        _this.closedGroups.delete(newGroupHeader.get('header'));
                        _this.layout();
                    });
                }
                else {
                    newGroupHeader.set('isOpen', true);
                    _this.closedGroups.delete(newGroupHeader.get('header'));
                    _this.layout();
                }
            }
        });
        return newGroupHeader;
    };
    Palette.prototype.createPaletteEntry = function (title, metadata) {
        return Shapes.Factory.createNode({
            renderer: this.renderer,
            paper: this.palette,
            metadata: metadata
        });
    };
    Palette.prototype.buildPalette = function (metamodel) {
        var _this = this;
        var startTime = new Date().getTime();
        this.paletteReady.emit(false);
        this.paletteGraph.clear();
        var groupAdded = new Set();
        var parentWidth = this._paletteSize - Flo.SCROLLBAR_WIDTH;
        console.debug("Parent Width: " + parentWidth);
        // The field closedGroups tells us which should not be shown
        // Work out the list of active groups/nodes based on the filter text
        this.metamodel.groups().forEach(function (group) {
            if (metamodel && metamodel.has(group)) {
                Array.from(metamodel.get(group).keys()).sort().forEach(function (name) {
                    var node = metamodel.get(group).get(name);
                    if (node) {
                        if (!groupAdded.has(group)) {
                            _this.createPaletteGroup(group, !_this.closedGroups.has(group));
                            groupAdded.add(group);
                        }
                        if (!(node.metadata && node.metadata.noPaletteEntry)) {
                            _this.createPaletteEntry(name, node);
                        }
                    }
                });
            }
        });
        this.noMacthesFoundNode = new joint$1.shapes.flo.NoMatchesFound();
        this.palette.model.addCell(this.noMacthesFoundNode);
        this.layout();
        this.paletteReady.emit(true);
        console.debug('buildPalette took ' + (new Date().getTime() - startTime) + 'ms');
    };
    Palette.prototype.layout = function () {
        var _this = this;
        var startTime = new Date().getTime();
        var filterText = this.filterText;
        if (filterText) {
            filterText = filterText.toLowerCase();
        }
        var paletteNodes = [];
        var parentWidth = this._paletteSize - Flo.SCROLLBAR_WIDTH;
        console.debug("Parent Width: " + parentWidth);
        var presentGroups = new Set();
        this.palette.model.getCells().forEach(function (cell) {
            var metadata = cell.attr('metadata');
            if (cell.get('header')) {
                paletteNodes.push(cell);
            }
            else if (metadata && metadata.group && metadata.name
                && (!filterText || metadata.group.indexOf(filterText) >= 0 || metadata.name.indexOf(filterText) >= 0)) {
                if (!_this.closedGroups.has(metadata.group)) {
                    cell.attr('./display', 'block');
                    cell.removeAttr('./display');
                    paletteNodes.push(cell);
                }
                else {
                    cell.attr('./display', 'none');
                }
                presentGroups.add(metadata.group);
            }
            else {
                if (cell === _this.noMacthesFoundNode) ;
                else {
                    cell.attr('./display', 'none');
                }
            }
        });
        // Clean group headers
        var filteredGroupHeaders = [];
        paletteNodes.forEach(function (cell) {
            if (cell.get('header')) {
                if (presentGroups.has(cell.get('header'))) {
                    cell.attr('./display', 'block');
                    cell.removeAttr('./display');
                    filteredGroupHeaders.push(cell);
                }
                else {
                    cell.attr('./display', 'none');
                }
            }
            else {
                filteredGroupHeaders.push(cell);
            }
        });
        paletteNodes = filteredGroupHeaders;
        // Check if last group is empty
        var previous = paletteNodes.length > 0 ? paletteNodes[paletteNodes.length - 1] : undefined;
        // If previous is a paletter header node as well then the previous header had no nodes under it and we can hide it and remove from paletteNodes aeeay
        if (previous && previous.get('header') && !this.closedGroups.has(previous.get('header'))) {
            paletteNodes.pop().attr('./display', 'none');
        }
        var cellWidth = 0, cellHeight = 0;
        // Determine the size of the palette entry cell (width and height)
        paletteNodes.forEach(function (pnode) {
            if (pnode.attr('metadata/name')) {
                var elementSize = _this.palette.findViewByModel(pnode).getBBox();
                var dimension = {
                    width: elementSize.width,
                    height: elementSize.height
                };
                if (cellWidth < dimension.width) {
                    cellWidth = dimension.width;
                }
                if (cellHeight < dimension.height) {
                    cellHeight = dimension.height;
                }
            }
        });
        // Adjust the palette entry cell size with paddings.
        cellWidth += 2 * this.paletteEntryPadding.width;
        cellHeight += 2 * this.paletteEntryPadding.height;
        // Align palette entries row to be at the center
        var startX = parentWidth >= cellWidth ? (parentWidth - Math.floor(parentWidth / cellWidth) * cellWidth) / 2 : 0;
        var xpos = startX;
        var ypos = 0;
        var prevNode;
        // Layout palette entry nodes
        paletteNodes.forEach(function (pnode) {
            var elementSize = _this.palette.findViewByModel(pnode).getBBox();
            var dimension = {
                width: elementSize.width,
                height: elementSize.height
            };
            if (pnode.get('header')) { //attributes.attrs.header) {
                // Palette entry header
                xpos = startX;
                if (ypos) {
                    ypos += _this.paletteEntryPadding.height;
                }
                pnode.set('size', { width: parentWidth, height: pnode.get('size').height || 30 });
                pnode.set('position', { x: 0, y: ypos });
                ypos += dimension.height + _this.paletteEntryPadding.height;
            }
            else {
                // Palette entry element
                if (xpos + cellWidth > parentWidth) {
                    // Not enough real estate to place entry in a row - reset x position and leave the y pos which is next line
                    xpos = startX;
                    pnode.set('position', { x: xpos + (cellWidth - dimension.width) / 2, y: ypos + (cellHeight - dimension.height) / 2 });
                }
                else {
                    // Enough real estate to place entry in a row - adjust y position
                    if (prevNode && prevNode.attr('metadata/name')) {
                        ypos -= cellHeight;
                    }
                    pnode.set('position', { x: xpos + (cellWidth - dimension.width) / 2, y: ypos + (cellHeight - dimension.height) / 2 });
                }
                // increment x position and y position (can be reorganized)
                xpos += cellWidth;
                ypos += cellHeight;
            }
            prevNode = pnode;
        });
        this.noMacthesFoundNode.set('size', { width: parentWidth, height: this.noMacthesFoundNode.get('size').height || 30 });
        this.noMacthesFoundNode.set('position', { x: 0, y: 0 });
        if (paletteNodes.length === 0 && filterText) {
            // There is a filter present but everything is filtered out
            // Show no matches found node
            this.noMacthesFoundNode.attr('./display', 'block');
            this.noMacthesFoundNode.removeAttr('./display');
            ypos = this.noMacthesFoundNode.get('size').height;
        }
        else {
            // Hide no matches node in all other cases
            this.noMacthesFoundNode.attr('./display', 'none');
        }
        this.palette.setDimensions(parentWidth, ypos);
        console.debug('buildPalette layout ' + (new Date().getTime() - startTime) + 'ms');
    };
    Object.defineProperty(Palette.prototype, "filterText", {
        get: function () {
            return this._filterText;
        },
        set: function (text) {
            if (this._filterText !== text) {
                this._filterText = text;
                this.filterTextModel.next(text);
            }
        },
        enumerable: true,
        configurable: true
    });
    Palette.prototype.getPaletteView = function (view) {
        var self = this;
        return view.extend({
            pointerdown: function ( /*evt, x, y*/) {
                // Remove the tooltip
                // $('.node-tooltip').remove();
                // TODO move metadata to the right place (not inside attrs I think)
                self.clickedElement = this.model;
                if (self.clickedElement && self.clickedElement.attr('metadata')) {
                    $$2(self.document).on('mousemove', self.mouseMoveHanlder);
                }
            },
            pointermove: function ( /*evt, x, y*/) {
                // Nothing to prevent move within the palette canvas
            },
        });
    };
    Palette.prototype.handleMouseUp = function (event) {
        $$2(this.document).off('mousemove', this.mouseMoveHanlder);
    };
    Palette.prototype.trigger = function (event) {
        this.onPaletteEntryDrop.emit(event);
    };
    Palette.prototype.handleDrag = function (event) {
        // TODO offsetX/Y not on firefox
        // console.debug("tracking move: x="+event.pageX+",y="+event.pageY);
        // console.debug('Element = ' + (this.clickedElement ? this.clickedElement.attr('metadata/name'): 'null'));
        if (this.clickedElement && this.clickedElement.attr('metadata')) {
            if (!this.viewBeingDragged) {
                var dataOfClickedElement = this.clickedElement.attr('metadata');
                // custom div if not already built.
                $$2('<div>', {
                    id: 'palette-floater'
                }).appendTo($$2('body'));
                var floatergraph = new joint$1.dia.Graph();
                floatergraph.set('type', Constants.FEEDBACK_CONTEXT);
                var parent_1 = $$2('#palette-floater');
                this.floaterpaper = new joint$1.dia.Paper({
                    el: $$2('#palette-floater'),
                    elementView: this.renderer && this.renderer.getNodeView ? this.renderer.getNodeView() : joint$1.dia.ElementView,
                    gridSize: 10,
                    model: floatergraph,
                    height: parent_1.height(),
                    width: parent_1.width(),
                    validateMagnet: function () { return false; },
                    validateConnection: function () { return false; }
                });
                // TODO float thing needs to be bigger otherwise icon label is missing
                // Initiative drag and drop - create draggable element
                var floaternode = Shapes.Factory.createNode({
                    'renderer': this.renderer,
                    'paper': this.floaterpaper,
                    'graph': floatergraph,
                    'metadata': dataOfClickedElement
                });
                // Only node view expected
                this.viewBeingDragged = this.floaterpaper.findViewByModel(floaternode);
                var box = this.viewBeingDragged.getBBox();
                var size = floaternode.get('size');
                parent_1.css('width', box.width + box.width - size.width);
                parent_1.css('height', box.height + box.height - size.height);
                // Account for node real size including ports
                floaternode.translate(box.width - size.width, box.height - size.height);
                parent_1.offset({ left: event.pageX + 5, top: event.pageY + 5 });
            }
            else {
                $$2('#palette-floater').offset({ left: event.pageX + 5, top: event.pageY + 5 });
                this.trigger({
                    type: Flo.DnDEventType.DRAG,
                    view: this.viewBeingDragged,
                    event: event
                });
            }
        }
    };
    /*
     * Modify the rotation of the arrow in the header from horizontal(closed) to vertical(open)
     */
    Palette.prototype.rotateOpen = function (element) {
        var _this = this;
        return new Promise(function (resolve) {
            setTimeout(function () { return _this.doRotateOpen(element, 90).then(function () {
                resolve();
            }); });
        });
    };
    Palette.prototype.doRotateOpen = function (element, angle) {
        var _this = this;
        return new Promise(function (resolve) {
            angle -= 10;
            element.attr({ 'path': { 'transform': 'rotate(-' + angle + ',15,13)' } });
            if (angle <= 0) {
                resolve();
            }
            else {
                setTimeout(function () { return _this.doRotateOpen(element, angle).then(function () { return resolve(); }); }, 10);
            }
        });
    };
    Palette.prototype.doRotateClose = function (element, angle) {
        var _this = this;
        return new Promise(function (resolve) {
            angle += 10;
            element.attr({ 'path': { 'transform': 'rotate(-' + angle + ',15,13)' } });
            if (angle >= 90) {
                resolve();
            }
            else {
                setTimeout(function () { return _this.doRotateClose(element, angle).then(function () { return resolve(); }); }, 10);
            }
        });
    };
    // TODO better name for this function as this does the animation *and* updates the palette
    /*
     * Modify the rotation of the arrow in the header from vertical(open) to horizontal(closed)
     */
    Palette.prototype.rotateClosed = function (element) {
        var _this = this;
        return new Promise(function (resolve) {
            setTimeout(function () {
                _this.doRotateClose(element, 0).then(function () {
                    resolve();
                });
            });
        });
    };
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], Palette.prototype, "metamodel", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], Palette.prototype, "renderer", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], Palette.prototype, "paletteEntryPadding", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], Palette.prototype, "searchFilterPlaceHolder", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], Palette.prototype, "onPaletteEntryDrop", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], Palette.prototype, "paletteReady", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], Palette.prototype, "paletteFocus", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], Palette.prototype, "paletteSize", null);
    Palette = __decorate([
        Component({
            selector: 'flo-palette',
            template: "\n    <div id=\"palette-filter\" class=\"palette-filter\">\n      <label class=\"palette-filter-label\" for=\"palette-filter-textfield\">\n        <input type=\"search\" id=\"palette-filter-textfield\" class=\"palette-filter-textfield\" [(ngModel)]=\"filterText\" (focus)=\"onFocus()\" [placeholder]=\"searchFilterPlaceHolder\"/>\n      </label>\n    </div>\n    <div id=\"palette-paper-container\">\n      <div id=\"palette-paper\" class=\"palette-paper\" style=\"overflow:hidden;\"></div>\n    </div>\n  ",
            styles: ["\n    /* Joint JS paper for drawing palette -> canvas DnD visual feedback START */\n\n    #palette-floater {\n      /* TODO size relative to paper that goes on it? */\n      opacity: 0.75;\n      background-color: transparent;\n      /*\n        background-color: #6db33f;\n        */\n      float:left;\n      position: absolute;\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n    }\n\n    #palette-floater.joint-paper > svg {\n      background-color: transparent;\n    }\n\n    #palette-paper-container {\n      overflow-y: auto;\n      overflow-x: hidden;\n      background-color: white;\n      color: white;\n      height:calc(100% - 46px);\n      width:100%;\n    }\n\n    /* Joint JS paper for drawing palette -> canvas DnD visual feedback END */\n\n    /* Palette START */\n\n    .palette-filter {\n      border: 3px solid #6db33f;\n      font-size:24px;\n      background-color: white;\n    }\n\n    .palette-filter-textfield {\n      width: 100%;\n      border: none;\n      /* border: 3px solid #6db33f;\n     */\tfont-family: \"Varela Round\",sans-serif;\n      /* \tpadding: 2px; */\n    }\n\n    .palette-paper {\n      background-color: #eeeeee;\n      /*\n        border-right: 7px solid;\n        */\n      border-color: #6db33f;\n      /* \twidth: 170px;\n            height:100%;\n                float: left;\n         */\n    }\n\n    .no-matches-label {\n      fill: #777;\n      font-size: 14px;\n    }\n\n    /* Palette END */\n  "],
            encapsulation: ViewEncapsulation.None
        }),
        __param(1, Inject(DOCUMENT)),
        __metadata("design:paramtypes", [ElementRef, Object])
    ], Palette);
    return Palette;
}());

var joint$2 = Flo.joint;
var $$3 = _$;
var Utils = /** @class */ (function () {
    function Utils() {
    }
    Utils.fanRoute = function (graph, cell) {
        if (cell instanceof joint$2.dia.Element) {
            var links = graph.getConnectedLinks(cell);
            var groupsOfOverlappingLinks = groupBy(links, function (link) {
                // the key of the group is the model id of the link's source or target, but not our cell id.
                var sourceId = link.get('source').id;
                var targetId = link.get('target').id;
                return cell.id !== sourceId ? sourceId : targetId;
            });
            each(groupsOfOverlappingLinks, function (group, key) {
                // If the member of the group has both source and target model adjust vertices.
                var toRoute = {};
                if (key !== undefined) {
                    group.forEach(function (link) {
                        if (link.get('source').id === cell.get('id') && link.get('target').id) {
                            toRoute[link.get('target').id] = link;
                        }
                        else if (link.get('target').id === cell.get('id') && link.get('source').id) {
                            toRoute[link.get('source').id] = link;
                        }
                    });
                    Object.keys(toRoute).forEach(function (k) {
                        Utils.fanRoute(graph, toRoute[k]);
                    });
                }
            });
        }
        else if (cell instanceof joint$2.dia.Link) {
            var link = cell;
            // The cell is a link. Let's find its source and target models.
            var src_1 = link.source() || link.previous('source');
            var trg_1 = link.target() || cell.previous('target');
            // If one of the ends is not a model, the link has no siblings.
            if (!src_1.id || !trg_1.id) {
                return;
            }
            var siblings = graph.getLinks().filter(function (sibling) {
                var _src = sibling.source();
                var _trg = sibling.target();
                var vertices = sibling.get('vertices');
                var fanRouted = !vertices || vertices.length === 0 || sibling.get('fanRouted');
                return ((isEqual(_src, src_1) && isEqual(_trg, trg_1)) || (isEqual(_src, trg_1) && isEqual(_trg, src_1))) && fanRouted;
            });
            switch (siblings.length) {
                case 0:
                    // The link was removed and had no siblings.
                    break;
                case 1:
                    // There is only one link between the source and target. No vertices needed.
                    var vertices = cell.get('vertices');
                    if (vertices && vertices.length && cell.get('fanRouted')) {
                        cell.unset('vertices');
                    }
                    break;
                default:
                    // There is more than one siblings. We need to create vertices.
                    // First of all we'll find the middle point of the link.
                    var source = link.getSourceElement();
                    var target = link.getTargetElement();
                    if (!source || !target) {
                        // When clearing the graph it may happen that some nodes are gone and some are left
                        return;
                    }
                    var srcCenter = source.getBBox().center();
                    var trgCenter = target.getBBox().center();
                    var midPoint_1 = joint$2.g.line(srcCenter, trgCenter).midpoint();
                    // Then find the angle it forms.
                    var theta_1 = srcCenter.theta(trgCenter);
                    // This is the maximum distance between links
                    var gap_1 = 20;
                    siblings.forEach(function (sibling, index) {
                        // We want the offset values to be calculated as follows 0, 20, 20, 40, 40, 60, 60 ..
                        var offset = gap_1 * Math.ceil(index / 2);
                        // Now we need the vertices to be placed at points which are 'offset' pixels distant
                        // from the first link and forms a perpendicular angle to it. And as index goes up
                        // alternate left and right.
                        //
                        //  ^  odd indexes
                        //  |
                        //  |---->  index 0 line (straight line between a source center and a target center.
                        //  |
                        //  v  even indexes
                        var sign = index % 2 ? 1 : -1;
                        var angle = joint$2.g.toRad(theta_1 + sign * 90);
                        // We found the vertex.
                        var vertex = joint$2.g.point.fromPolar(offset, angle, midPoint_1);
                        sibling.set('fanRouted', true);
                        sibling.set('vertices', [{ x: vertex.x, y: vertex.y }], { 'fanRouted': true });
                    });
            }
        }
    };
    Utils.isCustomPaperEvent = function (args) {
        return args.length === 5 &&
            isString(args[0]) &&
            (args[0].indexOf('link:') === 0 || args[0].indexOf('element:') === 0) &&
            args[1] instanceof $$3.Event &&
            args[2] instanceof joint$2.dia.CellView &&
            isNumber(args[3]) &&
            isNumber(args[4]);
    };
    return Utils;
}());

var joint$3 = Flo.joint;
var $$4 = _$;
var EditorComponent = /** @class */ (function () {
    function EditorComponent(element) {
        var _this = this;
        this.element = element;
        /**
         * Flag specifying whether the Flo-Editor is in read-only mode.
         */
        this._readOnlyCanvas = false;
        /**
         * Grid size
         */
        this._gridSize = 1;
        this._hiddenPalette = false;
        this.paletteSizeValue = 170;
        this.textToGraphEventEmitter = new EventEmitter();
        this.graphToTextEventEmitter = new EventEmitter();
        this._graphToTextSyncEnabled = true;
        this.validationEventEmitter = new EventEmitter();
        this._disposables = new CompositeDisposable();
        this._dslText = '';
        this.textToGraphConversionCompleted = new Subject();
        this.graphToTextConversionCompleted = new Subject();
        this.paletteReady = new BehaviorSubject(false);
        this.paletteSizeChange = new EventEmitter();
        this.searchFilterPlaceHolder = 'Search...';
        /**
         * Min zoom percent value
         */
        this.minZoom = 5;
        /**
         * Max zoom percent value
         */
        this.maxZoom = 400;
        /**
         * Zoom percent increment/decrement step
         */
        this.zoomStep = 5;
        this.paperPadding = 0;
        this.floApi = new EventEmitter();
        this.validationMarkers = new EventEmitter();
        this.contentValidated = new EventEmitter();
        this.dslChange = new EventEmitter();
        this.onProperties = new EventEmitter();
        this._resizeHandler = function () { return _this.autosizePaper(); };
        var self = this;
        this.editorContext = new (/** @class */ (function () {
            function DefaultRunnableContext() {
            }
            Object.defineProperty(DefaultRunnableContext.prototype, "zoomPercent", {
                get: function () {
                    return self.zoomPercent;
                },
                set: function (percent) {
                    self.zoomPercent = percent;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(DefaultRunnableContext.prototype, "noPalette", {
                get: function () {
                    return self.noPalette;
                },
                set: function (noPalette) {
                    self.noPalette = noPalette;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(DefaultRunnableContext.prototype, "gridSize", {
                get: function () {
                    return self.gridSize;
                },
                set: function (gridSize) {
                    self.gridSize = gridSize;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(DefaultRunnableContext.prototype, "readOnlyCanvas", {
                get: function () {
                    return self.readOnlyCanvas;
                },
                set: function (readOnly) {
                    self.readOnlyCanvas = readOnly;
                },
                enumerable: true,
                configurable: true
            });
            DefaultRunnableContext.prototype.setDsl = function (dsl) {
                self.dsl = dsl;
            };
            DefaultRunnableContext.prototype.updateGraph = function () {
                return self.updateGraphRepresentation();
            };
            DefaultRunnableContext.prototype.updateText = function () {
                return self.updateTextRepresentation();
            };
            DefaultRunnableContext.prototype.performLayout = function () {
                return self.doLayout();
            };
            DefaultRunnableContext.prototype.clearGraph = function () {
                var _this = this;
                self.selection = undefined;
                self.graph.clear();
                if (self.metamodel && self.metamodel.load && self.editor && self.editor.setDefaultContent) {
                    return self.metamodel.load().then(function (data) {
                        self.editor.setDefaultContent(_this, data);
                        if (!self.graphToTextSync) {
                            return self.updateTextRepresentation();
                        }
                    });
                }
                else {
                    if (!self.graphToTextSync) {
                        return self.updateTextRepresentation();
                    }
                }
            };
            DefaultRunnableContext.prototype.getGraph = function () {
                return self.graph;
            };
            DefaultRunnableContext.prototype.getPaper = function () {
                return self.paper;
            };
            Object.defineProperty(DefaultRunnableContext.prototype, "graphToTextSync", {
                get: function () {
                    return self.graphToTextSync;
                },
                set: function (sync) {
                    self.graphToTextSync = sync;
                },
                enumerable: true,
                configurable: true
            });
            DefaultRunnableContext.prototype.getMinZoom = function () {
                return self.minZoom;
            };
            DefaultRunnableContext.prototype.getMaxZoom = function () {
                return self.maxZoom;
            };
            DefaultRunnableContext.prototype.getZoomStep = function () {
                return self.zoomStep;
            };
            DefaultRunnableContext.prototype.fitToPage = function () {
                self.fitToPage();
            };
            DefaultRunnableContext.prototype.createNode = function (metadata, props, position) {
                return self.createNode(metadata, props, position);
            };
            DefaultRunnableContext.prototype.createLink = function (source, target, metadata, props) {
                return self.createLink(source, target, metadata, props);
            };
            Object.defineProperty(DefaultRunnableContext.prototype, "selection", {
                get: function () {
                    return self.selection;
                },
                set: function (newSelection) {
                    self.selection = newSelection;
                },
                enumerable: true,
                configurable: true
            });
            DefaultRunnableContext.prototype.deleteSelectedNode = function () {
                self.deleteSelected();
            };
            DefaultRunnableContext.prototype.delete = function (cell) {
                self.delete(cell);
            };
            Object.defineProperty(DefaultRunnableContext.prototype, "textToGraphConversionObservable", {
                get: function () {
                    return self.textToGraphConversionCompleted;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(DefaultRunnableContext.prototype, "graphToTextConversionObservable", {
                get: function () {
                    return self.graphToTextConversionCompleted;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(DefaultRunnableContext.prototype, "paletteReady", {
                get: function () {
                    return self.paletteReady;
                },
                enumerable: true,
                configurable: true
            });
            return DefaultRunnableContext;
        }()))();
    }
    Object.defineProperty(EditorComponent.prototype, "paletteSize", {
        /**
         * Size (Width) of the palette
         */
        get: function () {
            return this.paletteSizeValue;
        },
        set: function (newSize) {
            this.paletteSizeValue = newSize;
            this.paletteSizeChange.emit(newSize);
        },
        enumerable: true,
        configurable: true
    });
    EditorComponent.prototype.onPropertiesHandle = function () {
        if (this.editorContext.selection) {
            this.onProperties.emit(this.editorContext.selection.model);
        }
    };
    EditorComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.initGraph();
        this.initPaper();
        this.initGraphListeners();
        this.initPaperListeners();
        this.initMetamodel();
        $$4(window).on('resize', this._resizeHandler);
        this._disposables.add(Disposable.create(function () { return $$4(window).off('resize', _this._resizeHandler); }));
        /*
         * Execute resize to get the right size for the SVG element on the editor canvas.
         * Executed via timeout to let angular render the DOM first and elements to have the right width and height
         */
        window.setTimeout(this._resizeHandler);
        this.floApi.emit(this.editorContext);
    };
    EditorComponent.prototype.ngOnDestroy = function () {
        this._disposables.dispose();
    };
    EditorComponent.prototype.deleteSelected = function () {
        if (this.selection) {
            this.delete(this.selection.model);
        }
    };
    EditorComponent.prototype.delete = function (cell) {
        this.graph.trigger('startDeletion', cell);
    };
    Object.defineProperty(EditorComponent.prototype, "noPalette", {
        get: function () {
            return this._hiddenPalette;
        },
        set: function (hidden) {
            this._hiddenPalette = hidden;
            // If palette is not shown ensure that canvas starts from the left==0!
            if (hidden) {
                $$4('#paper-container', this.element.nativeElement).css('left', 0);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(EditorComponent.prototype, "graphToTextSync", {
        get: function () {
            return this._graphToTextSyncEnabled;
        },
        set: function (sync) {
            this._graphToTextSyncEnabled = sync;
            // Try commenting the sync out. Just set the flag but don't kick off graph->text conversion
            // this.performGraphToTextSyncing();
        },
        enumerable: true,
        configurable: true
    });
    EditorComponent.prototype.performGraphToTextSyncing = function () {
        if (this._graphToTextSyncEnabled) {
            this.graphToTextEventEmitter.emit();
        }
    };
    EditorComponent.prototype.createHandle = function (element, kind, action, location) {
        if (!location) {
            var bbox = element.model.getBBox();
            location = bbox.origin().offset(bbox.width / 2, bbox.height / 2);
        }
        var handle = Shapes.Factory.createHandle({
            renderer: this.renderer,
            paper: this.paper,
            parent: element.model,
            kind: kind,
            position: location
        });
        var view = this.paper.findViewByModel(handle);
        view.on('cell:pointerdown', function () {
            if (action) {
                action();
            }
        });
        view.on('cell:mouseover', function () {
            handle.attr('image/filter', {
                name: 'dropShadow',
                args: { dx: 1, dy: 1, blur: 1, color: 'black' }
            });
        });
        view.on('cell:mouseout', function () {
            handle.removeAttr('image/filter');
        });
        view.setInteractivity(false);
        return handle;
    };
    EditorComponent.prototype.removeEmbeddedChildrenOfType = function (element, types) {
        var embeds = element.getEmbeddedCells();
        for (var i = 0; i < embeds.length; i++) {
            if (types.indexOf(embeds[i].get('type')) >= 0) {
                embeds[i].remove();
            }
        }
    };
    Object.defineProperty(EditorComponent.prototype, "selection", {
        get: function () {
            return this._selection;
        },
        set: function (newSelection) {
            var _this = this;
            if (newSelection && (newSelection.model.get('type') === joint$3.shapes.flo.DECORATION_TYPE || newSelection.model.get('type') === joint$3.shapes.flo.HANDLE_TYPE)) {
                newSelection = this.paper.findViewByModel(this.graph.getCell(newSelection.model.get('parent')));
            }
            if (newSelection && (!newSelection.model.attr('metadata') || newSelection.model.attr('metadata/metadata/unselectable'))) {
                newSelection = undefined;
            }
            if (newSelection !== this._selection) {
                if (this._selection) {
                    var elementview = this.paper.findViewByModel(this._selection.model);
                    if (elementview) { // May have been removed from the graph
                        this.removeEmbeddedChildrenOfType(elementview.model, joint$3.shapes.flo.HANDLE_TYPE);
                        elementview.unhighlight();
                    }
                }
                if (newSelection) {
                    newSelection.highlight();
                    if (this.editor && this.editor.createHandles) {
                        this.editor.createHandles(this.editorContext, function (owner, kind, action, location) { return _this.createHandle(owner, kind, action, location); }, newSelection);
                    }
                }
                this._selection = newSelection;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(EditorComponent.prototype, "readOnlyCanvas", {
        get: function () {
            return this._readOnlyCanvas;
        },
        set: function (value) {
            var _this = this;
            if (this._readOnlyCanvas === value) {
                // Nothing to do
                return;
            }
            if (value) {
                this.selection = undefined;
            }
            if (this.graph) {
                this.graph.getLinks().forEach(function (link) {
                    if (value) {
                        link.attr('.link-tools/display', 'none');
                        link.attr('.marker-vertices/display', 'none');
                        link.attr('.connection-wrap/display', 'none');
                    }
                    else {
                        link.removeAttr('.link-tools/display');
                        if (_this.editor && _this.editor.allowLinkVertexEdit) {
                            link.removeAttr('.marker-vertices/display');
                        }
                        link.removeAttr('.connection-wrap/display');
                    }
                });
            }
            this._readOnlyCanvas = value;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Displays graphical feedback for the drag and drop in progress based on current drag and drop descriptor object
     *
     * @param dragDescriptor DnD info object. Has on info on graph node being dragged (drag source) and what it is
     * being dragged over at the moment (drop target)
     */
    EditorComponent.prototype.showDragFeedback = function (dragDescriptor) {
        if (this.editor && this.editor.showDragFeedback) {
            this.editor.showDragFeedback(this.editorContext, dragDescriptor);
        }
        else {
            var magnet = void 0;
            if (dragDescriptor.source && dragDescriptor.source.view) {
                joint$3.V(dragDescriptor.source.view.el).addClass('dnd-source-feedback');
                if (dragDescriptor.source.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.source.view, dragDescriptor.source.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).addClass('dnd-source-feedback');
                    }
                }
            }
            if (dragDescriptor.target && dragDescriptor.target.view) {
                joint$3.V(dragDescriptor.target.view.el).addClass('dnd-target-feedback');
                if (dragDescriptor.target.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.target.view, dragDescriptor.target.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).addClass('dnd-target-feedback');
                    }
                }
            }
        }
    };
    /**
     * Hides graphical feedback for the drag and drop in progress based on current drag and drop descriptor object
     *
     * @param dragDescriptor DnD info object. Has on info on graph node being dragged (drag source) and what it is
     * being dragged over at the moment (drop target)
     */
    EditorComponent.prototype.hideDragFeedback = function (dragDescriptor) {
        if (this.editor && this.editor.hideDragFeedback) {
            this.editor.hideDragFeedback(this.editorContext, dragDescriptor);
        }
        else {
            var magnet = void 0;
            if (dragDescriptor.source && dragDescriptor.source.view) {
                joint$3.V(dragDescriptor.source.view.el).removeClass('dnd-source-feedback');
                if (dragDescriptor.source.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.source.view, dragDescriptor.source.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).removeClass('dnd-source-feedback');
                    }
                }
            }
            if (dragDescriptor.target && dragDescriptor.target.view) {
                joint$3.V(dragDescriptor.target.view.el).removeClass('dnd-target-feedback');
                if (dragDescriptor.target.cssClassSelector) {
                    magnet = Flo.findMagnetByClass(dragDescriptor.target.view, dragDescriptor.target.cssClassSelector);
                    if (magnet) {
                        joint$3.V(magnet).removeClass('dnd-target-feedback');
                    }
                }
            }
        }
    };
    /**
     * Sets the new DnD info object - the descriptor for DnD
     *
     * @param dragDescriptor DnD info object. Has on info on graph node being dragged (drag source) and what it is
     * being dragged over at the moment (drop target)
     */
    EditorComponent.prototype.setDragDescriptor = function (dragDescriptor) {
        if (this.highlighted === dragDescriptor) {
            return;
        }
        if (this.highlighted && dragDescriptor && isEqual(this.highlighted.sourceComponent, dragDescriptor.sourceComponent)) {
            if (this.highlighted.source === dragDescriptor.source && this.highlighted.target === dragDescriptor.target) {
                return;
            }
            if (this.highlighted.source &&
                dragDescriptor.source &&
                this.highlighted.target &&
                dragDescriptor.target &&
                this.highlighted.source.view.model === dragDescriptor.source.view.model &&
                this.highlighted.source.cssClassSelector === dragDescriptor.source.cssClassSelector &&
                this.highlighted.target.view.model === dragDescriptor.target.view.model &&
                this.highlighted.target.cssClassSelector === dragDescriptor.target.cssClassSelector) {
                return;
            }
        }
        if (this.highlighted) {
            this.hideDragFeedback(this.highlighted);
        }
        this.highlighted = dragDescriptor;
        if (this.highlighted) {
            this.showDragFeedback(this.highlighted);
        }
    };
    /**
     * Handles DnD events when a node is being dragged over canvas
     *
     * @param draggedView The Joint JS view object being dragged
     * @param targetUnderMouse The Joint JS view under mouse cursor
     * @param x X coordinate of the mouse on the canvas
     * @param y Y coordinate of the mosue on the canvas
     * @param context DnD context (palette or canvas)
     */
    EditorComponent.prototype.handleNodeDragging = function (draggedView, targetUnderMouse, x, y, sourceComponent) {
        if (this.editor && this.editor.calculateDragDescriptor) {
            this.setDragDescriptor(this.editor.calculateDragDescriptor(this.editorContext, draggedView, targetUnderMouse, joint$3.g.point(x, y), sourceComponent));
        }
    };
    /**
     * Handles DnD drop event when a node is being dragged and dropped on the main canvas
     */
    EditorComponent.prototype.handleNodeDropping = function () {
        if (this.highlighted && this.editor && this.editor.handleNodeDropping) {
            this.editor.handleNodeDropping(this.editorContext, this.highlighted);
        }
        this.setDragDescriptor(undefined);
    };
    /**
     * Hides DOM Node (used to determine drop target DOM element)
     * @param domNode DOM node to hide
     * @returns
     */
    EditorComponent.prototype._hideNode = function (domNode) {
        var oldVisibility = {
            visibility: domNode.style ? domNode.style.display : undefined,
            children: []
        };
        for (var i = 0; i < domNode.children.length; i++) {
            var node = domNode.children.item(i);
            if (node instanceof HTMLElement) {
                oldVisibility.children.push(this._hideNode(node));
            }
        }
        domNode.style.display = 'none';
        return oldVisibility;
    };
    /**
     * Restored DOM node original visibility (used to determine drop target DOM element)
     * @param domNode DOM node to restore visibility of
     * @param oldVisibility original visibility parameter
     */
    EditorComponent.prototype._restoreNodeVisibility = function (domNode, oldVisibility) {
        if (domNode.style) {
            domNode.style.display = oldVisibility.visibility;
        }
        var j = 0;
        for (var i = 0; i < domNode.childNodes.length; i++) {
            if (j < oldVisibility.children.length) {
                var node = domNode.children.item(i);
                if (node instanceof HTMLElement) {
                    this._restoreNodeVisibility(node, oldVisibility.children[j++]);
                }
            }
        }
    };
    /**
     * Unfortunately we can't just use event.target because often draggable shape on the canvas overlaps the target.
     * We can easily find the element(s) at location, but only nodes :-( Unclear how to find links at location
     * (bounding box of a link for testing is bad).
     * The result of that is that links can only be the drop target when dragging from the palette currently.
     * When DnDing shapes on the canvas drop target cannot be a link.
     *
     * Excluded views enables you to choose to filter some possible answers (useful in the case where elements are stacked
     * - e.g. Drag-n-Drop)
     */
    EditorComponent.prototype.getTargetViewFromEvent = function (event, x, y, excludeViews) {
        var _this = this;
        if (excludeViews === void 0) { excludeViews = []; }
        if (!x && !y) {
            var l = this.paper.snapToGrid({ x: event.clientX, y: event.clientY });
            x = l.x;
            y = l.y;
        }
        // TODO: See if next code paragraph is needed. Most likely it's just code executed for nothing
        // let elements = this.graph.findModelsFromPoint(joint.g.point(x, y));
        // let underMouse = elements.find(e => !_.isUndefined(excludeViews.find(x => x === this.paper.findViewByModel(e))));
        // if (underMouse) {
        //   return underMouse;
        // }
        var oldVisibility = excludeViews.map(function (_x) { return _this._hideNode(_x.el); });
        var targetElement = document.elementFromPoint(event.clientX, event.clientY);
        excludeViews.forEach(function (excluded, i) {
            _this._restoreNodeVisibility(excluded.el, oldVisibility[i]);
        });
        return this.paper.findView($$4(targetElement));
    };
    EditorComponent.prototype.handleDnDFromPalette = function (dndEvent) {
        switch (dndEvent.type) {
            case Flo.DnDEventType.DRAG:
                this.handleDragFromPalette(dndEvent);
                break;
            case Flo.DnDEventType.DROP:
                this.handleDropFromPalette(dndEvent);
                break;
            default:
                break;
        }
    };
    EditorComponent.prototype.handleDragFromPalette = function (dnDEvent) {
        console.debug('Dragging from palette');
        if (dnDEvent.view && !this.readOnlyCanvas) {
            var location_1 = this.paper.snapToGrid({ x: dnDEvent.event.clientX, y: dnDEvent.event.clientY });
            this.handleNodeDragging(dnDEvent.view, this.getTargetViewFromEvent(dnDEvent.event, location_1.x, location_1.y, [dnDEvent.view]), location_1.x, location_1.y, Constants.PALETTE_CONTEXT);
        }
    };
    EditorComponent.prototype.createNode = function (metadata, props, position) {
        return Shapes.Factory.createNode({
            renderer: this.renderer,
            paper: this.paper,
            metadata: metadata,
            props: props,
            position: position
        });
    };
    EditorComponent.prototype.createLink = function (source, target, metadata, props) {
        return Shapes.Factory.createLink({
            renderer: this.renderer,
            paper: this.paper,
            source: source,
            target: target,
            metadata: metadata,
            props: props
        });
    };
    EditorComponent.prototype.handleDropFromPalette = function (event) {
        var cellview = event.view;
        var evt = event.event;
        if (this.paper.el === evt.target || $$4.contains(this.paper.el, evt.target)) {
            if (this.readOnlyCanvas) {
                this.setDragDescriptor(undefined);
            }
            else {
                var metadata = cellview.model.attr('metadata');
                var props = cellview.model.attr('props');
                var position = this.paper.snapToGrid({ x: evt.clientX, y: evt.clientY });
                /* Calculate target element before creating the new
                 * element under mouse location. Otherwise target
                 * element would be the newly created element because
                 * it's under the mouse pointer
                 */
                var targetElement = this.getTargetViewFromEvent(evt, position.x, position.y, [event.view]);
                var newNode = this.createNode(metadata, props, position);
                var newView = this.paper.findViewByModel(newNode);
                this.handleNodeDragging(newView, targetElement, position.x, position.y, Constants.PALETTE_CONTEXT);
                this.handleNodeDropping();
            }
        }
    };
    EditorComponent.prototype.fitToContent = function (gridWidth, gridHeight, padding, opt) {
        var paper = this.paper;
        if (joint$3.util.isObject(gridWidth)) {
            // first parameter is an option object
            opt = gridWidth;
            gridWidth = opt.gridWidth || 1;
            gridHeight = opt.gridHeight || 1;
            padding = opt.padding || 0;
        }
        else {
            opt = opt || {};
            gridWidth = gridWidth || 1;
            gridHeight = gridHeight || 1;
            padding = padding || 0;
        }
        var paddingJson = joint$3.util.normalizeSides(padding);
        // Calculate the paper size to accomodate all the graph's elements.
        var bbox = joint$3.V(paper.viewport).getBBox();
        var currentScale = paper.scale();
        var currentTranslate = paper.translate();
        bbox.x *= currentScale.sx;
        bbox.y *= currentScale.sy;
        bbox.width *= currentScale.sx;
        bbox.height *= currentScale.sy;
        var calcWidth = Math.max((bbox.width + bbox.x) / gridWidth, 1) * gridWidth;
        var calcHeight = Math.max((bbox.height + bbox.y) / gridHeight, 1) * gridHeight;
        var tx = 0;
        var ty = 0;
        if ((opt.allowNewOrigin === 'negative' && bbox.x < 0) || (opt.allowNewOrigin === 'positive' && bbox.x >= 0) || opt.allowNewOrigin === 'any') {
            tx = (-bbox.x / gridWidth) * gridWidth;
            tx += paddingJson.left;
        }
        else if (opt.allowNewOrigin === 'same') {
            tx = currentTranslate.tx;
        }
        calcWidth += tx;
        if ((opt.allowNewOrigin === 'negative' && bbox.y < 0) || (opt.allowNewOrigin === 'positive' && bbox.y >= 0) || opt.allowNewOrigin === 'any') {
            ty = (-bbox.y / gridHeight) * gridHeight;
            ty += paddingJson.top;
        }
        else if (opt.allowNewOrigin === 'same') {
            ty = currentTranslate.ty;
        }
        calcHeight += ty;
        calcWidth += paddingJson.right;
        calcHeight += paddingJson.bottom;
        // Make sure the resulting width and height are greater than minimum.
        calcWidth = Math.max(calcWidth, opt.minWidth || 0);
        calcHeight = Math.max(calcHeight, opt.minHeight || 0);
        // Make sure the resulting width and height are lesser than maximum.
        calcWidth = Math.min(calcWidth, opt.maxWidth || Number.MAX_VALUE);
        calcHeight = Math.min(calcHeight, opt.maxHeight || Number.MAX_VALUE);
        var dimensionChange = calcWidth !== paper.options.width || calcHeight !== paper.options.height;
        var originChange = tx !== currentTranslate.tx || ty !== currentTranslate.ty;
        // Change the dimensions only if there is a size discrepency or an origin change
        if (originChange) {
            paper.translate(tx, ty);
        }
        if (dimensionChange) {
            paper.setDimensions(calcWidth, calcHeight);
        }
    };
    EditorComponent.prototype.autosizePaper = function () {
        var parent = $$4('#paper-container', this.element.nativeElement);
        var parentWidth = parent.innerWidth();
        var parentHeight = parent.innerHeight();
        this.fitToContent(this.gridSize, this.gridSize, this.paperPadding, {
            minWidth: parentWidth - Flo.SCROLLBAR_WIDTH,
            minHeight: parentHeight - Flo.SCROLLBAR_WIDTH,
            allowNewOrigin: 'same'
        });
    };
    EditorComponent.prototype.fitToPage = function () {
        var parent = $$4('#paper-container', this.element.nativeElement);
        var minScale = this.minZoom / 100;
        var maxScale = 2;
        var parentWidth = parent.innerWidth();
        var parentHeight = parent.innerHeight();
        this.paper.scaleContentToFit({
            padding: this.paperPadding,
            minScaleX: minScale,
            minScaleY: minScale,
            maxScaleX: maxScale,
            maxScaleY: maxScale,
            fittingBBox: { x: 0, y: 0, width: parentWidth - Flo.SCROLLBAR_WIDTH, height: parentHeight - Flo.SCROLLBAR_WIDTH }
        });
        /**
         * Size the canvas appropriately and allow origin movement
         */
        this.fitToContent(this.gridSize, this.gridSize, this.paperPadding, {
            minWidth: parentWidth,
            minHeight: parentHeight,
            maxWidth: parentWidth,
            maxHeight: parentHeight,
            allowNewOrigin: 'any'
        });
    };
    Object.defineProperty(EditorComponent.prototype, "zoomPercent", {
        get: function () {
            return Math.round(this.paper.scale().sx * 100);
        },
        set: function (percent) {
            if (!isNaN(percent)) {
                if (percent < this.minZoom) {
                    percent = this.minZoom;
                }
                else if (percent >= this.maxZoom) {
                    percent = this.maxZoom;
                }
                else {
                    if (percent <= 0) {
                        percent = 0.00001;
                    }
                }
                this.paper.scale(percent / 100, percent / 100);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(EditorComponent.prototype, "gridSize", {
        get: function () {
            return this._gridSize;
        },
        set: function (size) {
            if (!isNaN(size) && size >= 1) {
                this._gridSize = size;
                if (this.paper) {
                    this.paper.setGridSize(size);
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    EditorComponent.prototype.validateContent = function () {
        var _this = this;
        return new Promise(function (resolve) {
            if (_this.editor && _this.editor.validate) {
                return _this.editor
                    .validate(_this.graph, _this.dsl, _this.editorContext)
                    .then(function (allMarkers) {
                    _this.graph.getCells()
                        .forEach(function (cell) { return _this.markElement(cell, allMarkers.has(cell.id) ? allMarkers.get(cell.id) : []); });
                    _this.validationMarkers.emit(allMarkers);
                    _this.contentValidated.emit(true);
                    resolve();
                });
            }
            else {
                resolve();
            }
        });
    };
    EditorComponent.prototype.markElement = function (cell, markers) {
        cell.set('markers', markers);
        // Old legacy code below consider removing
        var errorMessages = markers.map(function (m) { return m.message; });
        var errorCell = cell.getEmbeddedCells().find(function (e) { return e.attr('./kind') === Constants.ERROR_DECORATION_KIND; });
        if (errorCell) {
            if (errorMessages.length === 0) {
                errorCell.remove();
            }
            else {
                // Without rewrite we merge this list with existing errors
                errorCell.attr('messages', errorMessages, { rewrite: true });
            }
        }
        else if (errorMessages.length > 0) {
            var error = Shapes.Factory.createDecoration({
                renderer: this.renderer,
                paper: this.paper,
                parent: cell,
                kind: Constants.ERROR_DECORATION_KIND,
                messages: errorMessages
            });
            if (error) {
                var view = this.paper.findViewByModel(error);
                view.setInteractivity(false);
            }
        }
    };
    EditorComponent.prototype.doLayout = function () {
        if (this.renderer && this.renderer.layout) {
            return this.renderer.layout(this.paper);
        }
    };
    Object.defineProperty(EditorComponent.prototype, "dsl", {
        get: function () {
            return this._dslText;
        },
        set: function (dslText) {
            if (this._dslText !== dslText) {
                this._dslText = dslText;
                this.textToGraphEventEmitter.emit();
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Ask the server to parse the supplied text into a JSON graph of nodes and links,
     * then update the view based on that new information.
     */
    EditorComponent.prototype.updateGraphRepresentation = function () {
        var _this = this;
        console.debug("Updating graph to represent '" + this._dslText + "'");
        if (this.metamodel && this.metamodel.textToGraph) {
            return this.metamodel.textToGraph(this.editorContext, this._dslText).then(function () {
                _this.textToGraphConversionCompleted.next();
                return _this.validateContent();
            });
        }
        else {
            this.textToGraphConversionCompleted.next();
            return this.validateContent();
        }
    };
    EditorComponent.prototype.updateTextRepresentation = function () {
        var _this = this;
        if (this.metamodel && this.metamodel.graphToText) {
            return this.metamodel.graphToText(this.editorContext).then(function (text) {
                if (_this._dslText !== text) {
                    _this._dslText = text;
                    _this.dslChange.emit(text);
                }
                _this.graphToTextConversionCompleted.next();
                return _this.validateContent();
            })
                .catch(function (error) {
                // Validation may reveal why the graph couldn't be
                // converted so let it run
                _this.graphToTextConversionCompleted.next();
                return _this.validateContent();
            });
        }
        else {
            this.graphToTextConversionCompleted.next();
            return this.validateContent();
        }
    };
    EditorComponent.prototype.initMetamodel = function () {
        var _this = this;
        this.metamodel.load().then(function (data) {
            _this.updateGraphRepresentation();
            var textSyncSubscription = _this.graphToTextEventEmitter.pipe(debounceTime(100)).subscribe(function () {
                if (_this._graphToTextSyncEnabled) {
                    _this.updateTextRepresentation();
                }
            });
            _this._disposables.add(Disposable.create(function () { return textSyncSubscription.unsubscribe(); }));
            // Setup content validated event emitter. Emit not validated when graph to text conversion required
            var graphValidatedSubscription1 = _this.graphToTextEventEmitter.subscribe(function () { return _this.contentValidated.emit(false); });
            _this._disposables.add(Disposable.create(function () { return graphValidatedSubscription1.unsubscribe; }));
            // let validationSubscription = this.validationEventEmitter.pipe(debounceTime(100)).subscribe(() => this.validateGraph());
            // this._disposables.add(Disposable.create(() => validationSubscription.unsubscribe()));
            var graphSyncSubscription = _this.textToGraphEventEmitter.pipe(debounceTime(300)).subscribe(function () { return _this.updateGraphRepresentation(); });
            _this._disposables.add(Disposable.create(function () { return graphSyncSubscription.unsubscribe(); }));
            // Setup content validated event emitter. Emit not validated when text to graph conversion required
            var graphValidatedSubscription2 = _this.textToGraphEventEmitter.subscribe(function () { return _this.contentValidated.emit(false); });
            _this._disposables.add(Disposable.create(function () { return graphValidatedSubscription2.unsubscribe; }));
            if (_this.editor && _this.editor.setDefaultContent) {
                _this.editor.setDefaultContent(_this.editorContext, data);
            }
        });
    };
    EditorComponent.prototype.initGraph = function () {
        this.graph = new joint$3.dia.Graph();
        this.graph.set('type', Constants.CANVAS_CONTEXT);
        this.graph.set('paperPadding', this.paperPadding);
    };
    EditorComponent.prototype.handleNodeCreation = function (node) {
        var _this = this;
        node.on('change:size', this._resizeHandler);
        node.on('change:position', this._resizeHandler);
        if (node.attr('metadata')) {
            node.on('change:attrs', function (cell, attrs, changeData) {
                var propertyPath = changeData ? changeData.propertyPath : undefined;
                if (propertyPath) {
                    var propAttr = propertyPath.substr(propertyPath.indexOf('/') + 1);
                    if (propAttr.indexOf('metadata') === 0 ||
                        propAttr.indexOf('props') === 0 ||
                        (_this.renderer && _this.renderer.isSemanticProperty && _this.renderer.isSemanticProperty(propAttr, node))) {
                        _this.performGraphToTextSyncing();
                    }
                    if (_this.renderer && _this.renderer.refreshVisuals) {
                        _this.renderer.refreshVisuals(node, propAttr, _this.paper);
                    }
                }
            });
        }
        node.on('change:markers', function () {
            if (_this.renderer && _this.renderer.markersChanged) {
                _this.renderer.markersChanged(node, _this.paper);
            }
        });
    };
    /**
     * Forwards a link event occurrence to any handlers in the editor service, if they are defined. Event examples
     * are 'change:source', 'change:target'.
     */
    EditorComponent.prototype.handleLinkEvent = function (event, link) {
        if (this.renderer && this.renderer.handleLinkEvent) {
            this.renderer.handleLinkEvent(this.editorContext, event, link);
        }
    };
    EditorComponent.prototype.handleLinkCreation = function (link) {
        var _this = this;
        link.on('change:source', function (l) {
            _this.autosizePaper();
            var newSourceId = l.get('source').id;
            var oldSourceId = l.previous('source').id;
            if (newSourceId !== oldSourceId) {
                _this.performGraphToTextSyncing();
            }
            _this.handleLinkEvent('change:source', l);
        });
        link.on('change:target', function (l) {
            _this.autosizePaper();
            var newTargetId = l.get('target').id;
            var oldTargetId = l.previous('target').id;
            if (newTargetId !== oldTargetId) {
                _this.performGraphToTextSyncing();
            }
            _this.handleLinkEvent('change:target', l);
        });
        link.on('change:vertices', this._resizeHandler);
        link.on('change:attrs', function (cell, attrs, changeData) {
            var propertyPath = changeData ? changeData.propertyPath : undefined;
            if (propertyPath) {
                var propAttr = propertyPath.substr(propertyPath.indexOf('/') + 1);
                if (propAttr.indexOf('metadata') === 0 ||
                    propAttr.indexOf('props') === 0 ||
                    (_this.renderer && _this.renderer.isSemanticProperty && _this.renderer.isSemanticProperty(propAttr, link))) {
                    var sourceId = link.get('source').id;
                    var targetId = link.get('target').id;
                    _this.performGraphToTextSyncing();
                }
                if (_this.renderer && _this.renderer.refreshVisuals) {
                    _this.renderer.refreshVisuals(link, propAttr, _this.paper);
                }
            }
        });
        this.paper.findViewByModel(link).on('link:options', function () { return _this.handleLinkEvent('options', link); });
        if (this.readOnlyCanvas) {
            link.attr('.link-tools/display', 'none');
        }
        this.handleLinkEvent('add', link);
    };
    EditorComponent.prototype.initGraphListeners = function () {
        var _this = this;
        this.graph.on('add', function (element) {
            if (element instanceof joint$3.dia.Link) {
                _this.handleLinkCreation(element);
            }
            else if (element instanceof joint$3.dia.Element) {
                _this.handleNodeCreation(element);
            }
            if (element.get('type') === joint$3.shapes.flo.NODE_TYPE || element.get('type') === joint$3.shapes.flo.LINK_TYPE) {
                _this.performGraphToTextSyncing();
            }
            _this.autosizePaper();
        });
        this.graph.on('remove', function (element) {
            if (element instanceof joint$3.dia.Link) {
                _this.handleLinkEvent('remove', element);
            }
            if (_this.selection && _this.selection.model === element) {
                _this.selection = undefined;
            }
            if (element.isLink()) {
                window.setTimeout(function () { return _this.performGraphToTextSyncing(); }, 100);
            }
            else if (element.get('type') === joint$3.shapes.flo.NODE_TYPE) {
                _this.performGraphToTextSyncing();
            }
            _this.autosizePaper();
        });
        // Set if link is fan-routed. Should be called before routing call
        this.graph.on('change:vertices', function (link, changed, opt) {
            if (opt.fanRouted) {
                link.set('fanRouted', true);
            }
            else {
                link.unset('fanRouted');
            }
        });
        // adjust vertices when a cell is removed or its source/target was changed
        this.graph.on('add remove change:source change:target change:vertices change:position', partial(Utils.fanRoute, this.graph));
        this.graph.on('startDeletion', function (cell) {
            if (_this.editor && _this.editor.preDelete) {
                if (_this.editor.preDelete(_this.editorContext, _this.selection.model)) {
                    cell.remove();
                }
            }
            else {
                cell.remove();
            }
        });
    };
    EditorComponent.prototype.initPaperListeners = function () {
        var _this = this;
        // https://stackoverflow.com/questions/20463533/how-to-add-an-onclick-event-to-a-joint-js-element
        this.paper.on('cell:pointerup', function (cellView) {
            if (!_this.readOnlyCanvas) {
                _this.selection = cellView;
            }
        });
        this.paper.on('blank:pointerdown', function () {
            _this.selection = undefined;
        });
        this.paper.on('scale', this._resizeHandler);
        this.paper.on('all', function () {
            if (Utils.isCustomPaperEvent(arguments)) {
                arguments[2].trigger.apply(arguments[2], [arguments[0], arguments[1], arguments[3], arguments[4]]);
            }
        });
        this.paper.on('dragging-node-over-canvas', function (dndEvent) {
            console.debug("Canvas DnD type = " + dndEvent.type);
            var location = _this.paper.snapToGrid({ x: dndEvent.event.clientX, y: dndEvent.event.clientY });
            switch (dndEvent.type) {
                case Flo.DnDEventType.DRAG:
                    _this.handleNodeDragging(dndEvent.view, _this.getTargetViewFromEvent(dndEvent.event, location.x, location.y, [dndEvent.view]), location.x, location.y, Constants.CANVAS_CONTEXT);
                    break;
                case Flo.DnDEventType.DROP:
                    _this.handleNodeDropping();
                    break;
                default:
                    break;
            }
        });
        // JointJS now no longer grabs focus if working in a paper element - crude...
        // $('#flow-view', this.element.nativeElement).on('mousedown', () => {
        // $('#palette-filter-textfield', this.element.nativeElement).focus();
        // });
    };
    EditorComponent.prototype.initPaper = function () {
        var _this = this;
        var options = {
            el: $$4('#paper', this.element.nativeElement),
            gridSize: this._gridSize,
            drawGrid: true,
            model: this.graph,
            elementView: this.renderer && this.renderer.getNodeView ? this.renderer.getNodeView() : joint$3.shapes.flo.ElementView /*joint.dia.ElementView*/,
            linkView: this.renderer && this.renderer.getLinkView ? this.renderer.getLinkView() : joint$3.shapes.flo.LinkView,
            // Enable link snapping within 25px lookup radius
            snapLinks: { radius: 25 },
            defaultLink: /*this.renderer && this.renderer.createDefaultLink ? this.renderer.createDefaultLink: new joint.shapes.flo.Link*/ function (cellView, magnet) {
                if (_this.renderer && _this.renderer.createLink) {
                    var linkEnd = {
                        id: cellView.model.id
                    };
                    if (magnet) {
                        linkEnd.selector = cellView.getSelector(magnet, undefined);
                    }
                    if (magnet.getAttribute('port')) {
                        linkEnd.port = magnet.getAttribute('port');
                    }
                    if (magnet.getAttribute('port') === 'input') {
                        return _this.renderer.createLink(undefined, linkEnd);
                    }
                    else {
                        return _this.renderer.createLink(linkEnd, undefined);
                    }
                }
                else {
                    return new joint$3.shapes.flo.Link();
                }
            },
            // decide whether to create a link if the user clicks a magnet
            validateMagnet: function (cellView, magnet) {
                if (_this.readOnlyCanvas) {
                    return false;
                }
                else {
                    if (_this.editor && _this.editor.validatePort) {
                        return _this.editor.validatePort(_this.editorContext, cellView, magnet);
                    }
                    else {
                        return true;
                    }
                }
            },
            interactive: function (cellView, event) {
                if (_this.readOnlyCanvas) {
                    return false;
                }
                else {
                    if (_this.editor && _this.editor.interactive) {
                        if (typeof _this.editor.interactive === 'function') {
                            // Type for interactive is wrong in JointJS have to cast to <any>
                            return _this.editor.interactive(cellView, event);
                        }
                        else {
                            return _this.editor.interactive;
                        }
                    }
                    return true;
                }
            },
            highlighting: this.editor && this.editor.highlighting ? this.editor.highlighting : {
                'default': {
                    name: 'addClass',
                    options: {
                        className: 'highlighted'
                    }
                }
            },
            markAvailable: true
        };
        if (this.renderer && this.renderer.getLinkAnchorPoint) {
            options.linkConnectionPoint = this.renderer.getLinkAnchorPoint;
        }
        if (this.editor && this.editor.validateLink) {
            var self_1 = this;
            options.validateConnection = function (cellViewS, magnetS, cellViewT, magnetT, end, linkView) {
                return self_1.editor.validateLink(_this.editorContext, cellViewS, magnetS, cellViewT, magnetT, end === 'source', linkView);
            };
        }
        // The paper is what will represent the graph on the screen
        this.paper = new joint$3.dia.Paper(options);
        this._disposables.add(Disposable.create(function () { return _this.paper.remove(); }));
        this.paper.options.highlighterNamespace['addParentClass'] = {
            /**
             * @param {joint.dia.CellView} cellView
             * @param {Element} magnetEl
             * @param {object=} opt
             */
            highlight: function (cellView, magnetEl, opt) {
                opt = opt || {};
                var className = opt.className || this.className;
                joint$3.V(magnetEl.parentElement).addClass(className);
            },
            /**
             * @param {joint.dia.CellView} cellView
             * @param {Element} magnetEl
             * @param {object=} opt
             */
            unhighlight: function (cellView, magnetEl, opt) {
                opt = opt || {};
                var className = opt.className || this.className;
                joint$3.V(magnetEl.parentElement).removeClass(className);
            }
        };
    };
    EditorComponent.prototype.updatePaletteReadyState = function (ready) {
        this.paletteReady.next(ready);
    };
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "metamodel", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "renderer", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "editor", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], EditorComponent.prototype, "paletteSize", null);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "paletteSizeChange", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "searchFilterPlaceHolder", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "paletteEntryPadding", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "minZoom", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "maxZoom", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "zoomStep", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "paperPadding", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "floApi", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "validationMarkers", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "contentValidated", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "dslChange", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], EditorComponent.prototype, "onProperties", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], EditorComponent.prototype, "dsl", null);
    EditorComponent = __decorate([
        Component({
            selector: 'flo-editor',
            template: "\n    <ng-content select=\"[header]\"></ng-content>\n    <div id=\"flow-view\" class=\"flow-view\" style=\"position:relative\">\n      <div id=\"canvas\" class=\"canvas\" style=\"position:relative; display: block; width: 100%; height: 100%;\">\n        <div *ngIf=\"!noPalette\" id=\"palette-container\" class=\"palette-container\" style=\"overflow:hidden;\">\n          <flo-palette [metamodel]=\"metamodel\" [renderer]=\"renderer\" [paletteSize]=\"paletteSize\"\n                       [paletteEntryPadding]=\"paletteEntryPadding || {width: 12, height: 12}\"\n                       (onPaletteEntryDrop)=\"handleDnDFromPalette($event)\"\n                        (paletteReady)=\"updatePaletteReadyState($event)\"\n                        (paletteFocus)=\"graphToTextSync=true\"\n                        [searchFilterPlaceHolder]=\"searchFilterPlaceHolder\">\n          </flo-palette>\n        </div>\n\n        <div id=\"sidebar-resizer\" *ngIf=\"!noPalette\"\n          resizer\n          [splitSize]=\"paletteSize\"\n          (sizeChange)=\"paletteSize = $event\"\n          [resizerWidth]=\"6\"\n          [resizerLeft]=\"'#palette-container'\"\n          [resizerRight]=\"'#paper-container'\">\n        </div>\n\n          <flo-editor-paper tabindex=\"0\" (onDelete)=\"deleteSelected()\" (onBlur)=\"selection = null\"\n                            (onProperties)=\"onPropertiesHandle()\">\n            <div id=\"paper\" class=\"paper\" tabindex=\"0\" style=\"overflow: hidden; position: absolute; display: block; height:100%; width:100%; overflow:auto;\"></div>\n            <ng-content select=\"[canvas]\"></ng-content>\n          </flo-editor-paper>\n\n          <span class=\"canvas-controls-container\" ng-if=\"canvasControls\">\n            <table ng-if=\"canvasControls.zoom\" class=\"canvas-control zoom-canvas-control\">\n              <tbody>\n                <tr>\n                  <td>\n                    <input class=\"zoom-canvas-input canvas-control zoom-canvas-control\" type=\"text\"\n                           data-inline=\"true\" [(ngModel)]=\"zoomPercent\"\n                           size=\"3\">\n                  </td>\n                  <td>\n                    <label class=\"canvas-control zoom-canvas-label\">%</label>\n                  </td>\n                  <td>\n                    <input type=\"range\" data-inline=\"true\" [(ngModel)]=\"zoomPercent\"\n                           [step]=\"zoomStep\"\n                           [max]=\"maxZoom\" [min]=\"minZoom\" data-type=\"range\"\n                           name=\"range\" class=\"canvas-control zoom-canvas-control\">\n                  </td>\n                </tr>\n              </tbody>\n            </table>\n          </span>\n\n      </div>\n    </div>\n    <ng-content select=\"[footer]\"></ng-content>\n  ",
            styles: ["\n    flo-view {\n      width:100%;\n      height:100%;\n      margin: 0;\n      background-color: #eeeeee;\n      font-family: \"Varela Round\",sans-serif;\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n    }\n\n    .canvas {\n      border: 1px solid;\n      border-color: #6db33f;\n      border-radius: 2px;\n      margin-top: 3px;\n    }\n\n    /* Canvas contains the palette on the left and the paper on the right */\n\n    .paper {\n      padding: 0px;\n      background-color: #ffffff;\n      /* \theight: 100%;\n          width: 100%;\n          position: relative;\n          overflow: hidden;\n       *//* \tmargin-left: 400px; */\n    }\n\n    #sidebar-resizer {\n      background-color: #34302d;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      width: 6px;\n      cursor: e-resize;\n    }\n\n    #palette-container {\n      background-color: #EEE;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      left: 0;\n      overflow: auto;\n    }\n\n    #paper-container {\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      right: 0;\n      overflow: auto;\n      color: #FFF;\n      background-color: #FFF;\n      outline: none;\n    }\n\n    /* Tooltip START */\n\n    .node-tooltip .tooltip-description {\n      margin-top: 5px;\n      margin-left: 0px;\n      margin-bottom: 5px;\n    }\n\n    .node-tooltip {\n      display:none;\n      position:absolute;\n      border:1px solid #333;\n      background-color:#34302d;/*#161616;*/\n      border-radius:5px;\n      padding:5px;\n      color:#fff;\n      /*\tfont-size:12px Arial;*/\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 19px;\n      z-index: 100;\n    }\n\n    .tooltip-title-type {\n      font-size: 24px;\n      font-weight: bold;\n    }\n\n    .tooltip-title-group {\n      padding-left: 5px;\n      font-size: 20px;\n      font-style: italic;\n    }\n\n    .node-tooltip-option-name {\n      font-family: monospace;/*\"Varela Round\",sans-serif;*/\n      font-size: 17px;\n      font-weight: bold;\n      padding-right: 20px;\n\n    }\n\n    .node-tooltip-option-description {\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 18px;\n    }\n\n    /* Tooltip END */\n\n\n    /* Validation Error Marker on Canvas START */\n\n    .error-tooltip p {\n      margin-top: 5px;\n      margin-left: 0px;\n      margin-bottom: 5px;\n      color:#fff;\n    }\n    .error-tooltip {\n      display:none;\n      position:absolute;\n      border:1px solid #333;\n      background-color:red;/*#161616;*/\n      border-radius:5px;\n      padding:5px;\n      color:#fff;\n      /*\tfont-size:12px Arial;*/\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 20px;\n      z-index: 100;\n    }\n\n    /* Validation Error Marker on Canvas END */\n\n    /* Controls on Canvas START */\n\n    .canvas-controls-container {\n      position: absolute;\n      right: 15px;\n      top: 5px;\n    }\n\n    .canvas-control {\n      background: transparent;\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 11px;\n      vertical-align: middle;\n      margin: 0px;\n    }\n\n    .zoom-canvas-control {\n      border: 0px;\n      padding: 0px;\n      margin: 0px;\n      outline: none;\n    }\n\n    .zoom-canvas-input {\n      text-align: right;\n      font-weight:bold;\n      color: black;\n      background-color: transparent;\n    }\n\n    .zoom-canvas-label {\n      padding-right: 4px;\n      color: black;\n    }\n\n    /* Controls on Canvas END */\n\n\n\n\n    /* START - FLO CANVAS STYLES - override joint js styles */\n\n    .highlighted {\n      outline: none;\n    }\n\n    .joint-type-handle {\n      cursor: pointer;\n    }\n\n    .available-magnet {\n      stroke-width: 3;\n    }\n\n    .link {\n      fill: none;\n      stroke: #ccc;\n      stroke-width: 1.5px;\n    }\n\n    .link-tools .tool-options {\n      display: none;       /* by default, we don't display link options tool */\n    }\n\n    /* Make transparent the circle around the link-tools (cog) icon. It'll allow shape to have a circle clicking area */\n    .link-tools .tool-options circle {\n      fill: transparent;\n      stroke: transparent;\n    }\n\n    .link-tools .tool-options path {\n      fill: black;\n      stroke: black;\n    }\n\n    .link-tools .tool-remove circle {\n      fill: red;\n      stroke: red;\n    }\n\n    .link-tools .tool-remove path {\n      fill: white;\n      stroke: white;\n    }\n\n    .link-tools-container {\n      stroke-width: 0;\n      fill: transparent;\n    }\n\n    /* END - FLO CANVAS STYLES */\n  "],
            encapsulation: ViewEncapsulation.None
        }),
        __metadata("design:paramtypes", [ElementRef])
    ], EditorComponent);
    return EditorComponent;
}());

var $$5 = _$;
var ResizerDirective = /** @class */ (function () {
    function ResizerDirective(element, document) {
        var _this = this;
        this.element = element;
        this.document = document;
        this.dragInProgress = false;
        this.vertical = true;
        this._subscriptions = new CompositeDisposable();
        this.sizeChange = new EventEmitter();
        this.mouseMoveHandler = function (e) {
            if (_this.dragInProgress) {
                _this.mousemove(e);
            }
        };
    }
    Object.defineProperty(ResizerDirective.prototype, "splitSize", {
        set: function (splitSize) {
            if (this.maxSplitSize && splitSize > this.maxSplitSize) {
                splitSize = this.maxSplitSize;
            }
            if (this.vertical) {
                // Handle vertical resizer
                $$5(this.element.nativeElement).css({
                    left: splitSize + 'px'
                });
                $$5(this.first).css({
                    width: splitSize + 'px'
                });
                $$5(this.second).css({
                    left: (splitSize + this._size) + 'px'
                });
            }
            else {
                // Handle horizontal resizer
                $$5(this.element.nativeElement).css({
                    bottom: splitSize + 'px'
                });
                $$5(this.first).css({
                    bottom: (splitSize + this._size) + 'px'
                });
                $$5(this.second).css({
                    height: splitSize + 'px'
                });
            }
            this._splitSize = splitSize;
            // Update the local field
            this.sizeChange.emit(splitSize);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ResizerDirective.prototype, "resizerWidth", {
        set: function (width) {
            this._size = width;
            this.vertical = true;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ResizerDirective.prototype, "resizerHeight", {
        set: function (height) {
            this._size = height;
            this.vertical = false;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ResizerDirective.prototype, "resizerLeft", {
        set: function (first) {
            this.first = first;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ResizerDirective.prototype, "resizerTop", {
        set: function (first) {
            this.first = first;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ResizerDirective.prototype, "resizerRight", {
        set: function (second) {
            this.second = second;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ResizerDirective.prototype, "resizerBottom", {
        set: function (second) {
            this.second = second;
        },
        enumerable: true,
        configurable: true
    });
    ResizerDirective.prototype.startDrag = function () {
        this.dragInProgress = true;
    };
    ResizerDirective.prototype.mousemove = function (event) {
        var size;
        if (this.vertical) { // Handle vertical resizer. Calculate new size relative to palette container DOM node
            size = event.pageX - $$5(this.first).offset().left;
        }
        else {
            // Handle horizontal resizer Calculate new size relative to palette container DOM node
            size = window.innerHeight - event.pageY - $$5(this.second).offset().top;
        }
        this.splitSize = size;
    };
    ResizerDirective.prototype.ngOnInit = function () {
        // Need to set left and right elements width and fire events on init when DOM is built
        var _this = this;
        this.splitSize = this._splitSize;
        var subscription1 = fromEvent($$5(this.document).get(0), 'mousemove')
            .pipe(sampleTime(300))
            .subscribe(this.mouseMoveHandler);
        this._subscriptions.add(Disposable.create(function () { return subscription1.unsubscribe(); }));
        var subscription2 = fromEvent($$5(this.document).get(0), 'mouseup')
            .subscribe(function (e) {
            if (_this.dragInProgress) {
                _this.mousemove(e);
                _this.dragInProgress = false;
            }
        });
        this._subscriptions.add(Disposable.create(function () { return subscription2.unsubscribe(); }));
    };
    ResizerDirective.prototype.ngOnDestroy = function () {
        this._subscriptions.dispose();
    };
    __decorate([
        Input(),
        __metadata("design:type", Number)
    ], ResizerDirective.prototype, "maxSplitSize", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], ResizerDirective.prototype, "sizeChange", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], ResizerDirective.prototype, "splitSize", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], ResizerDirective.prototype, "resizerWidth", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], ResizerDirective.prototype, "resizerHeight", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], ResizerDirective.prototype, "resizerLeft", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], ResizerDirective.prototype, "resizerTop", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], ResizerDirective.prototype, "resizerRight", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], ResizerDirective.prototype, "resizerBottom", null);
    ResizerDirective = __decorate([
        Directive({
            selector: '[resizer]',
            host: { '(mousedown)': 'startDrag()' }
        }),
        __param(1, Inject(DOCUMENT)),
        __metadata("design:paramtypes", [ElementRef, Object])
    ], ResizerDirective);
    return ResizerDirective;
}());

var $$6 = _$;
var DslEditorComponent = /** @class */ (function () {
    function DslEditorComponent(element) {
        var _this = this;
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.debounce = 0;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = function () {
            _this._dsl = _this.doc.getValue();
            _this.dslChange.emit(_this._dsl);
        };
    }
    Object.defineProperty(DslEditorComponent.prototype, "dsl", {
        set: function (dsl) {
            this._dsl = dsl;
            if (this.doc && this._dsl !== this.doc.getValue()) {
                var cursorPosition = this.doc.getCursor();
                this.doc.setValue(this._dsl || '');
                this.doc.setCursor(cursorPosition);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DslEditorComponent.prototype, "lintOptions", {
        set: function (lintOptions) {
            this._lint = lintOptions;
            if (this.doc) {
                this.doc.setOption('lint', this._lint);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DslEditorComponent.prototype, "hintOptions", {
        set: function (hintOptions) {
            this._hint = hintOptions;
            if (this.doc) {
                this.doc.setOption('hintOptions', this._hint);
            }
        },
        enumerable: true,
        configurable: true
    });
    DslEditorComponent.prototype.ngOnInit = function () {
        var _this = this;
        var options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            electricChars: false,
            smartIndent: false,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        if (this._hint) {
            options.hintOptions = this._hint;
        }
        this.doc = fromTextArea($$6('#dsl-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this.debounce ? debounce(this._dslChangedHandler, this.debounce) : this._dslChangedHandler);
        this.doc.on('focus', function () { return _this.focus.emit(); });
        this.doc.on('blur', function () { return _this.blur.emit(); });
        this.editor.emit(this.doc);
    };
    DslEditorComponent.prototype.ngOnDestroy = function () {
    };
    __decorate([
        Input('line-numbers'),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "lineNumbers", void 0);
    __decorate([
        Input('line-wrapping'),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "lineWrapping", void 0);
    __decorate([
        Input('scrollbar-style'),
        __metadata("design:type", String)
    ], DslEditorComponent.prototype, "scrollbarStyle", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], DslEditorComponent.prototype, "placeholder", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "debounce", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "dslChange", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "focus", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "blur", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], DslEditorComponent.prototype, "editor", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], DslEditorComponent.prototype, "dsl", null);
    __decorate([
        Input(),
        __metadata("design:type", Object),
        __metadata("design:paramtypes", [Object])
    ], DslEditorComponent.prototype, "lintOptions", null);
    __decorate([
        Input(),
        __metadata("design:type", Object),
        __metadata("design:paramtypes", [Object])
    ], DslEditorComponent.prototype, "hintOptions", null);
    DslEditorComponent = __decorate([
        Component({
            selector: 'dsl-editor',
            template: "\n    <textarea id=\"dsl-editor-host\"></textarea>\n  ",
            styles: ["\n    /* Code Mirror related styles START */\n\n    .CodeMirror {\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n      height: 100%;\n    }\n    .CodeMirror-hint {\n      max-width: 38em;\n    }\n    .CodeMirror-vertical-ruler-error {\n      background-color: rgba(188, 0, 0, 0.5);\n    }\n    .CodeMirror-vertical-ruler-warning {\n      background-color: rgba(255, 188, 0, 0.5);\n    }\n\n\n    /* Code Mirror related styles END */\n  "],
            encapsulation: ViewEncapsulation.None
        }),
        __metadata("design:paramtypes", [ElementRef])
    ], DslEditorComponent);
    return DslEditorComponent;
}());

var $$7 = _$;
// Lint support
// Unclear how to import this dynamically...
// import 'codemirror-minified/addon/lint/javascript-lint';
// import 'codemirror-minified/addon/lint/json-lint';
// import 'codemirror-minified/addon/lint/yaml-lint';
// TODO: use dynamic import with JS7 in the future. CM autoLoad cannot load it properly - thinks its AMD
// Supported languages until dynamic loading
// import 'codemirror-minified/mode/groovy/groovy';
// import 'codemirror-minified/mode/javascript/javascript';
// import 'codemirror-minified/mode/python/python';
// import 'codemirror-minified/mode/ruby/ruby';
// import 'codemirror-minified/mode/clike/clike';
// import 'codemirror-minified/mode/yaml/yaml';
var CodeEditorComponent = /** @class */ (function () {
    function CodeEditorComponent(element) {
        var _this = this;
        this.element = element;
        this._dsl = '';
        this._lint = false;
        this.lineNumbers = false;
        this.lineWrapping = false;
        this.dslChange = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.editor = new EventEmitter();
        this._dslChangedHandler = function () {
            _this._dsl = _this.doc.getValue();
            _this.dslChange.emit(_this._dsl);
            if (_this._onChangeHandler) {
                _this._onChangeHandler(_this._dsl);
            }
        };
    }
    CodeEditorComponent_1 = CodeEditorComponent;
    Object.defineProperty(CodeEditorComponent.prototype, "dsl", {
        set: function (dsl) {
            this._dsl = dsl;
            if (this.doc && this._dsl !== this.doc.getValue()) {
                var cursorPosition = this.doc.getCursor();
                this.doc.setValue(this._dsl || '');
                this.doc.setCursor(cursorPosition);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CodeEditorComponent.prototype, "language", {
        set: function (_language) {
            if (this._language !== _language) {
                this._language = _language;
                this.loadEditorMode();
            }
        },
        enumerable: true,
        configurable: true
    });
    CodeEditorComponent.prototype.ngOnInit = function () {
        var _this = this;
        var options = {
            value: this._dsl || '',
            gutters: ['CodeMirror-lint-markers'],
            extraKeys: { 'Ctrl-Space': 'autocomplete' },
            lineNumbers: this.lineNumbers,
            lineWrapping: this.lineWrapping,
            matchBrackets: true,
            autoCloseBrackets: true,
        };
        if (this.scrollbarStyle) {
            options.scrollbarStyle = this.scrollbarStyle;
        }
        if (this._lint) {
            options.lint = this._lint;
        }
        this.doc = fromTextArea($$7('#code-editor-host', this.element.nativeElement)[0], options);
        if (this.placeholder) {
            this.doc.setOption('placeholder', this.placeholder);
        }
        // Turns out "value" in the option doesn't set it.
        this.doc.setValue(this._dsl || '');
        this.doc.on('change', this._dslChangedHandler);
        this.doc.on('focus', function () {
            _this.focus.emit();
            if (_this._onTouchHandler) {
                _this._onTouchHandler();
            }
        });
        this.doc.on('blur', function () { return _this.blur.emit(); });
        this.warningRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-warning');
        this.errorRuler = this.doc.annotateScrollbar('CodeMirror-vertical-ruler-error');
        this.loadEditorMode();
        this.editor.emit(this.doc);
    };
    CodeEditorComponent.prototype.loadEditorMode = function () {
        // CodeMirror doc object must be initialized
        if (!this.doc) {
            return;
        }
        var info = this._language ? findModeByName(this._language) : undefined;
        // Set proper editor mode
        if (info) {
            this.doc.setOption('mode', info.mime);
            // (<any>CodeMirror).autoLoadMode(this.doc, info.mode);
        }
        else {
            this.doc.setOption('mode', 'text/plain');
        }
        // Set proper Lint mode
        this.doc.setOption('lint', this.getLintOptions());
    };
    CodeEditorComponent.prototype.ngOnDestroy = function () {
    };
    CodeEditorComponent.prototype.writeValue = function (obj) {
        this.dsl = obj;
    };
    CodeEditorComponent.prototype.registerOnChange = function (fn) {
        this._onChangeHandler = fn;
    };
    CodeEditorComponent.prototype.registerOnTouched = function (fn) {
        this._onTouchHandler = fn;
    };
    CodeEditorComponent.prototype.getLintOptions = function () {
        var _this = this;
        switch (this._language) {
            case 'javascript':
            case 'json':
            case 'coffeescript':
            case 'yaml':
                return {
                    onUpdateLinting: function (annotations) {
                        var warnings = [];
                        var errors = [];
                        if (_this.overviewRuler) {
                            if (Array.isArray(annotations)) {
                                annotations.forEach(function (a) {
                                    if (a.to && a.from && a.from.line >= 0 && a.from.ch >= 0 && a.to.line >= a.from.line && a.from.ch >= 0) {
                                        if (a.severity === 'error') {
                                            errors.push(a);
                                        }
                                        else if (a.severity === 'warning') {
                                            warnings.push(a);
                                        }
                                    }
                                });
                            }
                        }
                        _this.warningRuler.update(warnings);
                        _this.errorRuler.update(errors);
                    }
                };
        }
        return false;
    };
    var CodeEditorComponent_1;
    __decorate([
        Input('line-numbers'),
        __metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "lineNumbers", void 0);
    __decorate([
        Input('line-wrapping'),
        __metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "lineWrapping", void 0);
    __decorate([
        Input('scrollbar-style'),
        __metadata("design:type", String)
    ], CodeEditorComponent.prototype, "scrollbarStyle", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], CodeEditorComponent.prototype, "placeholder", void 0);
    __decorate([
        Input('overview-ruler'),
        __metadata("design:type", Boolean)
    ], CodeEditorComponent.prototype, "overviewRuler", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "dslChange", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "focus", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "blur", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], CodeEditorComponent.prototype, "editor", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], CodeEditorComponent.prototype, "dsl", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], CodeEditorComponent.prototype, "language", null);
    CodeEditorComponent = CodeEditorComponent_1 = __decorate([
        Component({
            selector: 'code-editor',
            template: "\n    <div class=\"code-editor-host\">\n      <textarea id=\"code-editor-host\"></textarea>\n    </div>\n  ",
            styles: ["\n    .CodeMirror {\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n      height: 100%;\n    }\n    .CodeMirror-hint {\n      max-width: 38em;\n    }\n    .CodeMirror-vertical-ruler-error {\n      background-color: rgba(188, 0, 0, 0.5);\n    }\n    .CodeMirror-vertical-ruler-warning {\n      background-color: rgba(255, 188, 0, 0.5);\n    }\n    .CodeMirror-lint-tooltip {\n      z-index: 2000;\n    }\n  "],
            encapsulation: ViewEncapsulation.None,
            providers: [
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(function () { return CodeEditorComponent_1; }),
                    multi: true
                }
            ]
        }),
        __metadata("design:paramtypes", [ElementRef])
    ], CodeEditorComponent);
    return CodeEditorComponent;
}());

var Properties;
(function (Properties) {
    var InputType;
    (function (InputType) {
        InputType[InputType["TEXT"] = 0] = "TEXT";
        InputType[InputType["NUMBER"] = 1] = "NUMBER";
        InputType[InputType["SELECT"] = 2] = "SELECT";
        InputType[InputType["CHECKBOX"] = 3] = "CHECKBOX";
        InputType[InputType["PASSWORD"] = 4] = "PASSWORD";
        InputType[InputType["EMAIL"] = 5] = "EMAIL";
        InputType[InputType["URL"] = 6] = "URL";
        InputType[InputType["CODE"] = 7] = "CODE";
    })(InputType = Properties.InputType || (Properties.InputType = {}));
    var GenericControlModel = /** @class */ (function () {
        function GenericControlModel(_property, type, validation) {
            this._property = _property;
            this.type = type;
            this.validation = validation;
        }
        Object.defineProperty(GenericControlModel.prototype, "id", {
            get: function () {
                return this.property.id;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GenericControlModel.prototype, "name", {
            get: function () {
                return this.property.name;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GenericControlModel.prototype, "description", {
            get: function () {
                return this.property.description;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GenericControlModel.prototype, "defaultValue", {
            get: function () {
                return this.property.defaultValue;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GenericControlModel.prototype, "value", {
            get: function () {
                return this.getValue();
            },
            set: function (value) {
                this.setValue(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GenericControlModel.prototype, "property", {
            get: function () {
                return this._property;
            },
            enumerable: true,
            configurable: true
        });
        GenericControlModel.prototype.setValue = function (value) {
            this.property.value = value;
        };
        GenericControlModel.prototype.getValue = function () {
            return this.property.value;
        };
        return GenericControlModel;
    }());
    Properties.GenericControlModel = GenericControlModel;
    var CheckBoxControlModel = /** @class */ (function (_super) {
        __extends(CheckBoxControlModel, _super);
        function CheckBoxControlModel(_property, validation) {
            return _super.call(this, _property, InputType.CHECKBOX, validation) || this;
        }
        CheckBoxControlModel.prototype.getValue = function () {
            var res = _super.prototype.getValue.call(this);
            var type = typeof res;
            switch (type) {
                case 'boolean':
                    return res;
                case 'string':
                    switch (res.trim().toLowerCase()) {
                        case 'true':
                        case '1':
                            return true;
                        case 'false':
                        case '0':
                            return false;
                        default:
                            return this.property.defaultValue;
                    }
                case 'number':
                    var num = res;
                    if (num === 0) {
                        return false;
                    }
                    else if (num === 1) {
                        return true;
                    }
                    else {
                        return this.property.defaultValue;
                    }
            }
            return this.property.defaultValue;
        };
        return CheckBoxControlModel;
    }(GenericControlModel));
    Properties.CheckBoxControlModel = CheckBoxControlModel;
    var AbstractCodeControlModel = /** @class */ (function (_super) {
        __extends(AbstractCodeControlModel, _super);
        function AbstractCodeControlModel(_property, encode, decode, validation) {
            var _this = _super.call(this, _property, InputType.CODE, validation) || this;
            _this.encode = encode;
            _this.decode = decode;
            return _this;
        }
        Object.defineProperty(AbstractCodeControlModel.prototype, "value", {
            get: function () {
                var dsl = _super.prototype.getValue.call(this);
                if (dsl && this.decode) {
                    return this.decode(dsl);
                }
                else {
                    return dsl;
                }
            },
            set: function (value) {
                if (value && this.encode) {
                    _super.prototype.setValue.call(this, this.encode(value));
                }
                else {
                    _super.prototype.setValue.call(this, value);
                }
            },
            enumerable: true,
            configurable: true
        });
        return AbstractCodeControlModel;
    }(GenericControlModel));
    Properties.AbstractCodeControlModel = AbstractCodeControlModel;
    var GenericCodeControlModel = /** @class */ (function (_super) {
        __extends(GenericCodeControlModel, _super);
        function GenericCodeControlModel(_property, language, encode, decode, validation) {
            var _this = _super.call(this, _property, encode, decode, validation) || this;
            _this.language = language;
            return _this;
        }
        return GenericCodeControlModel;
    }(AbstractCodeControlModel));
    Properties.GenericCodeControlModel = GenericCodeControlModel;
    var CodeControlModelWithDynamicLanguageProperty = /** @class */ (function (_super) {
        __extends(CodeControlModelWithDynamicLanguageProperty, _super);
        function CodeControlModelWithDynamicLanguageProperty(_property, _languagePropertyName, _groupModel, encode, decode, validation) {
            var _this = _super.call(this, _property, encode, decode, validation) || this;
            _this._languagePropertyName = _languagePropertyName;
            _this._groupModel = _groupModel;
            return _this;
        }
        Object.defineProperty(CodeControlModelWithDynamicLanguageProperty.prototype, "language", {
            get: function () {
                var value = this.languageControlModel.value;
                return value ? value : this.languageControlModel.defaultValue;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CodeControlModelWithDynamicLanguageProperty.prototype, "languageControlModel", {
            get: function () {
                var _this = this;
                if (!this._langControlModel) {
                    // Cast to Properties.ControlModel<any> from Properties.ControlModel<any> | undefined
                    // Should not be undefined!
                    this._langControlModel = this._groupModel.getControlsModels().find(function (c) { return c.id === _this._languagePropertyName; });
                }
                return this._langControlModel;
            },
            enumerable: true,
            configurable: true
        });
        return CodeControlModelWithDynamicLanguageProperty;
    }(AbstractCodeControlModel));
    Properties.CodeControlModelWithDynamicLanguageProperty = CodeControlModelWithDynamicLanguageProperty;
    var GenericListControlModel = /** @class */ (function (_super) {
        __extends(GenericListControlModel, _super);
        function GenericListControlModel(property, validation) {
            return _super.call(this, property, InputType.TEXT, validation) || this;
        }
        Object.defineProperty(GenericListControlModel.prototype, "value", {
            get: function () {
                return this.property.value ? this.property.value.toString().trim().split(/\s*,\s*/).join(', ') : '';
            },
            set: function (value) {
                this.property.value = value && value.trim() ? value.split(/\s*,\s*/).join(',') : undefined;
            },
            enumerable: true,
            configurable: true
        });
        return GenericListControlModel;
    }(GenericControlModel));
    Properties.GenericListControlModel = GenericListControlModel;
    var SelectControlModel = /** @class */ (function (_super) {
        __extends(SelectControlModel, _super);
        function SelectControlModel(_property, type, options) {
            var _this = _super.call(this, _property, type) || this;
            _this.options = options;
            if (_property.defaultValue === undefined) {
                options.unshift({
                    name: 'SELECT',
                    value: _property.defaultValue
                });
            }
            return _this;
        }
        return SelectControlModel;
    }(GenericControlModel));
    Properties.SelectControlModel = SelectControlModel;
    var DefaultCellPropertiesSource = /** @class */ (function () {
        function DefaultCellPropertiesSource(cell) {
            this.cell = cell;
        }
        DefaultCellPropertiesSource.prototype.getProperties = function () {
            var _this = this;
            var metadata = this.cell.attr('metadata');
            return Promise.resolve(metadata.properties().then(function (propsMetadata) { return Array.from(propsMetadata.values()).map(function (m) { return _this.createProperty(m); }); }));
        };
        DefaultCellPropertiesSource.prototype.createProperty = function (metadata) {
            return {
                id: metadata.id,
                name: metadata.name,
                type: metadata.type,
                defaultValue: metadata.defaultValue,
                attr: "props/" + metadata.name,
                value: this.cell.attr("props/" + metadata.name),
                description: metadata.description,
                valueOptions: metadata.options
            };
        };
        DefaultCellPropertiesSource.prototype.applyChanges = function (properties) {
            var _this = this;
            this.cell.trigger('batch:start', { batchName: 'update properties' });
            properties.forEach(function (property) {
                if ((typeof property.value === 'boolean' && !property.defaultValue && !property.value) ||
                    (property.value === property.defaultValue || property.value === '' || property.value === undefined || property.value === null)) {
                    var currentValue = _this.cell.attr(property.attr);
                    if (currentValue !== undefined && currentValue !== null) {
                        // Remove attr doesn't fire appropriate event. Set default value first as a workaround to schedule DSL resync
                        _this.cell.attr(property.attr, property.defaultValue === undefined ? null : property.defaultValue);
                        _this.cell.removeAttr(property.attr);
                    }
                }
                else {
                    _this.cell.attr(property.attr, property.value);
                }
            });
            this.cell.trigger('batch:stop', { batchName: 'update properties' });
        };
        return DefaultCellPropertiesSource;
    }());
    Properties.DefaultCellPropertiesSource = DefaultCellPropertiesSource;
    var PropertiesGroupModel = /** @class */ (function () {
        function PropertiesGroupModel(propertiesSource) {
            this.loading = true;
            this.propertiesSource = propertiesSource;
        }
        PropertiesGroupModel.prototype.load = function () {
            var _this = this;
            this.loading = true;
            this._loadedSubject = new Subject();
            this.propertiesSource.getProperties().then(function (properties) {
                _this.controlModels = properties.map(function (p) { return _this.createControlModel(p); });
                _this.loading = false;
                _this._loadedSubject.next(true);
                _this._loadedSubject.complete();
            });
        };
        Object.defineProperty(PropertiesGroupModel.prototype, "isLoading", {
            get: function () {
                return this.loading;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PropertiesGroupModel.prototype, "loadedSubject", {
            get: function () {
                return this._loadedSubject;
            },
            enumerable: true,
            configurable: true
        });
        PropertiesGroupModel.prototype.getControlsModels = function () {
            return this.controlModels;
        };
        PropertiesGroupModel.prototype.createControlModel = function (property) {
            return new GenericControlModel(property, InputType.TEXT);
        };
        PropertiesGroupModel.prototype.applyChanges = function () {
            if (this.loading) {
                return;
            }
            var properties = this.controlModels.map(function (cm) { return cm.property; });
            this.propertiesSource.applyChanges(properties);
        };
        return PropertiesGroupModel;
    }());
    Properties.PropertiesGroupModel = PropertiesGroupModel;
    var UNIQUE_RESOURCE_ERROR = { uniqueResource: true };
    var Validators;
    (function (Validators) {
        function uniqueResource(service, debounceDuration) {
            return function (control) {
                return new Observable(function (obs) {
                    if (control.valueChanges) {
                        return control.valueChanges.pipe(debounceTime(debounceDuration), switchMap(function () { return service(control.value); })).subscribe(function (res) {
                            if (res) {
                                obs.next(undefined);
                            }
                            else {
                                obs.next(UNIQUE_RESOURCE_ERROR);
                            }
                            obs.complete();
                        }, function () {
                            obs.next(UNIQUE_RESOURCE_ERROR);
                            obs.complete();
                        });
                    }
                    else {
                        service(control.value).subscribe(function (res) {
                            if (res) {
                                obs.next(undefined);
                            }
                            else {
                                obs.next(UNIQUE_RESOURCE_ERROR);
                            }
                            obs.complete();
                        }, function () {
                            obs.next(UNIQUE_RESOURCE_ERROR);
                            obs.complete();
                        });
                    }
                });
            };
        }
        Validators.uniqueResource = uniqueResource;
        function noneOf(excluded) {
            return function (control) {
                return excluded.find(function (e) { return e === control.value; }) ? { 'noneOf': { value: control.value } } : {};
            };
        }
        Validators.noneOf = noneOf;
    })(Validators = Properties.Validators || (Properties.Validators = {}));
})(Properties || (Properties = {}));

var PropertiesGroupComponent = /** @class */ (function () {
    function PropertiesGroupComponent() {
    }
    PropertiesGroupComponent.prototype.ngOnInit = function () {
        var _this = this;
        if (this.propertiesGroupModel.isLoading) {
            var subscription_1 = this.propertiesGroupModel.loadedSubject.subscribe(function (loaded) {
                if (loaded) {
                    subscription_1.unsubscribe();
                    _this.createGroupControls();
                }
            });
        }
        else {
            this.createGroupControls();
        }
    };
    PropertiesGroupComponent.prototype.createGroupControls = function () {
        var _this = this;
        this.propertiesGroupModel.getControlsModels().forEach(function (c) {
            if (c.validation) {
                _this.form.addControl(c.id, new FormControl(c.value || '', c.validation.validator, c.validation.asyncValidator));
            }
            else {
                _this.form.addControl(c.id, new FormControl(c.value || ''));
            }
        });
    };
    Object.defineProperty(PropertiesGroupComponent.prototype, "controlModelsToDisplay", {
        get: function () {
            var _this = this;
            return this.propertiesGroupModel.getControlsModels().filter(function (c) { return !_this.filter || _this.filter.accept(c.property); });
        },
        enumerable: true,
        configurable: true
    });
    __decorate([
        Input(),
        __metadata("design:type", Properties.PropertiesGroupModel)
    ], PropertiesGroupComponent.prototype, "propertiesGroupModel", void 0);
    __decorate([
        Input(),
        __metadata("design:type", FormGroup)
    ], PropertiesGroupComponent.prototype, "form", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], PropertiesGroupComponent.prototype, "filter", void 0);
    PropertiesGroupComponent = __decorate([
        Component({
            selector: 'properties-group',
            template: "\n    <div *ngIf=\"propertiesGroupModel && !propertiesGroupModel.isLoading\" class=\"properties-group-container\"\n         [formGroup]=\"form\">\n      <div\n        *ngIf=\"propertiesGroupModel.getControlsModels().length > 0 && controlModelsToDisplay.length === 0; else propertiesList\"\n        class=\"no-matches-label\">No results found.\n      </div>\n    </div>\n\n    <ng-template #propertiesList>\n      <df-property *ngFor=\"let model of controlModelsToDisplay\" [model]=\"model\" [form]=\"form\"\n                   class=\"property-row\"></df-property>\n    </ng-template>\n  ",
            encapsulation: ViewEncapsulation.None
        })
    ], PropertiesGroupComponent);
    return PropertiesGroupComponent;
}());

var DynamicFormPropertyComponent = /** @class */ (function () {
    function DynamicFormPropertyComponent() {
    }
    Object.defineProperty(DynamicFormPropertyComponent.prototype, "types", {
        get: function () {
            return Properties.InputType;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DynamicFormPropertyComponent.prototype, "control", {
        get: function () {
            return this.form.controls[this.model.id];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DynamicFormPropertyComponent.prototype, "errorData", {
        get: function () {
            var _this = this;
            return (this.model.validation && this.model.validation.errorData ? this.model.validation.errorData : [])
                .filter(function (e) { return _this.control.errors && _this.control.errors[e.id]; });
        },
        enumerable: true,
        configurable: true
    });
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], DynamicFormPropertyComponent.prototype, "model", void 0);
    __decorate([
        Input(),
        __metadata("design:type", FormGroup)
    ], DynamicFormPropertyComponent.prototype, "form", void 0);
    DynamicFormPropertyComponent = __decorate([
        Component({
            selector: 'df-property',
            template: "\n    <tr [formGroup]=\"form\" class=\"df-property-row\" [ngClass]=\"{'invalid-property-value': control.invalid}\">\n\n      <td class=\"df-property-label-cell\">\n        <label [attr.for]=\"model.id\" class=\"df-form-label\">{{model.name}}</label>\n      </td>\n\n      <td class=\"df-property-control-cell\">\n        <div [ngSwitch]=\"model.type\" class=\"df-property-container\">\n\n          <label *ngSwitchCase=\"types.CHECKBOX\" class=\"df-property-control\">\n            <input type=\"checkbox\" [id]=\"model.id\" [(ngModel)]=\"model.value\" [formControlName]=\"model.id\">\n            {{model.value ? 'True' : 'False' }}\n          </label>\n\n          <input *ngSwitchCase=\"types.NUMBER\" class=\"df-property-control\" type=\"number\" [id]=\"model.id\"\n                 [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n          <input *ngSwitchCase=\"types.PASSWORD\" class=\"df-property-control\" type=\"password\" [id]=\"model.id\"\n                 [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n          <input *ngSwitchCase=\"types.EMAIL\" class=\"df-property-control\" type=\"password\" [id]=\"model.id\"\n                 [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n          <input *ngSwitchCase=\"types.URL\" class=\"df-property-control\" type=\"url\" [id]=\"model.id\"\n                 [formControlName]=\"model.id\" [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n\n          <select *ngSwitchCase=\"types.SELECT\" class=\"df-property-control\" [id]=\"model.id\"\n                 [formControlName]=\"model.id\" [(ngModel)]=\"model.value\">\n            <option *ngFor=\"let o of model['options']\" [ngValue]=\"o.value\">{{o.name}}</option>\n          </select>\n\n          <code-editor *ngSwitchCase=\"types.CODE\" class=\"df-property-control\" [id]=\"model.id\"\n                  [formControlName]=\"model.id\" [language]=\"model['language']\" [(ngModel)]=\"model.value\" line-numbers=\"true\"\n                  scrollbar-style=\"simple\" [placeholder]=\"model.defaultValue || 'Enter code snippet...'\" overview-ruler=\"true\">\n          </code-editor>\n\n          <input *ngSwitchDefault class=\"df-property-control\" type=\"text\" [id]=\"model.id\" [formControlName]=\"model.id\"\n                 [placeholder]=\"model.defaultValue || ''\" [(ngModel)]=\"model.value\">\n        </div>\n        <div class=\"help-block\">\n          <div>{{model.description}}</div>\n          <div *ngFor=\"let e of errorData\" class=\"validation-error-block\">{{e.message}}</div>\n        </div>\n      </td>\n\n    </tr>\n  ",
            encapsulation: ViewEncapsulation.None
        }),
        __metadata("design:paramtypes", [])
    ], DynamicFormPropertyComponent);
    return DynamicFormPropertyComponent;
}());

var PaperComponent = /** @class */ (function () {
    function PaperComponent() {
        this.onDelete = new EventEmitter();
        this.onProperties = new EventEmitter();
        this.onBlur = new EventEmitter();
    }
    PaperComponent.prototype.click = function () {
        this.paperElement.nativeElement.focus();
    };
    PaperComponent.prototype.mousedown = function () {
        this.paperElement.nativeElement.focus();
    };
    PaperComponent.prototype.backspaceHandle = function () {
        this.onDelete.emit();
    };
    PaperComponent.prototype.deleteHandle = function () {
        this.onDelete.emit();
    };
    PaperComponent.prototype.oHandle = function () {
        this.onProperties.emit();
    };
    PaperComponent.prototype.ngOnInit = function () {
        var onBlur = this.onBlur;
        this.paperElement.nativeElement.addEventListener('blur', function () {
            onBlur.emit();
        });
    };
    __decorate([
        ViewChild('paper', { static: true }),
        __metadata("design:type", ElementRef)
    ], PaperComponent.prototype, "paperElement", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], PaperComponent.prototype, "onDelete", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], PaperComponent.prototype, "onProperties", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], PaperComponent.prototype, "onBlur", void 0);
    __decorate([
        HostListener('click'),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "click", null);
    __decorate([
        HostListener('mousedown'),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "mousedown", null);
    __decorate([
        HostListener('keydown.backspace'),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "backspaceHandle", null);
    __decorate([
        HostListener('keydown.delete'),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "deleteHandle", null);
    __decorate([
        HostListener('keydown.o'),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PaperComponent.prototype, "oHandle", null);
    PaperComponent = __decorate([
        Component({
            selector: 'flo-editor-paper',
            template: "\n    <div #paper tabindex=\"0\" id=\"paper-container\">\n      <ng-content></ng-content>\n    </div>",
            styles: ["\n    flo-view {\n      width:100%;\n      height:100%;\n      margin: 0;\n      background-color: #eeeeee;\n      font-family: \"Varela Round\",sans-serif;\n      -webkit-user-select: none;\n      -khtml-user-select: none;\n      -moz-user-select: none;\n      -o-user-select: none;\n      user-select: none;\n    }\n\n    .canvas {\n      border: 1px solid;\n      border-color: #6db33f;\n      border-radius: 2px;\n      margin-top: 3px;\n    }\n\n    /* Canvas contains the palette on the left and the paper on the right */\n\n    .paper {\n      padding: 0px;\n      background-color: #ffffff;\n      /* \theight: 100%;\n          width: 100%;\n          position: relative;\n          overflow: hidden;\n       *//* \tmargin-left: 400px; */\n    }\n\n    #sidebar-resizer {\n      background-color: #34302d;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      width: 6px;\n      cursor: e-resize;\n    }\n\n    #palette-container {\n      background-color: #EEE;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      left: 0;\n      overflow: auto;\n    }\n\n    #paper-container {\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      right: 0;\n      overflow: auto;\n      color: #FFF;\n      background-color: #FFF;\n      outline: none;\n    }\n\n    /* Tooltip START */\n\n    .node-tooltip .tooltip-description {\n      margin-top: 5px;\n      margin-left: 0px;\n      margin-bottom: 5px;\n    }\n\n    .node-tooltip {\n      display:none;\n      position:absolute;\n      border:1px solid #333;\n      background-color:#34302d;/*#161616;*/\n      border-radius:5px;\n      padding:5px;\n      color:#fff;\n      /*\tfont-size:12px Arial;*/\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 19px;\n      z-index: 100;\n    }\n\n    .tooltip-title-type {\n      font-size: 24px;\n      font-weight: bold;\n    }\n\n    .tooltip-title-group {\n      padding-left: 5px;\n      font-size: 20px;\n      font-style: italic;\n    }\n\n    .node-tooltip-option-name {\n      font-family: monospace;/*\"Varela Round\",sans-serif;*/\n      font-size: 17px;\n      font-weight: bold;\n      padding-right: 20px;\n\n    }\n\n    .node-tooltip-option-description {\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 18px;\n    }\n\n    /* Tooltip END */\n\n\n    /* Validation Error Marker on Canvas START */\n\n    .error-tooltip p {\n      margin-top: 5px;\n      margin-left: 0px;\n      margin-bottom: 5px;\n      color:#fff;\n    }\n    .error-tooltip {\n      display:none;\n      position:absolute;\n      border:1px solid #333;\n      background-color:red;/*#161616;*/\n      border-radius:5px;\n      padding:5px;\n      color:#fff;\n      /*\tfont-size:12px Arial;*/\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 20px;\n      z-index: 100;\n    }\n\n    /* Validation Error Marker on Canvas END */\n\n    /* Controls on Canvas START */\n\n    .canvas-controls-container {\n      position: absolute;\n      right: 15px;\n      top: 5px;\n    }\n\n    .canvas-control {\n      background: transparent;\n      font-family: \"Varela Round\",sans-serif;\n      font-size: 11px;\n      vertical-align: middle;\n      margin: 0px;\n    }\n\n    .zoom-canvas-control {\n      border: 0px;\n      padding: 0px;\n      margin: 0px;\n      outline: none;\n    }\n\n    .zoom-canvas-input {\n      text-align: right;\n      font-weight:bold;\n      color: black;\n      background-color: transparent;\n    }\n\n    .zoom-canvas-label {\n      padding-right: 4px;\n      color: black;\n    }\n\n    /* Controls on Canvas END */\n\n\n\n\n    /* START - FLO CANVAS STYLES - override joint js styles */\n\n    .highlighted {\n      outline: none;\n    }\n\n    .joint-type-handle {\n      cursor: pointer;\n    }\n\n    .available-magnet {\n      stroke-width: 3;\n    }\n\n    .link {\n      fill: none;\n      stroke: #ccc;\n      stroke-width: 1.5px;\n    }\n\n    .link-tools .tool-options {\n      display: none;       /* by default, we don't display link options tool */\n    }\n\n    /* Make transparent the circle around the link-tools (cog) icon. It'll allow shape to have a circle clicking area */\n    .link-tools .tool-options circle {\n      fill: transparent;\n      stroke: transparent;\n    }\n\n    .link-tools .tool-options path {\n      fill: black;\n      stroke: black;\n    }\n\n    .link-tools .tool-remove circle {\n      fill: red;\n      stroke: red;\n    }\n\n    .link-tools .tool-remove path {\n      fill: white;\n      stroke: white;\n    }\n\n    .link-tools-container {\n      stroke-width: 0;\n      fill: transparent;\n    }\n\n    /* END - FLO CANVAS STYLES */\n  "],
            encapsulation: ViewEncapsulation.None
        })
    ], PaperComponent);
    return PaperComponent;
}());

var FloModule = /** @class */ (function () {
    function FloModule() {
    }
    FloModule = __decorate([
        NgModule({
            imports: [
                FormsModule,
                CommonModule,
                ReactiveFormsModule
            ],
            declarations: [
                Palette,
                EditorComponent,
                ResizerDirective,
                DslEditorComponent,
                CodeEditorComponent,
                PropertiesGroupComponent,
                DynamicFormPropertyComponent,
                PaperComponent
            ],
            exports: [
                EditorComponent,
                DslEditorComponent,
                DynamicFormPropertyComponent,
                PropertiesGroupComponent
            ]
        })
    ], FloModule);
    return FloModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { CodeEditorComponent, Constants, DslEditorComponent, DynamicFormPropertyComponent, EditorComponent, Flo, FloModule, Palette, Properties, PropertiesGroupComponent, ResizerDirective, Shapes, PaperComponent as ɵa };
//# sourceMappingURL=spring-flo.js.map
