"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function newValue(oldValue, value) {
    if (oldValue === undefined) {
        return value;
    }
    if (oldValue instanceof Array) {
        return oldValue.concat(value);
    }
    return [oldValue, value];
}
function setFieldValue(dto, path, value) {
    if (path.index !== undefined) {
        var array = dto[path.name] || [];
        if (array.length <= path.index) {
            var extension = new Array(path.index - array.length + 1);
            array = array.concat(extension);
        }
        var oldValue = array[path.index];
        array[path.index] = newValue(oldValue, value);
        dto[path.name] = array;
    }
    else {
        var oldValue = dto[path.name];
        dto[path.name] = newValue(oldValue, value);
    }
}
function getFieldValue(dto, path) {
    if (path.index !== undefined) {
        var array = dto[path.name];
        if (array === undefined) {
            return array;
        }
        return array[path.index];
    }
    else {
        return dto[path.name];
    }
}
function setPathValue(dto, path, value) {
    if (path.length === 1) {
        setFieldValue(dto, path[0], value);
    }
    else {
        var head = path[0], tail = path.slice(1);
        var subDto = getFieldValue(dto, head);
        if (subDto === undefined) {
            subDto = {};
            setFieldValue(dto, head, subDto);
        }
        setPathValue(subDto, tail, value);
    }
}
function formDataToObject(formData) {
    var obj = {};
    formData.forEach(function (element) { return setPathValue(obj, element.path, element.value); });
    return obj;
}
function buildPathSegment(segment) {
    if (segment.endsWith(']')) {
        var split = segment.split(/[\[\]]/);
        return { name: split[0], index: Number(split[1]) };
    }
    else {
        return { name: segment };
    }
}
function fieldNameToPathSegments(fieldName) {
    return fieldName.split('.').map(buildPathSegment);
}
function nameValuePairToPathValue(nameValuePair) {
    return { path: fieldNameToPathSegments(nameValuePair.name), value: nameValuePair.value };
}
function serializeFormDataArray(formDataArray) {
    var obj = formDataToObject(formDataArray.map(nameValuePairToPathValue));
    return JSON.stringify(obj);
}
exports.serializeFormDataArray = serializeFormDataArray;
function serializeFormData(formData) {
    var formDataArray = [];
    formData.forEach(function (value, key) { return formDataArray.push({ name: key, value: value.toString() }); });
    return serializeFormDataArray(formDataArray);
}
exports.serializeFormData = serializeFormData;
//# sourceMappingURL=index.js.map