import { flatKeywordList } from '../../utils.js';
export const functions = flatKeywordList({
  // https://www.ibm.com/docs/en/db2-for-zos/11?topic=functions-aggregate
  aggregate: ['ARRAY_AGG', 'AVG', 'CORR', 'CORRELATION', 'COUNT', 'COUNT_BIG', 'COVAR_POP', 'COVARIANCE', 'COVAR', 'COVAR_SAMP', 'COVARIANCE_SAMP', 'CUME_DIST', 'GROUPING', 'LISTAGG', 'MAX', 'MEDIAN', 'MIN', 'PERCENTILE_CONT', 'PERCENTILE_DISC', 'PERCENT_RANK', 'REGR_AVGX', 'REGR_AVGY', 'REGR_COUNT', 'REGR_INTERCEPT', 'REGR_ICPT', 'REGR_R2', 'REGR_SLOPE', 'REGR_SXX', 'REGR_SXY', 'REGR_SYY', 'STDDEV_POP', 'STDDEV', 'STDDEV_SAMP', 'SUM', 'VAR_POP', 'VARIANCE', 'VAR', 'VAR_SAMP', 'VARIANCE_SAMP', 'XMLAGG'],
  // https://www.ibm.com/docs/en/db2-for-zos/11?topic=functions-scalar
  scalar: ['ABS', 'ABSVAL', 'ACOS', 'ADD_DAYS', 'ADD_MONTHS', 'ARRAY_DELETE', 'ARRAY_FIRST', 'ARRAY_LAST', 'ARRAY_NEXT', 'ARRAY_PRIOR', 'ARRAY_TRIM', 'ASCII', 'ASCII_CHR', 'ASCII_STR', 'ASCIISTR', 'ASIN', 'ATAN', 'ATANH', 'ATAN2', 'BIGINT', 'BINARY', 'BITAND', 'BITANDNOT', 'BITOR', 'BITXOR', 'BITNOT', 'BLOB', 'BTRIM', 'CARDINALITY', 'CCSID_ENCODING', 'CEILING', 'CEIL', 'CHAR', 'CHAR9', 'CHARACTER_LENGTH', 'CHAR_LENGTH', 'CHR', 'CLOB', 'COALESCE', 'COLLATION_KEY', 'COMPARE_DECFLOAT', 'CONCAT', 'CONTAINS', 'COS', 'COSH', 'DATE', 'DAY', 'DAYOFMONTH', 'DAYOFWEEK', 'DAYOFWEEK_ISO', 'DAYOFYEAR', 'DAYS', 'DAYS_BETWEEN', 'DBCLOB', 'DECFLOAT', 'DECFLOAT_FORMAT', 'DECFLOAT_SORTKEY', 'DECIMAL', 'DEC', 'DECODE', 'DECRYPT_BINARY', 'DECRYPT_BIT', 'DECRYPT_CHAR', 'DECRYPT_DB', 'DECRYPT_DATAKEY_BIGINT', 'DECRYPT_DATAKEY_BIT', 'DECRYPT_DATAKEY_CLOB', 'DECRYPT_DATAKEY_DBCLOB', 'DECRYPT_DATAKEY_DECIMAL', 'DECRYPT_DATAKEY_INTEGER', 'DECRYPT_DATAKEY_VARCHAR', 'DECRYPT_DATAKEY_VARGRAPHIC', 'DEGREES', 'DIFFERENCE', 'DIGITS', 'DOUBLE_PRECISION', 'DOUBLE', 'DSN_XMLVALIDATE', 'EBCDIC_CHR', 'EBCDIC_STR', 'ENCRYPT_DATAKEY', 'ENCRYPT_TDES', 'EXP', 'EXTRACT', 'FLOAT', 'FLOOR', 'GENERATE_UNIQUE', 'GENERATE_UNIQUE_BINARY', 'GETHINT', 'GETVARIABLE', 'GRAPHIC', 'GREATEST', 'HASH', 'HASH_CRC32', 'HASH_MD5', 'HASH_SHA1', 'HASH_SHA256', 'HEX', 'HOUR', 'IDENTITY_VAL_LOCAL', 'IFNULL', 'INSERT', 'INSTR', 'INTEGER', 'INT', 'JULIAN_DAY', 'LAST_DAY', 'LCASE', 'LEAST', 'LEFT', 'LENGTH', 'LN', 'LOCATE', 'LOCATE_IN_STRING', 'LOG10', 'LOWER', 'LPAD', 'LTRIM', 'MAX', 'MAX_CARDINALITY', 'MICROSECOND', 'MIDNIGHT_SECONDS', 'MIN', 'MINUTE', 'MOD', 'MONTH', 'MONTHS_BETWEEN', 'MQREAD', 'MQREADCLOB', 'MQRECEIVE', 'MQRECEIVECLOB', 'MQSEND', 'MULTIPLY_ALT', 'NEXT_DAY', 'NEXT_MONTH', 'NORMALIZE_DECFLOAT', 'NORMALIZE_STRING', 'NULLIF', 'NVL', 'OVERLAY', 'PACK', 'POSITION', 'POSSTR', 'POWER', 'POW', 'QUANTIZE', 'QUARTER', 'RADIANS', 'RAISE_ERROR', 'RANDOM', 'RAND', 'REAL', 'REGEXP_COUNT', 'REGEXP_INSTR', 'REGEXP_LIKE', 'REGEXP_REPLACE', 'REGEXP_SUBSTR', 'REPEAT', 'REPLACE', 'RID', 'RIGHT', 'ROUND', 'ROUND_TIMESTAMP', 'ROWID', 'RPAD', 'RTRIM', 'SCORE', 'SECOND', 'SIGN', 'SIN', 'SINH', 'SMALLINT', 'SOUNDEX', 'SOAPHTTPC', 'SOAPHTTPV', 'SOAPHTTPNC', 'SOAPHTTPNV', 'SPACE', 'SQRT', 'STRIP', 'STRLEFT', 'STRPOS', 'STRRIGHT', 'SUBSTR', 'SUBSTRING', 'TAN', 'TANH', 'TIME', 'TIMESTAMP', 'TIMESTAMPADD', 'TIMESTAMPDIFF', 'TIMESTAMP_FORMAT', 'TIMESTAMP_ISO', 'TIMESTAMP_TZ', 'TO_CHAR', 'TO_CLOB', 'TO_DATE', 'TO_NUMBER', 'TOTALORDER', 'TO_TIMESTAMP', 'TRANSLATE', 'TRIM', 'TRIM_ARRAY', 'TRUNCATE', 'TRUNC', 'TRUNC_TIMESTAMP', 'UCASE', 'UNICODE', 'UNICODE_STR', 'UNISTR', 'UPPER', 'VALUE', 'VARBINARY', 'VARCHAR', 'VARCHAR9', 'VARCHAR_BIT_FORMAT', 'VARCHAR_FORMAT', 'VARGRAPHIC', 'VERIFY_GROUP_FOR_USER', 'VERIFY_ROLE_FOR_USER', 'VERIFY_TRUSTED_CONTEXT_ROLE_FOR_USER', 'WEEK', 'WEEK_ISO', 'WRAP', 'XMLATTRIBUTES', 'XMLCOMMENT', 'XMLCONCAT', 'XMLDOCUMENT', 'XMLELEMENT', 'XMLFOREST', 'XMLMODIFY', 'XMLNAMESPACES', 'XMLPARSE', 'XMLPI', 'XMLQUERY', 'XMLSERIALIZE', 'XMLTEXT', 'XMLXSROBJECTID', 'XSLTRANSFORM', 'YEAR'],
  // https://www.ibm.com/docs/en/db2-for-zos/11?topic=functions-table
  table: ['ADMIN_TASK_LIST', 'ADMIN_TASK_OUTPUT', 'ADMIN_TASK_STATUS', 'BLOCKING_THREADS', 'MQREADALL', 'MQREADALLCLOB', 'MQRECEIVEALL', 'MQRECEIVEALLCLOB', 'XMLTABLE'],
  // https://www.ibm.com/docs/en/db2-for-zos/11?topic=functions-row
  row: ['UNPACK'],
  // https://www.ibm.com/docs/en/db2-for-zos/12?topic=expressions-olap-specification
  olap: ['CUME_DIST', 'PERCENT_RANK', 'RANK', 'DENSE_RANK', 'NTILE', 'LAG', 'LEAD', 'ROW_NUMBER', 'FIRST_VALUE', 'LAST_VALUE', 'NTH_VALUE', 'RATIO_TO_REPORT'],
  // Type casting
  cast: ['CAST']
});
//# sourceMappingURL=db2.functions.js.map