import { flatKeywordList } from '../../utils.js';
export const functions = flatKeywordList({
  // https://www.ibm.com/docs/en/db2/11.5?topic=bif-aggregate-functions
  aggregate: ['ARRAY_AGG', 'AVG', 'CORRELATION', 'COUNT', 'COUNT_BIG', 'COVARIANCE', 'COVARIANCE_SAMP', 'CUME_DIST', 'GROUPING', 'LISTAGG', 'MAX', 'MEDIAN', 'MIN', 'PERCENTILE_CONT', 'PERCENTILE_DISC', 'PERCENT_RANK', 'REGR_AVGX', 'REGR_AVGY', 'REGR_COUNT', 'REGR_INTERCEPT', 'REGR_ICPT', 'REGR_R2', 'REGR_SLOPE', 'REGR_SXX', 'REGR_SXY', 'REGR_SYY', 'STDDEV', 'STDDEV_SAMP', 'SUM', 'VARIANCE', 'VARIANCE_SAMP', 'XMLAGG', 'XMLGROUP'],
  // https://www.ibm.com/docs/en/db2/11.5?topic=bif-scalar-functions
  scalar: ['ABS', 'ABSVAL', 'ACOS', 'ADD_DAYS', 'ADD_HOURS', 'ADD_MINUTES', 'ADD_MONTHS', 'ADD_SECONDS', 'ADD_YEARS', 'AGE', 'ARRAY_DELETE', 'ARRAY_FIRST', 'ARRAY_LAST', 'ARRAY_NEXT', 'ARRAY_PRIOR', 'ASCII', 'ASCII_STR', 'ASIN', 'ATAN', 'ATAN2', 'ATANH', 'BIGINT', 'BINARY', 'BITAND', 'BITANDNOT', 'BITOR', 'BITXOR', 'BITNOT', 'BLOB', 'BOOLEAN', 'BPCHAR', 'BSON_TO_JSON', 'BTRIM', 'CARDINALITY', 'CEILING', 'CEIL', 'CHAR', 'CHARACTER_LENGTH', 'CHR', 'CLOB', 'COALESCE', 'COLLATION_KEY', 'COLLATION_KEY_BIT', 'COMPARE_DECFLOAT', 'CONCAT', 'COS', 'COSH', 'COT', 'CURSOR_ROWCOUNT', 'DATAPARTITIONNUM', 'DATE', 'DATETIME', 'DATE_PART', 'DATE_TRUNC', 'DAY', 'DAYNAME', 'DAYOFMONTH', 'DAYOFWEEK', 'DAYOFWEEK_ISO', 'DAYOFYEAR', 'DAYS', 'DAYS_BETWEEN', 'DAYS_TO_END_OF_MONTH', 'DBCLOB', 'DBPARTITIONNUM', 'DECFLOAT', 'DECFLOAT_FORMAT', 'DECIMAL', 'DEC', 'DECODE', 'DECRYPT_BIN', 'DECRYPT_CHAR', 'DEGREES', 'DEREF', 'DIFFERENCE', 'DIGITS', 'DOUBLE_PRECISION', 'DOUBLE', 'EMPTY_BLOB', 'EMPTY_CLOB', 'EMPTY_DBCLOB', 'EMPTY_NCLOB', 'ENCRYPT', 'EVENT_MON_STATE', 'EXP', 'EXTRACT', 'FIRST_DAY', 'FLOAT', 'FLOAT4', 'FLOAT8', 'FLOOR', 'FROM_UTC_TIMESTAMP', 'GENERATE_UNIQUE', 'GETHINT', 'GRAPHIC', 'GREATEST', 'HASH', 'HASH4', 'HASH8', 'HASHEDVALUE', 'HEX', 'HEXTORAW', 'HOUR', 'HOURS_BETWEEN', 'IDENTITY_VAL_LOCAL', 'IFNULL', 'INITCAP', 'INSERT', 'INSTR', 'INSTR2', 'INSTR4', 'INSTRB', 'INT', 'INTERVAL', 'INTEGER', 'INT2', 'INT4', 'INT8', 'INTNAND', 'INTNOR', 'INTNXOR', 'INTNNOT', 'ISNULL', 'JSON_ARRAY', 'JSON_OBJECT', 'JSON_QUERY', 'JSON_TO_BSON', 'JSON_VALUE', 'JULIAN_DAY', 'LAST_DAY', 'LCASE', 'LEAST', 'LEFT', 'LENGTH', 'LENGTH2', 'LENGTH4', 'LENGTHB', 'LN', 'LOCATE', 'LOCATE_IN_STRING', 'LOG10', 'LONG_VARCHAR', 'LONG_VARGRAPHIC', 'LOWER', 'LPAD', 'LTRIM', 'MAX', 'MAX_CARDINALITY', 'MICROSECOND', 'MIDNIGHT_SECONDS', 'MIN', 'MINUTE', 'MINUTES_BETWEEN', 'MOD', 'MONTH', 'MONTHNAME', 'MONTHS_BETWEEN', 'MULTIPLY_ALT', 'NCHAR', 'NCHR', 'NCLOB', 'NVARCHAR', 'NEXT_DAY', 'NEXT_MONTH', 'NEXT_QUARTER', 'NEXT_WEEK', 'NEXT_YEAR', 'NORMALIZE_DECFLOAT', 'NOW', 'NULLIF', 'NUMERIC', 'NVL', 'NVL2', 'OCTET_LENGTH', 'OVERLAY', 'PARAMETER', 'POSITION', 'POSSTR', 'POW', 'POWER', 'QUANTIZE', 'QUARTER', 'QUOTE_IDENT', 'QUOTE_LITERAL', 'RADIANS', 'RAISE_ERROR', 'RAND', 'RANDOM', 'RAWTOHEX', 'REAL', 'REC2XML', 'REGEXP_COUNT', 'REGEXP_EXTRACT', 'REGEXP_INSTR', 'REGEXP_LIKE', 'REGEXP_MATCH_COUNT', 'REGEXP_REPLACE', 'REGEXP_SUBSTR', 'REPEAT', 'REPLACE', 'RID and RID_BIT', 'RIGHT', 'ROUND', 'ROUND_TIMESTAMP', 'RPAD', 'RTRIM', 'SECLABEL', 'SECLABEL_BY_NAME', 'SECLABEL_TO_CHAR', 'SECOND', 'SECONDS_BETWEEN', 'SIGN', 'SIN', 'SINH', 'SMALLINT', 'SOUNDEX', 'SPACE', 'SQRT', 'STRIP', 'STRLEFT', 'STRPOS', 'STRRIGHT', 'SUBSTR', 'SUBSTR2', 'SUBSTR4', 'SUBSTRB', 'SUBSTRING', 'TABLE_NAME', 'TABLE_SCHEMA', 'TAN', 'TANH', 'THIS_MONTH', 'THIS_QUARTER', 'THIS_WEEK', 'THIS_YEAR', 'TIME', 'TIMESTAMP', 'TIMESTAMP_FORMAT', 'TIMESTAMP_ISO', 'TIMESTAMPDIFF', 'TIMEZONE', 'TO_CHAR', 'TO_CLOB', 'TO_DATE', 'TO_HEX', 'TO_MULTI_BYTE', 'TO_NCHAR', 'TO_NCLOB', 'TO_NUMBER', 'TO_SINGLE_BYTE', 'TO_TIMESTAMP', 'TO_UTC_TIMESTAMP', 'TOTALORDER', 'TRANSLATE', 'TRIM', 'TRIM_ARRAY', 'TRUNC_TIMESTAMP', 'TRUNCATE', 'TRUNC', 'TYPE_ID', 'TYPE_NAME', 'TYPE_SCHEMA', 'UCASE', 'UNICODE_STR', 'UPPER', 'VALUE', 'VARBINARY', 'VARCHAR', 'VARCHAR_BIT_FORMAT', 'VARCHAR_FORMAT', 'VARCHAR_FORMAT_BIT', 'VARGRAPHIC', 'VERIFY_GROUP_FOR_USER', 'VERIFY_ROLE_FOR_USER', 'VERIFY_TRUSTED_CONTEXT_ROLE_FOR_USER', 'WEEK', 'WEEK_ISO', 'WEEKS_BETWEEN', 'WIDTH_BUCKET', 'XMLATTRIBUTES', 'XMLCOMMENT', 'XMLCONCAT', 'XMLDOCUMENT', 'XMLELEMENT', 'XMLFOREST', 'XMLNAMESPACES', 'XMLPARSE', 'XMLPI', 'XMLQUERY', 'XMLROW', 'XMLSERIALIZE', 'XMLTEXT', 'XMLVALIDATE', 'XMLXSROBJECTID', 'XSLTRANSFORM', 'YEAR', 'YEARS_BETWEEN', 'YMD_BETWEEN'],
  // https://www.ibm.com/docs/en/db2/11.5?topic=bif-table-functions
  table: ['BASE_TABLE', 'JSON_TABLE', 'UNNEST', 'XMLTABLE'],
  // https://www.ibm.com/docs/en/db2/11.5?topic=expressions-olap-specification
  // Additional function names not already present in the aggregate functions list
  olap: ['RANK', 'DENSE_RANK', 'NTILE', 'LAG', 'LEAD', 'ROW_NUMBER', 'FIRST_VALUE', 'LAST_VALUE', 'NTH_VALUE', 'RATIO_TO_REPORT'],
  // Type casting
  cast: ['CAST']
});
//# sourceMappingURL=db2.functions.js.map