"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.snowflake = exports.singlestoredb = exports.transactsql = exports.trino = exports.sql = exports.sqlite = exports.spark = exports.redshift = exports.postgresql = exports.plsql = exports.n1ql = exports.tidb = exports.mysql = exports.mariadb = exports.hive = exports.db2i = exports.db2 = exports.bigquery = exports.ConfigError = exports.expandPhrases = exports.formatDialect = exports.format = exports.supportedDialects = void 0;
var sqlFormatter_js_1 = require("./sqlFormatter.js");
Object.defineProperty(exports, "supportedDialects", { enumerable: true, get: function () { return sqlFormatter_js_1.supportedDialects; } });
Object.defineProperty(exports, "format", { enumerable: true, get: function () { return sqlFormatter_js_1.format; } });
Object.defineProperty(exports, "formatDialect", { enumerable: true, get: function () { return sqlFormatter_js_1.formatDialect; } });
var expandPhrases_js_1 = require("./expandPhrases.js");
Object.defineProperty(exports, "expandPhrases", { enumerable: true, get: function () { return expandPhrases_js_1.expandPhrases; } });
var validateConfig_js_1 = require("./validateConfig.js");
Object.defineProperty(exports, "ConfigError", { enumerable: true, get: function () { return validateConfig_js_1.ConfigError; } });
// When adding a new dialect, be sure to add it to the list of exports below.
var bigquery_formatter_js_1 = require("./languages/bigquery/bigquery.formatter.js");
Object.defineProperty(exports, "bigquery", { enumerable: true, get: function () { return bigquery_formatter_js_1.bigquery; } });
var db2_formatter_js_1 = require("./languages/db2/db2.formatter.js");
Object.defineProperty(exports, "db2", { enumerable: true, get: function () { return db2_formatter_js_1.db2; } });
var db2i_formatter_js_1 = require("./languages/db2i/db2i.formatter.js");
Object.defineProperty(exports, "db2i", { enumerable: true, get: function () { return db2i_formatter_js_1.db2i; } });
var hive_formatter_js_1 = require("./languages/hive/hive.formatter.js");
Object.defineProperty(exports, "hive", { enumerable: true, get: function () { return hive_formatter_js_1.hive; } });
var mariadb_formatter_js_1 = require("./languages/mariadb/mariadb.formatter.js");
Object.defineProperty(exports, "mariadb", { enumerable: true, get: function () { return mariadb_formatter_js_1.mariadb; } });
var mysql_formatter_js_1 = require("./languages/mysql/mysql.formatter.js");
Object.defineProperty(exports, "mysql", { enumerable: true, get: function () { return mysql_formatter_js_1.mysql; } });
var tidb_formatter_js_1 = require("./languages/tidb/tidb.formatter.js");
Object.defineProperty(exports, "tidb", { enumerable: true, get: function () { return tidb_formatter_js_1.tidb; } });
var n1ql_formatter_js_1 = require("./languages/n1ql/n1ql.formatter.js");
Object.defineProperty(exports, "n1ql", { enumerable: true, get: function () { return n1ql_formatter_js_1.n1ql; } });
var plsql_formatter_js_1 = require("./languages/plsql/plsql.formatter.js");
Object.defineProperty(exports, "plsql", { enumerable: true, get: function () { return plsql_formatter_js_1.plsql; } });
var postgresql_formatter_js_1 = require("./languages/postgresql/postgresql.formatter.js");
Object.defineProperty(exports, "postgresql", { enumerable: true, get: function () { return postgresql_formatter_js_1.postgresql; } });
var redshift_formatter_js_1 = require("./languages/redshift/redshift.formatter.js");
Object.defineProperty(exports, "redshift", { enumerable: true, get: function () { return redshift_formatter_js_1.redshift; } });
var spark_formatter_js_1 = require("./languages/spark/spark.formatter.js");
Object.defineProperty(exports, "spark", { enumerable: true, get: function () { return spark_formatter_js_1.spark; } });
var sqlite_formatter_js_1 = require("./languages/sqlite/sqlite.formatter.js");
Object.defineProperty(exports, "sqlite", { enumerable: true, get: function () { return sqlite_formatter_js_1.sqlite; } });
var sql_formatter_js_1 = require("./languages/sql/sql.formatter.js");
Object.defineProperty(exports, "sql", { enumerable: true, get: function () { return sql_formatter_js_1.sql; } });
var trino_formatter_js_1 = require("./languages/trino/trino.formatter.js");
Object.defineProperty(exports, "trino", { enumerable: true, get: function () { return trino_formatter_js_1.trino; } });
var transactsql_formatter_js_1 = require("./languages/transactsql/transactsql.formatter.js");
Object.defineProperty(exports, "transactsql", { enumerable: true, get: function () { return transactsql_formatter_js_1.transactsql; } });
var singlestoredb_formatter_js_1 = require("./languages/singlestoredb/singlestoredb.formatter.js");
Object.defineProperty(exports, "singlestoredb", { enumerable: true, get: function () { return singlestoredb_formatter_js_1.singlestoredb; } });
var snowflake_formatter_js_1 = require("./languages/snowflake/snowflake.formatter.js");
Object.defineProperty(exports, "snowflake", { enumerable: true, get: function () { return snowflake_formatter_js_1.snowflake; } });
//# sourceMappingURL=index.js.map