import type { RuntimeContext } from '../../../../engine/types';
type METHOD = 'GET' | 'POST' | 'PUT' | 'DELETE' | 'PATCH';
export type SSEArgs = {
    method: METHOD;
    headers?: Record<string, string>;
    openWhenHidden?: boolean;
    retryInterval?: number;
    retryScaler?: number;
    retryMaxWaitMs?: number;
    retryMaxCount?: number;
    abort?: AbortSignal;
} & ({
    contentType: 'json';
    includeLocal?: boolean;
} | {
    contentType: 'form';
    selector?: string;
});
export declare const sse: (ctx: RuntimeContext, url: string, args: SSEArgs) => Promise<void>;
export {};
