import { PluginType } from '~/engine/types';
export const SignalValueMacro = {
    name: 'signalValue',
    type: PluginType.Macro,
    fn: (original) => {
        const validJS = /(?<path>[\w0-9.]*)((\.value))/gm;
        const sub = `ctx.signals.signal('$1').value`;
        return original.replaceAll(validJS, sub);
    },
};
