// Authors: Delaney Gillilan
// Icon: ion:checkmark-round
// Slug: Set all signals that match a regular expression
import { PluginType } from '../../../../engine/types';
export const SetAll = {
    type: PluginType.Action,
    name: 'setAll',
    fn: ({ signals }, prefix, newValue) => {
        signals.walk((path, signal) => {
            if (!path.startsWith(prefix))
                return;
            signal.value = newValue;
        });
    },
};
