export class LruCache {
    constructor(maxEntries = 64) {
        this.maxEntries = maxEntries;
        this.entries = new Map();
    }
    get(key) {
        const entry = this.entries.get(key);
        if (entry) {
            this.entries.delete(key);
            this.entries.set(key, entry);
        }
        return entry;
    }
    set(key, value) {
        if (this.entries.size >= this.maxEntries) {
            const keyToDelete = this.entries.keys().next().value;
            if (!keyToDelete)
                return;
            this.entries.delete(keyToDelete);
        }
        this.entries.set(key, value);
    }
}
