export const isBoolString = (str) => str.trim() === 'true';
export const kebabize = (str) => str.replace(/[A-Z]+(?![a-z])|[A-Z]/g, ($, ofs) => (ofs ? '-' : '') + $.toLowerCase());
export const camelize = (str) => str
    .replace(/(?:^\w|[A-Z]|\b\w)/g, (word, index) => index === 0 ? word.toLowerCase() : word.toUpperCase())
    .replace(/\s+/g, '');
export const jsStrToObject = (raw) => new Function(`return Object.assign({}, ${raw})`)();
export const trimDollarSignPrefix = (str) => str.startsWith('$') ? str.slice(1) : str;
