import { PluginType, } from '../../../../engine/types';
import { jsStrToObject } from '../../../../utils/text';
export const Signals = {
    type: PluginType.Attribute,
    name: 'signals',
    removeOnLoad: () => true,
    onLoad: (ctx) => {
        const { key, value, genRX, signals, mods } = ctx;
        const ifMissing = mods.has('ifmissing');
        if (key !== '' && !ifMissing) {
            const v = value === '' ? value : genRX()();
            signals.setValue(key, v);
        }
        else {
            const obj = jsStrToObject(ctx.value);
            ctx.value = JSON.stringify(obj);
            const rx = genRX();
            const nv = rx();
            signals.merge(nv, ifMissing);
        }
    },
};
