export function delay(callback, wait) {
    return (...args) => {
        setTimeout(() => {
            callback(...args);
        }, wait);
    };
}
export function debounce(callback, wait, leading = false, trailing = true) {
    let timer = -1;
    const resetTimer = () => timer && clearTimeout(timer);
    return (...args) => {
        resetTimer();
        if (leading && !timer) {
            callback(...args);
        }
        timer = setTimeout(() => {
            if (trailing) {
                callback(...args);
            }
            resetTimer();
        }, wait);
    };
}
export function throttle(callback, wait, leading = true, trailing = false) {
    let waiting = false;
    return (...args) => {
        if (waiting)
            return;
        if (leading) {
            callback(...args);
        }
        waiting = true;
        setTimeout(() => {
            waiting = false;
            if (trailing) {
                callback(...args);
            }
        }, wait);
    };
}
