import { ElementObserverDelegate } from "./element_observer";
export interface AttributeObserverDelegate {
    elementMatchedAttribute?(element: Element, attributeName: string): any;
    elementAttributeValueChanged?(element: Element, attributeName: string): any;
    elementUnmatchedAttribute?(element: Element, attributeName: string): any;
}
export declare class AttributeObserver implements ElementObserverDelegate {
    attributeName: string;
    private delegate;
    private elementObserver;
    constructor(element: Element, attributeName: string, delegate: AttributeObserverDelegate);
    readonly element: Element;
    readonly selector: string;
    start(): void;
    stop(): void;
    matchElement(element: Element): boolean;
    matchElementsInTree(tree: Element): Element[];
    elementMatched(element: Element): void;
    elementUnmatched(element: Element): void;
    elementAttributeChanged(element: Element, attributeName: string): void;
}
